/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.hosts;

import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.hosts.HostEdit;
import com.dev63.restoran.hosts.HostServers;
import com.dev63.restoran.swt.components.SWTMessage;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class HostChoice {
    private String host;
    private String dbSchema;
    private String user;
    private String pass;
    private HostServers.HostEntry entry;

    public HostChoice(final Display d, String hostAddress, String dbSchema, String user, String pass) {
        String hn;
        HostServers.HostEntry hent;
        HostEdit he;
        boolean hostUndefined = false;
        this.host = hostAddress;
        this.dbSchema = dbSchema;
        this.user = user;
        this.pass = pass;
        final Shell s = new Shell(d, 2144);
        s.setLayout((Layout)new GridLayout(2, false));
        s.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZBOR_LOKACIJE"));
        try {
            final Image image = new Image((Device)d, ImagePath.getPath() + "/hostelIcon.ico");
            s.setImage(image);
            s.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                }
            });
        }
        catch (Exception image) {
            // empty catch block
        }
        final ComboViewer cv = new ComboViewer((Composite)s, 12);
        cv.setContentProvider((IContentProvider)new ArrayContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof HostServers.HostEntry) {
                    HostServers.HostEntry hostEntry = (HostServers.HostEntry)element;
                    String result = "";
                    System.out.println(hostEntry.getShortName().length());
                    result = hostEntry.getShortName() != null && hostEntry.getShortName().length() != 0 ? hostEntry.getShortName() : hostEntry.getName();
                    return result;
                }
                return "";
            }
        });
        final LinkedList<HostServers.HostEntry> input = new LinkedList<HostServers.HostEntry>();
        cv.setInput(input);
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        gd.widthHint = 200;
        cv.getCombo().setLayoutData((Object)gd);
        input.addAll(HostServers.getHosts());
        cv.refresh();
        Listener editListener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.stateMask & 0x40000) != 0 && (event.keyCode == 101 || event.keyCode == 69)) {
                    d.removeFilter(2, (Listener)this);
                    IStructuredSelection selection = (IStructuredSelection)cv.getSelection();
                    if (selection.isEmpty()) {
                        SWTMessage.showLocalizedInfoDialog(s, String.format(Konstante.getBundle().getString("PORUKA_MORATE_PRVO_OBELEZITI_HOSTA"), new Object[0]));
                        return;
                    }
                    HostServers.HostEntry hent = (HostServers.HostEntry)selection.getFirstElement();
                    HostEdit he = new HostEdit(s, hent);
                    if (he.getHostEntry() != null && !he.getHostEntry().equals(hent) && HostServers.saveHost(he.getHostEntry())) {
                        hent = he.getHostEntry();
                        input.clear();
                        input.addAll(HostServers.getHosts());
                        cv.refresh();
                        cv.setSelection((ISelection)new StructuredSelection((Object)hent));
                    }
                    d.addFilter(2, (Listener)this);
                }
            }
        };
        if (!input.isEmpty()) {
            HostServers.HostEntry he2 = HostServers.getHostEntry(this.host, this.dbSchema, this.user, this.pass, "");
            if (he2 != null) {
                int ind = input.indexOf(he2);
                if (ind > -1) {
                    cv.setSelection((ISelection)new StructuredSelection(input.get(ind)));
                } else {
                    hostUndefined = true;
                }
            } else {
                hostUndefined = true;
            }
        }
        Button bOk = new Button((Composite)s, 8);
        bOk.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_POTVRDI"));
        bOk.setLayoutData((Object)new GridData(4, 4, true, false));
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostChoice.this.setHost((HostServers.HostEntry)((StructuredSelection)cv.getSelection()).getFirstElement());
                if (HostChoice.this.getHost() == null) {
                    MessageBox mb = new MessageBox(s);
                    mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_IZBOR_LOKACIJE"));
                    mb.setMessage(String.format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_ODABIRA_HOSTA"), new Object[0]));
                    mb.open();
                } else {
                    s.dispose();
                }
            }
        });
        Button bCancel = new Button((Composite)s, 8);
        bCancel.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_OTKAZI"));
        bCancel.setLayoutData((Object)new GridData(4, 4, true, false));
        bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostChoice.this.setHost(null);
                s.close();
            }
        });
        s.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                HostChoice.this.setHost(null);
            }
        });
        d.addFilter(2, editListener);
        s.pack();
        s.setLocation(new Point((d.getPrimaryMonitor().getBounds().width - s.getBounds().width) / 2, (d.getPrimaryMonitor().getBounds().height - s.getBounds().height) / 2));
        s.setDefaultButton(bOk);
        s.open();
        if (hostUndefined && (he = new HostEdit(s, hent = new HostServers.HostEntry(hn = "", this.host, this.dbSchema, this.user, this.pass, hn))).getHostEntry() != null && !he.getHostEntry().equals(hent) && HostServers.saveHost(he.getHostEntry())) {
            this.entry = he.getHostEntry();
            input.clear();
            input.addAll(HostServers.getHosts());
            cv.refresh();
            cv.setSelection((ISelection)new StructuredSelection((Object)this.entry));
        }
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        d.removeFilter(2, editListener);
    }

    public HostServers.HostEntry getHost() {
        return this.entry;
    }

    public void setHost(HostServers.HostEntry entry) {
        this.entry = entry;
    }
}

