/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.frontoffice;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Meni;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.resources.FontCache;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MeniIzbor {
    private static Restoran restoran;
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private String fontName;
    private Shell shell;
    private Display display;
    private List<Meni> meniList;
    private MeniPromet output = null;
    private ListViewer meniLV;
    private DoubleInput2 kolicina;
    private DoubleInput2 cena;
    private DoubleInput2 ukupno;
    private DoubleInput2 iznos;
    private ModifyListener ml;
    private boolean modified = false;
    private Image numBack;
    private Image backImg;
    private Font numFont;
    private Font buttFont;
    private Font font10;
    private Font lblFont;
    private Color buttCol;
    private Color textCol;
    private static Konobar konobar;
    private static Double ukupnoNabavno;
    private RestoranServer server;

    public MeniIzbor(Shell parent, List<Meni> meniListica, Konobar konobar, Double ukupnoNabavno, Restoran restoran) {
        MeniIzbor.restoran = restoran;
        this.server = restoran.getServer();
        MeniIzbor.ukupnoNabavno = ukupnoNabavno;
        MeniIzbor.konobar = konobar;
        this.ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MeniIzbor.this.kolicina != null && MeniIzbor.this.cena != null && MeniIzbor.this.ukupno != null) {
                    try {
                        Double qnt = MeniIzbor.this.kolicina.getResult();
                        Double prc = MeniIzbor.this.cena.getResult();
                        Double sum = MeniIzbor.this.ukupno.getResult();
                        ((Text)MeniIzbor.this.kolicina.getControl()).removeModifyListener(MeniIzbor.this.ml);
                        ((Text)MeniIzbor.this.cena.getControl()).removeModifyListener(MeniIzbor.this.ml);
                        ((Text)MeniIzbor.this.ukupno.getControl()).removeModifyListener(MeniIzbor.this.ml);
                        if (e.widget.equals(MeniIzbor.this.kolicina.getControl())) {
                            MeniIzbor.this.ukupno.setResult(qnt * prc);
                        } else if (e.widget.equals(MeniIzbor.this.cena.getControl())) {
                            MeniIzbor.this.ukupno.setResult(qnt * prc);
                        } else if (e.widget.equals(MeniIzbor.this.ukupno.getControl())) {
                            MeniIzbor.this.cena.setResult((double)Math.round(sum / qnt * 100.0) / 100.0);
                        }
                        ((Text)MeniIzbor.this.kolicina.getControl()).addModifyListener(MeniIzbor.this.ml);
                        ((Text)MeniIzbor.this.cena.getControl()).addModifyListener(MeniIzbor.this.ml);
                        ((Text)MeniIzbor.this.ukupno.getControl()).addModifyListener(MeniIzbor.this.ml);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MeniIzbor.this.modified = true;
                }
            }
        };
        this.display = parent.getDisplay();
        this.font10 = FontCache.getFont(BMTerminalSettings.getFOTheme().getTextFont());
        this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        this.lblFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getLargeButtonFont());
        this.buttCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.textCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getTextFontColor());
        this.numFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getNumButtonFont());
        this.meniList = new LinkedList<Meni>(meniListica);
        this.shell = new Shell(parent, 34032);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.setText(String.format(this.barmasterText.getString("TEXT_IZBOR_MENIJA"), new Object[0]));
        GridData gd = new GridData(4, 4, false, true, 1, 2);
        gd.widthHint = 300;
        this.fontName = BMTerminalSettings.getFOTheme().getTextFont().getName();
        Font f = new Font((Device)this.shell.getDisplay(), this.fontName, 14, 1);
        Composite levo = new Composite((Composite)this.shell, 0);
        GridLayout gll = new GridLayout();
        gll.horizontalSpacing = 0;
        gll.verticalSpacing = 0;
        gll.marginHeight = 0;
        gll.marginWidth = 0;
        levo.setLayout((Layout)gll);
        levo.setLayoutData((Object)gd);
        this.meniLV = new ListViewer(levo, 2048);
        this.meniLV.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.meniLV.getList().setFont(f);
        this.meniLV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.meniLV.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Meni m = (Meni)element;
                return m.getNaziv();
            }
        });
        this.meniLV.setInput(this.meniList);
        this.meniLV.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                if (!MeniIzbor.this.modified) {
                    try {
                        IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                        Meni m = (Meni)iSel.getFirstElement();
                        MeniPromet mp = null;
                        mp = MeniIzbor.this.server.findLastMPbyName(m);
                        if (mp != null) {
                            MeniIzbor.this.kolicina.setResult(mp.getKolicina());
                            MeniIzbor.this.cena.setResult(mp.getCena());
                            MeniIzbor.this.ukupno.setResult(mp.getTotal());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        Composite desno = new Composite((Composite)this.shell, 2048);
        desno.setLayoutData((Object)new GridData(4, 4, true, true));
        desno.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(desno, 131072);
        l.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NABAVNA_VREDNOST") + ": ");
        l.setFont(this.buttFont);
        l.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.iznos = new DoubleInput2(desno, String.format(this.barmasterText.getString("TEXT_NABAVNA_VREDNOST"), new Object[0]), false);
        this.iznos.setResult(ukupnoNabavno);
        this.iznos.getControl().setFont(this.buttFont);
        this.iznos.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        Label lKol = new Label(desno, 131072);
        lKol.setText(String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + ":");
        lKol.setFont(this.buttFont);
        lKol.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.kolicina = new DoubleInput2(desno, String.format(this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]), (Double)1.0, false);
        this.kolicina.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.kolicina.getControl().setFont(this.buttFont);
        this.kolicina.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text t = (Text)e.widget;
                t.selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        ((Text)this.kolicina.getControl()).addModifyListener(this.ml);
        Label lCena = new Label(desno, 131072);
        lCena.setText(String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]) + ":");
        lCena.setFont(this.buttFont);
        lCena.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.cena = new DoubleInput2(desno, String.format(this.barmasterText.getString("TEXT_CENA"), new Object[0]), (Double)0.0, false);
        this.cena.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.cena.getControl().setFont(this.buttFont);
        this.cena.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text t = (Text)e.widget;
                t.selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        ((Text)this.cena.getControl()).addModifyListener(this.ml);
        Label lTotal = new Label(desno, 131072);
        lTotal.setText(String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ":");
        lTotal.setFont(this.buttFont);
        lTotal.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.ukupno = new DoubleInput2(desno, String.format(this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]), (Double)0.0, false);
        this.ukupno.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.ukupno.getControl().setFont(this.buttFont);
        this.ukupno.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text t = (Text)e.widget;
                t.selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        ((Text)this.ukupno.getControl()).addModifyListener(this.ml);
        Composite numericka = new Composite((Composite)this.shell, 0);
        numericka.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData();
        gridData.heightHint = 80;
        gridData.widthHint = 80;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 164;
        gridData2.heightHint = 80;
        gridData2.horizontalSpan = 2;
        GridData gridData3 = new GridData();
        gridData3.heightHint = 80;
        gridData3.widthHint = 80;
        gridData3.horizontalSpan = 2;
        gridData3.horizontalAlignment = 16384;
        ImageButton b = new ImageButton(numericka, 524288);
        b.setBackgroundImage(this.numBack);
        b.setFont(this.numFont);
        b.setForeground(this.buttCol);
        b.setText("7");
        b.setLayoutData(gridData);
        this.addListenerNumeric("7", b);
        ImageButton b3 = new ImageButton(numericka, 524288);
        b3.setBackgroundImage(this.numBack);
        b3.setFont(this.numFont);
        b3.setForeground(this.buttCol);
        b3.setText("8");
        b3.setLayoutData(gridData);
        this.addListenerNumeric("8", b3);
        ImageButton b4 = new ImageButton(numericka, 524288);
        b4.setBackgroundImage(this.numBack);
        b4.setFont(this.numFont);
        b4.setForeground(this.buttCol);
        b4.setText("9");
        b4.setLayoutData(gridData);
        this.addListenerNumeric("9", b4);
        ImageButton b6 = new ImageButton(numericka, 524288);
        b6.setBackgroundImage(this.numBack);
        b6.setFont(this.numFont);
        b6.setForeground(this.buttCol);
        b6.setText("4");
        b6.setLayoutData(gridData);
        this.addListenerNumeric("4", b6);
        ImageButton b7 = new ImageButton(numericka, 524288);
        b7.setBackgroundImage(this.numBack);
        b7.setFont(this.numFont);
        b7.setForeground(this.buttCol);
        b7.setText("5");
        b7.setLayoutData(gridData);
        this.addListenerNumeric("5", b7);
        ImageButton b8 = new ImageButton(numericka, 524288);
        b8.setBackgroundImage(this.numBack);
        b8.setFont(this.numFont);
        b8.setForeground(this.buttCol);
        b8.setText("6");
        b8.setLayoutData(gridData);
        this.addListenerNumeric("6", b8);
        ImageButton b0 = new ImageButton(numericka, 524288);
        b0.setBackgroundImage(this.numBack);
        b0.setFont(this.numFont);
        b0.setForeground(this.buttCol);
        b0.setText("1");
        b0.setLayoutData(gridData);
        this.addListenerNumeric("1", b0);
        ImageButton tacka = new ImageButton(numericka, 524288);
        tacka.setBackgroundImage(this.numBack);
        tacka.setFont(this.numFont);
        tacka.setForeground(this.buttCol);
        tacka.setText("2");
        tacka.setLayoutData(gridData);
        this.addListenerNumeric("2", tacka);
        ImageButton b1 = new ImageButton(numericka, 524288);
        b1.setBackgroundImage(this.numBack);
        b1.setFont(this.numFont);
        b1.setForeground(this.buttCol);
        b1.setText("3");
        b1.setLayoutData(gridData);
        this.addListenerNumeric("3", b1);
        ImageButton b5 = new ImageButton(numericka, 524288);
        b5.setBackgroundImage(this.numBack);
        b5.setFont(this.numFont);
        b5.setForeground(this.buttCol);
        b5.setText("0");
        b5.setLayoutData(gridData);
        this.addListenerNumeric("0", b5);
        ImageButton bDot = new ImageButton(numericka, 524288);
        bDot.setBackgroundImage(this.numBack);
        bDot.setFont(this.numFont);
        bDot.setForeground(this.buttCol);
        bDot.setText(",");
        bDot.setLayoutData(gridData);
        this.addListenerNumeric(".", bDot);
        ImageButton bBS = new ImageButton(numericka, 540676);
        bBS.setBackgroundImage(this.numBack);
        bBS.setPadding(8);
        bBS.setFont(this.numFont);
        bBS.setForeground(this.buttCol);
        bBS.setLayoutData(gridData);
        this.addListenerNumeric("\b", bBS);
        ImageButton bCancel = new ImageButton(numericka, 0);
        bCancel.setBackgroundImage(this.numBack);
        bCancel.setFont(this.buttFont);
        bCancel.setForeground(this.buttCol);
        bCancel.setText(String.format(this.barmasterText.getString("TEXT_OTKAZI"), new Object[0]));
        bCancel.setLayoutData(gridData);
        bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MeniIzbor.this.setOutput(null);
                MeniIzbor.this.shell.dispose();
            }
        });
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.widthHint = 164;
        data.heightHint = 80;
        data.horizontalAlignment = 0x1000000;
        ImageButton potvrdaLoginScreen = new ImageButton(numericka, 0);
        potvrdaLoginScreen.setLayoutData(gridData2);
        potvrdaLoginScreen.setBackgroundImage(this.backImg);
        potvrdaLoginScreen.setFont(this.buttFont);
        potvrdaLoginScreen.setForeground(this.buttCol);
        potvrdaLoginScreen.setText(this.barmasterText.getString("TEXT_POTVRDI"));
        potvrdaLoginScreen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Meni sm = null;
                IStructuredSelection iSel = (IStructuredSelection)MeniIzbor.this.meniLV.getSelection();
                sm = (Meni)iSel.getFirstElement();
                if (sm == null) {
                    MessageBox mb = new MessageBox(MeniIzbor.this.shell, 34);
                    mb.setText(String.format(MeniIzbor.this.barmasterText.getString("TEXT_INFO"), new Object[0]));
                    mb.setMessage(String.format(MeniIzbor.this.barmasterText.getString("PORUKA_MORATE_IZABRATI_MENI_IZ_LISTE"), new Object[0]));
                    mb.open();
                    return;
                }
                try {
                    MeniIzbor.this.setOutput(new MeniPromet());
                    MeniIzbor.this.getOutput().setCena(MeniIzbor.this.cena.getResult());
                    MeniIzbor.this.getOutput().setKolicina(MeniIzbor.this.kolicina.getResult());
                    MeniIzbor.this.getOutput().setNaziv(sm.getNaziv());
                    MeniIzbor.this.getOutput().setMeni(sm);
                }
                catch (Exception ex) {
                    Logger.getLogger(MeniIzbor.class.getName()).log(Level.WARNING, String.format(MeniIzbor.this.barmasterText.getString("LOG_DOSLO_JE_DO_GRESKE_PRILIKOM_KREIRANJA_MENI_PROMETA"), new Object[0]), ex);
                    MeniIzbor.this.setOutput(null);
                    return;
                }
                if (MeniIzbor.this.getOutput() != null) {
                    MessageBox mb = new MessageBox(MeniIzbor.this.shell, 290);
                    mb.setText(String.format(MeniIzbor.this.barmasterText.getString("TEXT_INFO"), new Object[0]));
                    mb.setMessage(String.format(MeniIzbor.this.barmasterText.getString("TEXT_PODACI_O_MENIJU"), new Object[0]) + ":\n" + String.format(MeniIzbor.this.barmasterText.getString("TEXT_NAZIV"), new Object[0]) + ": " + MeniIzbor.this.getOutput().getMeni().getNaziv() + "\n" + String.format(MeniIzbor.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + ": " + StatLogic.getNumber03(MeniIzbor.this.getOutput().getKolicina()) + "\n" + String.format(MeniIzbor.this.barmasterText.getString("TEXT_CENA"), new Object[0]) + ": " + StatLogic.getNumber02(MeniIzbor.this.getOutput().getCena()) + "\n" + String.format(MeniIzbor.this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ": " + StatLogic.getNumber02(MeniIzbor.this.getOutput().getTotal()));
                    int res = mb.open();
                    if (res == 32) {
                        MeniIzbor.this.shell.dispose();
                    }
                }
            }
        });
        numericka.setTabList(new Control[]{bCancel, potvrdaLoginScreen});
        data = new GridData();
        data.horizontalSpan = 4;
        data.heightHint = 80;
        data.widthHint = 164;
        data.horizontalAlignment = 131072;
        data = new GridData();
        numericka.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 100;
        data.widthHint = 425;
        Composite meniControl = new Composite(levo, 0);
        GridLayout glmc = new GridLayout(3, true);
        meniControl.setLayout((Layout)glmc);
        meniControl.setLayoutData((Object)new GridData(4, 4, true, false));
        gridData = new GridData(0x1000000, 0x1000000, true, true);
        gridData.heightHint = 80;
        gridData.widthHint = 80;
        ImageButton bUp = new ImageButton(meniControl, 524420);
        bUp.setBackgroundImage(this.numBack);
        bUp.setPadding(8);
        bUp.setFont(this.numFont);
        bUp.setForeground(this.buttCol);
        bUp.setText(",");
        bUp.setLayoutData(gridData);
        bUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = MeniIzbor.this.meniLV.getList().getSelectionIndex();
                idx = idx == -1 ? 0 : idx;
                idx += MeniIzbor.this.meniList.size();
                MeniIzbor.this.meniLV.getList().setSelection(--idx % MeniIzbor.this.meniList.size());
            }
        });
        final ImageButton bNew = new ImageButton(meniControl, 524288);
        bNew.setBackgroundImage(this.numBack);
        bNew.setFont(this.buttFont);
        bNew.setForeground(this.buttCol);
        bNew.setEnabled(konobar.getOtvaraMeni());
        bNew.setText(String.format(this.barmasterText.getString("TEXT_NOVI"), new Object[0]));
        bNew.setLayoutData(gridData);
        bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnosNovogMenija unm = new UnosNovogMenija(MeniIzbor.this.shell, MeniIzbor.this.meniList);
                if (unm.getOutput() != null) {
                    MeniIzbor.this.meniList.add(unm.getOutput());
                    MeniIzbor.this.meniLV.refresh();
                    bNew.setEnabled(false);
                }
            }
        });
        ImageButton bDown = new ImageButton(meniControl, 525316);
        bDown.setBackgroundImage(this.numBack);
        bDown.setPadding(8);
        bDown.setFont(this.numFont);
        bDown.setForeground(this.buttCol);
        bDown.setText(",");
        bDown.setLayoutData(gridData);
        bDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = MeniIzbor.this.meniLV.getList().getSelectionIndex();
                idx += MeniIzbor.this.meniList.size();
                MeniIzbor.this.meniLV.getList().setSelection(++idx % MeniIzbor.this.meniList.size());
            }
        });
        levo.setTabList(new Control[]{this.meniLV.getControl()});
        this.shell.pack();
        this.shell.setTabList(new Control[]{levo, desno, numericka});
        this.kolicina.getControl().forceFocus();
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                MeniIzbor.this.setOutput(null);
            }
        });
        Konstante.centerShellOnDisplay(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        f.dispose();
    }

    private void addListenerNumeric(String s, ImageButton c) {
        if (s == null || s.length() == 0) {
            return;
        }
        char input = s.charAt(0);
        c.addSelectionListener(new NumericListener(input));
    }

    public static void main(String[] args) {
        LinkedList<Meni> meniList = new LinkedList<Meni>();
        for (int i = 0; i < 10; ++i) {
            Meni m = new Meni();
            m.setNaziv("Meni " + i);
            meniList.add(m);
        }
        Display d = new Display();
        Shell s = new Shell(d, 1264);
        s.open();
        MeniIzbor mi = new MeniIzbor(s, meniList, konobar, ukupnoNabavno, restoran);
        s.close();
        d.dispose();
    }

    public List<Meni> getMeniList() {
        return this.meniList;
    }

    public void setMeniList(List<Meni> meniList) {
        this.meniList = meniList;
    }

    public MeniPromet getOutput() {
        return this.output;
    }

    public void setOutput(MeniPromet output) {
        this.output = output;
    }

    public class UnosNovogMenija {
        private Meni output = null;
        private List<Meni> existing;

        public UnosNovogMenija(Shell parent, List<Meni> existingMenus) {
            this.existing = existingMenus != null ? existingMenus : new LinkedList();
            final Shell sNew = new Shell(parent, 34912);
            sNew.setText(String.format(MeniIzbor.this.barmasterText.getString("TEXT_UNOS_NOVOG_MENIJA"), new Object[0]));
            sNew.setLayout((Layout)new GridLayout(2, true));
            sNew.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    UnosNovogMenija.this.output = null;
                }
            });
            Composite cData = new Composite((Composite)sNew, 0);
            GridData gdd = new GridData(4, 4, true, true, 2, 1);
            gdd.heightHint = 80;
            cData.setLayoutData((Object)gdd);
            cData.setLayout((Layout)new GridLayout(2, false));
            Label lName = new Label(cData, 131072);
            gdd = new GridData(4, 0x1000000, false, true);
            lName.setLayoutData((Object)gdd);
            lName.setFont(MeniIzbor.this.buttFont);
            lName.setText(String.format(MeniIzbor.this.barmasterText.getString("TEXT_NAZIV_MENIJA"), new Object[0]) + ": ");
            final Text tName = new Text(cData, 2048);
            gdd = new GridData(4, 0x1000000, true, true);
            gdd.widthHint = 200;
            tName.setFont(MeniIzbor.this.buttFont);
            tName.setLayoutData((Object)gdd);
            tName.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        Runtime.getRuntime().exec("cmd /c C:\\Windows\\System32\\osk.exe");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            GridData gd = new GridData(0x1000000, 0x1000000, true, false);
            gd.widthHint = 120;
            gd.heightHint = 50;
            ImageButton bCancel = new ImageButton((Composite)sNew, 0);
            bCancel.setLayoutData(gd);
            bCancel.setBackgroundImage(MeniIzbor.this.backImg);
            bCancel.setFont(MeniIzbor.this.buttFont);
            bCancel.setForeground(MeniIzbor.this.buttCol);
            bCancel.setText(MeniIzbor.this.barmasterText.getString("TEXT_OTKAZI"));
            bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sNew.dispose();
                }
            });
            final ImageButton bOk = new ImageButton((Composite)sNew, 0);
            bOk.setLayoutData(gd);
            bOk.setBackgroundImage(MeniIzbor.this.backImg);
            bOk.setFont(MeniIzbor.this.buttFont);
            bOk.setForeground(MeniIzbor.this.buttCol);
            bOk.setText(MeniIzbor.this.barmasterText.getString("TEXT_POTVRDI"));
            bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tName.getText().length() == 0) {
                        return;
                    }
                    for (Meni meni : UnosNovogMenija.this.existing) {
                        if (!meni.getNaziv().equals(tName.getText())) continue;
                        MessageBox mb = new MessageBox(sNew, 34);
                        mb.setText(String.format(MeniIzbor.this.barmasterText.getString("TEXT_INFO"), new Object[0]));
                        mb.setMessage(String.format(MeniIzbor.this.barmasterText.getString("PORUKA_MENI_SA_ZADATIM_IMENOM_VEC_POSTOJI"), new Object[0]));
                        mb.open();
                        return;
                    }
                    Meni newMeni = new Meni();
                    newMeni.setNaziv(tName.getText());
                    UnosNovogMenija.this.output = newMeni;
                    sNew.dispose();
                }
            });
            tName.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        bOk.notifyListeners(13, new Event());
                    }
                }
            });
            sNew.pack();
            Konstante.centerShellOnDisplay(sNew);
            sNew.open();
            while (!sNew.isDisposed()) {
                if (sNew.getDisplay().readAndDispatch()) continue;
                sNew.getDisplay().sleep();
            }
        }

        public Meni getOutput() {
            return this.output;
        }

        public void setOutput(Meni output) {
            this.output = output;
        }
    }

    private class NumericListener
    implements SelectionListener {
        private char input;
        private Display d = Display.getCurrent();

        public NumericListener(char input) {
            this.input = input;
        }

        public void widgetSelected(SelectionEvent e) {
            Event ev = new Event();
            ev.character = this.input;
            ev.keyLocation = 0;
            ev.type = 1;
            this.d.post(ev);
            ev = new Event();
            ev.character = this.input;
            ev.keyLocation = 0;
            ev.type = 2;
            this.d.post(ev);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

