/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.frontoffice;

import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.model.ZD;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;

public class FrontOfficeServer {
    private EntityManagerFactory emf;

    public FrontOfficeServer(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public EntityManager getEM() {
        return this.emf.createEntityManager();
    }

    public void releaseEM(EntityManager em) {
        em.close();
    }

    public List<Artikal> findAllArticlesForSale() {
        EntityManager em = this.getEM();
        TypedQuery tq = em.createQuery("SELECT a FROM Artikal a WHERE a.blokiran = FALSE AND (a.tip = :prod OR a.tip = :sloz OR a.tip = :polu)", Artikal.class).setParameter("prod", (Object)TipArtikla.SLOZ).setParameter("sloz", (Object)TipArtikla.PROD).setParameter("proiz", (Object)TipArtikla.POLU);
        List result = tq.getResultList();
        this.releaseEM(em);
        return result;
    }

    public List<Tura> findAllOrdersForDate(Date d) {
        Date end;
        List endList;
        EntityManager em = this.getEM();
        TypedQuery tqZd = em.createQuery("SELECT zd FROM ZD zd WHERE zd.datum = :date AND zd.pocetak = :start", ZD.class);
        Date start = new Date();
        List startList = tqZd.setParameter("start", (Object)Boolean.TRUE).setParameter("date", (Object)d).getResultList();
        if (!startList.isEmpty()) {
            start = ((ZD)startList.get(startList.size() - 1)).getZakljucenje();
        }
        if (!(endList = tqZd.setParameter("start", (Object)Boolean.FALSE).setParameter("date", (Object)d).getResultList()).isEmpty()) {
            end = ((ZD)endList.get(endList.size() - 1)).getZakljucenje();
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(start);
            c.add(5, 1);
            end = c.getTime();
        }
        TypedQuery tq = em.createQuery("SELECT t FROM Tura t WHERE t.datum BETWEEN :start AND :end", Tura.class).setParameter("start", (Object)start).setParameter("end", (Object)end);
        List result = tq.getResultList();
        this.releaseEM(em);
        return result;
    }
}

