/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.db.queries;

import com.dev63.restoran.db.queries.QueryName;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Queries {
    public static final Map<QueryName, String> QUERIES = new EnumMap<QueryName, String>(QueryName.class){

        @Override
        public String get(Object key) {
            QueryName mapKey = (QueryName)((Object)key);
            if (!this.containsKey((Object)mapKey)) {
                this.put(mapKey, Queries.readResource("/queries/".concat(mapKey.getPath())));
            }
            return (String)super.get(key);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(Queries.class.getName());
    private static final String PATH = Queries.class.getPackage().getName().replaceAll("\\.", "/").concat("/");
    private static final String NIVELACIJA_SUB = "Nivelacija.sql";
    private static final String ISZ_SUB = "IzvestaOStanjuZaliha.sql";
    private static final String PPA_NESTED_SUB = "PrometPoArtiklimaNested.sql";
    private static final Charset defaultCharset = Charset.forName("UTF8");
    private static char[] buffer = new char[4096];
    private static int count;

    private static String readResource(String fileName) {
        String out;
        System.out.println(fileName);
        try (InputStream stream = Queries.class.getResourceAsStream(fileName);
             InputStreamReader isr = new InputStreamReader(stream, defaultCharset);){
            out = "";
            while ((count = isr.read(buffer)) != -1) {
                out = out.concat(new String(buffer, 0, count));
            }
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, MessageFormat.format("Error reading query resource!\n{0}", ioe.getMessage()), ioe);
            out = null;
        }
        return out;
    }

    public static void main(String[] args) {
        for (Map.Entry<QueryName, String> en : QUERIES.entrySet()) {
            QueryName key = en.getKey();
            String val = en.getValue();
            System.out.println("key = " + (Object)((Object)key));
            System.out.println("val = " + val);
        }
        System.out.println("PATH = " + PATH + NIVELACIJA_SUB);
        InputStream resourceAsStream = Queries.class.getResourceAsStream("Queries.class");
        InputStream resourceAsStream2 = Queries.class.getResourceAsStream(NIVELACIJA_SUB);
        System.out.println("resourceAsStream = " + resourceAsStream);
        System.out.println("resourceAsStream = " + resourceAsStream2);
    }
}

