/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BMDBQueryUtil {
    private static final Pattern PARAM_PATTERN = Pattern.compile(":\\w+");

    public static void main(String ... args) {
        String q = "select * from mb.ss where id = :id and ququ = :ququ and papa = :pqpq and a = 1";
        Matcher matcher = PARAM_PATTERN.matcher(q);
        StringBuffer buff = new StringBuffer();
        while (matcher.find()) {
            System.out.println("matcher.start() = " + matcher.start());
            System.out.println("matcher.end() = " + matcher.end());
            System.out.println("matcher.group(0) = " + matcher.group(0));
            System.out.println("matcher.group(0).substring(1) = " + matcher.group(0).substring(1));
            matcher.appendReplacement(buff, "?");
        }
        matcher.appendTail(buff);
        System.out.println("buff = " + buff);
    }

    public static void remapNamedToPositionalParams(String inQuery, Map<String, Object> namedParams, StringBuffer outQuery, List<Object> positionalParams) {
        if (inQuery == null) {
            throw new IllegalArgumentException("inQuery is null!");
        }
        if (namedParams == null) {
            throw new IllegalArgumentException("namedParams is null!");
        }
        if (outQuery == null) {
            throw new IllegalArgumentException("outQuery is null!");
        }
        if (positionalParams == null) {
            throw new IllegalArgumentException("positionalParams is null!");
        }
        Matcher matcher = PARAM_PATTERN.matcher(inQuery);
        while (matcher.find()) {
            String paramName = matcher.group(0).substring(1);
            Object paramValue = namedParams.computeIfAbsent(paramName, k -> {
                throw new IllegalArgumentException("Encountered parameter name " + paramName + " not found in named params");
            });
            positionalParams.add(paramValue);
            matcher.appendReplacement(outQuery, "?");
        }
        matcher.appendTail(outQuery);
    }

    public static PreparedStatement prepareStatement(Connection conn, String query, List<Object> params) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(query);
        int position = 1;
        for (Object param : params) {
            statement.setObject(position++, param);
        }
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection conn, String query, Object ... params) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(query);
        int position = 1;
        for (Object param : params) {
            statement.setObject(position++, param);
        }
        return statement;
    }

    public static interface QueryParam {

        public static enum ParamType {
            ARRAY,
            ASCII_STREAM,
            BIG_DECIMAL,
            BINARY_STREAM,
            BLOB,
            BOOLEAN,
            BYTE,
            BYTES,
            CHARACTER_STREAM,
            CLOB,
            DATE,
            DOUBLE,
            INT,
            FLOAT,
            LONG,
            NCHARACTER_STREAM,
            NCLOB,
            NSTRING;

        }
    }
}

