/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class BMDBConnectionPool {
    public static final String VALIDATION_QUERY = "/* ping */ SELECT 1";
    public static final int VALIDATION_QUERY_TIMEOUT = 60;
    public static final String POOL_NAME = "bmPool";
    public static final String DRIVER_URL = "jdbc:apache:commons:dbcp:";
    public static final String POOL_URL = "jdbc:apache:commons:dbcp:bmPool";
    private static BMDBConnectionPool instance;

    private BMDBConnectionPool(String connectURI, String username, char[] password) throws ClassNotFoundException, SQLException {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, String.valueOf(password));
        Arrays.fill(password, ' ');
        GenericObjectPool connectionPool = new GenericObjectPool();
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, VALIDATION_QUERY, 60, false, false);
        connectionPool.setFactory((PoolableObjectFactory)poolableConnectionFactory);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_URL);
        driver.registerPool(POOL_NAME, (ObjectPool)connectionPool);
    }

    public static void init(String connectURI, String username, char[] password) throws ClassNotFoundException, SQLException {
        instance = new BMDBConnectionPool(connectURI, username, password);
    }

    public static BMDBConnectionPool instance() {
        if (instance == null) {
            throw new PoolNotInitializedException();
        }
        return instance;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(POOL_URL);
    }

    public static void shutDown() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_URL);
        driver.closePool(POOL_NAME);
    }

    public static class PoolNotInitializedException
    extends IllegalStateException {
        public PoolNotInitializedException() {
            super("Pool not initialized exception!");
        }
    }
}

