/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.customerdisplay;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import jssc.SerialPort;
import jssc.SerialPortException;

public class CustomerDisplay {
    private static final Logger LOG = Logger.getLogger(CustomerDisplay.class.getName());
    private static SerialPort sp;
    private static String name;
    private static int baudRate;
    private static int dataBits;
    private static int stopBits;
    private static int parity;
    private static int flowControl;
    private static int rows;
    private static int cols;
    private static long standByPeriod;
    private static String[] standByMessage;
    private static Timer cdTimer;
    private static TimerTask cdStandByTask;

    public static void configureDisplay(int lines, int characters) {
        String[] sbm = new String[]{"www.petcom.rs", "011/2317590"};
        long sbp = 30000L;
        CustomerDisplay.configureDisplay(lines, characters, sbm, sbp);
    }

    public static void configureDisplay(int lines, int characters, String[] standByMessage, long standByPeriod) {
        rows = lines;
        cols = characters;
        if (standByMessage.length > 0) {
            String tmp;
            String string;
            int i;
            CustomerDisplay.standByMessage = new String[rows];
            for (i = 0; i < standByMessage.length; ++i) {
                string = standByMessage[i];
                if (i >= rows) break;
                tmp = string.length() >= cols ? string.substring(0, cols) : string;
                int c = 0;
                while (tmp.length() < cols) {
                    tmp = c++ % 2 == 0 ? " " + tmp : tmp + " ";
                }
                CustomerDisplay.standByMessage[i] = tmp;
            }
            for (i = 0; i < CustomerDisplay.standByMessage.length; ++i) {
                string = CustomerDisplay.standByMessage[i];
                if (string != null) continue;
                tmp = "";
                while (tmp.length() < cols) {
                    tmp = tmp + " ";
                }
                CustomerDisplay.standByMessage[i] = tmp;
            }
            CustomerDisplay.standByPeriod = standByPeriod;
        } else {
            CustomerDisplay.standByMessage = new String[0];
            CustomerDisplay.standByPeriod = 0L;
        }
    }

    public static synchronized boolean openSerialPort(String name, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        boolean ret = false;
        try {
            if (!CustomerDisplay.closePort()) {
                return ret;
            }
            if (name == null) {
                throw new IllegalArgumentException("Argument name cannot be null");
            }
            CustomerDisplay.name = name;
            CustomerDisplay.baudRate = baudRate;
            CustomerDisplay.dataBits = dataBits;
            CustomerDisplay.stopBits = stopBits;
            CustomerDisplay.parity = parity;
            CustomerDisplay.flowControl = flowControl;
            sp = new SerialPort(name);
            sp.openPort();
            sp.setParams(9600, 8, 1, 0);
            sp.setFlowControlMode(0);
            ret = true;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            ret = false;
        }
        return ret;
    }

    public static boolean checkConn() {
        if (!CustomerDisplay.checkOpenPort()) {
            return CustomerDisplay.reOpenPort();
        }
        return true;
    }

    public static synchronized boolean resetDisplay() {
        boolean ret = false;
        try {
            if (CustomerDisplay.checkConn()) {
                sp.writeBytes(new byte[]{27, 64});
                ret = true;
            }
        }
        catch (SerialPortException ex) {
            Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, null, ex);
            ret = false;
        }
        return ret;
    }

    public static boolean reOpenPort() {
        return CustomerDisplay.openSerialPort(name, baudRate, dataBits, stopBits, parity, flowControl);
    }

    public static synchronized boolean closePort() {
        boolean ret = false;
        try {
            if (CustomerDisplay.checkOpenPort()) {
                sp.closePort();
            }
            ret = true;
        }
        catch (Exception ex) {
            Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return ret;
    }

    public static synchronized boolean writeStandByMessage() {
        if (CustomerDisplay.clearDisplay()) {
            for (int i = 0; i < standByMessage.length; ++i) {
                String string = standByMessage[i];
                if (CustomerDisplay.writeLine(i + 1, string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static synchronized boolean writeLines(String ... lines) {
        if (!CustomerDisplay.clearDisplay()) {
            return false;
        }
        for (int i = 0; i < lines.length && i < rows; ++i) {
            String line = lines[i];
            if (line == null) continue;
            System.out.println("line = " + line);
            if (CustomerDisplay.writeLine(i + 1, line)) continue;
            return false;
        }
        CustomerDisplay.scheduleStandBy();
        return true;
    }

    private static void scheduleStandBy() {
        if (standByMessage != null && standByMessage.length > 0 && standByPeriod > 0L && cdTimer != null) {
            if (cdStandByTask != null) {
                try {
                    cdStandByTask.cancel();
                    cdTimer.purge();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cdStandByTask = new TimerTask(){

                @Override
                public void run() {
                    CustomerDisplay.writeStandByMessage();
                }
            };
            cdTimer.schedule(cdStandByTask, standByPeriod);
        }
    }

    public static synchronized boolean writeLine(int line, String text) {
        if (!CustomerDisplay.checkConn()) {
            return false;
        }
        try {
            if (sp.writeBytes(new byte[]{31, 36, 1, (byte)((line - 1) % rows + 1 & 0xFF)})) {
                System.out.println("text = " + text);
                String tmp = text.length() >= cols ? text.substring(0, cols) : text;
                System.out.println("tmp = " + tmp);
                while (tmp.length() < cols) {
                    tmp = tmp + " ";
                }
                System.out.println("tmp = " + tmp);
                return sp.writeString(tmp);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return false;
    }

    public static synchronized boolean writeBytes(byte ... bytes) {
        if (!CustomerDisplay.checkConn()) {
            return false;
        }
        try {
            return sp.writeBytes(bytes);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    public static synchronized boolean writeStartMessage(String ... text) {
        if (!CustomerDisplay.checkConn()) {
            return false;
        }
        try {
            String message = "";
            if (sp.writeBytes(new byte[]{27, 77})) {
                for (int i = 0; i < text.length; ++i) {
                    String tmp;
                    String string = text[i];
                    if (i >= rows) continue;
                    String string2 = tmp = string.length() >= cols ? string.substring(0, cols) : string;
                    while (tmp.length() < cols) {
                        tmp = tmp + " ";
                    }
                    message = message + tmp;
                }
                while (message.length() < rows * cols) {
                    message = message + " ";
                }
                return sp.writeString(message);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return false;
    }

    public static synchronized boolean clearDisplay() {
        if (!CustomerDisplay.checkOpenPort() && !CustomerDisplay.reOpenPort()) {
            return false;
        }
        try {
            return sp.writeInt(12);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
    }

    public static boolean checkOpenPort() {
        return sp != null && sp.isOpened();
    }

    public static void showText(String ... lines) {
        try {
            SerialPort sp = new SerialPort("COM4");
            sp.openPort();
            sp.setParams(9600, 8, 1, 0);
            sp.setFlowControlMode(0);
            sp.writeInt(12);
            sp.writeString("PROBA                               ");
            sp.closePort();
        }
        catch (SerialPortException ex) {
            Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        CustomerDisplay.configureDisplay(2, 20, new String[0], 0L);
        CustomerDisplay.openSerialPort("COM4", 9600, 8, 1, 0, 0);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
        CustomerDisplay.clearDisplay();
        CustomerDisplay.clearDisplay();
        CustomerDisplay.writeLine(1, "sada sledi proba ovog cuda");
        CustomerDisplay.writeLine(2, "oooooooooo daaaaaaaaaaaaaaaaaa");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (int i = 1; i < 11; ++i) {
            try {
                CustomerDisplay.writeLines(i % 2 == 0 ? "POVOLJNO POVOLJNO" : "", i % 2 == 0 ? "" : "POVOLJNO POVOLJNO");
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            Thread.sleep(180000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CustomerDisplay.class.getName()).log(Level.SEVERE, null, ex);
        }
        CustomerDisplay.closePort();
    }

    static {
        standByMessage = new String[0];
        cdTimer = new Timer();
    }
}

