/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.constants;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.model.Trosak;
import com.dev63.restoran.sistem.PoreskeStope;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TaxCalc {
    public static Double getIznosBezPoreza(Racun racun) {
        System.out.println("iznos bez poreza metoda pocela " + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()));
        Double totalBPdv = 0.0;
        for (StavkaRacuna sr : racun.getStavke1()) {
            System.out.println("krug poceo " + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()));
            totalBPdv = totalBPdv + Konstante.getOsnovicaFromBruto(sr.getArtikal().getPoreskaGrupa(), sr.getVrednostSaPopustom());
            System.out.println("krug gotov " + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()));
        }
        totalBPdv = StatLogic.round(totalBPdv, 2);
        System.out.println("iznos bez poreza metoda pocela " + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()));
        return totalBPdv;
    }

    public static Double getIznosBezPoreza(Trebovanje racun) {
        Double totalBPdv = 0.0;
        for (TrebovanjeStavka sr : racun.getStavke()) {
            totalBPdv = totalBPdv + sr.getKomadBPDV() * sr.getKolicina();
        }
        return totalBPdv;
    }

    public static Double getIznosBezPoreza(Prijemnica racun) {
        Double totalBPdv = 0.0;
        for (PrijemnicaStavka sr : racun.getStavke()) {
            totalBPdv = totalBPdv + sr.getKomad() * sr.getKolicina();
        }
        totalBPdv = StatLogic.round(totalBPdv, 2);
        return totalBPdv;
    }

    public static Double getIznosBezPoreza(Trosak racun) {
        Double totalBPdv = 0.0;
        totalBPdv = racun.getIznos() - TaxCalc.getPorez(racun);
        return totalBPdv;
    }

    public static Double getPorez(Racun racun) {
        return racun.total() - TaxCalc.getIznosBezPoreza(racun);
    }

    public static Double getPorez(Trebovanje racun) {
        Double pTotal = 0.0;
        for (TrebovanjeStavka sr : racun.getStavke()) {
            pTotal = pTotal + sr.getKomad() * sr.getKolicina() / (1.0 + sr.getPdvStopa() / 100.0) * (sr.getPdvStopa() / 100.0);
        }
        return pTotal;
    }

    public static Double getPorez(Prijemnica racun) {
        Double pTotal = 0.0;
        for (PrijemnicaStavka sr : racun.getStavke()) {
            Double stopa = sr.getPdvStopa() != null ? sr.getPdvStopa().doubleValue() : PoreskeStope.getPoreskaStopa(sr.getArtikal().getPoreskaGrupa(), racun.getDatumPrijemnice()).getStopa();
            pTotal = pTotal + sr.getKolicina() * sr.getKomad() * (stopa / 100.0);
        }
        return StatLogic.round(pTotal, 2);
    }

    public static Double getPorez(Trosak racun) {
        Double pTotal = 0.0;
        Double porez = racun.getPorez();
        if (porez == null) {
            Double stopa = PoreskeStope.getDefaultStopa() != null ? PoreskeStope.getDefaultStopa().getStopa() : 0.0;
            porez = racun.getIznos() / (1.0 + stopa / 100.0) * stopa / 100.0;
        }
        return porez;
    }
}

