/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.constants;

import com.dev63.restoran.Konstante;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class StatLogic {
    private static final DateFormat df;
    private static final DateFormat tf;
    private static final NumberFormat nf0_1;
    private static final NumberFormat nf0_2;
    private static final NumberFormat nf0_3;
    private static final NumberFormat nf0_0_3;
    private static final NumberFormat nf0_4;
    private static final NumberFormat nf0;
    private static final NumberFormat nf0_1ng;
    private static final NumberFormat nf0_0_1ng;
    private static final NumberFormat nf0_2ng;
    private static final NumberFormat nf0_0_2ng;
    private static final NumberFormat nf0_3ng;
    private static final NumberFormat nf0_0_3ng;
    private static final NumberFormat nf0_4ng;
    private static final NumberFormat nf0_0_4ng;
    private static final NumberFormat nf0ng;
    private static final char[] decSeps;

    public static String getDateString(Date date) {
        return df.format(date);
    }

    public static String getDateTimeString(Date date) {
        return df.format(date) + " " + tf.format(date);
    }

    public static String getTimeString(Date date) {
        return tf.format(date);
    }

    public static String getNumber0(Double d) {
        return nf0.format(d);
    }

    public static String getNumber0(BigDecimal d) {
        return nf0.format(d);
    }

    public static String getNumber01(Double d) {
        return nf0_1.format(d);
    }

    public static String getNumber01(BigDecimal d) {
        return nf0_1.format(d);
    }

    public static String getNumber02(Double d) {
        return nf0_2.format(d);
    }

    public static String getNumber02(BigDecimal d) {
        return nf0_2.format(d);
    }

    public static String getNumber03(Double d) {
        return nf0_3.format(d);
    }

    public static String getNumber03(BigDecimal d) {
        return nf0_3.format(d);
    }

    public static String getNumber03F(Double d) {
        return nf0_0_3.format(d);
    }

    public static String getNumber03F(BigDecimal d) {
        return nf0_0_3.format(d);
    }

    public static String getNumber04(Double d) {
        return nf0_4.format(d);
    }

    public static String getNumber04(BigDecimal d) {
        return nf0_4.format(d);
    }

    public static String getNumber0NG(Double d) {
        return nf0ng.format(d);
    }

    public static String getNumber0NG(BigDecimal d) {
        return nf0ng.format(d);
    }

    public static String getNumber01NG(Double d) {
        return nf0_1ng.format(d);
    }

    public static String getNumber01NG(BigDecimal d) {
        return nf0_1ng.format(d);
    }

    public static String getNumber01NGF(Double d) {
        return nf0_0_1ng.format(d);
    }

    public static String getNumber01NGF(BigDecimal d) {
        return nf0_0_1ng.format(d);
    }

    public static String getNumber02NG(Double d) {
        return nf0_2ng.format(d);
    }

    public static String getNumber02NG(BigDecimal d) {
        return nf0_2ng.format(d);
    }

    public static String getNumber02NGF(Double d) {
        return nf0_0_2ng.format(d);
    }

    public static String getNumber02NGF(BigDecimal d) {
        return nf0_0_2ng.format(d);
    }

    public static String getNumber03NG(Double d) {
        return nf0_3ng.format(d);
    }

    public static String getNumber03NG(BigDecimal d) {
        return nf0_3ng.format(d);
    }

    public static String getNumber03NGF(Double d) {
        return nf0_0_3ng.format(d);
    }

    public static String getNumber03NGF(BigDecimal d) {
        return nf0_0_3ng.format(d);
    }

    public static String getNumber04NG(Double d) {
        return nf0_4ng.format(d);
    }

    public static String getNumber04NG(BigDecimal d) {
        return nf0_4ng.format(d);
    }

    public static String getNumber04NGF(Double d) {
        return nf0_0_4ng.format(d);
    }

    public static DateFormat getDateFormat() {
        return df;
    }

    public static DateFormat getTimeFomat() {
        return tf;
    }

    public static Number parseNumber0(String number) throws ParseException {
        return nf0.parse(StatLogic.replaceDecSep(number));
    }

    public static Number parseNumber01(String number) throws ParseException {
        return nf0_1.parse(StatLogic.replaceDecSep(number));
    }

    public static Number parseNumber02(String number) throws ParseException {
        return nf0_2.parse(StatLogic.replaceDecSep(number));
    }

    public static Number parseNumber03(String number) throws ParseException {
        return nf0_3.parse(StatLogic.replaceDecSep(number));
    }

    public static Number parseNumber04(String number) throws ParseException {
        return nf0_4.parse(StatLogic.replaceDecSep(number));
    }

    public static Double parseDouble0(String number) throws ParseException {
        return nf0.parse(StatLogic.replaceDecSep(number)).doubleValue();
    }

    public static Double parseDouble01(String number) throws ParseException {
        return nf0_1.parse(StatLogic.replaceDecSep(number)).doubleValue();
    }

    public static Double parseDouble02(String number) throws ParseException {
        return nf0_2.parse(StatLogic.replaceDecSep(number)).doubleValue();
    }

    public static Double parseDouble03(String number) throws ParseException {
        return nf0_3.parse(StatLogic.replaceDecSep(number)).doubleValue();
    }

    public static Double parseDouble04(String number) throws ParseException {
        return nf0_4.parse(StatLogic.replaceDecSep(number)).doubleValue();
    }

    public static Number parseNumber0Suppress(String number) {
        try {
            return nf0.parse(StatLogic.replaceDecSep(number));
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble0Suppress(String number) {
        try {
            return nf0.parse(StatLogic.replaceDecSep(number)).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Number parseNumber01Suppress(String number) {
        try {
            return nf0_1.parse(StatLogic.replaceDecSep(number));
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble01Suppress(String number) {
        try {
            return nf0_1.parse(StatLogic.replaceDecSep(number)).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble02Suppress(String number) {
        try {
            Number n = nf0_2.parse(StatLogic.replaceDecSep(number));
            if (n instanceof Long) {
                return (double)((Long)n);
            }
            return (double)((Double)n);
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Number parseNumber03Suppress(String number) {
        try {
            return nf0_3.parse(StatLogic.replaceDecSep(number));
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble03Suppress(String number) {
        try {
            return nf0_3.parse(StatLogic.replaceDecSep(number)).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Number parseNumber03NGSuppress(String number) {
        try {
            return nf0_3ng.parse(StatLogic.replaceDecSep(number));
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble03NGSuppress(String number) {
        try {
            return nf0_3ng.parse(StatLogic.replaceDecSep(number)).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Number parseNumber04Suppress(String number) {
        try {
            return nf0_4.parse(StatLogic.replaceDecSep(number));
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble04Suppress(String number) {
        try {
            return nf0_4.parse(StatLogic.replaceDecSep(number)).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Number parseNumber04NGSuppress(String number) {
        try {
            return nf0_4ng.parse(StatLogic.replaceDecSep(number));
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static Double parseDouble04NGSuppress(String number) {
        try {
            return nf0_4ng.parse(StatLogic.replaceDecSep(number)).doubleValue();
        }
        catch (ParseException ex) {
            return 0.0;
        }
    }

    public static String clearFromEasternLatinChars(String input) {
        input = input.replaceAll("\u010c", "C");
        input = input.replaceAll("\u010d", "c");
        input = input.replaceAll("\u0106", "C");
        input = input.replaceAll("\u0107", "c");
        input = input.replaceAll("\u0110", "Dj");
        input = input.replaceAll("\u0111", "dj");
        input = input.replaceAll("\u0160", "S");
        input = input.replaceAll("\u0161", "s");
        input = input.replaceAll("\u017d", "Z");
        input = input.replaceAll("\u017e", "z");
        return input;
    }

    public static String replaceCyrillicWithEasternLatinChars(String input) {
        input = input.replaceAll("\u0409", "Lj");
        input = input.replaceAll("\u0459", "lj");
        input = input.replaceAll("\u040a", "Nj");
        input = input.replaceAll("\u045a", "nj");
        input = input.replaceAll("\u0415", "E");
        input = input.replaceAll("\u0435", "e");
        input = input.replaceAll("\u0420", "R");
        input = input.replaceAll("\u0440", "r");
        input = input.replaceAll("\u0422", "T");
        input = input.replaceAll("\u0442", "t");
        input = input.replaceAll("\u0417", "Z");
        input = input.replaceAll("\u0437", "z");
        input = input.replaceAll("\u0423", "U");
        input = input.replaceAll("\u0443", "u");
        input = input.replaceAll("\u0418", "I");
        input = input.replaceAll("\u0438", "i");
        input = input.replaceAll("\u041e", "O");
        input = input.replaceAll("\u043e", "o");
        input = input.replaceAll("\u041f", "P");
        input = input.replaceAll("\u043f", "p");
        input = input.replaceAll("\u0428", "\u0160");
        input = input.replaceAll("\u0448", "\u0161");
        input = input.replaceAll("\u0402", "\u0110");
        input = input.replaceAll("\u0452", "\u0111");
        input = input.replaceAll("\u0416", "\u017d");
        input = input.replaceAll("\u0436", "\u017e");
        input = input.replaceAll("\u0410", "A");
        input = input.replaceAll("\u0430", "a");
        input = input.replaceAll("\u0421", "S");
        input = input.replaceAll("\u0441", "s");
        input = input.replaceAll("\u0414", "D");
        input = input.replaceAll("\u0434", "d");
        input = input.replaceAll("\u0424", "F");
        input = input.replaceAll("\u0444", "f");
        input = input.replaceAll("\u0413", "G");
        input = input.replaceAll("\u0433", "g");
        input = input.replaceAll("\u0425", "H");
        input = input.replaceAll("\u0445", "h");
        input = input.replaceAll("\u0408", "J");
        input = input.replaceAll("\u0458", "j");
        input = input.replaceAll("\u041a", "K");
        input = input.replaceAll("\u043a", "k");
        input = input.replaceAll("\u041b", "L");
        input = input.replaceAll("\u043b", "l");
        input = input.replaceAll("\u0427", "\u010c");
        input = input.replaceAll("\u0447", "\u010d");
        input = input.replaceAll("\u040b", "\u0106");
        input = input.replaceAll("\u045b", "\u0107");
        input = input.replaceAll("\u040f", "D\u017e");
        input = input.replaceAll("\u045f", "d\u017e");
        input = input.replaceAll("\u0426", "C");
        input = input.replaceAll("\u0446", "c");
        input = input.replaceAll("\u0412", "V");
        input = input.replaceAll("\u0432", "v");
        input = input.replaceAll("\u0411", "B");
        input = input.replaceAll("\u0431", "b");
        input = input.replaceAll("\u041d", "N");
        input = input.replaceAll("\u043d", "n");
        input = input.replaceAll("\u041c", "M");
        input = input.replaceAll("\u043c", "m");
        return input;
    }

    public static char getDecimalSeparatorFromLocale(Locale curLocale) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(curLocale);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        char sep = symbols.getDecimalSeparator();
        return sep;
    }

    public static char getDecSepForCurLocale() {
        return StatLogic.getDecimalSeparatorFromLocale(Konstante.getCurLocale());
    }

    public static double round(double input, int scale) {
        return BigDecimal.valueOf(input).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static char[] getDecimalSeparators() {
        return decSeps;
    }

    public static List<Character> getDecimalSeparatorsList() {
        LinkedList<Character> list = new LinkedList<Character>();
        for (char c : StatLogic.getDecimalSeparators()) {
            list.add(Character.valueOf(c));
        }
        return list;
    }

    public static List<Character> getNotUsedDecimalSeparatorsList() {
        LinkedList<Character> list = new LinkedList<Character>();
        for (char c : StatLogic.getDecimalSeparators()) {
            if (c == StatLogic.getDecSepForCurLocale()) continue;
            list.add(Character.valueOf(c));
        }
        return list;
    }

    public static String replaceDecSep(String numberInput) {
        List<Character> list = StatLogic.getDecimalSeparatorsList();
        int idx = -1;
        for (Character character : list) {
            if (!numberInput.contains(character.toString())) continue;
            int n = idx = idx < numberInput.lastIndexOf(character.charValue()) ? numberInput.lastIndexOf(character.charValue()) : idx;
            if (idx == 0) {
                numberInput = "0" + numberInput;
                ++idx;
            }
            int len = numberInput.length();
            if ((numberInput = numberInput.replace(character.toString(), "")).length() >= len) continue;
            idx -= len - numberInput.length();
        }
        if (idx > -1) {
            numberInput = numberInput.substring(0, idx + 1) + StatLogic.getDecSepForCurLocale() + numberInput.substring(idx + 1);
        }
        return numberInput;
    }

    public static int daysBetween(Date from, Date to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument d1 cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument d2 cannot be null");
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(from);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(to);
        int days = 0;
        long t1 = c1.getTimeInMillis();
        long t2 = c2.getTimeInMillis();
        days = (int)((t2 + (long)c2.get(16) - (t1 + (long)c1.get(16))) / 1000L / 60L / 60L / 24L);
        return days;
    }

    public static int daysBetween(Calendar from, Calendar to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument d1 cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument d2 cannot be null");
        }
        return StatLogic.daysBetween(from.getTime(), to.getTime());
    }

    public static String defaultIfNull(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public static void main(String[] args) {
        System.out.println("getDecSepForCurLocale() = " + StatLogic.getDecSepForCurLocale());
        String ni = StatLogic.replaceDecSep("");
        System.out.println("ni = " + ni);
    }

    static {
        decSeps = new char[]{',', '.'};
        df = DateFormat.getDateInstance(2, Konstante.getCurLocale());
        tf = new SimpleDateFormat("HH:mm:ss");
        nf0_1 = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_1.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_1.setMinimumIntegerDigits(1);
        nf0_1.setMinimumFractionDigits(1);
        nf0_1.setMaximumFractionDigits(1);
        nf0_2 = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_2.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_2.setMinimumIntegerDigits(1);
        nf0_2.setMinimumFractionDigits(2);
        nf0_2.setMaximumFractionDigits(2);
        nf0_3 = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_3.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_3.setMinimumIntegerDigits(1);
        nf0_3.setMinimumFractionDigits(3);
        nf0_3.setMaximumFractionDigits(3);
        nf0_0_3 = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_0_3.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_0_3.setMinimumIntegerDigits(1);
        nf0_0_3.setMinimumFractionDigits(0);
        nf0_0_3.setMaximumFractionDigits(3);
        nf0_4 = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_4.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_4.setMinimumIntegerDigits(1);
        nf0_4.setMinimumFractionDigits(4);
        nf0_4.setMaximumFractionDigits(4);
        nf0 = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0.setMinimumIntegerDigits(1);
        nf0.setMinimumFractionDigits(0);
        nf0.setMaximumFractionDigits(0);
        nf0_1ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_1ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_1ng.setMinimumIntegerDigits(1);
        nf0_1ng.setMinimumFractionDigits(1);
        nf0_1ng.setMaximumFractionDigits(1);
        nf0_1ng.setGroupingUsed(false);
        nf0_0_1ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_0_1ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_0_1ng.setMinimumIntegerDigits(1);
        nf0_0_1ng.setMinimumFractionDigits(0);
        nf0_0_1ng.setMaximumFractionDigits(1);
        nf0_0_1ng.setGroupingUsed(false);
        nf0_2ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_2ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_2ng.setMinimumIntegerDigits(1);
        nf0_2ng.setMinimumFractionDigits(2);
        nf0_2ng.setMaximumFractionDigits(2);
        nf0_2ng.setGroupingUsed(false);
        nf0_0_2ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_0_2ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_0_2ng.setMinimumIntegerDigits(1);
        nf0_0_2ng.setMinimumFractionDigits(0);
        nf0_0_2ng.setMaximumFractionDigits(2);
        nf0_0_2ng.setGroupingUsed(false);
        nf0_3ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_3ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_3ng.setMinimumIntegerDigits(1);
        nf0_3ng.setMinimumFractionDigits(3);
        nf0_3ng.setMaximumFractionDigits(3);
        nf0_3ng.setGroupingUsed(false);
        nf0_0_3ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_0_3ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_0_3ng.setMinimumIntegerDigits(1);
        nf0_0_3ng.setMinimumFractionDigits(0);
        nf0_0_3ng.setMaximumFractionDigits(3);
        nf0_0_3ng.setGroupingUsed(false);
        nf0_4ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_4ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_4ng.setMinimumIntegerDigits(1);
        nf0_4ng.setMinimumFractionDigits(4);
        nf0_4ng.setMaximumFractionDigits(4);
        nf0_4ng.setGroupingUsed(false);
        nf0_0_4ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0_0_4ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0_0_4ng.setMinimumIntegerDigits(1);
        nf0_0_4ng.setMinimumFractionDigits(0);
        nf0_0_4ng.setMaximumFractionDigits(4);
        nf0_0_4ng.setGroupingUsed(false);
        nf0ng = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        nf0ng.setRoundingMode(RoundingMode.HALF_EVEN);
        nf0ng.setMinimumIntegerDigits(1);
        nf0ng.setMinimumFractionDigits(0);
        nf0ng.setMaximumFractionDigits(0);
        nf0ng.setGroupingUsed(false);
    }
}

