/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backup;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.backup.MySQLBackup;
import com.dev63.restoran.backup.MySQLBackupParams;
import com.dev63.restoran.model.OptionBO;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestoranBackup {
    private final String host = BMTerminalSettings.getSetting(OptionBO.ADRESA).stringValue();
    private final String user = BMTerminalSettings.getSetting(OptionBO.USER).stringValue();
    private final String pass = BMTerminalSettings.getSetting(OptionBO.PASS).stringValue();
    private final String filePath = BMTerminalSettings.getSetting(OptionBO.BACKUP_PUTANJA).stringValue();
    private final String schemaName = BMTerminalSettings.getSetting(OptionBO.BAZA).stringValue();

    public boolean doSilentBackup() {
        boolean success = false;
        try {
            String buPath = new File(new File(this.filePath), "restoran" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".sql").getAbsolutePath();
            MySQLBackup.backup(new MySQLBackupParams(this.host, this.user, this.pass, this.schemaName, buPath));
            success = true;
        }
        catch (Exception e) {
            Logger.getLogger(RestoranBackup.class.getName()).log(Level.SEVERE, "Greska kod iniciranja backupa baze", e);
        }
        return success;
    }

    public boolean doBackupToDir(File dir) throws Exception {
        boolean success = false;
        if (dir == null) {
            dir = new File(this.filePath);
        }
        try {
            String buPath = new File(dir, "restoran" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".sql").getAbsolutePath();
            MySQLBackup.backup(new MySQLBackupParams(this.host, this.user, this.pass, this.schemaName, buPath));
            success = true;
        }
        catch (Exception e) {
            Logger.getLogger(RestoranBackup.class.getName()).log(Level.SEVERE, "Greska kod iniciranja backupa baze", e);
            throw e;
        }
        return success;
    }
}

