/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.knjizenje;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.backoffice.knjizenje.PrikazKnjizenja;
import com.dev63.restoran.backoffice.parts.IzborStalnihGostiju;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.constants.TaxCalc;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Knjiziv;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.Trosak;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class KnjigaFaktura
extends Window {
    private RestoranServer server;
    private List<StalniGost> partneri;
    private Date dod;
    private Date ddo;
    private boolean sviGosti;
    private boolean samoNerealizovani;
    private TableViewer tvUlaz;
    private TableViewer tvIzlaz;
    private TableViewer tvZbir;

    public KnjigaFaktura(Shell parentShell, RestoranServer serverica) {
        super(parentShell);
        this.server = serverica;
        this.init();
    }

    public KnjigaFaktura(IShellProvider shellProvider, RestoranServer serverica) {
        super(shellProvider);
        this.server = serverica;
        this.init();
    }

    private void init() {
        this.partneri = this.server.findAllPartneri();
        this.sviGosti = true;
        this.samoNerealizovani = true;
        this.setShellStyle(34032);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format(Konstante.getBundle().getString("TEXT_KNJIGA_RACUNA"), new Object[0]));
        newShell.setMaximized(true);
    }

    protected Control createContents(Composite parent) {
        Composite cAll = new Composite(parent, 0);
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        cAll.setLayout((Layout)new GridLayout());
        final CTabFolder ctf = new CTabFolder(cAll, 2176);
        ctf.setLayoutData((Object)new GridData(4, 4, true, true));
        ctf.setFont(Konstante.getFont(parent.getShell().getDisplay(), 18, 0));
        CTabItem ctiUlazna = new CTabItem(ctf, 0);
        ctiUlazna.setText(TipKnjige.ULAZNA.getInterName());
        TableColumnLayout tclUlazna = new TableColumnLayout();
        Composite cUlazna = new Composite((Composite)ctf, 0);
        ctiUlazna.setControl((Control)cUlazna);
        cUlazna.setLayout((Layout)tclUlazna);
        this.tvUlaz = new TableViewer(cUlazna, 65540);
        this.tvUlaz.getTable().setHeaderVisible(true);
        this.tvUlaz.getTable().setLinesVisible(true);
        KnjizenjeLabelProvider klp = new KnjizenjeLabelProvider();
        this.tvUlaz.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.assignColumns(this.tvUlaz, tclUlazna, klp);
        CTabItem ctiIzlazna = new CTabItem(ctf, 0);
        ctiIzlazna.setText(TipKnjige.IZLAZNA.getInterName());
        TableColumnLayout tclIzlazna = new TableColumnLayout();
        Composite cIzlazna = new Composite((Composite)ctf, 0);
        ctiIzlazna.setControl((Control)cIzlazna);
        cIzlazna.setLayout((Layout)tclIzlazna);
        this.tvIzlaz = new TableViewer(cIzlazna, 65540);
        this.tvIzlaz.getTable().setHeaderVisible(true);
        this.tvIzlaz.getTable().setLinesVisible(true);
        KnjizenjeLabelProvider klpiz = new KnjizenjeLabelProvider();
        this.tvIzlaz.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.assignColumns(this.tvIzlaz, tclIzlazna, klpiz);
        CTabItem ctiZbirna = new CTabItem(ctf, 0);
        ctiZbirna.setText(TipKnjige.ZBIRNA.getInterName());
        TableColumnLayout tclZbirna = new TableColumnLayout();
        Composite cZbirna = new Composite((Composite)ctf, 0);
        ctiZbirna.setControl((Control)cZbirna);
        cZbirna.setLayout((Layout)tclZbirna);
        this.tvZbir = new TableViewer(cZbirna, 65540);
        this.tvZbir.getTable().setHeaderVisible(true);
        this.tvZbir.getTable().setLinesVisible(true);
        KnjizenjeLabelProvider klpzb = new KnjizenjeLabelProvider();
        this.tvZbir.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.assignColumns(this.tvZbir, tclZbirna, klpzb);
        Composite cControl = new Composite(cAll, 0);
        cControl.setLayoutData((Object)new GridData(4, 4, true, false));
        cControl.setLayout((Layout)new GridLayout(2, false));
        ViewerComparator kvcc = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Prijemnica pr;
                BObject tr;
                Racun racun;
                Date d1 = null;
                Date d2 = null;
                if (e1 instanceof Racun) {
                    racun = (Racun)e1;
                    d1 = racun.getDatum();
                } else if (e1 instanceof Trebovanje) {
                    tr = (Trebovanje)e1;
                    d1 = ((Trebovanje)tr).getDatumTrebovanja();
                } else if (e1 instanceof Prijemnica) {
                    pr = (Prijemnica)e1;
                    d1 = pr.getDatumPrijemnice();
                } else if (e1 instanceof Trosak) {
                    tr = (Trosak)e1;
                    d1 = ((Trosak)tr).getDan();
                }
                if (e2 instanceof Racun) {
                    racun = (Racun)e2;
                    d2 = racun.getDatum();
                } else if (e2 instanceof Trebovanje) {
                    tr = (Trebovanje)e2;
                    d2 = ((Trebovanje)tr).getDatumTrebovanja();
                } else if (e2 instanceof Prijemnica) {
                    pr = (Prijemnica)e2;
                    d2 = pr.getDatumPrijemnice();
                } else if (e2 instanceof Trosak) {
                    tr = (Trosak)e2;
                    d2 = ((Trosak)tr).getDan();
                }
                if (d1 == null) {
                    d1 = new Date(0L);
                }
                if (d2 == null) {
                    d2 = new Date(0L);
                }
                return d1.compareTo(d2);
            }
        };
        this.tvUlaz.setComparator(kvcc);
        this.tvIzlaz.setComparator(kvcc);
        this.tvZbir.setComparator(kvcc);
        Button b = new Button(cControl, 8);
        b.setText(String.format(Konstante.getBundle().getString("TEXT_KNJIZI"), new Object[0]));
        b.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        ((GridData)b.getLayoutData()).heightHint = 50;
        ((GridData)b.getLayoutData()).widthHint = 120;
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object obj;
                IStructuredSelection iSel = null;
                switch (ctf.getSelectionIndex()) {
                    case 0: {
                        iSel = (IStructuredSelection)KnjigaFaktura.this.tvUlaz.getSelection();
                        break;
                    }
                    case 1: {
                        iSel = (IStructuredSelection)KnjigaFaktura.this.tvIzlaz.getSelection();
                        break;
                    }
                    case 2: {
                        iSel = (IStructuredSelection)KnjigaFaktura.this.tvZbir.getSelection();
                    }
                }
                if (iSel != null && (obj = iSel.getFirstElement()) != null && obj instanceof Knjiziv) {
                    PrikazKnjizenja pk = new PrikazKnjizenja(KnjigaFaktura.this.getShell());
                    pk.setInput((Knjiziv)obj);
                    pk.setServer(KnjigaFaktura.this.server);
                    pk.setBlockOnOpen(true);
                    pk.open();
                    KnjigaFaktura.this.reloadData();
                }
            }
        });
        Button bIzlaz = new Button(cControl, 8);
        bIzlaz.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        bIzlaz.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        ((GridData)bIzlaz.getLayoutData()).heightHint = 50;
        ((GridData)bIzlaz.getLayoutData()).widthHint = 120;
        bIzlaz.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KnjigaFaktura.this.close();
            }
        });
        this.reloadData();
        return cAll;
    }

    public void reloadData() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                LinkedList<Object> list = new LinkedList<Object>();
                List<Racun> racuni = KnjigaFaktura.this.server.findIzlazniRacuniForPeriodAndStalniGosti(KnjigaFaktura.this.dod, KnjigaFaktura.this.ddo, KnjigaFaktura.this.partneri, KnjigaFaktura.this.samoNerealizovani);
                list.addAll(racuni);
                KnjigaFaktura.this.tvIzlaz.setInput(racuni);
                List<Object> fakture = KnjigaFaktura.this.server.findBeliUlazniRacuniForPeriodAndStalniGosti(KnjigaFaktura.this.dod, KnjigaFaktura.this.ddo, KnjigaFaktura.this.partneri, KnjigaFaktura.this.sviGosti, KnjigaFaktura.this.samoNerealizovani);
                list.addAll(fakture);
                KnjigaFaktura.this.tvUlaz.setInput(fakture);
                KnjigaFaktura.this.tvZbir.setInput(list);
            }
        });
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)t);
        } else {
            try {
                t.start();
                t.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(KnjigaFaktura.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void assignColumns(TableViewer tv, TableColumnLayout tcl, KnjizenjeLabelProvider klp) {
        TableViewerColumn tvcU1 = new TableViewerColumn(tv, 131072);
        tvcU1.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_DATUM"), new Object[0]));
        tvcU1.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU1.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        TableViewerColumn valuta = new TableViewerColumn(tv, 131072);
        valuta.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_VALUTA_PLACANJA_DATUM"), new Object[0]));
        valuta.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)valuta.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        TableViewerColumn tvcU2 = new TableViewerColumn(tv, 131072);
        tvcU2.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_BROJ_DOKUMENTA"), new Object[0]));
        tvcU2.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU2.getColumn(), (ColumnLayoutData)new ColumnWeightData(200, 200, true));
        TableViewerColumn tvcU3 = new TableViewerColumn(tv, 131072);
        tvcU3.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_PARTNER"), new Object[0]));
        tvcU3.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU3.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvcU4 = new TableViewerColumn(tv, 131072);
        tvcU4.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_IZNOS_BEZ_POREZA"), new Object[0]));
        tvcU4.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU4.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvcU5 = new TableViewerColumn(tv, 131072);
        tvcU5.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_POREZ"), new Object[0]));
        tvcU5.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU5.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvcU6 = new TableViewerColumn(tv, 131072);
        tvcU6.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_IZNOS"), new Object[0]));
        tvcU6.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU6.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvcU7 = new TableViewerColumn(tv, 131072);
        tvcU7.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_REALIZOVAN"), new Object[0]));
        tvcU7.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU7.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn ostatak = new TableViewerColumn(tv, 131072);
        ostatak.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_OSTALO_ZA_UPLATU"), new Object[0]));
        ostatak.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)ostatak.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvcU8 = new TableViewerColumn(tv, 131072);
        tvcU8.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_REALIZOVANI_IZNOS"), new Object[0]));
        tvcU8.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU8.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvcU9 = new TableViewerColumn(tv, 131072);
        tvcU9.getColumn().setText(String.format(Konstante.getBundle().getString("TEXT_VRSTA_DOKUMENTA"), new Object[0]));
        tvcU9.setLabelProvider((CellLabelProvider)klp);
        tcl.setColumnData((Widget)tvcU9.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
    }

    public boolean close() {
        this.partneri = this.server.findAllPartneri();
        this.sviGosti = true;
        return super.close();
    }

    public List<StalniGost> getPartneri() {
        return this.partneri;
    }

    public void setPartneri(List<StalniGost> partneri) {
        this.partneri = partneri;
    }

    public boolean isSviGosti() {
        return this.sviGosti;
    }

    public void setSviGosti(boolean sviGosti) {
        this.sviGosti = sviGosti;
    }

    public RestoranServer getServer() {
        return this.server;
    }

    public void setServer(RestoranServer server) {
        this.server = server;
    }

    public Date getDatumOd() {
        return this.dod;
    }

    public void setDatumOd(Date dod) {
        this.dod = dod;
    }

    public Date getDatumDo() {
        return this.ddo;
    }

    public void setDatumDo(Date ddo) {
        this.ddo = ddo;
    }

    public void setSamoNerealizovani(boolean samoNerealizovani) {
        this.samoNerealizovani = samoNerealizovani;
    }

    public static enum TipKnjige {
        ULAZNA(String.format(Konstante.getBundle().getString("TEXT_KNJIGA_ULAZA"), new Object[0])),
        IZLAZNA(String.format(Konstante.getBundle().getString("TEXT_KNJIGA_IZLAZA"), new Object[0])),
        ZBIRNA(String.format(Konstante.getBundle().getString("TEXT_ZBIRNA_KNJIGA"), new Object[0]));

        private String interName;

        private TipKnjige(String interName) {
            this.interName = interName;
        }

        public String getInterName() {
            return this.interName;
        }
    }

    public static class KnjigaFakturaInput2 {
        private KnjigaFaktura kf;
        private ResourceBundle barmasterText = Konstante.getBundle();
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private List<StalniGost> stalniGosti;
        private Button stalniGostIzbor;
        private Button ceoPeriodB;
        private Button sviStalniGosti;
        private Button samoNerealizovani;
        private boolean sviGosti = true;
        private boolean ceoPeriod = true;
        NacinPlacanja np = null;
        Shell parent;
        List<Button> belaDugmici = new ArrayList<Button>();
        List<Button> crnaDugmici = new ArrayList<Button>();

        public KnjigaFakturaInput2(Shell owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.kf = new KnjigaFaktura(this.parent, this.server);
            Shell shell = this.parent;
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            Image img = new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)img));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText(String.format(Konstante.getBundle().getString("TEXT_KNJIGA_RACUNA"), new Object[0]));
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText(String.format(Konstante.getBundle().getString("PORUKA_EKRAN_ZA_UNOS_PREGLED_I_ISPRAVKU"), new Object[0]));
            Button uputstvo = new Button(panel1, 8);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 90;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_UNOS_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 110;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_IZVESTAJA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label ceoPL = new Label((Composite)grupa1, 0);
            ceoPL.setText(String.format(Konstante.getBundle().getString("TEXT_CEO_PERIOD"), new Object[0]) + ":");
            this.ceoPeriodB = new Button((Composite)grupa1, 32);
            final Label od = new Label((Composite)grupa1, 0);
            od.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            final Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatuma = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            this.ceoPeriodB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    odDatuma.setEnabled(!ceoPeriodB.getSelection());
                    doDatuma.setEnabled(!ceoPeriodB.getSelection());
                    od.setEnabled(!ceoPeriodB.getSelection());
                    doD.setEnabled(!ceoPeriodB.getSelection());
                }
            });
            this.stalniGosti = this.server.findAllPartneri();
            this.stalniGostIzbor = new Button((Composite)grupa2, 8);
            GridData gda = new GridData(0x1000000, 0x1000000, false, true);
            gda.widthHint = 120;
            gda.heightHint = 40;
            this.stalniGostIzbor.setLayoutData((Object)gda);
            this.stalniGostIzbor.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_PARTNERA"), new Object[0]));
            this.stalniGostIzbor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LinkedList<Object> list = new LinkedList<Object>();
                    List<StalniGostiGrupa> grupe = server.readGrupeStGosti();
                    List<StalniGost> dobavljaci = server.allDobavljaci();
                    list.addAll(grupe);
                    list.addAll(dobavljaci);
                    IzborStalnihGostiju isg = new IzborStalnihGostiju(parent);
                    isg.setInput(list);
                    isg.create();
                    isg.getShell().setMaximized(true);
                    isg.open();
                    stalniGosti = isg.getStalniGosti();
                    if (stalniGosti.isEmpty()) {
                        stalniGosti.addAll(server.allDobavljaci());
                    }
                }
            });
            this.sviStalniGosti = new Button((Composite)grupa2, 32);
            this.sviStalniGosti.setText(String.format(Konstante.getBundle().getString("TEXT_SVI_PARTNERI"), new Object[0]));
            this.sviStalniGosti.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.widget;
                    stalniGostIzbor.setEnabled(!b.getSelection());
                }
            });
            Label ll = new Label((Composite)grupa2, 0);
            this.samoNerealizovani = new Button((Composite)grupa2, 32);
            this.samoNerealizovani.setText(String.format(Konstante.getBundle().getString("TEXT_SAMO_NEREALIZOVANI"), new Object[0]));
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            ceoPL.setLayoutData((Object)data);
            od.setLayoutData((Object)data);
            ll.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.samoNerealizovani.setLayoutData((Object)data);
            this.sviStalniGosti.setLayoutData((Object)data);
            this.sviStalniGosti.setSelection(this.sviGosti);
            this.sviStalniGosti.notifyListeners(13, new Event());
            this.ceoPeriodB.setSelection(this.ceoPeriod);
            this.ceoPeriodB.notifyListeners(13, new Event());
            this.ceoPeriodB.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.close();
        }

        private void ok() {
            if (this.ceoPeriodB.getSelection()) {
                this.kf.setDatumOd(this.server.getFirstDateZD());
                this.kf.setDatumDo(this.server.getLastDateZD());
            } else {
                try {
                    this.kf.setDatumOd(this.odDatuma.getResult());
                }
                catch (InputException ex) {
                    Logger.getLogger(KnjigaFaktura.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    this.kf.setDatumDo(this.doDatuma.getResult());
                }
                catch (InputException ex) {
                    Logger.getLogger(KnjigaFaktura.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.kf.setPartneri(this.stalniGosti);
            this.kf.setSamoNerealizovani(this.samoNerealizovani.getSelection());
            this.kf.setSviGosti(this.sviStalniGosti.getSelection());
            BusyIndicator.showWhile((Display)this.parent.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    kf.create();
                }
            });
            this.kf.getShell().setMaximized(true);
            this.kf.setBlockOnOpen(true);
            this.kf.open();
        }
    }

    private class KnjizenjeViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc;
            switch (this.propertyIndex) {
                case 0: {
                    Prijemnica pr;
                    BObject tr;
                    Racun racun;
                    Date d1 = null;
                    Date d2 = null;
                    if (e1 instanceof Racun) {
                        racun = (Racun)e1;
                        d1 = racun.getDatum();
                    } else if (e1 instanceof Trebovanje) {
                        tr = (Trebovanje)e1;
                        d1 = ((Trebovanje)tr).getDatumTrebovanja();
                    } else if (e1 instanceof Prijemnica) {
                        pr = (Prijemnica)e1;
                        d1 = pr.getDatumPrijemnice();
                    } else if (e1 instanceof Trosak) {
                        tr = (Trosak)e1;
                        d1 = ((Trosak)tr).getDan();
                    }
                    if (e2 instanceof Racun) {
                        racun = (Racun)e2;
                        d2 = racun.getDatum();
                    } else if (e2 instanceof Trebovanje) {
                        tr = (Trebovanje)e2;
                        d2 = ((Trebovanje)tr).getDatumTrebovanja();
                    } else if (e2 instanceof Prijemnica) {
                        pr = (Prijemnica)e2;
                        d2 = pr.getDatumPrijemnice();
                    } else if (e2 instanceof Trosak) {
                        tr = (Trosak)e2;
                        d2 = ((Trosak)tr).getDan();
                    }
                    if (d1 == null) {
                        d1 = new Date(0L);
                    }
                    if (d2 == null) {
                        d2 = new Date(0L);
                    }
                    rc = d1.compareTo(d2);
                    break;
                }
                case 1: {
                    Prijemnica pr;
                    BObject tr;
                    Racun racun;
                    String n1 = "";
                    String n2 = "";
                    if (e1 instanceof Racun) {
                        racun = (Racun)e1;
                        n1 = racun.getBrojFakture() != null ? racun.getBrojFakture().toString() : "";
                    } else if (e1 instanceof Trebovanje) {
                        tr = (Trebovanje)e1;
                        n1 = ((Trebovanje)tr).getBrTrebovanja() == null ? "" : ((Trebovanje)tr).getBrTrebovanja();
                    } else if (e1 instanceof Prijemnica) {
                        pr = (Prijemnica)e1;
                        n1 = pr.getBrPrijemnice() == null ? "" : pr.getBrPrijemnice();
                    } else if (e1 instanceof Trosak) {
                        tr = (Trosak)e1;
                        String string = n1 = ((Trosak)tr).getBrojTroska() == null ? "" : ((Trosak)tr).getBrojTroska();
                    }
                    if (e2 instanceof Racun) {
                        racun = (Racun)e2;
                        n2 = racun.getBrojFakture() != null ? racun.getBrojFakture().toString() : "";
                    } else if (e2 instanceof Trebovanje) {
                        tr = (Trebovanje)e2;
                        n2 = ((Trebovanje)tr).getBrTrebovanja() == null ? "" : ((Trebovanje)tr).getBrTrebovanja();
                    } else if (e2 instanceof Prijemnica) {
                        pr = (Prijemnica)e2;
                        n2 = pr.getBrPrijemnice() == null ? "" : pr.getBrPrijemnice();
                    } else if (e2 instanceof Trosak) {
                        tr = (Trosak)e2;
                        n2 = ((Trosak)tr).getBrojTroska() == null ? "" : ((Trosak)tr).getBrojTroska();
                    }
                    rc = n1.compareTo(n2);
                    break;
                }
                case 2: {
                    Prijemnica pr;
                    BObject tr;
                    StalniGost sg1;
                    Racun racun;
                    String n1 = "";
                    String n2 = "";
                    if (e1 instanceof Racun) {
                        racun = (Racun)e1;
                        sg1 = racun.getStalniGost();
                        n1 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    } else if (e1 instanceof Trebovanje) {
                        tr = (Trebovanje)e1;
                        sg1 = ((Trebovanje)tr).getDobavljac();
                        n1 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    } else if (e1 instanceof Prijemnica) {
                        pr = (Prijemnica)e1;
                        sg1 = pr.getDobavljac();
                        n1 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    } else if (e1 instanceof Trosak) {
                        tr = (Trosak)e1;
                        sg1 = ((Trosak)tr).getPartner();
                        String string = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : (n1 = "");
                    }
                    if (e2 instanceof Racun) {
                        racun = (Racun)e2;
                        sg1 = racun.getStalniGost();
                        n2 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    } else if (e2 instanceof Trebovanje) {
                        tr = (Trebovanje)e2;
                        sg1 = ((Trebovanje)tr).getDobavljac();
                        n2 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    } else if (e2 instanceof Prijemnica) {
                        pr = (Prijemnica)e2;
                        sg1 = pr.getDobavljac();
                        n2 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    } else if (e2 instanceof Trosak) {
                        tr = (Trosak)e2;
                        sg1 = ((Trosak)tr).getPartner();
                        n2 = sg1 != null ? (sg1.getNaziv() != null ? sg1.getNaziv() : "") : "";
                    }
                    rc = n1.compareTo(n2);
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class KnjizenjeLabelProvider
    extends CellLabelProvider {
        double iznosBezPoreza = 0.0;
        double porez = 0.0;
        double iznos = 0.0;
        double ostatak = 0.0;
        double realizovano = 0.0;

        private KnjizenjeLabelProvider() {
        }

        public void update(ViewerCell vc) {
            System.out.println("poceo update " + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()));
            Object element = vc.getElement();
            if (element instanceof Racun) {
                Racun racun = (Racun)element;
                Integer valutaSistem = racun.getStalniGost().getValutaPlacanja() == null ? Integer.parseInt(KnjigaFaktura.this.server.getSetting(Option.RACUN_VALUTA_PLACANJA).stringValue()) : racun.getStalniGost().getValutaPlacanja();
                Date d = racun.getDatum();
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                Calendar c = Calendar.getInstance();
                c.setTime(d);
                c.add(5, valutaSistem);
                String output = sdf.format(c.getTime());
                if (c.getTime().before(new Date())) {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(3));
                } else {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(6));
                }
                if (TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun) <= racun.getRealizovaniIznos()) {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(9));
                }
                switch (vc.getColumnIndex()) {
                    case 0: {
                        vc.setText(StatLogic.getDateString(racun.getDatum()));
                        break;
                    }
                    case 1: {
                        vc.setText(output);
                        break;
                    }
                    case 2: {
                        vc.setText(racun.getBrojFakture() != null ? racun.getBrojFakture().toString() : "");
                        break;
                    }
                    case 3: {
                        vc.setText(racun.getStalniGost() != null ? racun.getStalniGost().getNaziv() : "");
                        break;
                    }
                    case 4: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun)));
                        this.iznosBezPoreza += TaxCalc.getIznosBezPoreza(racun).doubleValue();
                        break;
                    }
                    case 5: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getPorez(racun)));
                        this.porez += TaxCalc.getPorez(racun).doubleValue();
                        break;
                    }
                    case 6: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun)));
                        this.iznos += this.iznosBezPoreza + this.porez;
                        break;
                    }
                    case 7: {
                        vc.setText(racun.getRealizovan() ? "DA" : "NE");
                        break;
                    }
                    case 8: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun) - racun.getRealizovaniIznos()));
                        this.ostatak += this.iznos - this.realizovano;
                        break;
                    }
                    case 9: {
                        vc.setText(StatLogic.getNumber02NG(racun.getRealizovaniIznos()));
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    case 10: {
                        vc.setText("Racun");
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    default: {
                        vc.setText("");
                        break;
                    }
                }
            } else if (element instanceof Trebovanje) {
                Trebovanje racun = (Trebovanje)element;
                if (racun.getDatumValute() == null) {
                    racun.setDatumValute(racun.getDatumUnosa());
                }
                try {
                    KnjigaFaktura.this.server.updateTrebovanje(racun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (racun.getDatumValute().before(new Date())) {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(3));
                } else {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(6));
                }
                if (TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun) <= racun.getRealizovaniIznos()) {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(9));
                }
                switch (vc.getColumnIndex()) {
                    case 0: {
                        vc.setText(StatLogic.getDateString(racun.getDatumTrebovanja()));
                        break;
                    }
                    case 1: {
                        vc.setText(racun.getDatumValute() == null ? new SimpleDateFormat("dd.MM.yyyy").format(racun.getDatumTrebovanja()) : new SimpleDateFormat("dd.MM.yyyy").format(racun.getDatumValute()));
                        break;
                    }
                    case 2: {
                        vc.setText(racun.getBrTrebovanja() != null ? racun.getBrTrebovanja() : "");
                        break;
                    }
                    case 3: {
                        vc.setText(racun.getDobavljac() != null ? racun.getDobavljac().getNaziv() : "");
                        break;
                    }
                    case 4: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun)));
                        this.iznosBezPoreza += TaxCalc.getIznosBezPoreza(racun).doubleValue();
                        break;
                    }
                    case 5: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getPorez(racun)));
                        this.porez += TaxCalc.getPorez(racun).doubleValue();
                        break;
                    }
                    case 6: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun)));
                        this.iznos += this.iznosBezPoreza + this.porez;
                        break;
                    }
                    case 7: {
                        vc.setText(racun.getRealizovan() ? "DA" : "NE");
                        break;
                    }
                    case 8: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun) - racun.getRealizovaniIznos()));
                        this.ostatak += this.iznos - this.realizovano;
                        break;
                    }
                    case 9: {
                        vc.setText(StatLogic.getNumber02NG(racun.getRealizovaniIznos()));
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    case 10: {
                        vc.setText("Trebovanje");
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    default: {
                        vc.setText("");
                        break;
                    }
                }
            } else if (element instanceof Prijemnica) {
                Prijemnica racun = (Prijemnica)element;
                if (racun.getDatumValute() == null) {
                    racun.setDatumValute(racun.getDatumUnosa());
                }
                try {
                    KnjigaFaktura.this.server.updatePrijemnica(racun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (racun.getDatumValute().before(new Date())) {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(3));
                } else {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(6));
                }
                if (TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun) <= racun.getRealizovaniIznos()) {
                    vc.setForeground(vc.getControl().getDisplay().getSystemColor(9));
                }
                switch (vc.getColumnIndex()) {
                    case 0: {
                        vc.setText(StatLogic.getDateString(racun.getDatumPrijemnice()));
                        break;
                    }
                    case 1: {
                        vc.setText(racun.getDatumValute() == null ? new SimpleDateFormat("dd.MM.yyyy").format(racun.getDatumPrijemnice()) : new SimpleDateFormat("dd.MM.yyyy").format(racun.getDatumValute()));
                        break;
                    }
                    case 2: {
                        vc.setText(racun.getBrPrijemnice() != null ? racun.getBrPrijemnice() : "");
                        break;
                    }
                    case 3: {
                        vc.setText(racun.getDobavljac() != null ? racun.getDobavljac().getNaziv() : "");
                        break;
                    }
                    case 4: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getPorez(racun)));
                        this.iznosBezPoreza += TaxCalc.getPorez(racun).doubleValue();
                        break;
                    }
                    case 5: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getPorez(racun)));
                        this.porez += TaxCalc.getPorez(racun).doubleValue();
                        break;
                    }
                    case 6: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun)));
                        this.iznos += this.iznosBezPoreza + this.porez;
                        break;
                    }
                    case 7: {
                        vc.setText(racun.getRealizovan() ? "DA" : "NE");
                        break;
                    }
                    case 8: {
                        vc.setText(StatLogic.getNumber02NG(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun) - racun.getRealizovaniIznos()));
                        this.ostatak += this.iznos - this.realizovano;
                        break;
                    }
                    case 9: {
                        vc.setText(StatLogic.getNumber02NG(racun.getRealizovaniIznos()));
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    case 10: {
                        vc.setText("Prijemnica");
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    default: {
                        vc.setText("");
                        break;
                    }
                }
            } else if (element instanceof Trosak) {
                Trosak racun = (Trosak)element;
                switch (vc.getColumnIndex()) {
                    case 0: {
                        vc.setText(StatLogic.getDateString(racun.getDan()));
                        break;
                    }
                    case 1: {
                        vc.setText("");
                        break;
                    }
                    case 2: {
                        vc.setText(racun.getBrojTroska() != null ? racun.getBrojTroska() : "");
                        break;
                    }
                    case 3: {
                        vc.setText(racun.getPartner() != null ? racun.getPartner().getNaziv() : "");
                        break;
                    }
                    case 4: {
                        vc.setText(StatLogic.getNumber02NG(StatLogic.round(TaxCalc.getIznosBezPoreza(racun), 2)));
                        this.iznosBezPoreza += TaxCalc.getIznosBezPoreza(racun).doubleValue();
                        break;
                    }
                    case 5: {
                        vc.setText(StatLogic.getNumber02NG(StatLogic.round(TaxCalc.getPorez(racun), 2)));
                        this.porez += TaxCalc.getPorez(racun).doubleValue();
                        break;
                    }
                    case 6: {
                        vc.setText(StatLogic.getNumber02NG(StatLogic.round(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun), 2)));
                        this.iznos += this.iznosBezPoreza + this.porez;
                        break;
                    }
                    case 7: {
                        vc.setText(racun.getRealizovan() ? "DA" : "NE");
                        break;
                    }
                    case 8: {
                        vc.setText(StatLogic.getNumber02NG(StatLogic.round(TaxCalc.getIznosBezPoreza(racun) + TaxCalc.getPorez(racun), 2) - racun.getRealizovaniIznos()));
                        this.ostatak += this.iznos - this.realizovano;
                        break;
                    }
                    case 9: {
                        vc.setText(StatLogic.getNumber02NG(StatLogic.round(racun.getRealizovaniIznos(), 2)));
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    case 10: {
                        vc.setText("Trosak");
                        this.realizovano += racun.getRealizovaniIznos().doubleValue();
                        break;
                    }
                    default: {
                        vc.setText("");
                    }
                }
            }
            System.out.println(this.iznosBezPoreza);
            System.out.println(this.porez);
            System.out.println(this.iznos);
            System.out.println(this.ostatak);
            System.out.println(this.realizovano);
        }
    }
}

