/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.apoteka;

import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.apoteka.PrescriptionPrintComposite;
import com.dev63.restoran.apoteka.Recept;
import com.dev63.restoran.exceptions.MenuVATGroupUndefinedException;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.stampa.FiskalniRacun;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SerializationUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class GlobRecRunner
extends Thread {
    public static final String GLOBAL_RECEPTURA_DIR = "C:/RECEPTURA/EXPORT";
    public static final String GLOBAL_RECEPTURA_RESPONSE_DIR = "C:/RECEPTURA/IMPORT/";
    private final File grDir = new File("C:/RECEPTURA/EXPORT");
    private final File grRespDir = new File("C:/RECEPTURA/IMPORT/");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private Artikal participacija;
    private Artikal ucesce;
    private EntityManager em;
    private char paymentType;
    private boolean responded = false;
    private int response = -1;
    private final String[] colNames = new String[]{"[ID]", "[SifRp]", "[SifZU]", "[PIO]", "[DatRodj]", "[OOP]", "[BrZK]", "[LBO]", "[Drz]", "[DatPropLeka]", "[BrKart]", "[IDLekar]", "[PropLek]", "[Dg]", "[DatIzdLeka]", "[IzdLek]", "[RBr]", "[Kol]", "[Cena]", "[LBOFarm]", "[ProcenatUcesca]", "[IznosParticipacije]"};
    private final boolean silent;
    private Konobar operater;
    private Restoran restoran;

    public GlobRecRunner(EntityManager em, Restoran restoran, boolean silent) {
        super.setDaemon(true);
        this.restoran = restoran;
        this.em = em;
        this.silent = silent;
        this.loadData();
    }

    public GlobRecRunner(EntityManager em, Restoran restoran) {
        super.setDaemon(true);
        this.restoran = restoran;
        this.em = em;
        this.silent = true;
        this.loadData();
    }

    public void loadData() {
        TypedQuery tq = this.em.createQuery("SELECT a FROM Artikal a WHERE a.name like :naziv", Artikal.class);
        tq.setParameter("naziv", (Object)"PARTICIPACIJA");
        tq.setMaxResults(1);
        this.participacija = (Artikal)tq.getSingleResult();
        tq.setParameter("naziv", (Object)"UCESCE");
        this.ucesce = (Artikal)tq.getSingleResult();
        this.operater = (Konobar)this.em.find(Konobar.class, (Object)1L);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    File[] sadrzaj;
                    for (File f : sadrzaj = this.grDir.listFiles()) {
                        try {
                            if (f.isFile() && f.canRead() && !f.isDirectory()) {
                                final Recept recept = this.readFile(f);
                                if (recept == null) {
                                    this.archiveFile(f);
                                    continue;
                                }
                                Artikal lek = this.findLekFromRecept(recept);
                                if (lek == null) {
                                    this.archiveFile(f);
                                    continue;
                                }
                                recept.setLek(lek);
                                this.paymentType = (char)78;
                                this.responded = false;
                                if (recept.getIznosParticipacije() > 0.0 || recept.getProcenatUcesca() > 0.0) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            Shell ss = new Shell(Display.getDefault(), 66568);
                                            ss.setBackground(Display.getDefault().getSystemColor(2));
                                            ss.setAlpha(128);
                                            ss.setMaximized(true);
                                            Shell s = new Shell(ss, 2048);
                                            s.setSize(new Point(500, 400));
                                            s.setLocation(new Point((Display.getDefault().getBounds().width - s.getBounds().width) / 2, (Display.getDefault().getBounds().height - s.getBounds().height) / 2));
                                            s.setLayout((Layout)new FillLayout());
                                            PrescriptionPrintComposite ppc = new PrescriptionPrintComposite((Composite)s, 2048, recept);
                                            ss.open();
                                            s.open();
                                            while (!ppc.isResponded()) {
                                                if (s.getDisplay().readAndDispatch()) continue;
                                                s.getDisplay().sleep();
                                            }
                                            s.dispose();
                                            ss.dispose();
                                            GlobRecRunner.this.paymentType = ppc.getPaymentType();
                                            GlobRecRunner.this.responded = true;
                                        }
                                    });
                                    while (!this.responded) {
                                        GlobRecRunner.sleep(200L);
                                    }
                                    if (this.paymentType == 'N') {
                                        if (!this.silent) {
                                            this.response = -1;
                                            Display.getDefault().asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 40);
                                                    mb.setMessage("Do\u0161lo je do gre\u0161ke prilikom odabira na\u010dina pla\u0107anja za recept");
                                                    GlobRecRunner.this.response = mb.open();
                                                }
                                            });
                                        }
                                        while (this.response == -1) {
                                            GlobRecRunner.sleep(200L);
                                        }
                                        Logger.getLogger(RestoranServer.class.getName()).log(Level.WARNING, "Do\u0161lo je do gre\u0161ke prilikom odabira na\u010dina pla\u0107anja za recept");
                                        continue;
                                    }
                                    if (this.operater == null) {
                                        if (!this.silent) {
                                            this.response = -1;
                                            Display.getDefault().asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 40);
                                                    mb.setMessage("Nije prijavljen operater da biste odstampali recept");
                                                    GlobRecRunner.this.response = mb.open();
                                                }
                                            });
                                        }
                                        while (this.response == -1) {
                                            GlobRecRunner.sleep(200L);
                                        }
                                        Logger.getLogger(GlobRecRunner.class.getName()).log(Level.WARNING, "Do\u0161lo je do gre\u0161ke prilikom odabira na\u010dina pla\u0107anja za recept");
                                        continue;
                                    }
                                }
                                Racun r = this.makeRacunRecept(recept, lek, this.paymentType);
                                this.printFiscal(r);
                                this.printNonFiscal(recept, lek);
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss_SSS");
                                File fTemp = new File(GLOBAL_RECEPTURA_RESPONSE_DIR, "Odgovor_" + sdf.format(new Date()) + ".txt.tmp");
                                if (fTemp.exists()) {
                                    fTemp.delete();
                                }
                                FileWriter fw = new FileWriter(fTemp);
                                fw.append(Integer.toString(recept.getId())).append("|").append(recept.getSifraRecepta()).append("|").append("R").append("|");
                                fw.flush();
                                fw.close();
                                File resp = new File(GLOBAL_RECEPTURA_RESPONSE_DIR, fTemp.getName().substring(0, fTemp.getName().length() - 4));
                                fTemp.renameTo(resp);
                                f.delete();
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (FiscalException ex) {
                            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (SerialIOException ex) {
                            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        if (!f.exists() || !f.isFile()) continue;
                        this.archiveFile(f);
                    }
                    GlobRecRunner.sleep(3000L);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    private boolean setupOk() {
        if (!this.grDir.exists() && !this.grDir.mkdirs()) {
            String msg = "Dirktorijum GLOBALRECEPTURE nije uspe\u0161no kreiran";
            if (!this.silent) {
                JOptionPane.showMessageDialog(null, msg);
            }
            System.out.println(msg);
            return false;
        }
        if (!this.grDir.isDirectory()) {
            if (!this.silent) {
                JOptionPane.showMessageDialog(null, "Dirktorijum GLOBALRECEPTURE nije direktorijum");
            }
            System.out.println("Gr dir nije direktorijum");
            return false;
        }
        if (!this.grDir.canRead()) {
            if (!this.silent) {
                JOptionPane.showMessageDialog(null, "Dirktorijum GLOBALRECEPTURE nije citljiv");
            }
            System.out.println("Gr dir nije citljiv");
            return false;
        }
        if (!this.grRespDir.exists() && !this.grRespDir.mkdirs()) {
            if (!this.silent) {
                JOptionPane.showMessageDialog(null, "Dirktorijum odgovora GLOBALRECEPTURE nije kreiran");
            }
            System.out.println("Gr odgovor dir nije kreiran");
            return false;
        }
        if (!this.grRespDir.isDirectory()) {
            if (!this.silent) {
                JOptionPane.showMessageDialog(null, "Dirktorijum GLOBALRECEPTURE nije direktorijum");
            }
            System.out.println("Gr odgovor dir nije direktorijum");
            return false;
        }
        if (!this.grRespDir.canRead()) {
            if (!this.silent) {
                JOptionPane.showMessageDialog(null, "Dirktorijum GLOBALRECEPTURE nije citljiv");
            }
            System.out.println("Gr odgovor dir nije citljiv");
            return false;
        }
        return true;
    }

    private void archiveFile(File f) {
        File moveF;
        File archDir = new File(GLOBAL_RECEPTURA_DIR, "Arhiva");
        if (!archDir.exists() || !archDir.isDirectory()) {
            archDir.mkdirs();
        }
        if ((moveF = new File(archDir, f.getName())).exists()) {
            moveF.delete();
        }
        System.out.println("" + f.renameTo(moveF));
        if (moveF.exists() && f.exists()) {
            f.delete();
        }
    }

    private Recept readFile(File f) throws IOException {
        System.out.println("f name je " + f.getName());
        List<String> ll = Files.readAllLines(f.toPath(), Charset.defaultCharset());
        int i = 0;
        String line = "";
        for (String s : ll) {
            System.out.println(++i + " : " + s);
            if (s.length() <= 0) continue;
            line = s;
            break;
        }
        String[] cols = line.split("\\|");
        Recept recept = new Recept();
        try {
            recept.setId(Integer.parseInt(cols[0]));
            recept.setSifraRecepta(cols[1]);
            recept.setSifraZU(Integer.parseInt(cols[2]));
            recept.setOsiguranik(cols[3]);
            recept.setDatumRodjOsg(this.sdf.parse(cols[4]));
            recept.setIdOsnoveOslobadjanja(Integer.parseInt(cols[5]));
            recept.setBrojZK(Long.parseLong(cols[6]));
            recept.setLicBrojOsig(cols[7]);
            recept.setDrzavaId(Integer.parseInt(cols[8]));
            recept.setDatPropisLeka(this.sdf.parse(cols[9]));
            recept.setBrojKartona(cols[10]);
            recept.setIdLekara(cols[11]);
            recept.setJklPropLeka(cols[12]);
            recept.setSifraDijagnoze(cols[13]);
            recept.setDatIzdLeka(this.sdf.parse(cols[14]));
            recept.setJklIzdLeka(cols[15]);
            recept.setRedniBrojRecepta(Integer.parseInt(cols[16]));
            recept.setKolicinaIzdLeka(Double.parseDouble(cols[17]));
            recept.setCenaIzdLeka(Double.parseDouble(cols[18]));
            recept.setLboFarmaceuta(cols[19]);
            recept.setProcenatUcesca(Double.parseDouble(cols[20]));
            recept.setIznosParticipacije(Double.parseDouble(cols[21]));
            Artikal art = new Artikal();
            art.setName("Bensedin");
            recept.setLek(art);
        }
        catch (NumberFormatException ex) {
            recept = null;
            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParseException ex) {
            recept = null;
            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
        }
        return recept;
    }

    public Konobar getOperater() {
        return this.operater;
    }

    public void setOperater(Konobar operater) {
        this.operater = operater;
    }

    public Artikal findLekFromRecept(Recept recept) throws InterruptedException {
        TypedQuery tq = this.em.createQuery("SELECT a FROM Artikal a WHERE a.jkl = :jkl", Artikal.class);
        tq.setParameter("jkl", (Object)recept.getJklIzdLeka());
        List aList = new LinkedList();
        aList = tq.getResultList();
        if (aList.isEmpty()) {
            if (!this.silent) {
                this.response = -1;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GlobRecRunner.this.response = JOptionPane.showConfirmDialog(null, "Ne postoji artikal sa zadatim JKL na receptu", "PharMaster", 0, 2);
                    }
                });
            }
            while (this.response < -1) {
                GlobRecRunner.sleep(200L);
            }
            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.WARNING, "Ne postoji artikal sa zadatim JKL na receptu {0}, jkl leka {1}", new Object[]{recept.getRedniBrojRecepta(), recept.getJklIzdLeka()});
            return null;
        }
        if (aList.size() > 1) {
            if (!this.silent) {
                MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 40);
                mb.setMessage("Postoji vise od jednog artikla sa zadatim JKL na receptu");
                mb.open();
            }
            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.WARNING, "Postoji vise od jednog artikla sa zadatim JKL na receptu {0}, jkl leka {1}", new Object[]{recept.getRedniBrojRecepta(), recept.getJklIzdLeka()});
        }
        return (Artikal)aList.get(0);
    }

    public Racun makeRacunRecept(Recept recept, Artikal lek, char paymentType) {
        StavkaRacuna sr;
        Racun r = new Racun();
        r.setBrojStola(0);
        r.setDatum(new Date());
        r.setFiskalniOdstampan(false);
        r.setPopust(0.0);
        r.setStorniran(false);
        r.setZatvoren(true);
        if (this.getOperater() == null) {
            return null;
        }
        r.setKonobar(this.getOperater());
        LinkedList<Tura> tList = new LinkedList<Tura>();
        Tura t = new Tura();
        t.setBrojStola(0);
        t.setBrojTure(0);
        t.setPocetak(new Timestamp(0L));
        t.setKraj(new Timestamp(0L));
        t.setDatum(r.getDatum());
        tList.add(t);
        LinkedList<StavkaRacuna> srList = new LinkedList<StavkaRacuna>();
        if (recept.getIznosParticipacije() > 0.0) {
            sr = new StavkaRacuna();
            sr.setArtikal(this.participacija);
            sr.setBrojStola(0);
            sr.setCena(recept.getIznosParticipacije());
            sr.setKolicina(1.0);
            sr.setNaziv(this.participacija.getName());
            sr.setRacun(r);
            sr.setTura(t);
            srList.add(sr);
        }
        if (recept.getProcenatUcesca() > 0.0) {
            sr = new StavkaRacuna();
            sr.setArtikal(this.ucesce);
            sr.setBrojStola(0);
            sr.setCena(Double.valueOf(Math.round(recept.getProcenatUcesca() * lek.getCena() * recept.getKolicinaIzdLeka())) / 100.0);
            sr.setKolicina(1.0);
            sr.setNaziv(this.ucesce.getName());
            sr.setRacun(r);
            sr.setTura(t);
            srList.add(sr);
        }
        sr = new StavkaRacuna();
        sr.setArtikal(lek);
        sr.setBrojStola(0);
        sr.setCena(0.0);
        sr.setKolicina(recept.getKolicinaIzdLeka());
        sr.setNaziv(lek.getName());
        sr.setRacun(r);
        sr.setTura(t);
        srList.add(sr);
        int iznos = 0;
        for (StavkaRacuna sr2 : srList) {
            iznos = (int)((double)iznos + sr2.getVrednost());
        }
        LinkedList<Placanje> plList = new LinkedList<Placanje>();
        Placanje p = new Placanje();
        p.setIznos(iznos);
        switch (paymentType) {
            case 'G': {
                p.setNacin(NacinPlacanja.GOTOVINA);
                break;
            }
            case 'C': {
                p.setNacin(NacinPlacanja.CEK);
                break;
            }
            case 'K': {
                p.setNacin(NacinPlacanja.KARTICA);
                break;
            }
            default: {
                p.setNacin(NacinPlacanja.GOTOVINA);
            }
        }
        p.setRacun(r);
        p.setVreme(r.getDatum());
        plList.add(p);
        EntityTransaction trans = this.em.getTransaction();
        try {
            trans.begin();
            this.em.persist((Object)r);
            t.setRacun(r);
            t = (Tura)this.em.merge((Object)t);
            LinkedList<StavkaRacuna> lsr = new LinkedList<StavkaRacuna>();
            for (StavkaRacuna stavkaRacuna : srList) {
                stavkaRacuna.setRacun(r);
                stavkaRacuna.setTura(t);
                StavkaRacuna stavkaRacuna2 = (StavkaRacuna)this.em.merge((Object)stavkaRacuna);
                lsr.add(stavkaRacuna2);
            }
            r.setStavke1(lsr);
            t.setStavke(lsr);
            LinkedList<Placanje> lp = new LinkedList<Placanje>();
            for (Placanje pl : plList) {
                pl.setRacun(r);
                pl = (Placanje)this.em.merge((Object)pl);
                lp.add(pl);
            }
            r.setPlacanja(lp);
            t = (Tura)this.em.merge((Object)t);
            LinkedList<Tura> linkedList = new LinkedList<Tura>();
            linkedList.add(t);
            r.setTure(linkedList);
            r = (Racun)this.em.merge((Object)r);
            trans.commit();
        }
        catch (Exception e) {
            Logger.getLogger(GlobRecRunner.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom upisivanja racuna", e);
            if (trans.isActive()) {
                trans.rollback();
            }
            return null;
        }
        return r;
    }

    public void printFiscal(Racun r) throws FiscalException, SQLException, SerialIOException {
        Racun rCopy = null;
        if (r != null && r.getId() != null) {
            rCopy = (Racun)SerializationUtils.clone((Serializable)r);
        }
        if (rCopy != null) {
            try {
                new FiskalniRacun(this.restoran).printFiscal(r, this.operater.getPunoime());
            }
            catch (MenuVATGroupUndefinedException ex) {
                Logger.getLogger(GlobRecRunner.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void printNonFiscal(Recept recept, Artikal lek) throws Exception {
        LinkedList<String> nfBlok = new LinkedList<String>();
        Double iznosParticipacije = recept.getIznosParticipacije();
        nfBlok.add("");
        nfBlok.add("PREGLED PARTICIPACIJE");
        nfBlok.add(lek.getName());
        if (recept.getIznosParticipacije() > 0.0) {
            nfBlok.add("VREDNOST");
            nfBlok.add(iznosParticipacije + " din");
        } else {
            nfBlok.add("PACIJENT OSLOBODJEN");
            nfBlok.add("PARTICIPACIJE");
        }
        nfBlok.add("");
        XMLWriter.writeNonFiscal(nfBlok);
    }
}

