/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.EvidencijaZaposlenih;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.sistem.IzracunajDnevniPromet;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ZakljucenjeDana {
    RestoranServer server;

    public ZakljucenjeDana(Restoran restoran, Shell shell, Event event, Button b) {
        this.server = restoran.getServer();
        if (this.server.getStolove().size() > 0 && !restoran.getServerBO().getSetting(OptionBO.RAD_BEZ_STOLOVA).booleanValue()) {
            Konstante.getPoruka(shell, "Morate zakljuciti sve stolove!");
            return;
        }
        int style = 65728;
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText("Info");
        messageBox.setMessage("Da li ste sigurni da zelite da zakljucite dan?\nPre zakljucenja dana potrebno je izvaditi fiskalni Z-izvestaj!");
        boolean bl = event.doit = messageBox.open() == 64;
        if (event.doit) {
            if (b != null) {
                b.setEnabled(false);
            }
            this.server.log("Zakljucenje dana");
            Date d = this.server.getLastDateZD();
            ZD zd = new ZD();
            zd.setDatum(d);
            zd.setZakljucenje(new Date());
            zd.setPocetak(Boolean.FALSE);
            zd.setZdBroj(this.server.getLastOpenZD().getZdBroj());
            this.server.addZD(zd);
            for (EvidencijaZaposlenih evidencijaZaposlenih : this.server.readNeodjavljeneZaposlene()) {
                evidencijaZaposlenih.setOdlazak(new Date());
                this.server.updateEZ(evidencijaZaposlenih);
            }
            this.server.refresh();
            IzracunajDnevniPromet dp = new IzracunajDnevniPromet(d, null, restoran.getServer());
            dp.createDnevnaStanja();
            for (DnevnoStanje ds : dp.getDnevnaStanja()) {
                this.server.addDnevnoStanje(ds);
            }
            Konstante.getPoruka3(shell, "Dan je uspesno zakljucen!");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ZakljucenjeDana.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            if (shell.getDisplay() != null && !shell.getDisplay().isDisposed()) {
                shell.getDisplay().dispose();
            }
            System.exit(1);
        }
    }
}

