/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.Pregled;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.UtrosakDoc;
import com.dev63.restoran.model.UtrosakDocStavke;
import com.dev63.restoran.model.UtrosakDocUtrosak;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.RekonstrukcijaSaPrikazom;
import com.dev63.restoran.stampa.UskaStampa;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PregledUtrosakDoc {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Shell shella;
    Restoran restoran;
    RestoranServer server;
    Display display;
    List list;
    private Date day;
    private Date day2;
    private SWTContainer parent;
    private UtrosakDoc active;
    private UtrosakDocStavke activeStavka;
    private Odeljenje odeljenje;
    boolean isCrno;
    Table table;
    private TableColumnLayout tcl;
    private TableViewer tableRacuni2V;
    List<UtrosakDoc> otpisi = new LinkedList<UtrosakDoc>();
    List<UtrosakDocStavke> stavke = new ArrayList<UtrosakDocStavke>();
    private Text pregled;
    private Text pretraga;
    private Combo artikal;
    private Double totalNab = 0.0;
    private Double totalProd = 0.0;
    private boolean poPosUnetCenama = false;
    private boolean poPosCenamaKombo = false;

    public PregledUtrosakDoc(final Shell shell, Restoran r, Date day1, Date day2, final Odeljenje o, Boolean crno) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shella = new Shell(shell, 1264);
        this.display = this.shella.getDisplay();
        this.shella.setText("Pregled utroska za odeljenje " + o.getNaziv());
        this.shella.setLayout((Layout)new GridLayout(2, false));
        this.shella.setBackground(this.display.getSystemColor(1));
        this.day = day1;
        this.day2 = day2;
        this.odeljenje = o;
        this.isCrno = crno;
        Composite tclc = new Composite((Composite)this.shella, 0);
        this.tcl = new TableColumnLayout();
        tclc.setLayout((Layout)this.tcl);
        this.table = new Table(tclc, 65796);
        this.table.setFont(Konstante.getFont(this.display, 8, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableRacuni2V = new TableViewer(this.table);
        this.tableRacuni2V.setContentProvider((IContentProvider)new PregledUtroskaDocContentProvider());
        this.tableRacuni2V.setInput(this.otpisi);
        final Button izmenaTreb = new Button((Composite)this.shella, 72);
        this.tableRacuni2V.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] items = PregledUtrosakDoc.this.table.getSelection();
                TableItem item = items[0];
                try {
                    Date datumOd = new SimpleDateFormat("dd.MM.yyyy").parse(item.getText(0));
                    PopisProvera provera = new PopisProvera(PregledUtrosakDoc.this.server, shell, datumOd, o, false);
                    if (provera.isPopis()) {
                        izmenaTreb.setEnabled(false);
                    } else {
                        izmenaTreb.setEnabled(true);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            Setting poPNC = this.server.getSetting(Option.PO_POSLEDNJIM_UNETIM_CENAMA);
            Setting poPNCKombo = this.server.getSetting(Option.PO_POSLEDNJIM_CENAMA_KOMBINOVANO);
            this.poPosUnetCenama = poPNC == null ? false : poPNC.booleanValue();
            this.poPosCenamaKombo = poPNCKombo == null ? false : poPNCKombo.booleanValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.makeHeaders();
        this.reload();
        Font buttonFont = FontCache.getFont("Arial", 18, 0);
        izmenaTreb.setText(String.format(this.barmasterText.getString("TEXT_IZMENA"), new Object[0]));
        izmenaTreb.setFont(buttonFont);
        izmenaTreb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledUtrosakDoc.this.table.getSelectionIndex() < 0) {
                    PregledUtrosakDoc.this.active = null;
                    return;
                }
                if (PregledUtrosakDoc.this.table.getSelectionIndex() > PregledUtrosakDoc.this.otpisi.size() - 1) {
                    return;
                }
                PregledUtrosakDoc.this.active = PregledUtrosakDoc.this.otpisi.get(PregledUtrosakDoc.this.table.getSelectionIndex());
                PregledUtrosakDoc.this.setActivePrijemnica(PregledUtrosakDoc.this.active, true);
            }
        });
        Button brisanjeTreb = new Button((Composite)this.shella, 72);
        brisanjeTreb.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE"), new Object[0]));
        brisanjeTreb.setFont(buttonFont);
        brisanjeTreb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledUtrosakDoc.this.table.getSelectionIndex() < 0) {
                    PregledUtrosakDoc.this.active = null;
                    return;
                }
                PregledUtrosakDoc.this.active = PregledUtrosakDoc.this.otpisi.get(PregledUtrosakDoc.this.table.getSelectionIndex());
                boolean potvrda = Konstante.getPorukaDaNe(shell, "Da li ste sigurni da hocete da obrisete utrosakDoc?").isOdgovorPozitivan();
                if (potvrda) {
                    Date d = PregledUtrosakDoc.this.active.getDatum();
                    int broj = PregledUtrosakDoc.this.server.sledeciBrojUtrosakDoc();
                    PregledUtrosakDoc.this.server.setBrojUtrosakDoc(broj);
                    List<UtrosakDocStavke> stavke = PregledUtrosakDoc.this.server.getUtrosakDocStavke(PregledUtrosakDoc.this.active);
                    for (UtrosakDocStavke uds : stavke) {
                        PregledUtrosakDoc.this.server.deleteUtrosakDocStavke(uds);
                    }
                    PregledUtrosakDoc.this.server.deleteUtrosakDoc(PregledUtrosakDoc.this.active);
                    PregledUtrosakDoc.this.izmenaPrometa(d);
                    PregledUtrosakDoc.this.reload();
                }
            }
        });
        Button potvrda = new Button((Composite)this.shella, 72);
        potvrda.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.setFont(buttonFont);
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledUtrosakDoc.this.table.getSelectionIndex() < 0) {
                    PregledUtrosakDoc.this.active = null;
                    return;
                }
                PregledUtrosakDoc.this.active = PregledUtrosakDoc.this.otpisi.get(PregledUtrosakDoc.this.table.getSelectionIndex());
                PregledUtrosakDoc.this.setActivePrijemnica(PregledUtrosakDoc.this.active, false);
            }
        });
        Button gore = new Button((Composite)this.shella, 132);
        gore.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledUtrosakDoc.this.table.getSelectionIndex();
                if (index == -1) {
                    if (PregledUtrosakDoc.this.table.getItemCount() != 0) {
                        PregledUtrosakDoc.this.table.setSelection(0);
                    }
                } else if (index != 0) {
                    PregledUtrosakDoc.this.table.setSelection(--index);
                }
            }
        });
        Button dole = new Button((Composite)this.shella, 1028);
        dole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledUtrosakDoc.this.table.getSelectionIndex();
                if (index == -1) {
                    PregledUtrosakDoc.this.table.setSelection(PregledUtrosakDoc.this.table.getItemCount() - 1);
                } else if (index != PregledUtrosakDoc.this.table.getItemCount() - 1) {
                    PregledUtrosakDoc.this.table.setSelection(++index);
                }
            }
        });
        Button button = new Button((Composite)this.shella, 72);
        button.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        button.setFont(buttonFont);
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledUtrosakDoc.this.shella.close();
            }
        });
        this.table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        data.verticalSpan = 7;
        tclc.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, true);
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData((Object)data);
        button.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        gore.setLayoutData((Object)data);
        dole.setLayoutData((Object)data);
        data = new GridData(0x1000000, 1, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        izmenaTreb.setLayoutData((Object)data);
        brisanjeTreb.setLayoutData((Object)data);
        this.shella.setMaximized(true);
        this.shella.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)buttonFont));
        this.shella.open();
        while (!this.shella.isDisposed()) {
            if (this.shella.getDisplay().readAndDispatch()) continue;
            this.shella.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn t1 = new TableColumn(this.table, 131072);
        t1.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        this.tcl.setColumnData((Widget)t1, (ColumnLayoutData)new ColumnWeightData(110, true));
        TableViewerColumn tvc1 = new TableViewerColumn(this.tableRacuni2V, t1);
        tvc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UtrosakDoc) {
                    UtrosakDoc t = (UtrosakDoc)element;
                    return StatLogic.getDateString(t.getDatum());
                }
                return "";
            }
        });
        TableColumn t5 = new TableColumn(this.table, 131072);
        t5.setText(String.format(this.barmasterText.getString("TEXT_BROJ"), new Object[0]));
        this.tcl.setColumnData((Widget)t5, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc5 = new TableViewerColumn(this.tableRacuni2V, t5);
        tvc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UtrosakDoc) {
                    UtrosakDoc t = (UtrosakDoc)element;
                    return t.getBroj();
                }
                return "";
            }
        });
        TableColumn t6 = new TableColumn(this.table, 131072);
        t6.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        this.tcl.setColumnData((Widget)t6, (ColumnLayoutData)new ColumnWeightData(140, true));
        TableViewerColumn tvc6 = new TableViewerColumn(this.tableRacuni2V, t6);
        tvc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UtrosakDoc) {
                    UtrosakDoc t = (UtrosakDoc)element;
                    Double total = 0.0;
                    for (UtrosakDocStavke os : PregledUtrosakDoc.this.server.readUtrosakDocStavke(t)) {
                        total = total + os.getVrednost();
                    }
                    return StatLogic.getNumber02(total);
                }
                return "";
            }
        });
        TableColumn t7 = new TableColumn(this.table, 131072);
        t7.setText(String.format(this.barmasterText.getString("TEXT_OPERATER"), new Object[0]));
        this.tcl.setColumnData((Widget)t7, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc7 = new TableViewerColumn(this.tableRacuni2V, t7);
        tvc7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof UtrosakDoc) {
                    UtrosakDoc t = (UtrosakDoc)element;
                    return t.getUname() != null ? t.getUname() : "";
                }
                return "";
            }
        });
        if (this.isCrno) {
            TableColumn t4 = new TableColumn(this.table, 0x1000000);
            t4.setText("Dodatno");
            t4.setWidth(100);
            this.tcl.setColumnData((Widget)t4, (ColumnLayoutData)new ColumnWeightData(100, true));
            TableViewerColumn tvc4 = new TableViewerColumn(this.tableRacuni2V, t4);
            tvc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof UtrosakDoc) {
                        UtrosakDoc t = (UtrosakDoc)element;
                        return PregledUtrosakDoc.this.isCrno ? String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_DA"), new Object[0]) : String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_NE"), new Object[0]);
                    }
                    return "";
                }
            });
        }
    }

    private void reload() {
        this.otpisi.clear();
        this.otpisi.addAll(this.server.readUtrosakDoc(this.day, this.day2, this.odeljenje, this.isCrno));
        this.tableRacuni2V.refresh();
        this.active = null;
    }

    private void setActivePrijemnica(UtrosakDoc p, boolean pregled) {
        this.active = p;
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell();
        shell2.setFullScreen(true);
        new UtrosakDocDialog(SWTContainerClass.makeContainer(shell2, ""), p, pregled);
    }

    public void izmenaPrometa(Date d) {
        RekonstrukcijaSaPrikazom rkp = new RekonstrukcijaSaPrikazom(this.shella, this.restoran, d);
        rkp.rekonstruisi();
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBela(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBela(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
        }
        return trNv;
    }

    private double getNabavnaCenaBezPDV(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(a) : this.server.getLastNabavnaCenaBelaBezPDV(a, new Date())) : a.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(a.getPoreskaGrupa()))) * mapa.get(a);
            }
        } else {
            trNv = (this.poPosUnetCenama ? (this.poPosCenamaKombo ? this.server.getLastNabavnaCenaKombo(art) : this.server.getLastNabavnaCenaBelaBezPDV(art, new Date())) : art.getTrenutnaNV()) / (1.0 + (this.poPosCenamaKombo || this.poPosUnetCenama ? 0.0 : Konstante.getPdvPoPG(art.getPoreskaGrupa()))) * kolicina;
        }
        return trNv;
    }

    private void saveUtrosakStavka(UtrosakDocStavke uds) {
        String query = "INSERT INTO utrosakdocstavke (cena, kolicina, ncUtroska, ncUtroskaBezPDV, vrednost, ARTIKAL_ID, UTROSAKDOC_ID ) VALUES(?,?,?,?,?,?,?)";
        Connection connection = this.server.getConnection();
        try {
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDouble(1, uds.getCena());
            ps.setDouble(2, uds.getKolicina());
            ps.setDouble(3, uds.getNcUtroska());
            ps.setDouble(4, uds.getNcUtroskaBezPDV());
            ps.setDouble(5, uds.getVrednost());
            ps.setLong(6, uds.getArtikal().getId());
            ps.setLong(7, uds.getUtrosakDoc().getId());
            ps.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void saveUtrosakDocUtrosak(UtrosakDocUtrosak udc) {
        String query = "INSERT INTO utrosakdocutrosak (kolicina, nabavnaCena, UTROSAKDOC_ID, ARTIKAL_ID, ODELJENJE_ID ) VALUES(?,?,?,?,?)";
        Connection connection = this.server.getConnection();
        try {
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDouble(1, udc.getKolicina());
            ps.setDouble(2, udc.getNabavnaCena());
            ps.setLong(3, udc.getUtrosakDoc().getId());
            ps.setLong(4, udc.getArtikal().getId());
            ps.setLong(5, udc.getOdeljenje().getId());
            ps.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void updateUtrosakDocdatum(UtrosakDoc udoc) {
        String query = "UPDATE utrosakdoc SET datum = ? WHERE id =?";
        Connection connection = this.server.getConnection();
        try {
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(udoc.getDatum().getTime()));
            ps.setLong(2, udoc.getId());
            ps.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private class UtrosakDocDialog {
        SWTContainer parent;
        Table table;
        Button plus;
        Button minus;
        UtrosakDoc utrosakDoc;
        boolean sifre;
        boolean pregled;
        private DateInput2 datum;
        double ukupnoNabavna = 0.0;
        double ukupnoNabavnaBezPDV = 0.0;
        double ukupnoProdajna = 0.0;

        public UtrosakDocDialog(SWTContainer owner, UtrosakDoc uDoc, boolean pregled) {
            PregledUtrosakDoc.this.server = PregledUtrosakDoc.this.restoran.getServer();
            this.parent = owner;
            this.utrosakDoc = uDoc;
            this.pregled = pregled;
            final Shell shell = this.parent.getControl().getShell();
            shell.setMaximized(true);
            try {
                this.sifre = PregledUtrosakDoc.this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
            }
            catch (Exception e) {
                this.sifre = false;
            }
            Composite sve = new Composite((Composite)shell, 0);
            Label pm = new Label(sve, 0);
            pm.setText(PregledUtrosakDoc.this.odeljenje != null ? PregledUtrosakDoc.this.odeljenje.getNaziv() : "");
            pm.setBackground(shell.getDisplay().getSystemColor(22));
            Label bo = new Label(sve, 0);
            bo.setText("Broj utrosakDoc:");
            bo.setBackground(shell.getDisplay().getSystemColor(22));
            Label brojPr = new Label(sve, 0);
            brojPr.setText(this.utrosakDoc.getBroj());
            brojPr.setBackground(shell.getDisplay().getSystemColor(22));
            Calendar c = Calendar.getInstance();
            c.setTime(this.utrosakDoc.getDatum());
            Date d = c.getTime();
            Label dat = new Label(sve, 0);
            dat.setText("Datum utrosakDoc:");
            dat.setBackground(shell.getDisplay().getSystemColor(22));
            this.datum = new DateInput2(sve, "Datum utrosakDoc:", PregledUtrosakDoc.this.server);
            this.datum.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datum, shell));
            this.datum.setResult(d);
            Label opisL = new Label(sve, 0);
            opisL.setText("Opis:");
            opisL.setBackground(shell.getDisplay().getSystemColor(22));
            Text opis = new Text(sve, 2560);
            opis.setText(this.utrosakDoc.getOpis());
            opis.setEnabled(false);
            Label separator1 = new Label(sve, 258);
            this.table = new Table(sve, 68356);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    if (UtrosakDocDialog.this.table.getSelectionIndex() > -1) {
                        for (UtrosakDocStavke os : PregledUtrosakDoc.this.server.readUtrosakDocStavke(UtrosakDocDialog.this.utrosakDoc)) {
                            String text = UtrosakDocDialog.this.table.getSelection()[0].getText().trim();
                            String text1 = !text.equals(null) && !text.equals("") ? UtrosakDocDialog.this.table.getSelection()[0].getText().trim().substring(1, UtrosakDocDialog.this.table.getSelection()[0].getText().length() - 2) : "";
                            if (UtrosakDocDialog.this.table.getSelection()[0].getText().trim() == null || !os.getArtikal().getName().equals(text1)) continue;
                            PregledUtrosakDoc.this.activeStavka = os;
                        }
                    }
                }
            });
            int artColumn = (this.parent.getWidth() - 300) / 6;
            int column = (this.parent.getWidth() - 300 - artColumn) / 7;
            TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
            nazivArtikla.setText("Artikal");
            nazivArtikla.setWidth(artColumn);
            TableColumn jm = new TableColumn(this.table, 0x1000000);
            jm.setText("J.M.");
            jm.setWidth(column / 2);
            TableColumn kolicina = new TableColumn(this.table, 0x1000000);
            kolicina.setText("Kol.");
            kolicina.setWidth(column / 2);
            TableColumn ckBezPDV = new TableColumn(this.table, 0x1000000);
            ckBezPDV.setText("Nab.Cena J.M. bez pdv-a");
            ckBezPDV.setWidth(column);
            TableColumn nvBezPDV = new TableColumn(this.table, 0x1000000);
            nvBezPDV.setText("NabVred. bez pdv-a");
            nvBezPDV.setWidth(column);
            TableColumn ck = new TableColumn(this.table, 0x1000000);
            ck.setText("Nab.Cena J.M.");
            ck.setWidth(column);
            TableColumn nv = new TableColumn(this.table, 0x1000000);
            nv.setText("NabVred.");
            nv.setWidth(column);
            TableColumn ck1 = new TableColumn(this.table, 0x1000000);
            ck1.setText("Prod.Cena J.M.");
            ck1.setWidth(column);
            TableColumn nv1 = new TableColumn(this.table, 0x1000000);
            nv1.setText("Prod.Vred.");
            nv1.setWidth(column);
            Label separator2 = new Label(sve, 258);
            Label t = new Label(sve, 0);
            t.setText("Ukupna nab.vrednost:");
            t.setBackground(shell.getDisplay().getSystemColor(22));
            Label total = new Label(sve, 0);
            double vrednost = 0.0;
            if (PregledUtrosakDoc.this.server.countUtrosakDocStavke(this.utrosakDoc) != 0.0) {
                vrednost = PregledUtrosakDoc.this.server.countUtrosakDocStavke(this.utrosakDoc);
            }
            total.setText(vrednost != 0.0 ? Konstante.getNumber2(vrednost) : "/");
            total.setBackground(shell.getDisplay().getSystemColor(22));
            Label t1 = new Label(sve, 0);
            t1.setText("Ukupna prod.vrednost:");
            t1.setBackground(shell.getDisplay().getSystemColor(22));
            Label total1 = new Label(sve, 0);
            double vrednost1 = 0.0;
            if (PregledUtrosakDoc.this.server.countUtrosakDocStavke(this.utrosakDoc) != 0.0) {
                for (UtrosakDocStavke os : PregledUtrosakDoc.this.server.readUtrosakDocStavke(this.utrosakDoc)) {
                    vrednost1 += os.getArtikal().getCena() / os.getArtikal().getMera() * os.getKolicina();
                }
            }
            total1.setText(vrednost1 != 0.0 ? Konstante.getNumber2(vrednost1) : "/");
            total1.setBackground(shell.getDisplay().getSystemColor(22));
            if (this.utrosakDoc != null) {
                for (UtrosakDocStavke udu : PregledUtrosakDoc.this.server.readUtrosakDocStavke(this.utrosakDoc)) {
                    PregledUtrosakDoc.this.stavke.add(udu);
                }
            }
            this.reloadTable();
            Label separator3 = new Label(sve, 258);
            GridLayout layoutSve = new GridLayout(2, false);
            layoutSve.marginHeight = 10;
            layoutSve.marginWidth = 10;
            layoutSve.verticalSpacing = 10;
            layoutSve.horizontalSpacing = 10;
            sve.setLayout((Layout)layoutSve);
            Composite dugmici = new Composite((Composite)shell, 0);
            Button printButt = new Button(dugmici, 8);
            printButt.setText(String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
            printButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Shell shell2 = new Shell(shell.getDisplay());
                    GridPrinter gp = new GridPrinter(new PrintHandler());
                    gp.printTable(new TableWrapper(UtrosakDocDialog.this.table), false, true, "UtrosakDoc artikala " + UtrosakDocDialog.this.utrosakDoc.getBroj() + "\nDatum: " + Konstante.getDate(UtrosakDocDialog.this.utrosakDoc.getDatum()) + "\nNapomena:" + UtrosakDocDialog.this.utrosakDoc.getOpis(), shell, PregledUtrosakDoc.this.server);
                }
            });
            Button uska = new Button(dugmici, 8);
            uska.setText(String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
            uska.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UskaStampa(UtrosakDocDialog.this.utrosakDoc, PregledUtrosakDoc.this.restoran);
                }
            });
            Button dodaj = new Button(dugmici, 8);
            dodaj.setEnabled(pregled);
            dodaj.setText(String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_DODAJ_STAVKU"), new Object[0]));
            dodaj.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UtrosakDocDialog.this.unosUtrosakDocStavke(shell, UtrosakDocDialog.this.table);
                    UtrosakDocDialog.this.reloadTable();
                }
            });
            Button del = new Button(dugmici, 8);
            del.setEnabled(pregled);
            del.setText(String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_OBRISI_STAVKU"), new Object[0]));
            del.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    int i;
                    if (PregledUtrosakDoc.this.activeStavka != null) {
                        i = UtrosakDocDialog.this.table.getSelectionIndex();
                        if (i == -1) {
                            return;
                        }
                    } else {
                        return;
                    }
                    UtrosakDocDialog.this.table.remove(i);
                    PregledUtrosakDoc.this.stavke.remove(i);
                    UtrosakDocDialog.this.reloadTable();
                }
            });
            Button okButt = Dugmici.getOkButton(dugmici);
            okButt.setEnabled(pregled);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Calendar dc = Calendar.getInstance();
                    if (PregledUtrosakDoc.this.stavke.size() < 1) {
                        Konstante.getPoruka(shell, "Morate uneti podatke za bar jedan artikal !");
                        return;
                    }
                    if (UtrosakDocDialog.this.utrosakDoc != null) {
                        try {
                            if (UtrosakDocDialog.this.datum.getResult().after(new Date())) {
                                Konstante.getPoruka(shell, "Uneti datum je neprihvatljiv!");
                                return;
                            }
                            dc.setTime(UtrosakDocDialog.this.datum.getResult());
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.set(5, dc.get(5));
                            cal.set(2, dc.get(2));
                            cal.set(1, dc.get(1));
                            UtrosakDocDialog.this.utrosakDoc = (UtrosakDoc)PregledUtrosakDoc.this.server.getBase().find(UtrosakDoc.class, (Object)UtrosakDocDialog.this.utrosakDoc.getId());
                            UtrosakDocDialog.this.utrosakDoc.setDatum(cal.getTime());
                            PregledUtrosakDoc.this.updateUtrosakDocdatum(UtrosakDocDialog.this.utrosakDoc);
                            List<UtrosakDocStavke> lista = PregledUtrosakDoc.this.stavke;
                            for (UtrosakDocStavke utrosakDocStavke : PregledUtrosakDoc.this.server.getUtrosakDocStavke(UtrosakDocDialog.this.utrosakDoc)) {
                                PregledUtrosakDoc.this.server.deleteUtrosakDocStavke(utrosakDocStavke);
                            }
                            for (UtrosakDocUtrosak utrosakDocUtrosak : PregledUtrosakDoc.this.server.getUtrosakDocUtrosak(UtrosakDocDialog.this.utrosakDoc)) {
                                PregledUtrosakDoc.this.server.deleteUtrosakDocUtrosak(utrosakDocUtrosak);
                            }
                            for (UtrosakDocStavke utrosakDocStavke : lista) {
                                utrosakDocStavke.setUtrosakDoc(UtrosakDocDialog.this.utrosakDoc);
                                UtrosakDocDialog.this.sacuvajUtrosakDocStavku(utrosakDocStavke);
                            }
                            if (!UtrosakDocDialog.this.unosUtrosakaDocUtrosak(UtrosakDocDialog.this.utrosakDoc, PregledUtrosakDoc.this.stavke)) {
                                SWTMessage.showMessageDialog(shell, "Neuspesan upis utrosaka u tabeli utrosakdocutrosak", String.format(PregledUtrosakDoc.this.barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                                return;
                            }
                            PregledUtrosakDoc.this.stavke.clear();
                        }
                        catch (InputException inputException) {
                            // empty catch block
                        }
                    }
                    UtrosakDocDialog.this.parent.getControl().getShell().close();
                }
            });
            Button cancelButt = Dugmici.getCancelButton(dugmici);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    PregledUtrosakDoc.this.stavke.clear();
                    UtrosakDocDialog.this.parent.getControl().getShell().close();
                }
            });
            GridLayout layout1 = new GridLayout(1, false);
            layout1.marginHeight = 10;
            layout1.marginWidth = 10;
            layout1.verticalSpacing = 10;
            layout1.horizontalSpacing = 10;
            dugmici.setLayout((Layout)layout1);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            bo.setLayoutData((Object)data);
            brojPr.setLayoutData((Object)data);
            dat.setLayoutData((Object)data);
            data.heightHint = 20;
            this.datum.getControl().setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            opisL.setLayoutData((Object)data);
            pm.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            separator1.setLayoutData((Object)data);
            separator2.setLayoutData((Object)data);
            separator3.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = this.parent.getWidth() - 300;
            data.heightHint = 300;
            this.table.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.heightHint = 60;
            opis.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalAlignment = 16384;
            t.setLayoutData((Object)data);
            total.setLayoutData((Object)data);
            t1.setLayoutData((Object)data);
            total1.setLayoutData((Object)data);
            data.widthHint = 120;
            data.heightHint = 40;
            printButt.setLayoutData((Object)data);
            uska.setLayoutData((Object)data);
            dodaj.setLayoutData((Object)data);
            del.setLayoutData((Object)data);
            cancelButt.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
            PregledUtrosakDoc.this.stavke.clear();
        }

        public void sacuvajUtrosakDocStavku(UtrosakDocStavke os) throws InputException {
            PregledUtrosakDoc.this.server.refresh();
            os.setVrednost(Double.parseDouble(Konstante.getNumber2(os.getNcUtroska() * os.getKolicina())));
            os.setId(null);
            PregledUtrosakDoc.this.saveUtrosakStavka(os);
        }

        protected synchronized boolean unosUtrosakaDocUtrosak(UtrosakDoc aktivanUtrosakDoc, List<UtrosakDocStavke> stavke) {
            System.out.println("ovde kreiram utroske otpisa");
            EntityManager base = PregledUtrosakDoc.this.server.getBase();
            boolean upis = false;
            try {
                HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
                HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
                HashMap<Artikal, Double> konacnaLista = new HashMap<Artikal, Double>();
                boolean prolazi = false;
                for (UtrosakDocStavke os : stavke) {
                    if (!artikal_kolicina.containsKey(os.getArtikal())) {
                        artikal_kolicina.put(os.getArtikal(), os.getKolicina());
                        continue;
                    }
                    artikal_kolicina.put(os.getArtikal(), (Double)artikal_kolicina.get(os.getArtikal()) + os.getKolicina());
                }
                ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    karticaList.clear();
                    normativ_kolicina.clear();
                    if (artikal.getOdeljenje() == null) continue;
                    for (Odeljenje o : artikal.getOdeljenja()) {
                        prolazi = PregledUtrosakDoc.this.odeljenje.equals(o);
                        if (prolazi) {
                            if (artikal.getTip() == TipArtikla.SLOZ || artikal.getTip() == TipArtikla.DODA) {
                                for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), PregledUtrosakDoc.this.server, artikal.getOdeljenje(), aktivanUtrosakDoc.getDatum()), PregledUtrosakDoc.this.server, o, aktivanUtrosakDoc.getDatum())) {
                                    boolean b = true;
                                    for (Kartica k2 : karticaList) {
                                        if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                                        k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                                        b = false;
                                    }
                                    if (!b) continue;
                                    k.setDokument("");
                                    k.setCrno(false);
                                    karticaList.add(k);
                                }
                            }
                            if (artikal.getTip() == TipArtikla.PROD || artikal.getTip() == TipArtikla.POLU || artikal.getTip() == TipArtikla.SIRO) {
                                if (!konacnaLista.containsKey(artikal)) {
                                    konacnaLista.put(artikal, (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                                } else {
                                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                                }
                            }
                        }
                        if (!prolazi) continue;
                        for (Kartica kartica : karticaList) {
                            if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                            normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                        }
                        for (Artikal artikal1 : normativ_kolicina.keySet()) {
                            if (!konacnaLista.containsKey(artikal1)) {
                                konacnaLista.put(artikal1, (Double)normativ_kolicina.get(artikal1));
                                continue;
                            }
                            konacnaLista.put(artikal1, (Double)konacnaLista.get(artikal1) + (Double)normativ_kolicina.get(artikal1));
                        }
                    }
                }
                for (Artikal artikal1 : konacnaLista.keySet()) {
                    UtrosakDocUtrosak utrosak = new UtrosakDocUtrosak();
                    utrosak.setUtrosakDoc(aktivanUtrosakDoc);
                    utrosak.setArtikal(artikal1);
                    utrosak.setOdeljenje(PregledUtrosakDoc.this.odeljenje);
                    utrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal1)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    utrosak.setNabavnaCena(artikal1.getTip() != TipArtikla.POLU ? PregledUtrosakDoc.this.server.getLastNabavnaCenaBelaBezPDV(artikal1, aktivanUtrosakDoc.getDatum()) : PregledUtrosakDoc.this.server.getNabavnaCenaPoluproizvodBezPDV(artikal1, 1.0));
                    PregledUtrosakDoc.this.saveUtrosakDocUtrosak(utrosak);
                }
                upis = true;
            }
            catch (Exception e) {
                upis = false;
                e.printStackTrace();
            }
            return upis;
        }

        public void unosUtrosakDocStavke(Shell shell, Table table) {
            final Shell shell2 = new Shell(shell.getDisplay(), 67680);
            shell2.setBackground(shell.getDisplay().getSystemColor(22));
            Monitor primary = shell2.getDisplay().getPrimaryMonitor();
            Rectangle bounds = primary.getBounds();
            Rectangle rect = shell2.getBounds();
            int x = bounds.x + rect.width / 2;
            int y = bounds.y + rect.height / 2;
            shell2.setLocation(x, y);
            final SortedMap<String, Long> artikli3 = PregledUtrosakDoc.this.server.getArtikliZaUtrosak(PregledUtrosakDoc.this.odeljenje.getId());
            final SWTContainer parent2 = new SWTContainer((Composite)shell2);
            Label p = new Label((Composite)shell2, 0);
            p.setText("Pretraga:");
            p.setBackground(shell.getDisplay().getSystemColor(22));
            PregledUtrosakDoc.this.pretraga = new Text((Composite)shell2, 0);
            PregledUtrosakDoc.this.pretraga.addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    switch (e.keyCode) {
                        case 13: 
                        case 0x1000050: {
                            String str = PregledUtrosakDoc.this.pretraga.getText();
                            if (str.length() > 0) {
                                PregledUtrosakDoc.this.artikal.removeAll();
                            }
                            SortedMap<Object, Object> sMapa = new TreeMap();
                            if (str == null || str.length() <= 0) {
                                return;
                            }
                            sMapa = PregledUtrosakDoc.this.server.getArtikliByNameOrBarcode(PregledUtrosakDoc.this.odeljenje.getId(), str);
                            if (sMapa.isEmpty()) {
                                Konstante.getPoruka3(shell2, "Nije pronadjen artikal po pretrazi");
                                for (String string : artikli3.keySet()) {
                                    PregledUtrosakDoc.this.artikal.add(string);
                                }
                                PregledUtrosakDoc.this.artikal.select(0);
                                break;
                            }
                            for (String string : sMapa.keySet()) {
                                PregledUtrosakDoc.this.artikal.add(string);
                            }
                            PregledUtrosakDoc.this.artikal.select(0);
                        }
                    }
                }
            });
            Label a = new Label((Composite)shell2, 0);
            a.setText("Artikal:");
            a.setBackground(shell2.getDisplay().getSystemColor(22));
            PregledUtrosakDoc.this.artikal = new Combo((Composite)shell2, 2572);
            for (String s : artikli3.keySet()) {
                PregledUtrosakDoc.this.artikal.add(s);
            }
            PregledUtrosakDoc.this.artikal.select(0);
            Label k = new Label((Composite)shell2, 0);
            k.setText("Kolicina :");
            k.setBackground(shell2.getDisplay().getSystemColor(22));
            final DoubleInput2 kolicina = new DoubleInput2(parent2, "Kolicina", false);
            Label c = new Label((Composite)shell2, 0);
            c.setText("Cena :");
            c.setBackground(shell2.getDisplay().getSystemColor(22));
            final DoubleInput2 cena = new DoubleInput2(parent2, "Cena", false);
            PregledUtrosakDoc.this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i = PregledUtrosakDoc.this.artikal.getSelectionIndex();
                    Artikal art = null;
                    if (i > -1) {
                        art = PregledUtrosakDoc.this.server.getArtikal(PregledUtrosakDoc.this.artikal.getItem(i));
                        cena.setResult(art.getCena());
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton(shell2);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    parent2.getControl().getShell().close();
                }
            });
            Button okButt = Dugmici.getOkButton(shell2);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        int i = PregledUtrosakDoc.this.artikal.getSelectionIndex();
                        Artikal art = null;
                        if (i > -1) {
                            art = PregledUtrosakDoc.this.server.getArtikal(PregledUtrosakDoc.this.artikal.getItem(i));
                        }
                        if (art == null) {
                            Konstante.getPoruka3(shell2, "Nije izabran artikal");
                            return;
                        }
                        UtrosakDocStavke os = new UtrosakDocStavke();
                        os.setArtikal(art);
                        os.setKolicina(kolicina.getResult());
                        os.setCena(cena.getResult());
                        os.setUtrosakDoc(PregledUtrosakDoc.this.active);
                        double nabavnaCenaUtroska = 0.0;
                        double nabavnaCenaBezPDV = 0.0;
                        if (art.getTip() == TipArtikla.SIRO || art.getTip() == TipArtikla.POLU) {
                            nabavnaCenaBezPDV = PregledUtrosakDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult());
                            nabavnaCenaUtroska = PregledUtrosakDoc.this.getNabavnaCena(art, kolicina.getResult());
                            os.setNcUtroskaBezPDV(Double.parseDouble(Konstante.getNumber2(nabavnaCenaBezPDV / kolicina.getResult())));
                            os.setNcUtroska(Double.parseDouble(Konstante.getNumber2(nabavnaCenaUtroska / kolicina.getResult())));
                            os.setVrednost(os.getNcUtroska() * kolicina.getResult());
                        } else if (art.getTip() == TipArtikla.SLOZ || art.getTip() == TipArtikla.DODA) {
                            art = (Artikal)PregledUtrosakDoc.this.server.getBase().find(Artikal.class, (Object)art.getId());
                            nabavnaCenaBezPDV = PregledUtrosakDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult());
                            nabavnaCenaUtroska = PregledUtrosakDoc.this.getNabavnaCena(art, kolicina.getResult());
                            os.setNcUtroskaBezPDV(Double.parseDouble(Konstante.getNumber2(nabavnaCenaBezPDV / kolicina.getResult())));
                            os.setNcUtroska(Double.parseDouble(Konstante.getNumber2(nabavnaCenaUtroska / kolicina.getResult())));
                            os.setVrednost(os.getNcUtroska() * kolicina.getResult());
                        } else {
                            art = (Artikal)PregledUtrosakDoc.this.server.getBase().find(Artikal.class, (Object)art.getId());
                            nabavnaCenaBezPDV = PregledUtrosakDoc.this.getNabavnaCenaBezPDV(art, kolicina.getResult());
                            nabavnaCenaUtroska = PregledUtrosakDoc.this.getNabavnaCena(art, kolicina.getResult());
                            os.setNcUtroskaBezPDV(Double.parseDouble(Konstante.getNumber2(nabavnaCenaBezPDV / kolicina.getResult())));
                            os.setNcUtroska(Double.parseDouble(Konstante.getNumber2(nabavnaCenaUtroska / kolicina.getResult())));
                            os.setVrednost(os.getNcUtroska() * kolicina.getResult());
                        }
                        PregledUtrosakDoc.this.stavke.add(os);
                        UtrosakDocDialog.this.reloadTable();
                        shell2.close();
                    }
                    catch (InputException ex) {
                        Konstante.getPoruka(shell2, ex.getMessage());
                    }
                }
            });
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell2.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 200;
            data.horizontalAlignment = 131072;
            PregledUtrosakDoc.this.artikal.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 30;
            data.horizontalAlignment = 16384;
            a.setLayoutData((Object)data);
            k.setLayoutData((Object)data);
            c.setLayoutData((Object)data);
            PregledUtrosakDoc.this.pretraga.setLayoutData((Object)data);
            kolicina.getControl().setLayoutData((Object)data);
            cena.getControl().setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            shell2.pack();
            shell2.open();
        }

        public double izracunajNabVrednost(Artikal input) {
            double nv = 0.0;
            try {
                for (Normativ n : PregledUtrosakDoc.this.server.getNormativiByLastNormativiArtikal(input.getId())) {
                    nv += n.getSastojak().getTrenutnaNV() * n.getKolicina();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            return nv;
        }

        protected void reloadTable() {
            this.table.removeAll();
            LinkedList<UtrosakDocStavke> deset = new LinkedList<UtrosakDocStavke>();
            LinkedList<UtrosakDocStavke> dvadeset = new LinkedList<UtrosakDocStavke>();
            for (UtrosakDocStavke ps : PregledUtrosakDoc.this.stavke) {
                String n;
                if (ps.getArtikal().getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_DJ)) {
                    dvadeset.add(ps);
                } else if (ps.getArtikal().getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_E)) {
                    deset.add(ps);
                }
                Artikal a = ps.getArtikal();
                TableItem item = new TableItem(this.table, 0);
                if (this.sifre) {
                    String s = ps.getArtikal().getBarCode() != null ? ps.getArtikal().getBarCode() : "";
                    n = " (" + ps.getArtikal().getName() + ")";
                } else {
                    n = ps.getArtikal().getName();
                }
                item.setText(new String[]{n, a.getJedinicaMere(), Konstante.getNumber2(ps.getKolicina()), Konstante.getNumber2(ps.getNcUtroskaBezPDV()), Konstante.getNumber2(ps.getNcUtroskaBezPDV() * ps.getKolicina()), ps.getNcUtroska() != null ? Konstante.getNumber2(ps.getNcUtroska()) : "/", ps.getNcUtroska() != null ? Konstante.getNumber2(ps.getNcUtroska() * ps.getKolicina()) : "/", ps.getCena() != null ? Konstante.getNumber2(ps.getCena() / a.getMera()) : "0.0", ps.getCena() != null ? Konstante.getNumber2(ps.getCena() / a.getMera() * ps.getKolicina()) : "0.0"});
                this.ukupnoNabavnaBezPDV += ps.getNcUtroskaBezPDV() * ps.getKolicina();
                this.ukupnoNabavna += ps.getNcUtroska() * ps.getKolicina();
                this.ukupnoProdajna += ps.getCena() != null ? ps.getCena() / a.getMera() * ps.getKolicina() : 0.0;
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{"", "", "", "UKUPNO: ", Konstante.getNumber2(this.ukupnoNabavnaBezPDV), "", Konstante.getNumber2(this.ukupnoNabavna), "", Konstante.getNumber2(this.ukupnoProdajna)});
            if (PregledUtrosakDoc.this.server.readUtrosakDocStavke(this.utrosakDoc).isEmpty()) {
                this.parent.getControl().getShell().close();
                PregledUtrosakDoc.this.server.deleteUtrosakDoc(this.utrosakDoc);
                PregledUtrosakDoc.this.reload();
            }
            PregledUtrosakDoc.this.activeStavka = null;
        }
    }

    public static class PregledUtroskaDocContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof List)) {
                return new Object[0];
            }
            List trebList = (List)inputElement;
            if (trebList.isEmpty()) {
                return new Object[0];
            }
            LinkedList ret = new LinkedList();
            SummaryWrapper total = new SummaryWrapper(0.0, 0.0);
            for (Object o : trebList) {
                if (!(o instanceof UtrosakDoc)) continue;
                UtrosakDoc t = (UtrosakDoc)o;
                double totalBPDV = 0.0;
                double totalSPDV = 0.0;
                for (UtrosakDocStavke ts : t.getStavke()) {
                    Double komadBPDV = ts.getVrednost();
                    if (komadBPDV == null) {
                        komadBPDV = Konstante.getOsnovicaFromBruto(ts.getArtikal().getPoreskaGrupa(), ts.getVrednost());
                    }
                    totalBPDV += komadBPDV * ts.getKolicina();
                    totalSPDV += ts.getVrednost() * ts.getKolicina();
                }
                total.addTotalBPDV(totalBPDV);
                total.addTotal(totalSPDV);
                ret.add(o);
            }
            ret.add(total);
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public static class SummaryWrapper {
            private double total;
            private double totalBPDV;

            public SummaryWrapper(double total, double totalBPDV) {
                this.total = total;
                this.totalBPDV = totalBPDV;
            }

            public double getTotal() {
                return this.total;
            }

            public double getTotalBPDV() {
                return this.totalBPDV;
            }

            public double addTotal(double total) {
                this.total += total;
                return this.total;
            }

            public double addTotalBPDV(double total) {
                this.totalBPDV += total;
                return this.totalBPDV;
            }
        }
    }

    public static class PregledUtrosakDocInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        Odeljenje o;
        Button crno;
        SWTContainer parent;
        boolean inspektor = false;
        boolean crn = false;

        public PregledUtrosakDocInput(SWTContainer owner, Restoran r, Odeljenje ode, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.o = ode;
            this.inspektor = inspektor;
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Pregled otpisa");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("");
            Button uputstvo = new Button(panel1, 0);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            Label dod = new Label((Composite)grupa1, 0);
            od.setText("Za dan:");
            dod.setText("Do dana:");
            this.odDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            this.doDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label cr = null;
            if (inspektor) {
                cr = new Label((Composite)grupa1, 0);
                cr.setText("Utrosak dodatnog stanja:");
                this.crno = new Button((Composite)grupa1, 32);
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            dod.setLayoutData((Object)data);
            if (inspektor) {
                cr.setLayoutData((Object)data);
            }
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            if (inspektor) {
                this.crno.setLayoutData((Object)data);
            }
            SWTContainerClass.setDimension(shell);
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                if (this.inspektor) {
                    this.crn = this.crno.getSelection();
                }
                this.server.log("Utrosak za dan->" + this.day1);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new PregledUtrosakDoc(shell2, this.restoran, this.day1, this.day2, this.o, this.crn);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

