/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.Pregled;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.IDKartica;
import com.dev63.restoran.model.Login;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.UpravljanjeTrebovanjem;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PregledTrebovanja2 {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Shell shell5;
    private Table tableRacuni2;
    private final TableViewer tableRacuni2V;
    private final Restoran restoran;
    private final RestoranServer server;
    private final Odeljenje iz;
    private final Odeljenje u;
    private final List<Trebovanje> trebovanja = new LinkedList<Trebovanje>();
    private Trebovanje active;
    private final boolean crno;
    private final boolean belo;
    private final Display display;
    private final Date fromDate;
    private final Date toDate;
    private final TipTrebovanja type;
    private final StalniGost dobavljac;
    private final TableColumnLayout tcl;
    Listener listener2;
    Rectangle bounds;
    private boolean inspektor;
    private boolean preskociSifru = false;
    private boolean hasap;

    public PregledTrebovanja2(final Shell parent, Restoran r, Date dayFrom, Date dayTo, final Odeljenje iz, final Odeljenje u, StalniGost dobavljac, boolean belo, boolean crno, final TipTrebovanja tip, boolean inspektor, boolean hasap) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.iz = iz;
        this.u = u;
        this.crno = this.server.getUser().getService() != false && crno;
        this.belo = belo;
        this.display = parent.getDisplay();
        this.fromDate = dayFrom;
        this.toDate = dayTo;
        this.type = tip;
        this.dobavljac = dobavljac;
        this.inspektor = inspektor;
        this.hasap = hasap;
        Monitor primary = this.display.getPrimaryMonitor();
        this.bounds = primary.getBounds();
        Login l = this.server.getUser();
        if (l.getOtvaraTrebovanje() == null) {
            l.setOtvaraTrebovanje(false);
        }
        final boolean otvaraTrebovanje = l.getOtvaraTrebovanje();
        this.preskociSifru = BMTerminalSettings.getSetting(OptionBO.PRESKOCI_SIFRU_TREBOVANJE).booleanValue();
        this.shell5 = new Shell(parent.getDisplay(), 1264);
        this.shell5.setText(tip.getInterName() + " - " + String.format(this.barmasterText.getString("TEXT_PREGLED_ZA_PERIOD"), new Object[0]) + " " + StatLogic.getDateString(this.fromDate) + " - " + StatLogic.getDateString(this.toDate) + " " + String.format(this.barmasterText.getString("TEXT_ZA_ODELJENJE"), new Object[0]) + ": " + (tip.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI ? (u == null ? "" : u.getNaziv()) : (iz == null ? "" : iz.getNaziv())) + (dobavljac == null ? "" : ", " + String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ": " + dobavljac.getNaziv()));
        this.shell5.setLayout((Layout)new GridLayout(2, false));
        this.shell5.setBackground(this.display.getSystemColor(1));
        Composite tclc = new Composite((Composite)this.shell5, 0);
        this.tcl = new TableColumnLayout();
        tclc.setLayout((Layout)this.tcl);
        this.tableRacuni2 = new Table(tclc, 65796);
        this.tableRacuni2.setFont(Konstante.getFont(this.display, 8, 0));
        this.tableRacuni2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableRacuni2.setLinesVisible(true);
        this.tableRacuni2.setHeaderVisible(true);
        this.tableRacuni2V = new TableViewer(this.tableRacuni2);
        this.tableRacuni2V.setContentProvider((IContentProvider)new PregledTrebovanjaContentProvider());
        this.tableRacuni2V.setInput(this.trebovanja);
        final Button izmenaTreb = new Button((Composite)this.shell5, 72);
        this.tableRacuni2V.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Odeljenje o = tip == TipTrebovanja.DIREKTNO_SA_KNJIZ || tip == TipTrebovanja.DIREKTNO_BEZ_KNJIZ || tip == TipTrebovanja.MEDJUTREBOVANJE || tip == TipTrebovanja.IZ_MAGACINA ? u : iz;
                TableItem[] items = PregledTrebovanja2.this.tableRacuni2.getSelection();
                if (items != null && items.length > 0) {
                    TableItem item = items[0];
                    try {
                        Date datumOd = new SimpleDateFormat("dd.MM.yyyy").parse(item.getText(0));
                        PopisProvera provera = new PopisProvera(PregledTrebovanja2.this.server, PregledTrebovanja2.this.shell5, datumOd, o, false);
                        if (provera.isPopis()) {
                            izmenaTreb.setEnabled(false);
                        } else {
                            izmenaTreb.setEnabled(true);
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.makeHeaders();
        this.reloadRows();
        Font buttonFont = FontCache.getFont("Arial", 18, 0);
        izmenaTreb.setText(String.format(this.barmasterText.getString("TEXT_IZMENA"), new Object[0]));
        izmenaTreb.setFont(buttonFont);
        izmenaTreb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledTrebovanja2.this.tableRacuni2.getSelectionIndex() < 0) {
                    PregledTrebovanja2.this.active = null;
                    return;
                }
                Shell sh = new Shell(parent.getDisplay(), 34912);
                parent.getDisplay().addListener(21, PregledTrebovanja2.this.listener2);
                boolean b = false;
                if (!PregledTrebovanja2.this.preskociSifru && !otvaraTrebovanje) {
                    ServOper so = new ServOper(PregledTrebovanja2.this.server, sh);
                    Konstante.endShell(sh);
                    b = so.getSO();
                }
                if (b || PregledTrebovanja2.this.preskociSifru || otvaraTrebovanje) {
                    PregledTrebovanja2.this.editDocument();
                    PregledTrebovanja2.this.reloadRows();
                }
            }
        });
        this.listener2 = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 21) {
                    PregledTrebovanja2.this.shell5.setEnabled(true);
                }
            }
        };
        Button brisanjeTreb = new Button((Composite)this.shell5, 72);
        brisanjeTreb.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE"), new Object[0]));
        brisanjeTreb.setFont(buttonFont);
        brisanjeTreb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledTrebovanja2.this.tableRacuni2.getSelectionIndex() < 0) {
                    PregledTrebovanja2.this.active = null;
                    return;
                }
                Shell sh = new Shell(parent.getDisplay(), 34912);
                parent.getDisplay().addListener(21, PregledTrebovanja2.this.listener2);
                boolean b = false;
                if (!PregledTrebovanja2.this.preskociSifru && !otvaraTrebovanje) {
                    ServOper so = new ServOper(PregledTrebovanja2.this.server, sh);
                    Konstante.endShell(sh);
                    b = so.getSO();
                }
                if (b || PregledTrebovanja2.this.preskociSifru || otvaraTrebovanje) {
                    PregledTrebovanja2.this.deleteDocument();
                    PregledTrebovanja2.this.reloadRows();
                }
            }
        });
        Button potvrda = new Button((Composite)this.shell5, 72);
        potvrda.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.setFont(buttonFont);
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledTrebovanja2.this.openDocument();
            }
        });
        Button gore = new Button((Composite)this.shell5, 132);
        gore.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledTrebovanja2.this.tableRacuni2.getSelectionIndex();
                if (index == -1) {
                    if (PregledTrebovanja2.this.tableRacuni2.getItemCount() != 0) {
                        PregledTrebovanja2.this.tableRacuni2.setSelection(0);
                    }
                } else if (index != 0) {
                    PregledTrebovanja2.this.tableRacuni2.setSelection(--index);
                }
            }
        });
        Button dole = new Button((Composite)this.shell5, 1028);
        dole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledTrebovanja2.this.tableRacuni2.getSelectionIndex();
                if (index == -1) {
                    PregledTrebovanja2.this.tableRacuni2.setSelection(PregledTrebovanja2.this.tableRacuni2.getItemCount() - 1);
                } else if (index != PregledTrebovanja2.this.tableRacuni2.getItemCount() - 1) {
                    PregledTrebovanja2.this.tableRacuni2.setSelection(++index);
                }
            }
        });
        Button stampa = new Button((Composite)this.shell5, 8);
        stampa.setText(String.format(Konstante.getBundle().getString("TEXT_STAMPA"), new Object[0]));
        stampa.setFont(buttonFont);
        stampa.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GridPrinter gp = new GridPrinter(new PrintHandler());
                gp.printTable(new TableWrapper(PregledTrebovanja2.this.tableRacuni2), false, true, PregledTrebovanja2.this.type.getInterName() + " - " + String.format(PregledTrebovanja2.this.barmasterText.getString("TEXT_PREGLED_ZA_PERIOD"), new Object[0]) + " " + StatLogic.getDateString(PregledTrebovanja2.this.fromDate) + " - " + StatLogic.getDateString(PregledTrebovanja2.this.toDate) + " " + String.format(PregledTrebovanja2.this.barmasterText.getString("TEXT_ZA_ODELJENJE"), new Object[0]) + ": " + (PregledTrebovanja2.this.type.getTipDokumenta() == TipTrebovanja.DokumentAtribut.ULAZNI ? (u == null ? "" : u.getNaziv()) : (iz == null ? "" : iz.getNaziv())) + (PregledTrebovanja2.this.dobavljac == null ? "" : ", " + String.format(PregledTrebovanja2.this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ": " + PregledTrebovanja2.this.dobavljac.getNaziv()), PregledTrebovanja2.this.shell5, PregledTrebovanja2.this.server);
            }
        });
        Button button = new Button((Composite)this.shell5, 72);
        button.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        button.setFont(buttonFont);
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledTrebovanja2.this.shell5.close();
            }
        });
        this.tableRacuni2.addListener(12, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        data.verticalSpan = 7;
        tclc.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, true);
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData((Object)data);
        button.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        gore.setLayoutData((Object)data);
        dole.setLayoutData((Object)data);
        stampa.setLayoutData((Object)data);
        data = new GridData(0x1000000, 1, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        izmenaTreb.setLayoutData((Object)data);
        brisanjeTreb.setLayoutData((Object)data);
        this.shell5.setMaximized(true);
        this.shell5.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)buttonFont));
        this.shell5.open();
        while (!this.shell5.isDisposed()) {
            if (this.shell5.getDisplay().readAndDispatch()) continue;
            this.shell5.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn t1 = new TableColumn(this.tableRacuni2, 131072);
        t1.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        this.tcl.setColumnData((Widget)t1, (ColumnLayoutData)new ColumnWeightData(110, true));
        TableViewerColumn tvc1 = new TableViewerColumn(this.tableRacuni2V, t1);
        tvc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Trebovanje) {
                    Trebovanje t = (Trebovanje)element;
                    return StatLogic.getDateString(t.getDatumTrebovanja());
                }
                if (element instanceof PregledTrebovanjaContentProvider.SummaryWrapper) {
                    return String.format(Konstante.getBundle().getString("TEXT_UKUPNO"), new Object[0]);
                }
                return "";
            }
        });
        TableColumn t2 = new TableColumn(this.tableRacuni2, 131072);
        t2.setText(String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]));
        this.tcl.setColumnData((Widget)t2, (ColumnLayoutData)new ColumnWeightData(200, true));
        TableViewerColumn tvc2 = new TableViewerColumn(this.tableRacuni2V, t2);
        tvc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Trebovanje) {
                    Trebovanje t = (Trebovanje)element;
                    return t.getDobavljac() == null ? "" : t.getDobavljac().getSkrNaziv();
                }
                return "";
            }
        });
        TableColumn t3 = new TableColumn(this.tableRacuni2, 131072);
        t3.setText(String.format(this.barmasterText.getString("TEXT_TOTAL_BEZ_PDV"), new Object[0]));
        this.tcl.setColumnData((Widget)t3, (ColumnLayoutData)new ColumnWeightData(140, true));
        TableViewerColumn tvc3 = new TableViewerColumn(this.tableRacuni2V, t3);
        tvc3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Trebovanje) {
                    Trebovanje t = (Trebovanje)element;
                    Double total = t.getTotalBezPdv();
                    if (total == null) {
                        total = 0.0;
                        for (TrebovanjeStavka ts : t.getStavke()) {
                            Double komadBPDV = ts.getKomadBPDV();
                            if (komadBPDV == null) {
                                komadBPDV = Konstante.getOsnovicaFromBruto(ts.getArtikal().getPoreskaGrupa(), ts.getKomad());
                            }
                            total = total + ts.getKolicina() * ts.getKomadBPDV();
                        }
                    }
                    return StatLogic.getNumber02(total);
                }
                if (element instanceof PregledTrebovanjaContentProvider.SummaryWrapper) {
                    PregledTrebovanjaContentProvider.SummaryWrapper sw = (PregledTrebovanjaContentProvider.SummaryWrapper)element;
                    return StatLogic.getNumber02(sw.getTotalBPDV());
                }
                return "";
            }
        });
        TableColumn t6 = new TableColumn(this.tableRacuni2, 131072);
        t6.setText(String.format(this.barmasterText.getString("TEXT_TOTAL"), new Object[0]));
        this.tcl.setColumnData((Widget)t6, (ColumnLayoutData)new ColumnWeightData(140, true));
        TableViewerColumn tvc6 = new TableViewerColumn(this.tableRacuni2V, t6);
        tvc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Trebovanje) {
                    Trebovanje t = (Trebovanje)element;
                    Double total = t.getTotalSaPdv();
                    if (total == null) {
                        total = 0.0;
                        for (TrebovanjeStavka ts : t.getStavke()) {
                            total = total + ts.getKolicina() * ts.getKomad();
                        }
                    }
                    return StatLogic.getNumber02(total);
                }
                if (element instanceof PregledTrebovanjaContentProvider.SummaryWrapper) {
                    PregledTrebovanjaContentProvider.SummaryWrapper sw = (PregledTrebovanjaContentProvider.SummaryWrapper)element;
                    return StatLogic.getNumber02(sw.getTotal());
                }
                return "";
            }
        });
        TableColumn t5 = new TableColumn(this.tableRacuni2, 131072);
        t5.setText(String.format(this.barmasterText.getString("TEXT_BROJ"), new Object[0]));
        this.tcl.setColumnData((Widget)t5, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc5 = new TableViewerColumn(this.tableRacuni2V, t5);
        tvc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Trebovanje) {
                    Trebovanje t = (Trebovanje)element;
                    return t.getBrTrebovanja();
                }
                return "";
            }
        });
        TableColumn t7 = new TableColumn(this.tableRacuni2, 131072);
        t7.setText(String.format(this.barmasterText.getString("TEXT_OZNAKA_DOKUMENTA"), new Object[0]));
        this.tcl.setColumnData((Widget)t7, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc7 = new TableViewerColumn(this.tableRacuni2V, t7);
        tvc7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Trebovanje) {
                    Trebovanje t = (Trebovanje)element;
                    return t.getPrijemnica() != null ? t.getPrijemnica().getOznakaDokumenta() : "";
                }
                return "";
            }
        });
        if (this.crno) {
            TableColumn t4 = new TableColumn(this.tableRacuni2, 0x1000000);
            t4.setText("Dodatno");
            t4.setWidth(100);
            this.tcl.setColumnData((Widget)t4, (ColumnLayoutData)new ColumnWeightData(100, true));
            TableViewerColumn tvc4 = new TableViewerColumn(this.tableRacuni2V, t4);
            tvc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Trebovanje) {
                        Trebovanje t = (Trebovanje)element;
                        return t.getCrno() != null && t.getCrno() != false ? String.format(PregledTrebovanja2.this.barmasterText.getString("TEXT_DA"), new Object[0]) : String.format(PregledTrebovanja2.this.barmasterText.getString("TEXT_NE"), new Object[0]);
                    }
                    return "";
                }
            });
        }
    }

    private void reloadRows() {
        boolean useFromDep = this.type.getOdeljenjeIzlaz() != TipTrebovanja.OdeljenjeAtribut.PRAZNO;
        boolean useToDep = this.type.getOdeljenjeUlaz() != TipTrebovanja.OdeljenjeAtribut.PRAZNO;
        boolean useSupp = this.type.isDobavljac();
        this.trebovanja.clear();
        this.trebovanja.addAll(this.server.findTrebovanja(this.fromDate, this.toDate, useFromDep, this.iz, useToDep, this.u, useSupp, this.dobavljac, this.belo, this.crno, this.type));
        this.tableRacuni2V.refresh();
    }

    private void openDocument() {
        if (this.tableRacuni2.getSelectionIndex() < 0) {
            this.active = null;
        }
        this.active = null;
        try {
            this.active = (Trebovanje)((IStructuredSelection)this.tableRacuni2V.getSelection()).getFirstElement();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.active == null) {
            return;
        }
        new UpravljanjeTrebovanjem(this.shell5, this.restoran, this.active, this.active.getU(), this.active.getIz(), this.type, null, true, this.inspektor, this.hasap);
    }

    private void editDocument() {
        if (this.tableRacuni2.getSelectionIndex() < 0) {
            this.active = null;
            return;
        }
        this.active = null;
        try {
            this.active = (Trebovanje)((IStructuredSelection)this.tableRacuni2V.getSelection()).getFirstElement();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.active == null) {
            return;
        }
        new UpravljanjeTrebovanjem(this.shell5, this.restoran, this.active, this.active.getU(), this.active.getIz(), this.type, null, false, this.inspektor, this.hasap);
    }

    private void deleteDocument() {
        if (this.tableRacuni2.getSelectionIndex() < 0) {
            return;
        }
        this.active = null;
        try {
            this.active = (Trebovanje)((IStructuredSelection)this.tableRacuni2V.getSelection()).getFirstElement();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.active == null) {
            return;
        }
        int style = 65728;
        MessageBox messageBox = new MessageBox(this.shell5, style);
        messageBox.setText("Info");
        messageBox.setMessage("Da li ste sigurni da zelite da obrisete trebovanje br " + this.active.getBrTrebovanja() + "?");
        if (messageBox.open() == 64) {
            try {
                this.server.deleteTrebovanjeJPAWithReconstruct(this.active);
            }
            catch (Exception e) {
                Logger.getLogger(PregledTrebovanja2.class.getName()).log(Level.WARNING, e.getMessage(), e);
                SWTOptionPane.showMessageDialog(SWTComponent.getSWTComponent((Control)this.shell5), (Object)e.getMessage(), "Gre\u0161ka", 2);
            }
        }
    }

    private class ServOper {
        RestoranServer server;
        Shell servisneOperacije;
        boolean so = false;
        final Text text;

        public ServOper(RestoranServer s, Shell sop) {
            this.server = s;
            this.servisneOperacije = sop;
            Font font = FontCache.getFont("Arial", 18, 1);
            Font numFont = FontCache.getFont("Arial", 36, 1);
            Color fg = sop.getDisplay().getSystemColor(6);
            this.servisneOperacije = Konstante.makeShell(this.servisneOperacije, PregledTrebovanja2.this.barmasterText.getString("TEXT_UNESITE_SIFRU"));
            this.servisneOperacije.setLayout((Layout)new GridLayout(1, true));
            SWTContainerClass.setDimension(this.servisneOperacije);
            this.text = new Text((Composite)this.servisneOperacije, 0x400004);
            this.text.setLayoutData((Object)new GridData(768));
            this.text.setFont(font);
            this.servisneOperacije.setLocation(PregledTrebovanja2.this.bounds.width / 2, PregledTrebovanja2.this.bounds.height / 8);
            this.text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: 
                        case 0x1000050: {
                            ServOper.this.potvrda();
                        }
                    }
                }
            });
            Composite allTogether = new Composite((Composite)this.servisneOperacije, 0);
            allTogether.setLayout((Layout)new GridLayout(1, true));
            Composite numericka = new Composite(allTogether, 0);
            numericka.setLayout((Layout)new GridLayout(4, false));
            GridData gridData = new GridData();
            gridData.heightHint = 80;
            gridData.widthHint = 80;
            GridData gridData2 = new GridData();
            gridData2.widthHint = 164;
            gridData2.heightHint = 80;
            GridData gridData3 = new GridData();
            gridData3.heightHint = 80;
            gridData3.widthHint = 80;
            gridData3.horizontalSpan = 2;
            gridData3.horizontalAlignment = 16384;
            Button b = new Button(numericka, 0);
            b.setLayoutData((Object)gridData);
            b.setText("7");
            b.setForeground(fg);
            b.setFont(numFont);
            this.addListenerNumeric("7", b);
            Button b3 = new Button(numericka, 0);
            b3.setText("8");
            b3.setFont(numFont);
            b3.setForeground(fg);
            b3.setLayoutData((Object)gridData);
            this.addListenerNumeric("8", b3);
            Button b4 = new Button(numericka, 0);
            b4.setText("9");
            b4.setFont(numFont);
            b4.setForeground(fg);
            b4.setLayoutData((Object)gridData);
            this.addListenerNumeric("9", b4);
            Button stPorudz = new Button(numericka, 0x1000040);
            stPorudz.setLayoutData((Object)gridData2);
            stPorudz.setForeground(fg);
            stPorudz.setText(String.format(Konstante.getBundle().getString("TEXT_PONISTI"), new Object[0]));
            stPorudz.setFont(font);
            stPorudz.setBackground(PregledTrebovanja2.this.display.getSystemColor(1));
            stPorudz.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ServOper.this.text.setText("");
                    ServOper.this.text.forceFocus();
                }
            });
            Button b6 = new Button(numericka, 0);
            b6.setText("4");
            b6.setForeground(fg);
            b6.setFont(numFont);
            b6.setLayoutData((Object)gridData);
            this.addListenerNumeric("4", b6);
            Button b7 = new Button(numericka, 0);
            b7.setText("5");
            b7.setForeground(fg);
            b7.setFont(numFont);
            b7.setLayoutData((Object)gridData);
            this.addListenerNumeric("5", b7);
            Button b8 = new Button(numericka, 0);
            b8.setText("6");
            b8.setForeground(fg);
            b8.setFont(numFont);
            b8.setLayoutData((Object)gridData3);
            this.addListenerNumeric("6", b8);
            Button b0 = new Button(numericka, 0);
            b0.setText("1");
            b0.setForeground(fg);
            b0.setFont(numFont);
            b0.setLayoutData((Object)gridData);
            this.addListenerNumeric("1", b0);
            Button tacka = new Button(numericka, 0);
            tacka.setText("2");
            tacka.setForeground(fg);
            tacka.setFont(numFont);
            tacka.setLayoutData((Object)gridData);
            this.addListenerNumeric("2", tacka);
            Button b1 = new Button(numericka, 0);
            b1.setText("3");
            b1.setForeground(fg);
            b1.setFont(numFont);
            b1.setLayoutData((Object)gridData);
            this.addListenerNumeric("3", b1);
            Button izlaz = new Button(numericka, 64);
            izlaz.setLayoutData((Object)gridData2);
            izlaz.setForeground(fg);
            izlaz.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
            izlaz.setFont(font);
            izlaz.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ServOper.this.text.setText("");
                    ServOper.this.servisneOperacije.close();
                }
            });
            GridData data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 164;
            data.heightHint = 80;
            data.horizontalAlignment = 0x1000000;
            Button b5 = new Button(numericka, 0);
            b5.setText("0");
            b5.setForeground(fg);
            b5.setFont(numFont);
            b5.setLayoutData((Object)data);
            this.addListenerNumeric("0", b5);
            data = new GridData();
            data.horizontalSpan = 4;
            data.widthHint = 164;
            data.heightHint = 80;
            data.horizontalAlignment = 0x1000000;
            Button nazad = new Button(numericka, 0);
            nazad.setText("<");
            nazad.setForeground(fg);
            nazad.setFont(numFont);
            nazad.setLayoutData((Object)gridData);
            nazad.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (ServOper.this.text.getText().length() > 0) {
                        ServOper.this.text.setText(ServOper.this.text.getText().substring(0, ServOper.this.text.getText().length() - 1));
                    }
                    ServOper.this.text.setSelection(ServOper.this.text.getText().length() + 1);
                    ServOper.this.text.forceFocus();
                }
            });
            Button potvrda = new Button(numericka, 0);
            potvrda.setLayoutData((Object)gridData2);
            potvrda.setForeground(fg);
            potvrda.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
            potvrda.setFont(numFont);
            potvrda.setFont(font);
            potvrda.setBackground(PregledTrebovanja2.this.display.getSystemColor(1));
            potvrda.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ServOper.this.potvrda();
                }
            });
            data = new GridData();
            data.horizontalSpan = 4;
            data.heightHint = 80;
            data.widthHint = 164;
            data.horizontalAlignment = 131072;
            this.text.forceFocus();
            data = new GridData();
            numericka.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 100;
            data.widthHint = 425;
            data = new GridData(1604);
            allTogether.setLayoutData((Object)data);
            this.servisneOperacije.pack();
        }

        public void potvrda() {
            String kod = this.text.getText();
            String kodKartice = null;
            if (kod.length() > 0) {
                kodKartice = kod;
            }
            IDKartica idk = null;
            if (kodKartice != null) {
                try {
                    idk = this.server.findIDKarticaByKod(kod);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
            if (idk != null) {
                kod = idk.getSifra();
            }
            if (this.server.getLoginServis(kod) != null) {
                this.server.setUser(this.server.getLoginServis(kod));
                this.servisneOperacije.close();
                this.so = true;
            } else if (kod.equals("928374")) {
                this.server.setUser(new Login("SETUP", "928374"));
                this.servisneOperacije.close();
                this.so = true;
            } else {
                Konstante.getPoruka(this.servisneOperacije, PregledTrebovanja2.this.barmasterText.getString("PORUKA_POGRESNA_SIFRA"));
                this.so = false;
            }
        }

        private void addListenerNumeric(final String s, Button b) {
            b.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ServOper.this.text.setText(ServOper.this.text.getText() + s);
                    ServOper.this.text.setSelection(ServOper.this.text.getText().length() + 1);
                    ServOper.this.text.forceFocus();
                }
            });
        }

        public boolean getSO() {
            return this.so;
        }
    }

    public static class PregledTrebovanjaContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof List)) {
                return new Object[0];
            }
            List trebList = (List)inputElement;
            if (trebList.isEmpty()) {
                return new Object[0];
            }
            LinkedList ret = new LinkedList();
            SummaryWrapper total = new SummaryWrapper(0.0, 0.0);
            for (Object o : trebList) {
                if (!(o instanceof Trebovanje)) continue;
                Trebovanje t = (Trebovanje)o;
                double totalBPDV = 0.0;
                double totalSPDV = 0.0;
                for (TrebovanjeStavka ts : t.getStavke()) {
                    Double komadBPDV = ts.getKomadBPDV();
                    if (komadBPDV == null) {
                        komadBPDV = Konstante.getOsnovicaFromBruto(ts.getArtikal().getPoreskaGrupa(), ts.getKomad());
                    }
                    totalBPDV += komadBPDV * ts.getKolicina();
                    totalSPDV += ts.getKomad() * ts.getKolicina();
                }
                t.setTotalBezPdv(totalBPDV);
                t.setTotalSaPdv(totalSPDV);
                total.addTotalBPDV(totalBPDV);
                total.addTotal(totalSPDV);
                ret.add(o);
            }
            ret.add(total);
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public static class SummaryWrapper {
            private double total;
            private double totalBPDV;

            public SummaryWrapper(double total, double totalBPDV) {
                this.total = total;
                this.totalBPDV = totalBPDV;
            }

            public double getTotal() {
                return this.total;
            }

            public double getTotalBPDV() {
                return this.totalBPDV;
            }

            public double addTotal(double total) {
                this.total += total;
                return this.total;
            }

            public double addTotalBPDV(double total) {
                this.totalBPDV += total;
                return this.totalBPDV;
            }
        }
    }

    public static class PregledTrebovanja2Input {
        private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        private final DateInput2 odDatumaI;
        private final DateInput2 doDatumaI;
        private final Restoran restoran;
        private final RestoranServer server;
        private Combo dobavljacC;
        private Combo odeljenjaIzlazC;
        private Combo odeljenjaUlazC;
        private Date day1;
        private Date day2;
        private Button belo;
        private Button crno;
        boolean iscrno;
        boolean inspekcija;
        Odeljenje odMaticno;
        List<StalniGost> dobavljaci;
        List<Odeljenje> odeljenja;
        private final Shell shell;
        private TipTrebovanja type;
        private final Odeljenje magacin;
        private final Combo typeC;
        Odeljenje odl;
        boolean inspektor = false;
        boolean hasap = false;

        public PregledTrebovanja2Input(Shell parent, Restoran r, boolean ins, Odeljenje od, TipTrebovanja tip, boolean inspektor, boolean hasap) {
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.iscrno = this.server.readCrnaPlacanjaIzvestaji().size() > 0;
            this.inspekcija = ins;
            this.type = tip;
            this.magacin = this.server.returnMagacin();
            this.inspektor = inspektor;
            this.odeljenja = this.server.readOdeljenjeBezMag();
            this.dobavljaci = this.server.allDobavljaci();
            this.odMaticno = od;
            this.hasap = hasap;
            this.shell = new Shell(parent, 34912);
            this.shell.setLayout((Layout)new GridLayout(1, false));
            this.shell.setText(String.format(this.barmasterText.getString("TEXT_FILTER_PREGLEDA"), new Object[0]));
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            panel1.setLayoutData((Object)new GridData(4, 4, false, false));
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            GridData data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/stanjeZalihaV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData(4, 4, true, false, 2, 1);
            data.heightHint = 80;
            Group grupaText = new Group(panel1, 0);
            grupaText.setLayout((Layout)new GridLayout(2, false));
            grupaText.setLayoutData((Object)data);
            Label typeL = new Label((Composite)grupaText, 131072);
            typeL.setText(String.format(this.barmasterText.getString("TEXT_TIP_DOKUMENTA"), new Object[0]) + ": ");
            typeL.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.typeC = new Combo((Composite)grupaText, 12);
            this.typeC.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
            for (TipTrebovanja tt : TipTrebovanja.values()) {
                this.typeC.add(tt.getInterName());
            }
            data = new GridData();
            data.widthHint = 400;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText(String.format(this.barmasterText.getString("TEXT_FILTER_DATUMA"), new Object[0]));
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 400;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText(String.format(this.barmasterText.getString("TEXT_FILTER_ATRIBUTA"), new Object[0]));
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 400;
            Group grupa21 = null;
            if (inspektor) {
                grupa21 = new Group(panel2, 0);
                grupa21.setLayout((Layout)new GridLayout(4, false));
                grupa21.setText(String.format(this.barmasterText.getString("TEXT_FILTER_STANJA"), new Object[0]));
                grupa21.setLayoutData((Object)data);
            }
            data = new GridData();
            data.widthHint = 400;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(3, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label odD = new Label((Composite)grupa1, 0);
            odD.setText(String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]) + ":");
            this.odDatumaI = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_OD_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatumaI.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatumaI, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText(String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]) + ":");
            this.doDatumaI = new DateInput2(parent2, String.format(this.barmasterText.getString("TEXT_DO_DATUMA"), new Object[0]), new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatumaI.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatumaI, this.shell));
            this.dobavljacC = null;
            Label dobavljacL = new Label((Composite)grupa2, 0);
            dobavljacL.setText(String.format(this.barmasterText.getString("TEXT_DOBAVLJAC"), new Object[0]) + ":");
            this.dobavljacC = new Combo((Composite)grupa2, 8);
            this.dobavljacC.add(String.format(this.barmasterText.getString("TEXT_SVI_DOBAVLJACI"), new Object[0]));
            for (StalniGost dob : this.dobavljaci) {
                this.dobavljacC.add(dob.getNaziv());
            }
            this.dobavljacC.select(0);
            this.odeljenjaUlazC = null;
            this.odeljenjaIzlazC = null;
            Label odeljenjeUlazL = new Label((Composite)grupa2, 0);
            odeljenjeUlazL.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE_ULAZA"), new Object[0]) + ":");
            this.odeljenjaUlazC = new Combo((Composite)grupa2, 8);
            this.odeljenjaUlazC.add(String.format(this.barmasterText.getString("TEXT_SVA_ODELJENJA"), new Object[0]));
            int idxOdU = -1;
            for (int i = 0; i < this.odeljenja.size(); ++i) {
                this.odl = this.odeljenja.get(i);
                this.odeljenjaUlazC.add(this.odl.getNaziv());
                System.out.println("odl.getId() = " + this.odl.getId());
                System.out.println("odMaticno.getId() = " + this.odMaticno.getId());
                if (this.odl.getId().compareTo(this.odMaticno.getId()) != 0) continue;
                idxOdU = i;
            }
            this.odeljenjaUlazC.select(idxOdU + 1);
            Label odeljenjeIzlazL = new Label((Composite)grupa2, 0);
            odeljenjeIzlazL.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE_IZLAZA"), new Object[0]) + ":");
            this.odeljenjaIzlazC = new Combo((Composite)grupa2, 8);
            this.odeljenjaIzlazC.add(String.format(this.barmasterText.getString("TEXT_SVA_ODELJENJA"), new Object[0]));
            int idxOdI = -1;
            for (int i = 0; i < this.odeljenja.size(); ++i) {
                this.odl = this.odeljenja.get(i);
                this.odeljenjaIzlazC.add(this.odl.getNaziv());
                if (this.odl.getId().compareTo(od.getId()) != 0) continue;
                idxOdI = i;
            }
            this.odeljenjaIzlazC.select(idxOdI + 1);
            if (inspektor) {
                this.belo = new Button((Composite)grupa21, 32);
                this.belo.setText(String.format(this.barmasterText.getString("TEXT_OSNOVNA_STANJA"), new Object[0]));
                this.belo.setSelection(true);
                if (this.iscrno && inspektor) {
                    this.crno = new Button((Composite)grupa21, 32);
                    this.crno.setText(String.format(this.barmasterText.getString("TEXT_DODATNA_STANJA"), new Object[0]));
                }
            }
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            odD.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            this.odDatumaI.getControl().setLayoutData((Object)data);
            this.doDatumaI.getControl().setLayoutData((Object)data);
            dobavljacL.setLayoutData((Object)data);
            if (this.dobavljacC != null) {
                this.dobavljacC.setLayoutData((Object)data);
            }
            odeljenjeIzlazL.setLayoutData((Object)data);
            odeljenjeUlazL.setLayoutData((Object)data);
            if (this.odeljenjaUlazC != null) {
                this.odeljenjaUlazC.setLayoutData((Object)data);
            }
            if (this.odeljenjaIzlazC != null) {
                this.odeljenjaIzlazC.setLayoutData((Object)data);
            }
            this.shell.pack();
            this.typeC.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    System.out.println("e = " + e);
                    int idx = ((Combo)e.widget).getSelectionIndex();
                    if (idx > -1 && idx < TipTrebovanja.values().length) {
                        type = TipTrebovanja.values()[idx];
                    }
                    if (type != null) {
                        dobavljacC.setEnabled(type.isDobavljac());
                        odeljenjaUlazC.setEnabled(type.getOdUlaz() == TipTrebovanja.OdeljenjeAtribut.OBAVEZNO);
                        odeljenjaIzlazC.setEnabled(type.getOdIzlaz() == TipTrebovanja.OdeljenjeAtribut.OBAVEZNO);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            okButt.forceFocus();
            this.shell.setDefaultButton(okButt);
            Konstante.centerShellOnDisplay(this.shell);
            this.shell.open();
            this.typeC.select(0);
            this.typeC.notifyListeners(13, null);
            while (!this.shell.isDisposed()) {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
        }

        private void cancel() {
            this.shell.close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatumaI.getResult();
                this.day2 = this.doDatumaI.getResult();
                Odeljenje ulazno = null;
                Odeljenje izlazno = null;
                StalniGost dobavljac = null;
                if (this.type.isDobavljac() && this.dobavljacC.getSelectionIndex() > 0) {
                    dobavljac = this.dobavljaci.get(this.dobavljacC.getSelectionIndex() - 1);
                }
                switch (this.type.getOdIzlaz()) {
                    case MAGACIN: {
                        izlazno = this.magacin;
                        break;
                    }
                    case OBAVEZNO: {
                        if (this.odeljenjaIzlazC.getSelectionIndex() <= 0) break;
                        izlazno = this.odeljenja.get(this.odeljenjaIzlazC.getSelectionIndex() - 1);
                        break;
                    }
                    default: {
                        izlazno = null;
                    }
                }
                switch (this.type.getOdUlaz()) {
                    case MAGACIN: {
                        ulazno = this.magacin;
                        break;
                    }
                    case OBAVEZNO: {
                        if (this.odeljenjaUlazC.getSelectionIndex() <= 0) break;
                        ulazno = this.odeljenja.get(this.odeljenjaUlazC.getSelectionIndex() - 1);
                        break;
                    }
                    default: {
                        ulazno = null;
                    }
                }
                boolean crnoIns = false;
                if (this.crno != null) {
                    crnoIns = this.crno.getSelection();
                }
                this.server.log("Pregled trebovanja: od datuma->" + this.day1 + " do datuma ->" + this.day2);
                Boolean b = false;
                b = this.inspektor ? Boolean.valueOf(this.belo.getSelection()) : Boolean.valueOf(true);
                new PregledTrebovanja2(this.shell, this.restoran, Konstante.getOnlyDate(this.day1), Konstante.getOnlyDate(this.day2), izlazno, ulazno, dobavljac, b, crnoIns, this.type, this.inspektor, this.hasap);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.shell, (Object)ex.getMessage(), "Greska", 2);
            }
        }

        public String dajGrupu() {
            return this.odeljenjaUlazC.getText();
        }
    }
}

