/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.Pregled;

import Stampa.core.GridPrinter;
import Stampa.core.ImageCache;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Proizvodnja;
import com.dev63.restoran.model.ProizvodnjaStavka;
import com.dev63.restoran.model.ProizvodnjaUtrosak;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.PreostalaKolicina;
import com.dev63.restoran.sistem.RekonstrukcijaSaPrikazom;
import com.dev63.restoran.sistem.UnosProizvodnje;
import com.dev63.restoran.stampa.UskaStampa;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.persistence.EntityManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PregledProizvodnje {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Shell shella;
    Table table;
    private TableViewer tableRacuni2V;
    Restoran restoran;
    RestoranServer server;
    Date day1;
    Date day2;
    Odeljenje iz;
    Odeljenje u;
    private TableColumnLayout tcl;
    List<Proizvodnja> proizvodnje = new LinkedList<Proizvodnja>();
    List<Proizvodnja> proizvodnjeKonacno = new ArrayList<Proizvodnja>();
    private Proizvodnja active;
    boolean crno;
    Display display;
    private ProizvodnjaStavka activeStavka;
    Text pretraga;
    Combo artikal;

    public PregledProizvodnje(Display display, final Shell shell, Restoran r, Odeljenje iz, final Odeljenje u, Date day1, Date day2, boolean crno) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.day1 = day1;
        this.day2 = day2;
        this.iz = iz;
        this.u = u;
        this.crno = crno;
        this.shella = new Shell(shell, 1264);
        display = this.shella.getDisplay();
        this.shella.setText("Pregled proizvodnje za odeljenje " + iz.getNaziv());
        this.shella.setLayout((Layout)new GridLayout(2, false));
        this.shella.setBackground(display.getSystemColor(1));
        Composite tclc = new Composite((Composite)this.shella, 0);
        this.tcl = new TableColumnLayout();
        tclc.setLayout((Layout)this.tcl);
        this.table = new Table(tclc, 65796);
        this.table.setFont(Konstante.getFont(display, 8, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableRacuni2V = new TableViewer(this.table);
        this.tableRacuni2V.setContentProvider((IContentProvider)new PregledProizvodnjaContentProvider());
        this.tableRacuni2V.setInput(this.proizvodnje);
        final Button izmenaProiz = new Button((Composite)this.shella, 72);
        this.tableRacuni2V.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Odeljenje o = PregledProizvodnje.this.server.getOdeljenje("MAGACIN");
                TableItem[] items = PregledProizvodnje.this.table.getSelection();
                TableItem item = items[0];
                try {
                    Date datumOd = new SimpleDateFormat("dd.MM.yyyy").parse(item.getText(0));
                    PopisProvera provera = new PopisProvera(PregledProizvodnje.this.server, shell, datumOd, o, false);
                    if (provera.isPopis()) {
                        izmenaProiz.setEnabled(false);
                    } else {
                        izmenaProiz.setEnabled(true);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.makeHeaders();
        this.reload();
        Font buttonFont = FontCache.getFont("Arial", 18, 0);
        izmenaProiz.setText(String.format(this.barmasterText.getString("TEXT_IZMENA"), new Object[0]));
        izmenaProiz.setFont(buttonFont);
        izmenaProiz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledProizvodnje.this.table.getSelectionIndex() < 0) {
                    PregledProizvodnje.this.active = null;
                    return;
                }
                if (PregledProizvodnje.this.table.getSelectionIndex() > PregledProizvodnje.this.proizvodnje.size() - 1) {
                    return;
                }
                PregledProizvodnje.this.active = PregledProizvodnje.this.proizvodnje.get(PregledProizvodnje.this.table.getSelectionIndex());
                PregledProizvodnje.this.setActiveProizvodnja(PregledProizvodnje.this.active, u, true);
            }
        });
        Button brisanjeProiz = new Button((Composite)this.shella, 72);
        brisanjeProiz.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE"), new Object[0]));
        brisanjeProiz.setFont(buttonFont);
        brisanjeProiz.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledProizvodnje.this.table.getSelectionIndex() < 0) {
                    PregledProizvodnje.this.active = null;
                    return;
                }
                PregledProizvodnje.this.active = PregledProizvodnje.this.proizvodnje.get(PregledProizvodnje.this.table.getSelectionIndex());
                boolean potvrda = Konstante.getPorukaDaNe(shell, "Da li ste sigurni da hocete da obrisete dokument proizvodnje?").isOdgovorPozitivan();
                if (potvrda) {
                    if (PregledProizvodnje.this.active != null) {
                        for (ProizvodnjaStavka ps : PregledProizvodnje.this.server.readStavkePregledaProizvodnje(PregledProizvodnje.this.active)) {
                            PregledProizvodnje.this.server.deleteProizvodnjaStavka(ps);
                        }
                        PregledProizvodnje.this.server.deleteProizvodnju(PregledProizvodnje.this.active);
                        RekonstrukcijaSaPrikazom rkp = new RekonstrukcijaSaPrikazom(shell, PregledProizvodnje.this.restoran, PregledProizvodnje.this.active.getDatum());
                        rkp.rekonstruisi();
                    }
                    PregledProizvodnje.this.reload();
                }
            }
        });
        Button potvrda = new Button((Composite)this.shella, 72);
        potvrda.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.setFont(buttonFont);
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledProizvodnje.this.table.getSelectionIndex() < 0) {
                    PregledProizvodnje.this.active = null;
                    return;
                }
                PregledProizvodnje.this.active = PregledProizvodnje.this.proizvodnje.get(PregledProizvodnje.this.table.getSelectionIndex());
                PregledProizvodnje.this.setActiveProizvodnja(PregledProizvodnje.this.active, u, false);
            }
        });
        Button gore = new Button((Composite)this.shella, 132);
        gore.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledProizvodnje.this.table.getSelectionIndex();
                if (index == -1) {
                    if (PregledProizvodnje.this.table.getItemCount() != 0) {
                        PregledProizvodnje.this.table.setSelection(0);
                    }
                } else if (index != 0) {
                    PregledProizvodnje.this.table.setSelection(--index);
                }
            }
        });
        Button dole = new Button((Composite)this.shella, 1028);
        dole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledProizvodnje.this.table.getSelectionIndex();
                if (index == -1) {
                    PregledProizvodnje.this.table.setSelection(PregledProizvodnje.this.table.getItemCount() - 1);
                } else if (index != PregledProizvodnje.this.table.getItemCount() - 1) {
                    PregledProizvodnje.this.table.setSelection(++index);
                }
            }
        });
        Button button = new Button((Composite)this.shella, 72);
        button.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        button.setFont(buttonFont);
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledProizvodnje.this.shella.close();
            }
        });
        this.table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        data.verticalSpan = 7;
        tclc.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, true);
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData((Object)data);
        button.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        gore.setLayoutData((Object)data);
        dole.setLayoutData((Object)data);
        data = new GridData(0x1000000, 1, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        izmenaProiz.setLayoutData((Object)data);
        brisanjeProiz.setLayoutData((Object)data);
        this.shella.setMaximized(true);
        this.shella.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)buttonFont));
        this.shella.open();
        while (!this.shella.isDisposed()) {
            if (this.shella.getDisplay().readAndDispatch()) continue;
            this.shella.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn t5 = new TableColumn(this.table, 131072);
        t5.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        this.tcl.setColumnData((Widget)t5, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc5 = new TableViewerColumn(this.tableRacuni2V, t5);
        tvc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Proizvodnja) {
                    Proizvodnja t = (Proizvodnja)element;
                    return Konstante.getDate(t.getDatum());
                }
                return "";
            }
        });
        TableColumn t6 = new TableColumn(this.table, 131072);
        t6.setText(String.format(this.barmasterText.getString("TEXT_UNOS"), new Object[0]));
        this.tcl.setColumnData((Widget)t6, (ColumnLayoutData)new ColumnWeightData(140, true));
        TableViewerColumn tvc6 = new TableViewerColumn(this.tableRacuni2V, t6);
        tvc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Proizvodnja) {
                    Proizvodnja t = (Proizvodnja)element;
                    return Konstante.getDate(t.getDatumUnosa());
                }
                return "";
            }
        });
        TableColumn t7 = new TableColumn(this.table, 131072);
        t7.setText(String.format(this.barmasterText.getString("TEXT_ODELJENJE"), new Object[0]));
        this.tcl.setColumnData((Widget)t7, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc7 = new TableViewerColumn(this.tableRacuni2V, t7);
        tvc7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Proizvodnja) {
                    Proizvodnja t = (Proizvodnja)element;
                    return t.getOdeljenje().getNaziv();
                }
                return "";
            }
        });
        if (this.crno) {
            TableColumn t4 = new TableColumn(this.table, 0x1000000);
            t4.setText("Dodatno");
            t4.setWidth(100);
            this.tcl.setColumnData((Widget)t4, (ColumnLayoutData)new ColumnWeightData(100, true));
            TableViewerColumn tvc4 = new TableViewerColumn(this.tableRacuni2V, t4);
            tvc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Proizvodnja) {
                        Proizvodnja t = (Proizvodnja)element;
                        return PregledProizvodnje.this.crno ? String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_DA"), new Object[0]) : String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_NE"), new Object[0]);
                    }
                    return "";
                }
            });
        }
    }

    private void reload() {
        this.proizvodnje.clear();
        this.proizvodnje.addAll(this.server.readProizvodnja(this.u, this.day1, this.day2, this.crno));
        this.tableRacuni2V.refresh();
    }

    private void setActiveProizvodnja(Proizvodnja p, Odeljenje o, boolean pregled) {
        this.active = p;
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.shella.getDisplay());
        new UnosProizvodnje(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_PROIZVODNJE_POLUPROIZVODA"), new Object[0])), this.restoran, o, false, p);
        this.reload();
    }

    public static class PregledProizvodnjaContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof List)) {
                return new Object[0];
            }
            List trebList = (List)inputElement;
            if (trebList.isEmpty()) {
                return new Object[0];
            }
            LinkedList ret = new LinkedList();
            SummaryWrapper total = new SummaryWrapper(0.0, 0.0);
            for (Object o : trebList) {
                if (!(o instanceof Proizvodnja)) continue;
                Proizvodnja t = (Proizvodnja)o;
                double totalBPDV = 0.0;
                double totalSPDV = 0.0;
                total.addTotalBPDV(totalBPDV);
                total.addTotal(totalSPDV);
                ret.add(o);
            }
            ret.add(total);
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public static class SummaryWrapper {
            private double total;
            private double totalBPDV;

            public SummaryWrapper(double total, double totalBPDV) {
                this.total = total;
                this.totalBPDV = totalBPDV;
            }

            public double getTotal() {
                return this.total;
            }

            public double getTotalBPDV() {
                return this.totalBPDV;
            }

            public double addTotal(double total) {
                this.total += total;
                return this.total;
            }

            public double addTotalBPDV(double total) {
                this.totalBPDV += total;
                return this.totalBPDV;
            }
        }
    }

    public static class PregledProizvodnjaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        Odeljenje o;
        Button crno;
        SWTContainer parent;
        boolean inspektor = false;
        boolean crn = false;

        public PregledProizvodnjaInput(SWTContainer owner, Restoran r, Odeljenje ode, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.o = ode;
            this.inspektor = inspektor;
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Pregled proizvodnje");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("");
            Button uputstvo = new Button(panel1, 0);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            Label dod = new Label((Composite)grupa1, 0);
            od.setText("Za dan:");
            dod.setText("Do dana:");
            this.odDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            this.doDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label cr = null;
            cr = new Label((Composite)grupa1, 0);
            cr.setText("Popis dodatnog stanja:");
            this.crno = new Button((Composite)grupa1, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            dod.setLayoutData((Object)data);
            if (inspektor) {
                cr.setLayoutData((Object)data);
            }
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.crno.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                this.server.log("Pregled za dan->" + this.day1);
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new PregledProizvodnje(shell2.getDisplay(), shell2, this.restoran, this.o, this.o, this.day1, this.day2, this.crno.getSelection());
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }

    private class ProizvodnjaDialog {
        SWTContainer parent;
        Table table;
        Proizvodnja proizvodnja;
        protected List<ProizvodnjaStavka> stavke = new ArrayList<ProizvodnjaStavka>();

        public ProizvodnjaDialog(SWTContainer owner, final Proizvodnja p, Boolean pregled) {
            PregledProizvodnje.this.server = PregledProizvodnje.this.restoran.getServer();
            this.parent = owner;
            this.proizvodnja = p;
            final Shell shell = this.parent.getControl().getShell();
            for (ProizvodnjaStavka ps : PregledProizvodnje.this.server.readStavkePregledaProizvodnje(p)) {
                this.stavke.add(ps);
            }
            Label pm = new Label((Composite)shell, 0);
            pm.setText(PregledProizvodnje.this.iz != null ? PregledProizvodnje.this.iz.getNaziv() + " --> " + PregledProizvodnje.this.u.getNaziv() : PregledProizvodnje.this.u.getNaziv());
            pm.setBackground(shell.getDisplay().getSystemColor(22));
            Label dat = new Label((Composite)shell, 0);
            dat.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_DATUM_UNOSA"), new Object[0]) + ":");
            dat.setBackground(shell.getDisplay().getSystemColor(22));
            Label datum = new Label((Composite)shell, 0);
            datum.setText(Konstante.getDate(this.proizvodnja.getDatumUnosa()));
            datum.setBackground(shell.getDisplay().getSystemColor(22));
            Label dat2 = new Label((Composite)shell, 0);
            dat2.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_DATUM_AZURIRANJA"), new Object[0]) + ":");
            dat2.setBackground(shell.getDisplay().getSystemColor(22));
            Label datum2 = new Label((Composite)shell, 0);
            datum2.setText(Konstante.getDate(this.proizvodnja.getDatum()));
            datum2.setBackground(shell.getDisplay().getSystemColor(22));
            Label separator1 = new Label((Composite)shell, 258);
            this.table = new Table((Composite)shell, 68356);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.setFont(Konstante.getFont(shell.getDisplay(), 7, 0));
            this.table.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    if (ProizvodnjaDialog.this.table.getSelectionIndex() > -1) {
                        for (ProizvodnjaStavka ps : PregledProizvodnje.this.server.readStavkePregledaProizvodnje(ProizvodnjaDialog.this.proizvodnja)) {
                            if (!ps.getArtikal().getName().equals(ProizvodnjaDialog.this.table.getSelection()[0].getText().trim())) continue;
                            PregledProizvodnje.this.activeStavka = ps;
                        }
                    }
                }
            });
            TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
            nazivArtikla.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_NAZIV_ARTIKLA"), new Object[0]));
            nazivArtikla.setWidth(150);
            TableColumn kolic = new TableColumn(this.table, 0x1000000);
            kolic.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]));
            kolic.setWidth(80);
            TableColumn jmere = new TableColumn(this.table, 0x1000000);
            jmere.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_JEDINICA_MERE_SKR"), new Object[0]));
            jmere.setWidth(50);
            TableColumn nv = new TableColumn(this.table, 0x1000000);
            nv.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_NABAVNA_VREDNOST_SKR"), new Object[0]));
            nv.setWidth(100);
            TableColumn nv2 = new TableColumn(this.table, 0x1000000);
            nv2.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]));
            nv2.setWidth(100);
            double tot = 0.0;
            for (ProizvodnjaStavka ps : PregledProizvodnje.this.server.readStavkePregledaProizvodnje(this.proizvodnja)) {
                double ukupno = ps.getKolicina() * ps.getArtikal().getTrenutnaNV();
                tot += ukupno;
                TableItem item = new TableItem(this.table, 0);
                item.setText(new String[]{ps.getArtikal().getName(), Konstante.getNumber4(ps.getKolicina()), ps.getArtikal().getJedinicaMere(), Konstante.getNumber2(ps.getArtikal().getTrenutnaNV()), Konstante.getNumber2(ukupno)});
            }
            Label separator2 = new Label((Composite)shell, 258);
            Label t = new Label((Composite)shell, 0);
            t.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_TOTAL"), new Object[0]).toUpperCase() + ":");
            t.setBackground(shell.getDisplay().getSystemColor(22));
            Label total = new Label((Composite)shell, 0);
            total.setText(Konstante.getNumber2(tot));
            total.setBackground(shell.getDisplay().getSystemColor(22));
            Label separator3 = new Label((Composite)shell, 258);
            Button printButt = new Button((Composite)shell, 8);
            try {
                printButt.setImage(ImageCache.getImage("print.gif"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            printButt.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
            printButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    GridPrinter gp = new GridPrinter(new PrintHandler());
                    gp.printTable(new TableWrapper(ProizvodnjaDialog.this.table), false, true, String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_PROIZVODNJA"), new Object[0]) + p.getId() + "\nDatum: " + Konstante.getDate(p.getDatum()) + "\nNapomena:" + p.getOdeljenje(), shell, PregledProizvodnje.this.server);
                }
            });
            Button uska = new Button((Composite)shell, 8);
            uska.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
            uska.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UskaStampa(p, PregledProizvodnje.this.restoran);
                }
            });
            Button del = null;
            Button dodaj = null;
            if (pregled.booleanValue()) {
                del = new Button((Composite)shell, 8);
                del.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_OBRISI"), new Object[0]));
                del.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ProizvodnjaDialog.this.stavke.remove(PregledProizvodnje.this.activeStavka);
                        ProizvodnjaDialog.this.reloadTable();
                    }
                });
                dodaj = new Button((Composite)shell, 8);
                dodaj.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_DODAJ"), new Object[0]));
                dodaj.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ProizvodnjaDialog.this.unosStavkeProizvodnje(shell, PregledProizvodnje.this.active);
                        ProizvodnjaDialog.this.reloadTable();
                    }
                });
            }
            Button okButt = Dugmici.getOkButton(shell);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    for (ProizvodnjaStavka ts : PregledProizvodnje.this.server.readStavkePregledaProizvodnje(PregledProizvodnje.this.active)) {
                        PregledProizvodnje.this.server.deleteProizvodnjaStavka(ts);
                    }
                    for (ProizvodnjaUtrosak pu : PregledProizvodnje.this.server.readProizvodnjaUtrosak(PregledProizvodnje.this.active)) {
                        PregledProizvodnje.this.server.deleteProizvodnjaUtrosak(pu);
                    }
                    for (ProizvodnjaStavka ts : ProizvodnjaDialog.this.stavke) {
                        ts.setProizvodnja(PregledProizvodnje.this.active);
                        try {
                            ProizvodnjaDialog.this.sacuvajStavkuProizvodnje(ts);
                        }
                        catch (InputException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (!ProizvodnjaDialog.this.unosUtrosakaProizvodnje(PregledProizvodnje.this.active, ProizvodnjaDialog.this.stavke)) {
                        SWTMessage.showMessageDialog(shell, "Neuspesan upis utrosaka u tabeli proizvodnjautrosak", String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_UPOZORENJE"), new Object[0]), 2);
                        return;
                    }
                    ProizvodnjaDialog.this.parent.getControl().getShell().close();
                }
            });
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            dat.setLayoutData((Object)data);
            datum.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            pm.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            separator1.setLayoutData((Object)data);
            separator2.setLayoutData((Object)data);
            separator3.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 600;
            data.heightHint = 220;
            this.table.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.heightHint = 60;
            data = new GridData();
            data.horizontalAlignment = 16384;
            t.setLayoutData((Object)data);
            total.setLayoutData((Object)data);
            data.widthHint = 120;
            data.heightHint = 40;
            printButt.setLayoutData((Object)data);
            uska.setLayoutData((Object)data);
            if (pregled.booleanValue()) {
                del.setLayoutData((Object)data);
            }
            if (pregled.booleanValue()) {
                dodaj.setLayoutData((Object)data);
            }
            okButt.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
        }

        public void unosStavkeProizvodnje(Shell shell, Proizvodnja active) {
            final Shell shell2 = new Shell(shell.getDisplay());
            shell2.setBackground(shell.getDisplay().getSystemColor(22));
            Monitor primary = shell2.getDisplay().getPrimaryMonitor();
            Rectangle bounds = primary.getBounds();
            Rectangle rect = shell2.getBounds();
            int x = bounds.x + rect.width / 2;
            int y = bounds.y + rect.height / 2;
            shell2.setLocation(x, y);
            SortedMap<String, Long> artikli = PregledProizvodnje.this.server.getPoluproizvodi(PregledProizvodnje.this.u);
            final SWTContainer parent2 = new SWTContainer((Composite)shell2);
            Label pk2 = new Label((Composite)shell2, 0);
            pk2.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_STANJE"), new Object[0]) + " (" + PregledProizvodnje.this.u.getNaziv().toLowerCase() + ")");
            pk2.setBackground(shell2.getDisplay().getSystemColor(22));
            final Label preostalaKol2 = new Label((Composite)shell2, 0);
            preostalaKol2.setText("");
            preostalaKol2.setBackground(shell2.getDisplay().getSystemColor(22));
            Label p = new Label((Composite)shell2, 0);
            p.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_PRETRAGA"), new Object[0]) + ":");
            p.setBackground(shell.getDisplay().getSystemColor(22));
            PregledProizvodnje.this.pretraga = new Text((Composite)shell2, 0);
            PregledProizvodnje.this.pretraga.addListener(2, new Listener(){

                public void handleEvent(Event e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        String str = PregledProizvodnje.this.pretraga.getText();
                        PregledProizvodnje.this.artikal.removeAll();
                        for (String s : PregledProizvodnje.this.server.getPoluproizvodiByNameBarCode(PregledProizvodnje.this.u.getId(), str).keySet()) {
                            PregledProizvodnje.this.artikal.add(s);
                        }
                        PregledProizvodnje.this.artikal.select(0);
                        if (PregledProizvodnje.this.artikal.getSelectionIndex() >= 0) {
                            preostalaKol2.setText(Konstante.getNumber4(PreostalaKolicina.izracunajZalihe(PregledProizvodnje.this.server.getArtikal(PregledProizvodnje.this.artikal.getItem(PregledProizvodnje.this.artikal.getSelectionIndex())), PregledProizvodnje.this.u, PregledProizvodnje.this.server)));
                        }
                    }
                }
            });
            Label a = new Label((Composite)shell2, 0);
            a.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_ARTIKAL"), new Object[0]) + ":");
            a.setBackground(shell2.getDisplay().getSystemColor(22));
            PregledProizvodnje.this.artikal = new Combo((Composite)shell2, 2572);
            for (String s : artikli.keySet()) {
                PregledProizvodnje.this.artikal.add(s);
            }
            PregledProizvodnje.this.artikal.select(0);
            if (PregledProizvodnje.this.artikal.getSelectionIndex() >= 0) {
                preostalaKol2.setText(Konstante.getNumber4(PreostalaKolicina.izracunajZalihe(PregledProizvodnje.this.server.getArtikal(PregledProizvodnje.this.artikal.getItem(PregledProizvodnje.this.artikal.getSelectionIndex())), PregledProizvodnje.this.u, PregledProizvodnje.this.server)));
            }
            PregledProizvodnje.this.artikal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Artikal art = PregledProizvodnje.this.server.getArtikal(PregledProizvodnje.this.artikal.getItem(PregledProizvodnje.this.artikal.getSelectionIndex()));
                    preostalaKol2.setText(Konstante.getNumber4(PreostalaKolicina.izracunajZalihe(art, PregledProizvodnje.this.u, PregledProizvodnje.this.server)));
                }
            });
            Label k = new Label((Composite)shell2, 0);
            k.setText(String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]) + ":");
            k.setBackground(shell2.getDisplay().getSystemColor(22));
            final DoubleInput2 kolicina = new DoubleInput2(parent2, String.format(PregledProizvodnje.this.barmasterText.getString("TEXT_KOLICINA"), new Object[0]), false);
            Button cancelButt = Dugmici.getCancelButton(shell2);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    parent2.getControl().getShell().close();
                }
            });
            Button okButt = Dugmici.getOkButton(shell2);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        if (PregledProizvodnje.this.artikal.getSelectionIndex() == -1 || kolicina.getText().length() == 0) {
                            return;
                        }
                        Artikal art = PregledProizvodnje.this.server.getArtikal(PregledProizvodnje.this.artikal.getItem(PregledProizvodnje.this.artikal.getSelectionIndex()));
                        ProizvodnjaStavka ts = new ProizvodnjaStavka();
                        ts.setArtikal(art);
                        ts.setKolicina(kolicina.getResult());
                        ProizvodnjaDialog.this.stavke.add(ts);
                        TableItem item = new TableItem(ProizvodnjaDialog.this.table, 0);
                        item.setText(new String[]{art.getName(), kolicina.getResult().toString(), art.getJedinicaMere()});
                    }
                    catch (InputException ex) {
                        Konstante.getPoruka(shell2, ex.getMessage());
                    }
                    shell2.close();
                }
            });
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell2.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 200;
            data.horizontalAlignment = 131072;
            PregledProizvodnje.this.artikal.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 30;
            data.horizontalAlignment = 16384;
            a.setLayoutData((Object)data);
            k.setLayoutData((Object)data);
            PregledProizvodnje.this.pretraga.setLayoutData((Object)data);
            preostalaKol2.setLayoutData((Object)data);
            kolicina.getControl().setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 131072;
            shell2.pack();
            shell2.open();
        }

        protected synchronized boolean unosUtrosakaProizvodnje(Proizvodnja p, List<ProizvodnjaStavka> stavke) {
            System.out.println("ovde kreiram utroske proizvodnje");
            EntityManager base = PregledProizvodnje.this.server.getBase();
            boolean upis = false;
            try {
                HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
                HashMap normativ_kolicina = new HashMap();
                HashMap<Artikal, Double> konacnaLista = new HashMap<Artikal, Double>();
                boolean prolazi = false;
                for (ProizvodnjaStavka proizvodnjaStavka : stavke) {
                    artikal_kolicina.put(proizvodnjaStavka.getArtikal(), proizvodnjaStavka.getKolicina());
                }
                ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    if (artikal.getOdeljenje() == null) continue;
                    for (Odeljenje o : artikal.getOdeljenja()) {
                        if (PregledProizvodnje.this.server.getCurrentCounter().getOdeljenja().contains(o)) {
                            prolazi = true;
                        }
                        if (!prolazi || artikal.getTip() != TipArtikla.POLU) continue;
                        for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenje22(SkidanjeNormativa.razloziArtikalPoluproizvodProizvodnja(artikal, (Double)artikal_kolicina.get(artikal), PregledProizvodnje.this.server, p.getDatum()), PregledProizvodnje.this.server, o, p.getDatum())) {
                            boolean b = true;
                            for (Kartica k2 : karticaList) {
                                if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                                k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                                b = false;
                            }
                            if (!b) continue;
                            k.setDokument("");
                            k.setCrno(false);
                            karticaList.add(k);
                        }
                    }
                }
                if (prolazi) {
                    for (Kartica kartica : karticaList) {
                        konacnaLista.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                    }
                    for (Map.Entry entry : konacnaLista.entrySet()) {
                        ProizvodnjaUtrosak proizvodnjaUtrosak = new ProizvodnjaUtrosak();
                        proizvodnjaUtrosak.setProizvodnja(p);
                        proizvodnjaUtrosak.setArtikal((Artikal)entry.getKey());
                        proizvodnjaUtrosak.setOdeljenje(((Artikal)entry.getKey()).getOdeljenje());
                        proizvodnjaUtrosak.setKolicina(BigDecimal.valueOf((Double)entry.getValue()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                        proizvodnjaUtrosak.setNabavnaCena(((Artikal)entry.getKey()).getTip() != TipArtikla.POLU ? PregledProizvodnje.this.server.getLastNabavnaCenaBelaBezPDV((Artikal)entry.getKey(), p.getDatum()) : PregledProizvodnje.this.server.getNabavnaCenaPoluproizvodBezPDV((Artikal)entry.getKey(), 1.0));
                        PregledProizvodnje.this.server.insertPU(proizvodnjaUtrosak);
                    }
                    upis = true;
                }
            }
            catch (Exception e) {
                upis = false;
                e.printStackTrace();
            }
            return upis;
        }

        protected void sacuvajStavkuProizvodnje(ProizvodnjaStavka ts) throws InputException {
            Artikal art = ts.getArtikal();
            if (art.getTip().equals((Object)TipArtikla.POLU)) {
                PregledProizvodnje.this.server.addProizvodnjaStavka(ts);
            }
        }

        protected void reloadTable() {
            this.table.removeAll();
            if (!this.stavke.isEmpty()) {
                for (ProizvodnjaStavka ps : this.stavke) {
                    TableItem item = new TableItem(this.table, 0);
                    String n = ps.getArtikal().getName();
                    double nabavnaCena = ps.getArtikal().getTip() != TipArtikla.POLU ? PregledProizvodnje.this.server.getLastNabavnaCenaBelaBezPDV(ps.getArtikal(), this.proizvodnja.getDatum()) : PregledProizvodnje.this.server.getNabavnaCenaPoluproizvodBezPDV(ps.getArtikal(), 1.0);
                    item.setText(new String[]{n, Konstante.getNumber4(ps.getKolicina()), ps.getArtikal().getJedinicaMere(), Konstante.getNumber2(nabavnaCena / ps.getKolicina()), Konstante.getNumber2(nabavnaCena)});
                }
            }
            PregledProizvodnje.this.activeStavka = null;
        }
    }
}

