/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.TipArtikla;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NabavneCene {
    public static Map<String, Double> getPosednjaNabavna(Artikal a, Date d, Odeljenje o, boolean crno, int beloSl, int crnoSl, RestoranServer server) {
        if (a.getTip() == TipArtikla.SLOZ || a.getTip() == TipArtikla.DODA || a.getTip() == TipArtikla.POLU) {
            return NabavneCene.getPosednjaNabavnaSlozenog(a, d, o, beloSl, crnoSl, server);
        }
        HashMap<String, Double> nabavneCene = new HashMap<String, Double>();
        java.sql.Date datum = new java.sql.Date(d.getTime());
        boolean nemaNabavnuVrednost = true;
        String query = "SELECT ts.id, ts.komad, ts.komadBPDV, ts.prodajnaVrednost, t.datumTrebovanja, t.tip, t.U_ID FROM trebovanjestavka ts JOIN trebovanje t ON ts.TREBOVANJE_ID = t.id WHERE ts.ARTIKAL_ID = ?  AND t.datumTrebovanja <= ? AND t.tip IN('DIREKTNO_SA_KNJIZ','DIREKTNO_BEZ_KNJIZ','IZ_MAGACINA') AND t.U_ID =? AND t.crno = ? ORDER BY  t.datumTrebovanja DESC, ts.id DESC LIMIT 1";
        String queryMagacin = "SELECT ps.id, ps.komad, ps.komadSPDV, ps.prodajnaCena, p.datumPrijemnice,p.tip FROM prijemnicastavka ps JOIN prijemnica p ON ps.PRIJEMNICA_ID = p.id WHERE ps.ARTIKAL_ID = ? AND p.datumPrijemnice <= ? AND p.tip = 'PRIJEMNICA' AND p.crno = ? ORDER BY  p.datumPrijemnice DESC, ps.id DESC LIMIT 1";
        try {
            if (o.getNaziv().equals("MAGACIN")) {
                PreparedStatement ps = server.getConnection().prepareStatement(queryMagacin);
                ps.setLong(1, a.getId());
                ps.setDate(2, datum);
                ps.setBoolean(3, crno);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    nabavneCene.put("NCpoJMbezPDV", rs.getDouble("komad"));
                    nabavneCene.put("NCpoJMsaPDV", rs.getDouble("komadSPDV"));
                    nabavneCene.put("PCsaPDV", rs.getDouble("prodajnaCena"));
                    nabavneCene.put("PCbezPDV", server.getProdajnaCenaBezPDV(a.getPoreskaGrupa(), rs.getDouble("prodajnaCena")));
                    nemaNabavnuVrednost = false;
                }
                if (nemaNabavnuVrednost) {
                    nabavneCene.put("NCpoJMbezPDV", 0.0);
                    nabavneCene.put("NCpoJMsaPDV", 0.0);
                    nabavneCene.put("PCsaPDV", 0.0);
                    nabavneCene.put("PCbezPDV", 0.0);
                }
            } else {
                PreparedStatement ps = server.getConnection().prepareStatement(query);
                ps.setLong(1, a.getId());
                ps.setDate(2, datum);
                ps.setLong(3, o.getId());
                ps.setBoolean(4, crno);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    nabavneCene.put("NCpoJMbezPDV", rs.getDouble("komadBPDV"));
                    nabavneCene.put("NCpoJMsaPDV", rs.getDouble("komad"));
                    nabavneCene.put("PCsaPDV", rs.getDouble("prodajnaVrednost"));
                    nabavneCene.put("PCbezPDV", server.getProdajnaCenaBezPDV(a.getPoreskaGrupa(), rs.getDouble("prodajnaVrednost")));
                    nemaNabavnuVrednost = false;
                }
                if (nemaNabavnuVrednost) {
                    nabavneCene.put("NCpoJMbezPDV", 0.0);
                    nabavneCene.put("NCpoJMsaPDV", 0.0);
                    nabavneCene.put("PCsaPDV", 0.0);
                    nabavneCene.put("PCbezPDV", 0.0);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return nabavneCene;
    }

    public static Map<String, Double> getProsecnaNabavna(Artikal a, Date datumOd, Date datumDo, Odeljenje o, boolean crno, RestoranServer server) {
        HashMap<String, Double> nabavneCene = new HashMap<String, Double>();
        java.sql.Date datum1 = new java.sql.Date(datumOd.getTime());
        java.sql.Date datum2 = new java.sql.Date(datumDo.getTime());
        boolean nemaNabavnuVrednost = true;
        String query = "SELECT ts.id, round(AVG(ts.komad),4) AS komadSa, round(AVG(ts.komadBPDV),4) AS komadBez, ROUND(AVG(ts.prodajnaVrednost),2) AS prodajna, t.datumTrebovanja, t.tip FROM trebovanjestavka ts  JOIN trebovanje t ON ts.TREBOVANJE_ID =t.id WHERE ts.ARTIKAL_ID = ?  AND t.datumTrebovanja BETWEEN ? AND ? AND t.tip IN ('DIREKTNO_SA_KNJIZ','DIREKTNO_BEZ_KNJIZ','IZ_MAGACINA') AND t.crno = ? AND t.U_ID = ?";
        String queryMagacin = "SELECT ps.id, round(AVG(ps.komad),4) AS komadBez, round(AVG(ps.komadSPDV),4) AS komadSa, ROUND( AVG( ps.prodajnaCena), 2) AS prodajna , p.datumPrijemnice,p.tip FROM prijemnicastavka ps  JOIN prijemnica p ON ps.PRIJEMNICA_ID = p.id  WHERE ps.ARTIKAL_ID = ?  AND p.datumPrijemnice BETWEEN ? AND ? AND p.tip = 'PRIJEMNICA' AND p.crno = ?";
        try {
            if (o.getNaziv().equals("MAGACIN")) {
                PreparedStatement ps = server.getConnection().prepareStatement(queryMagacin);
                ps.setLong(1, a.getId());
                ps.setDate(2, datum1);
                ps.setDate(3, datum2);
                ps.setBoolean(4, crno);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    nabavneCene.put("NCpoJMbezPDV", rs.getDouble("komadBez"));
                    nabavneCene.put("NCpoJMsaPDV", rs.getDouble("komadSa"));
                    nabavneCene.put("PCsaPDV", rs.getDouble("prodajna"));
                    nabavneCene.put("PCbezPDV", server.getProdajnaCenaBezPDV(a.getPoreskaGrupa(), rs.getDouble("prodajna")));
                    nemaNabavnuVrednost = false;
                }
                if (nemaNabavnuVrednost) {
                    nabavneCene.put("NCpoJMbezPDV", 0.0);
                    nabavneCene.put("NCpoJMsaPDV", 0.0);
                    nabavneCene.put("PCsaPDV", 0.0);
                    nabavneCene.put("PCbezPDV", 0.0);
                }
            } else {
                PreparedStatement ps = server.getConnection().prepareStatement(query);
                ps.setLong(1, a.getId());
                ps.setDate(2, datum1);
                ps.setDate(3, datum2);
                ps.setBoolean(4, crno);
                ps.setLong(5, o.getId());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    nabavneCene.put("NCpoJMbezPDV", rs.getDouble("komadBez"));
                    nabavneCene.put("NCpoJMsaPDV", rs.getDouble("komadSa"));
                    nabavneCene.put("PCsaPDV", rs.getDouble("prodajna"));
                    nabavneCene.put("PCbezPDV", server.getProdajnaCenaBezPDV(a.getPoreskaGrupa(), rs.getDouble("prodajna")));
                    nemaNabavnuVrednost = false;
                }
                if (nemaNabavnuVrednost) {
                    nabavneCene.put("NCpoJMbezPDV", 0.0);
                    nabavneCene.put("NCpoJMsaPDV", 0.0);
                    nabavneCene.put("PCsaPDV", 0.0);
                    nabavneCene.put("PCbezPDV", 0.0);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return nabavneCene;
    }

    private static Map<String, Double> getPosednjaNabavnaSlozenog(Artikal a, Date d, Odeljenje o, int belo, int crno, RestoranServer server) {
        double nabavnaCenaSaPdv = 0.0;
        double nabavnaCenaBezPdv = 0.0;
        HashMap<String, Double> nabavneCene = new HashMap<String, Double>();
        java.sql.Date datum = new java.sql.Date(d.getTime());
        boolean nemaNabavnuVrednost = true;
        String queryParam = "SET @dat = ?, @artikid = ?, @odel = ?, @belo = ?, @crno =?;";
        String queryPrice = "select ARTIKAL_ID,sum(kolicina*putaotkuc*mera) as kolicina, ODELJENJA_ID, \r\n\t\t\tcoalesce((select komadBPDV from trebovanjestavka ts\r\n\t\t\t\t\t\t\t\t\t\t\tleft join trebovanje t on ts.TREBOVANJE_ID = t.id\r\n\t\t\t\t\t\t\t\t\t\t\twhere ts.ARTIKAL_ID = trt.ARTIKAL_ID AND  t.crno IN(@crno, @belo) AND t.datumTrebovanja =\r\n\t\t\t\t\t\t\t\t\t\t\t(SELECT max(t2.datumTrebovanja) from trebovanje t2 \r\n\t\t\t\t\t\t\t\t\t\t\t\tleft join trebovanjestavka ts2 on ts2.TREBOVANJE_ID = t2.id\r\n\t\t\t\t\t\t\t\t\t\t\t\twhere ts2.artikal_ID = trt.ARTIKAL_ID AND t2.crno IN(@crno, @belo)) limit 1),0) as nabavnaCenaBezPdv ,\r\n\t\t\tcoalesce((select komad from trebovanjestavka ts\r\n\t\t\t\t\t\t\t\t\t\t\tleft join trebovanje t on ts.TREBOVANJE_ID = t.id\r\n\t\t\t\t\t\t\t\t\t\t\twhere ts.ARTIKAL_ID = trt.ARTIKAL_ID AND  t.crno IN(@crno, @belo) and t.datumTrebovanja =\r\n\t\t\t\t\t\t\t\t\t\t\t(SELECT max(t2.datumTrebovanja) from trebovanje t2 \r\n\t\t\t\t\t\t\t\t\t\t\t\tleft join trebovanjestavka ts2 on ts2.TREBOVANJE_ID = t2.id\r\n\t\t\t\t\t\t\t\t\t\t\t\twhere ts2.artikal_ID = trt.ARTIKAL_ID AND  t2.crno IN(@crno, @belo))  limit 1),0) as nabavnaCenaSaPdv\r\n\t\t\t\t\t\t\t\t\t\t\t\t\r\n\r\nfrom (\r\nSELECT a.id as artikal_id, 1 as kolicina, a.mera, \r\n\t\t\t\t1 as putaotkuc, @odel as ODELJENJA_ID, '0' as ttip, a.tip\r\n\t\tFROM artikal a\r\n\t\tWHERE a.id = @artikid AND a.tip != 'SLOZ' and a.tip != 'POLU'\r\n\t\t\r\n\t\tUNION\r\n\t\tSELECT i.sastojak_id,i.kolicina,1 as mera, 1 as putaotkuc, @odel as ODELJENJA_id, \r\n\t\t\t\t\t\t\t\t\t\t\t'1' as ttip, a.tip\r\n\t\t\t\t\t\t\t\t\t\t\t\r\n\t\tfrom normativ i\r\n\t\tleft join artikal a on a.id = i.sastojak_id\r\n\t\tleft join normativartikal na on i.NORMATIVARTIKAL_ID = na.id\r\n\t\tWHERE a.tip != 'PPOLU' AND i.ARTIKAL_ID = @artikid AND a.tip != 'SLOZ' AND \r\n\t\t\t\t\t i.ODELJENJE_ID = @odel and \r\n\t\t\t\t\t\t\t\t\t\t\tna.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, @dat) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, @dat) LIMIT 1 ),0) \r\n\t\tUNION\r\n\t\tSELECT ii.sastojak_id,ii.kolicina,1 as mera, (i.kolicina * 1) as putaotkuc, ao.ODELJENJA_id, \r\n\t\t\t\t\t\t\t\t\t'2' as ttip, a.tip\r\n\t\tfrom normativ i\r\n\t\tleft join normativ ii on i.sastojak_id = ii.artikal_id\r\n\t\tleft join artikal a on a.id = ii.sastojak_id\r\n\t\tleft join artikal a2 on a2.id = i.artikal_id\r\n\t\tleft join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id\r\n\t\tleft join normativartikal na on ii.NORMATIVARTIKAL_ID = na.id\r\n\t\tleft join normativartikal na2 on i.NORMATIVARTIKAL_ID = na2.id\r\n\t\tWHERE i.artikal_id = @artikid and a2.tip != 'PPOLU' and a.tip != 'SLOZ' and \r\n\t\t\t\t\t ii.ODELJENJE_ID = @odel AND ao.ODELJENJA_ID = @odel AND ii.SASTOJAK_ID is not null and \r\n\t\t\t\t\t\t\t\t\t\t\tna.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = ii.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, @dat) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, @dat) LIMIT 1 ),0) and \r\n\t\t\t\t\t\t\t\t\t\t\tna2.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, @dat) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, @dat) LIMIT 1 ),0) \r\n\t\tUNION\r\n\t\tSELECT iii.sastojak_id,iii.kolicina,1 as mera, (i.kolicina * ii.kolicina * 1) as putaotkuc, ao.ODELJENJA_id, \r\n\t\t\t\t\t\t\t\t\t'3' as ttip, a.tip\r\n\t\tfrom normativ i\r\n\t\tleft join normativ ii on i.sastojak_id = ii.artikal_id\r\n\t\tleft join normativ iii on ii.sastojak_id = iii.artikal_id\r\n\t\tleft join artikal a on a.id = iii.sastojak_id\r\n\t\tleft join artikal a2 on a2.id = ii.artikal_id\r\n\t\tleft join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id\r\n\t\tleft join normativartikal na on iii.NORMATIVARTIKAL_ID = na.id\r\n\t\tleft join normativartikal na2 on ii.NORMATIVARTIKAL_ID = na2.id\r\n\t\tleft join normativartikal na3 on i.NORMATIVARTIKAL_ID = na3.id\r\n\t\twhere i.artikal_id = @artikid and a2.tip != 'PPOLU' and \r\n\t\t\t\t\t iii.ODELJENJE_ID = @odel AND ao.ODELJENJA_ID = @odel and iii.SASTOJAK_ID is not null and \r\n\t\t\t\t\t\t\t\t\t\t\tna.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = iii.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, @dat) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, @dat) LIMIT 1 ),0) and \r\n\t\t\t\t\t\t\t\t\t\t\tna2.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = ii.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, @dat) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, @dat) LIMIT 1 ),0) and \r\n\t\t\t\t\t\t\t\t\t\t\tna3.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, @dat) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, @dat) LIMIT 1 ),0) \r\n) as trt\r\ngroup BY artikal_id,odeljenja_id";
        try {
            PreparedStatement ps = server.getConnection().prepareStatement(queryParam);
            ps.setDate(1, datum);
            ps.setLong(2, a.getId());
            ps.setLong(3, o.getId());
            ps.setInt(4, belo);
            ps.setInt(5, crno);
            ps.execute();
            Statement st = server.getConnection().createStatement();
            ResultSet rs = st.executeQuery(queryPrice);
            while (rs.next()) {
                nabavnaCenaSaPdv += rs.getDouble("kolicina") * rs.getDouble("NabavnaCenaSaPdv");
                nabavnaCenaBezPdv += rs.getDouble("kolicina") * rs.getDouble("nabavnaCenaBezPdv");
                nemaNabavnuVrednost = false;
            }
            nabavneCene.put("NCpoJMbezPDV", Konstante.round(nabavnaCenaBezPdv, 2));
            nabavneCene.put("NCpoJMsaPDV", Konstante.round(nabavnaCenaSaPdv, 2));
            nabavneCene.put("PCsaPDV", 0.0);
            nabavneCene.put("PCbezPDV", 0.0);
            if (nemaNabavnuVrednost) {
                nabavneCene.put("NCpoJMbezPDV", 0.0);
                nabavneCene.put("NCpoJMsaPDV", 0.0);
                nabavneCene.put("PCsaPDV", 0.0);
                nabavneCene.put("PCbezPDV", 0.0);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return nabavneCene;
    }

    public static Date getPoslednjiDatumTrebovanja(Artikal a, RestoranServer server) {
        String query = "SELECT t.datumTrebovanja FROM trebovanje t JOIN trebovanjestavka ts ON t.id = ts.TREBOVANJE_ID WHERE ts.ARTIKAL_ID = ? ORDER BY t.id DESC LIMIT 1";
        try {
            PreparedStatement ps = server.getConnection().prepareStatement(query);
            ps.setLong(1, a.getId());
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getTimestamp("datumTrebovanja");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getPoslednjiDatumPrijemnice(Artikal a, RestoranServer server) {
        String query = "SELECT p.datumPrijemnice FROM prijemnica p JOIN prijemnicastavka ps ON p.id = ps.PRIJEMNICA_ID WHERE ps.ARTIKAL_ID =? ORDER BY p.id  DESC LIMIT 1";
        try {
            PreparedStatement ps = server.getConnection().prepareStatement(query);
            ps.setLong(1, a.getId());
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getTimestamp("datumPrijemnice");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

