/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.JSONoperation;

import com.dev63.restoran.JSONObjects.serbianbookers.SerbianBookersExtrasRequest;
import com.dev63.restoran.JSONObjects.serbianbookers.SerbianBookersLoginRequest;
import com.dev63.restoran.JSONObjects.serbianbookers.SerbianBookersLoginResponse;
import com.dev63.restoran.JSONObjects.serbianbookers.SerbianBookersLogoutRequest;
import com.dev63.restoran.JSONObjects.serbianbookers.SerbianBookersOcupiedRoomsRequest;
import com.dev63.restoran.JSONObjects.serbianbookers.SerbianBookersOcupiedRoomsResponse;
import com.dev63.restoran.JSONObjects.serbianbookers.models.Extras;
import com.dev63.restoran.JSONObjects.serbianbookers.models.PropertyInf;
import com.dev63.restoran.JSONObjects.serbianbookers.models.Room;
import com.dev63.restoran.JSONoperation.JSONGetter;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONSerbianBookers {
    RestoranServer server;
    SerbianBookersLoginResponse loginResponse;
    SerbianBookersOcupiedRoomsResponse ocupiedRoomsResponse;
    PropertyInf property;
    String roomsJSON;
    String invoiceJSON;
    String loginJSON;
    String logoutJSON;
    ObjectMapper mapper;
    Room[] occupiedRooms;
    String httpLogin;
    String httpLogout;
    String httpOcupiedRooms;
    String httpInvoice;
    String params;
    String guestName;
    String key;
    String account = "";

    public JSONSerbianBookers(RestoranServer server) {
        this.server = server;
        this.guestName = "";
        this.httpLogin = "https://newdb.otasync.me/api/user/auth/login";
        this.httpLogout = "https://newdb.otasync.me/api/user/auth/logout";
        this.httpOcupiedRooms = "https://newdb.otasync.me/api/reservation/data/occupiedRooms";
        this.httpInvoice = "https://newdb.otasync.me/api/reservation/insert/reservationExtra";
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.params = this.makeLoginParams();
        this.loginJSON = JSONGetter.getJSONFromHttpRequest(this.httpLogin, this.params);
        try {
            this.loginResponse = (SerbianBookersLoginResponse)this.mapper.readValue(this.loginJSON, SerbianBookersLoginResponse.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.property = this.loginResponse.getProperties()[0];
        this.key = this.loginResponse.getPkey();
        this.params = this.makeRoomParams(this.key, this.property.getId_properties());
        this.roomsJSON = JSONGetter.getJSONFromHttpRequest(this.httpOcupiedRooms, this.params);
        System.out.println(this.roomsJSON);
        try {
            this.ocupiedRoomsResponse = (SerbianBookersOcupiedRoomsResponse)this.mapper.readValue(this.roomsJSON, SerbianBookersOcupiedRoomsResponse.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.occupiedRooms = this.ocupiedRoomsResponse.getRooms();
    }

    public boolean sendBill(Racun bill, String sg, Long reservationId) {
        String reservationCode = String.valueOf(reservationId);
        this.guestName = sg;
        this.params = this.makeBillParams(bill, reservationCode);
        this.invoiceJSON = JSONGetter.getJSONFromHttpRequest(this.httpInvoice, this.params);
        System.out.println(this.invoiceJSON);
        return true;
    }

    public void logout() {
        this.params = this.makeLogOutParams();
        this.logoutJSON = JSONGetter.getJSONFromHttpRequest(this.httpLogout, this.params);
        System.out.println(this.logoutJSON);
    }

    public Map<String, Long> getBookersRooms() {
        HashMap<String, Long> rooms = new HashMap<String, Long>();
        for (Room r : this.occupiedRooms) {
            String roomName = r.getRoom_name();
            Long reservationId = Long.parseLong(r.getId_reservations());
            rooms.put(roomName, reservationId);
        }
        return rooms;
    }

    public Map<String, Long> getBookersGuests(String input) {
        HashMap<String, Long> guests = new HashMap<String, Long>();
        for (Room r : this.occupiedRooms) {
            String roomName = r.getRoom_name();
            if (!roomName.equals(input)) continue;
            String guestName = r.getGuest();
            Long reservationId = Long.parseLong(r.getId_reservations());
            guests.put(guestName, reservationId);
        }
        return guests;
    }

    private String makeLoginParams() {
        String userName = this.server.getSetting(Option.SERBIAN_BOOKERS_LOGIN_USERNAME).stringValue().trim();
        String password = this.server.getSetting(Option.SERBIAN_BOOKERS_LOGIN_PASSWORD).stringValue().trim();
        SerbianBookersLoginRequest loginRequest = new SerbianBookersLoginRequest(userName, password, "0");
        String loginParams = "";
        try {
            loginParams = this.mapper.writeValueAsString((Object)loginRequest);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        System.out.println(loginParams);
        return loginParams;
    }

    private String makeLogOutParams() {
        SerbianBookersLogoutRequest logoutRequest = new SerbianBookersLogoutRequest(this.key);
        String logoutParams = "";
        try {
            logoutParams = this.mapper.writeValueAsString((Object)logoutRequest);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return logoutParams;
    }

    private String makeRoomParams(String key, String property_id) {
        String roomParams = "";
        SerbianBookersOcupiedRoomsRequest ocupiedRoomsRequest = new SerbianBookersOcupiedRoomsRequest(key, property_id);
        try {
            roomParams = this.mapper.writeValueAsString((Object)ocupiedRoomsRequest);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return roomParams;
    }

    private Extras[] makeBillDetailParams(Racun bill) {
        List<StavkaRacuna> billItems = bill.getStavke();
        int itemsLength = billItems.size();
        String name = "";
        String quantity = "";
        String price = "";
        String tax = "";
        String total_price = "";
        double total = 0.0;
        Extras[] extras = new Extras[itemsLength];
        for (int i = 0; i < itemsLength; ++i) {
            Extras extr;
            StavkaRacuna item = billItems.get(i);
            name = item.getName();
            quantity = String.valueOf(item.getQuantity().doubleValue());
            price = String.valueOf(item.getPrice().doubleValue());
            tax = String.valueOf(Konstante.getPGStopaProcenat(item.getArtikal().getPoreskaGrupa()));
            total = Konstante.round(item.getQuantity().doubleValue() * item.getPriceWithDiscount().doubleValue(), 2);
            total_price = String.valueOf(total);
            extras[i] = extr = new Extras(name, quantity, price, tax, total_price);
        }
        return extras;
    }

    private String makeBillParams(Racun bill, String id_reservation) {
        Extras[] extras = this.makeBillDetailParams(bill);
        String id_properties = this.property.getId_properties();
        SerbianBookersExtrasRequest extrasRequest = new SerbianBookersExtrasRequest(this.key, id_properties, id_reservation, extras);
        String billParams = "";
        try {
            billParams = this.mapper.writeValueAsString((Object)extrasRequest);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return billParams;
    }
}

