/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.FrontOffice3;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.stampa.StampaPregledaTura;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.SerializationUtils;

public abstract class FrontOfficeTemplate {
    public static final Logger LOGGER = Logger.getLogger(FrontOfficeTemplate.class.getName());

    protected void cloneAndPrintOrdersOverview(List<Tura> orders, StalniGost guest, Stampac printer, Konobar waiter, int copies) {
        try {
            orders = orders.parallelStream().map(o -> (Tura)SerializationUtils.clone((Serializable)o)).collect(Collectors.toList());
            waiter = (Konobar)SerializationUtils.clone((Serializable)waiter);
            guest = (StalniGost)SerializationUtils.clone((Serializable)guest);
            this.printOrdersOverview(orders, guest, printer, waiter, copies);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    protected void printOrdersOverview(List<Tura> orders, StalniGost guest, Stampac printer, Konobar waiter, int copies) {
        Konstante.ORDER_EXECUTOR.execute(() -> new StampaPregledaTura(orders, guest, printer, waiter, copies));
    }

    protected void checkAndPrintGuestOrdersOverview(Racun bill, Stampac printer) {
        if (bill.getStalniGost() != null && bill.getStalniGost().getStampaPregleda() != null && bill.getStalniGost().getStampaPregleda().booleanValue()) {
            try {
                this.cloneAndPrintOrdersOverview(bill.getTure(), bill.getStalniGost(), printer, bill.getKonobar(), bill.getStalniGost().getBrojKopijaPregleda());
            }
            catch (Exception ex) {
                Logger.getLogger(FrontOffice3.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

