/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.backup.RestoranBackup;
import com.dev63.restoran.sistem.FiskalneFunkcije;
import com.dev63.restoran.swt.components.SWTMessage;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Cistacica {
    public static synchronized void cisti(Shell shell, final RestoranServer server) {
        Date datum;
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if ((datum = SWTMessage.showDateInputDialog(shell, "Datum:", "Do datuma?")) != null) {
            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Cistacica.ocistiUtroske(server, datum);
                        FiskalneFunkcije.presekStanja(server);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Cistacica.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    server.log(String.format(Konstante.getBundle().getString("LOG_CISTACICA"), new Object[0]));
                    server.cistacica(datum);
                }
            });
        }
    }

    public static synchronized boolean cistiGlasno(Shell shell, final RestoranServer server, File dir, boolean onlyBackup) {
        Date datum;
        boolean[] success = new boolean[]{false};
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (dir == null) {
            DirectoryDialog dd = new DirectoryDialog(shell, 4);
            dd.setMessage("Izaberite folder");
            String path = dd.open();
            if (path == null) {
                return false;
            }
            dir = new File(path);
        }
        File buDir = dir;
        Date tDate = new Date();
        if (!onlyBackup) {
            tDate = SWTMessage.showDateInputDialog(shell, "Datum:", "Do datuma?");
        }
        if ((datum = tDate) != null) {
            RestoranBackup rb = new RestoranBackup();
            try {
                success[0] = rb.doBackupToDir(buDir);
            }
            catch (Exception ex) {
                Logger.getLogger(Cistacica.class.getName()).warning("Backup neuspesan, procedura nastavljena bez backupa!!!");
            }
            if (!success[0]) {
                if (!onlyBackup) {
                    success[0] = SWTMessage.showLocalizedYesNoDialog(shell, "\u010cuvanje podataka nije uspelo. Nastaviti?") == 64;
                } else {
                    SWTMessage.showLocalizedInfoDialog(shell, "\u010cuvanje podataka nije uspelo.");
                }
            }
            if (onlyBackup) {
                return success[0];
            }
            final String[] errorMessage = new String[]{null};
            if (success[0]) {
                Cistacica.ocistiUtroske(server, datum);
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            server.log(String.format(Konstante.getBundle().getString("LOG_CISTACICA"), new Object[0]));
                            server.cistacica(datum);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(RestoranServer.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                            errorMessage[0] = "Error: " + ex.getMessage();
                        }
                    }
                });
            }
            if (errorMessage[0] != null) {
                SWTMessage.showLocalizedErrorDialog(shell, errorMessage[0]);
            }
        }
        return success[0];
    }

    private static void ocistiUtroske(RestoranServer server, Date datum) {
        Connection connection = server.getConnection();
        java.sql.Date queryDate = new java.sql.Date(datum.getTime());
        String dnevniUtrosak = "delete from dnevniutrosak where zdBroj <= (select zdBroj from zd where datum = ? and pocetak = 1) AND dodatno = 1";
        String otpisUtrosak = "delete from otpisutrosak where otpis_id in (select id from otpis where datum <= ? AND crno = 1) ";
        String proizvodnjaUtrosak = "delete from proizvodnjautrosak where proizvodnja_id in (select id from proizvodnja where datum <= ? AND crno = 1) ";
        String utrosakDocUtrosak = "delete from utrosakdocutrosak where utrosakdoc_id in (select id from utrosakdoc where datum <= ? AND crno = 1) ";
        try {
            connection.setAutoCommit(false);
            PreparedStatement pStatement = connection.prepareStatement(dnevniUtrosak);
            pStatement.setDate(1, queryDate);
            pStatement.execute();
            pStatement = connection.prepareStatement(otpisUtrosak);
            pStatement.setDate(1, queryDate);
            pStatement.execute();
            pStatement = connection.prepareStatement(proizvodnjaUtrosak);
            pStatement.setDate(1, queryDate);
            pStatement.execute();
            pStatement = connection.prepareStatement(utrosakDocUtrosak);
            pStatement.setDate(1, queryDate);
            pStatement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }
}

