/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.frontoffice.BMFrontTheme;
import com.dev63.restoran.lang.Language;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Setting;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class BMTerminalSettings {
    private static final Properties settings = new Properties();
    private static final File settFolder = new File("config");
    private static final File settFile = new File(settFolder, "Settings.conf");

    public static Setting getSetting(OptionBO option) {
        String actual;
        String name = option.getName();
        try {
            actual = settings.getProperty(option.getName());
            if (option.isEncrypted().booleanValue()) {
                actual = Setting.decrypt(actual);
            }
        }
        catch (Exception e) {
            actual = option.getDiefault();
        }
        Setting s = new Setting();
        s.setActual(actual);
        s.setName(name);
        return s;
    }

    public static void setSetting(Setting setting) {
        if (setting.getName() != null && setting.getActual() != null) {
            OptionBO key = OptionBO.findByName(setting.getName());
            if (key == null) {
                return;
            }
            BMTerminalSettings.setSetting(key, setting.getActual());
        }
    }

    public static boolean setSetting(OptionBO key, String value) {
        String oldValue = settings.getProperty(key.getName());
        boolean success = false;
        if (key.isEncrypted().booleanValue()) {
            try {
                value = Setting.encrypt(value);
                success = true;
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchPaddingException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvalidKeyException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalBlockSizeException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (BadPaddingException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                Logger.getLogger(BMTerminalSettings.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            success = true;
        }
        if (!success) {
            return false;
        }
        settings.setProperty(key.getName(), value);
        if (!BMTerminalSettings.saveSettings()) {
            System.out.println("save failed");
            settings.setProperty(key.getName(), oldValue);
            return false;
        }
        return true;
    }

    public static boolean saveSettings() {
        FileWriter fw = null;
        try {
            fw = new FileWriter(settFile);
            settings.store(fw, null);
            fw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            Logger.getLogger(Konstante.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Konstante.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public static boolean setCurLanguage(String langName) {
        for (Language le : Language.values()) {
            if (!langName.equalsIgnoreCase(le.getName())) continue;
            return BMTerminalSettings.setSetting(OptionBO.JEZIK_PROGRAMA, langName);
        }
        return false;
    }

    public static Language getCurLanguage() {
        String curLangName = BMTerminalSettings.getSetting(OptionBO.JEZIK_PROGRAMA).stringValue();
        for (Language le : Language.values()) {
            if (!le.getName().equalsIgnoreCase(curLangName)) continue;
            return le;
        }
        return Language.SRPSKI;
    }

    public static Locale getCurLocale() {
        String curLang = BMTerminalSettings.getSetting(OptionBO.JEZIK_PROGRAMA).stringValue();
        for (Language le : Language.values()) {
            if (!le.getName().equalsIgnoreCase(curLang)) continue;
            return le.getLangLocale();
        }
        return Locale.getDefault();
    }

    public static List<Setting> getSettings() {
        LinkedList<Setting> sList = new LinkedList<Setting>();
        for (OptionBO oBO : OptionBO.values()) {
            Setting s = BMTerminalSettings.getSetting(oBO);
            sList.add(s);
        }
        return sList;
    }

    public static void incrementPomocniBrojStola() throws Exception {
        Setting sbs = BMTerminalSettings.getSetting(OptionBO.POMOCNI_BROJ_STOLA);
        Setting pbs = null;
        if (sbs == null) {
            sbs = new Setting();
            sbs.setName(OptionBO.POMOCNI_BROJ_STOLA.getName());
            sbs.setActual("10001");
            pbs = new Setting();
            pbs.setName(OptionBO.POMOCNI_BROJ_POCETNI.getName());
            pbs.setActual("10000");
        } else {
            Integer tbs = null;
            try {
                tbs = Integer.valueOf(sbs.getActual());
            }
            catch (NumberFormatException nfe) {
                throw new Exception(String.format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NEUSPELA_KONVERZIJA_BROJA_STOLA_IZ_PODESAVANJA"), new Object[0]));
            }
            if (tbs == null) {
                throw new Exception(String.format(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DOBIJENI_BROJ_STOLA_IZ_BAZE_PRAZAN"), new Object[0]));
            }
            Integer n = tbs;
            Integer n2 = tbs = Integer.valueOf(tbs + 1);
            sbs.setActual("" + tbs);
        }
        System.out.println("Sledeci broj stola je " + sbs.getActual());
        BMTerminalSettings.setSetting(sbs);
        if (pbs != null) {
            BMTerminalSettings.setSetting(pbs);
        }
    }

    public static void resetPomocniBrojStola() {
        Setting pbs = BMTerminalSettings.getSetting(OptionBO.POMOCNI_BROJ_POCETNI);
        Setting sbs = BMTerminalSettings.getSetting(OptionBO.POMOCNI_BROJ_STOLA);
        if (sbs == null) {
            BMTerminalSettings.setSetting(sbs);
            sbs = new Setting();
            sbs.setName(OptionBO.POMOCNI_BROJ_STOLA.getName());
        }
        sbs.setActual(pbs == null ? "10000" : pbs.getActual());
        System.out.println("Pocetni broj stola je " + sbs.getActual());
        BMTerminalSettings.setSetting(sbs);
    }

    public static String getArtikleZaNeprikazivanje() {
        return BMTerminalSettings.getSetting(OptionBO.ARTIKLI_DA_SE_NE_VIDE).stringValue();
    }

    public static List<String> getGrupe() {
        return BMTerminalSettings.getSetting(OptionBO.GRUPE_ZA_FRONT).listStringValue();
    }

    public static void setGrupe(List<String> lista) {
        Setting s = new Setting();
        s.setName(OptionBO.GRUPE_ZA_FRONT.getName());
        s.setActual(lista);
        BMTerminalSettings.setSetting(s);
    }

    public static Boolean isNoviTipPodesavanja() {
        return Boolean.valueOf(BMTerminalSettings.getSetting(OptionBO.NOVI_TIP_PODESAVANJA).stringValue());
    }

    public static BMFrontTheme getFOTheme() {
        String theme = BMTerminalSettings.getSetting(OptionBO.TEMA_FRONTA).stringValue();
        for (BMFrontTheme bmT : BMFrontTheme.values()) {
            if (!bmT.name().equals(theme)) continue;
            return bmT;
        }
        return BMFrontTheme.STRAWBERIES_AND_CREAM;
    }

    public static void setFrontOfficeTheme(BMFrontTheme theme) {
        if (theme != null) {
            BMTerminalSettings.setSetting(OptionBO.TEMA_FRONTA, theme.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        FileReader fr = null;
        if (!settFile.exists()) {
            settFolder.mkdirs();
            for (OptionBO oBO : OptionBO.values()) {
                BMTerminalSettings.setSetting(oBO, oBO.getDiefault());
            }
        }
        try {
            fr = new FileReader(settFile);
            settings.load(fr);
            settings.list(System.out);
            if (!settings.containsKey(OptionBO.NOVI_TIP_PODESAVANJA.getName())) {
                for (OptionBO oBO : OptionBO.values()) {
                    BMTerminalSettings.setSetting(oBO, oBO.getDiefault());
                }
            } else {
                for (OptionBO oBO : OptionBO.values()) {
                    if (settings.containsKey(oBO.getName())) continue;
                    BMTerminalSettings.setSetting(oBO, oBO.getDiefault());
                }
            }
            fr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Konstante.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Konstante.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

