/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.backoffice.radkonobara.PregledStolovi;
import com.dev63.restoran.izvestaji.PrometPoArtiklimaNovi;
import com.dev63.restoran.izvestaji.PrometPoKonobarima2021;
import com.dev63.restoran.izvestaji.PrometSvihKonobara;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.sistem.FiskalneFunkcije;
import com.dev63.restoran.swt.components.ImageButton;
import com.dev63.restoran.swt.resources.FontCache;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AdministracijaKonobara {
    private final ResourceBundle barmasterText = Konstante.getBundle();
    Display display;
    Calendar reference;
    RestoranServer server;
    Restoran restoran;
    Shell shell;
    List<Konobar> konob;
    Font buttFont;
    Color buttCol;
    boolean rucno;
    ImageButton ztd = null;
    private Date pocetakDana;

    public AdministracijaKonobara(Display d, Restoran r) {
        this.display = d;
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.konob = this.server.readKonobar();
        this.pocetakDana = this.server.getLastDateZD();
        this.rucno = this.restoran.getServerBO().getSetting(OptionBO.FISKALNO_ZAKLJUCENJE).booleanValue() && !this.restoran.getServerBO().getSetting(OptionBO.AUTOMATSKO_ZAKLJUCENJE_FISKALA).booleanValue();
        this.shell = new Shell(this.display, 0);
        this.buttCol = new Color((Device)this.display, BMTerminalSettings.getFOTheme().getButtonFontColor());
        this.buttFont = FontCache.getFont(BMTerminalSettings.getFOTheme().getMediumButtonFont());
        ImageButton ppk = new ImageButton((Composite)this.shell, 8);
        ppk.setFont(this.buttFont);
        ppk.setForeground(this.buttCol);
        ImageButton ps = new ImageButton((Composite)this.shell, 8);
        ps.setFont(this.buttFont);
        ps.setForeground(this.buttCol);
        ImageButton ppa = new ImageButton((Composite)this.shell, 8);
        ppa.setFont(this.buttFont);
        ppa.setForeground(this.buttCol);
        ImageButton psk = new ImageButton((Composite)this.shell, 8);
        psk.setFont(this.buttFont);
        psk.setForeground(this.buttCol);
        if (this.rucno) {
            this.ztd = new ImageButton((Composite)this.shell, 8);
            this.ztd.setFont(this.buttFont);
            this.ztd.setForeground(this.buttCol);
        }
        ImageButton pregSto = new ImageButton((Composite)this.shell, 8);
        pregSto.setFont(this.buttFont);
        pregSto.setForeground(this.buttCol);
        ImageButton izl = new ImageButton((Composite)this.shell, 8);
        izl.setFont(this.buttFont);
        izl.setForeground(this.buttCol);
        ImageButton izl2 = new ImageButton((Composite)this.shell, 8);
        izl2.setFont(this.buttFont);
        izl2.setForeground(this.buttCol);
        pregSto.setText(String.format(this.barmasterText.getString("TEXT_PREGLED_STOLOVA"), new Object[0]));
        ppk.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_KONOBARIMA"), new Object[0]));
        psk.setText(String.format(this.barmasterText.getString("TEXT_PROMET_SVIH_KONOBARA"), new Object[0]));
        ppa.setText(String.format(this.barmasterText.getString("TEXT_PROMET_PO_ARTIKLIMA"), new Object[0]));
        ps.setText(String.format(this.barmasterText.getString("TEXT_PRESEK_STANJA_(X_IZVESTAJ)"), new Object[0]));
        izl.setText(String.format(this.barmasterText.getString("TEXT_IZLAZAK_IZ_PROGRAMA"), new Object[0]));
        izl2.setText(String.format(this.barmasterText.getString("TEXT_POVRATAK_U_PROGRAM"), new Object[0]));
        if (this.rucno) {
            this.ztd.setText(String.format(this.barmasterText.getString("TEXT_ZATVORI_DAN_(Z_IZVESTAJ)"), new Object[0]));
        }
        psk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Date day1 = AdministracijaKonobara.this.server.getPocetni(new Date());
                Date day2 = AdministracijaKonobara.this.server.getKrajnji(new Date());
                Shell s = new Shell(AdministracijaKonobara.this.shell, 34912);
                new PrometSvihKonobara(s, AdministracijaKonobara.this.restoran, day1, day2, Arrays.asList(NacinPlacanja.values()), StavkeSumarno.getCrnaNaziviIzvestaji(AdministracijaKonobara.this.server), false, false);
                while (!s.isDisposed()) {
                    if (s.getDisplay().readAndDispatch()) continue;
                    s.getDisplay().sleep();
                }
            }
        });
        pregSto.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Shell shell = new Shell(AdministracijaKonobara.this.display, 64);
                new PregledStolovi(shell, AdministracijaKonobara.this.restoran);
            }
        });
        ppk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AdministracijaKonobara.this.prikazKonobara();
            }
        });
        ppa.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new PrometPoArtiklimaNovi(AdministracijaKonobara.this.shell, AdministracijaKonobara.this.restoran, null, false, false, false, Arrays.asList(NacinPlacanja.values()), AdministracijaKonobara.this.server.readCrnaPlacanjaIzvestaji(), AdministracijaKonobara.this.server.readPodgrupeArtikala(), 0, null, false);
            }
        });
        ps.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    FiskalneFunkcije.presekStanja(AdministracijaKonobara.this.server);
                }
                catch (Exception ex) {
                    Logger.getLogger(AdministracijaKonobara.class.getName()).log(Level.WARNING, MessageFormat.format("Greska kod zatvaranja dana: {0}", ex.getMessage()), ex);
                }
            }
        });
        izl.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int style = 65728;
                MessageBox messageBox = new MessageBox(AdministracijaKonobara.this.shell, style);
                messageBox.setText(String.format(AdministracijaKonobara.this.barmasterText.getString("TEXT_INFO"), new Object[0]));
                messageBox.setMessage(String.format(AdministracijaKonobara.this.barmasterText.getString("TEXT_APLIKACIJA_IZLAZAK_PITANJE"), new Object[0]));
                boolean bl = event.doit = messageBox.open() == 64;
                if (event.doit) {
                    AdministracijaKonobara.this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                    AdministracijaKonobara.this.server.fine("Izlazak iz programa sa Login prozora", this.getClass());
                    AdministracijaKonobara.this.display.dispose();
                    System.exit(0);
                }
            }
        });
        izl2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AdministracijaKonobara.this.shell.close();
            }
        });
        if (this.rucno) {
            this.ztd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (AdministracijaKonobara.this.server.getStolove().size() > 0 && !AdministracijaKonobara.this.restoran.getServerBO().getSetting(OptionBO.RAD_BEZ_STOLOVA).booleanValue()) {
                        Konstante.getPoruka(AdministracijaKonobara.this.shell, String.format(AdministracijaKonobara.this.barmasterText.getString("TEXT_MORATE_ZAKLJUCITI_SVE_STOLOVE"), new Object[0]));
                    } else {
                        try {
                            if (FiskalneFunkcije.zatvoriDanSaPresekom(AdministracijaKonobara.this.restoran, AdministracijaKonobara.this.server, AdministracijaKonobara.this.shell)) {
                                AdministracijaKonobara.this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                                AdministracijaKonobara.this.server.fine("Izlazak iz programa sa Login prozora", this.getClass());
                                AdministracijaKonobara.this.display.dispose();
                                System.exit(0);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(AdministracijaKonobara.class.getName()).log(Level.WARNING, MessageFormat.format("Greska kod zatvaranja dana: {0}", ex.getMessage()), ex);
                        }
                    }
                }
            });
        }
        this.shell.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData();
        data.verticalIndent = 80;
        data.horizontalIndent = 150;
        data.horizontalAlignment = 0x1000000;
        data.widthHint = 275;
        data.heightHint = 60;
        pregSto.setLayoutData(data);
        psk.setLayoutData(data);
        ppk.setLayoutData(data);
        ppa.setLayoutData(data);
        ps.setLayoutData(data);
        izl.setLayoutData(data);
        izl2.setLayoutData(data);
        if (this.rucno) {
            this.ztd.setLayoutData(data);
        }
        this.shell.setMaximized(true);
        this.shell.forceFocus();
        this.shell.open();
    }

    public void prikazKonobara() {
        final Shell shell5 = new Shell(this.display, 0);
        shell5.setLayout((Layout)new GridLayout(2, false));
        shell5.setBackground(this.display.getSystemColor(1));
        final Table konobari = new Table((Composite)shell5, 65796);
        konobari.setFont(Konstante.getFont(this.display, 16, 0));
        konobari.setLayoutData((Object)new GridData(1808));
        konobari.setLinesVisible(true);
        konobari.setHeaderVisible(false);
        TableColumn k = new TableColumn(konobari, 0x1000000);
        k.setText(String.format(this.barmasterText.getString("TEXT_KONOBAR"), new Object[0]));
        k.setWidth(480);
        for (Konobar kon : this.konob) {
            TableItem item = new TableItem(konobari, 0);
            item.setText(0, kon.getPunoime());
        }
        ImageButton potvrda = new ImageButton((Composite)shell5, 8);
        boolean trenutni = true;
        potvrda.setFont(this.buttFont);
        potvrda.setForeground(this.buttCol);
        potvrda.setText(String.format(this.barmasterText.getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (konobari.getSelectionIndex() < 0) {
                    return;
                }
                Konobar konobar = AdministracijaKonobara.this.konob.get(konobari.getSelectionIndex());
                Date pdate = Konstante.getOnlyDate(new Date());
                new PrometPoKonobarima2021(shell5, AdministracijaKonobara.this.restoran, AdministracijaKonobara.this.pocetakDana, pdate, konobar, false, Arrays.asList(NacinPlacanja.values()), StavkeSumarno.getCrnaNaziviIzvestaji(AdministracijaKonobara.this.server), true, true);
                shell5.close();
            }
        });
        ImageButton gore = new ImageButton((Composite)shell5, 132);
        gore.setPadding(8);
        gore.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = konobari.getSelectionIndex();
                if (index == -1) {
                    if (konobari.getItemCount() != 0) {
                        konobari.setSelection(0);
                    }
                } else if (index != 0) {
                    konobari.setSelection(--index);
                }
            }
        });
        ImageButton dole = new ImageButton((Composite)shell5, 1028);
        dole.setPadding(8);
        dole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = konobari.getSelectionIndex();
                if (index == -1) {
                    konobari.setSelection(konobari.getItemCount() - 1);
                } else if (index != konobari.getItemCount() - 1) {
                    konobari.setSelection(++index);
                }
            }
        });
        ImageButton button = new ImageButton((Composite)shell5, 8);
        button.setFont(this.buttFont);
        button.setForeground(this.buttCol);
        button.setText(String.format(this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell5.close();
            }
        });
        konobari.pack();
        GridData data = new GridData(1040);
        data.horizontalIndent = 0;
        data.widthHint = 820;
        data.verticalSpan = 4;
        konobari.setLayoutData((Object)data);
        data = new GridData();
        data.verticalIndent = 420;
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData(data);
        data = new GridData(8);
        data.widthHint = 164;
        data.heightHint = 80;
        button.setLayoutData(data);
        gore.setLayoutData(data);
        dole.setLayoutData(data);
        shell5.setMaximized(true);
        Konstante.endShell(shell5);
    }
}

