/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTIcon;
import com.dev63.hotel.swt.swing2swt.components.SWTMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MenuItem;

public class SWTMenuItem
implements SelectionListener {
    protected MenuItem menuItem;
    protected EventListenerList eventListenerList = new EventListenerList();

    public SWTMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        menuItem.addSelectionListener((SelectionListener)this);
    }

    public SWTMenuItem(SWTMenu menu) {
        this(new MenuItem(menu.getMenu(), 8));
    }

    public SWTMenuItem(SWTMenu menu, Action a) {
        this(menu);
        this.setAction(a);
    }

    public SWTMenuItem(SWTMenu menu, Image icon) {
        this(menu);
        this.setIcon(icon);
    }

    public SWTMenuItem(SWTMenu menu, String text) {
        this(menu);
        this.setText(text);
    }

    public SWTMenuItem(SWTMenu menu, String text, Image icon) {
        this(menu);
        this.setText(text);
        this.setIcon(icon);
    }

    public SWTMenuItem(SWTMenu menu, String text, int mnemonic) {
        this(menu);
        StringBuffer textBuffer = new StringBuffer(text);
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != mnemonic) continue;
            textBuffer.insert(i, '&');
            break;
        }
        this.setText(textBuffer.toString());
    }

    public final MenuItem getMenuItem() {
        return this.menuItem;
    }

    public final boolean isEnabled() {
        return this.getMenuItem().isEnabled();
    }

    public final void setEnabled(boolean enabled) {
        this.getMenuItem().setEnabled(enabled);
    }

    public boolean isSelected() {
        return this.getMenuItem().getSelection();
    }

    public void setSelected(boolean selected) {
        this.getMenuItem().setSelection(selected);
    }

    public String getText() {
        return this.getMenuItem().getText();
    }

    public void setText(String text) {
        this.getMenuItem().setText(text);
    }

    public void setIcon(Image icon) {
        this.getMenuItem().setImage(icon);
    }

    public Image getIcon() {
        return this.getMenuItem().getImage();
    }

    public void setAction(Action action) {
        Object icon;
        String actionName = (String)action.getValue("Name");
        if (actionName != null) {
            this.getMenuItem().setText(actionName);
        }
        if ((icon = action.getValue("SmallIcon")) instanceof Image) {
            this.getMenuItem().setImage((Image)icon);
        } else if (icon instanceof SWTIcon) {
            this.getMenuItem().setImage(((SWTIcon)icon).getImage());
        }
        this.addActionListener(action);
    }

    public void addActionListener(ActionListener listener) {
        this.eventListenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.eventListenerList.remove(ActionListener.class, listener);
    }

    public void addItemListener(ItemListener listener) {
        this.eventListenerList.add(ItemListener.class, listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.eventListenerList.remove(ItemListener.class, listener);
    }

    public Object[] getSelectedObjects() {
        if (this.getMenuItem().getSelection()) {
            return new Object[]{this};
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        ActionEvent actionEvent = null;
        EventListener[] actionListeners = this.eventListenerList.getListeners(ActionListener.class);
        for (int i = 0; i < actionListeners.length; ++i) {
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this.getMenuItem().getText());
            }
            ((ActionListener)actionListeners[i]).actionPerformed(actionEvent);
        }
    }
}

