/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTIcon;
import com.dev63.hotel.swt.swing2swt.components.SWTMenuItem;
import javax.swing.Action;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SWTMenu {
    protected Menu menu;
    protected MenuItem menuItem;

    public SWTMenu(Menu menu, MenuItem menuItem) {
        this.menu = menu;
        this.menuItem = menuItem;
    }

    public SWTMenu(SWTMenu parentMenu) {
        this(new Menu(parentMenu.getMenu()), new MenuItem(parentMenu.getMenu(), 64));
        this.getMenuItem().setMenu(this.getMenu());
    }

    public SWTMenu(SWTMenu parentMenu, String label) {
        this(parentMenu);
        this.setText(label);
    }

    public SWTMenu(SWTMenu parentMenu, Action action) {
        this(parentMenu);
        Object icon;
        String actionName = (String)action.getValue("Name");
        if (actionName != null) {
            this.getMenuItem().setText(actionName);
        }
        if ((icon = action.getValue("SmallIcon")) instanceof Image) {
            this.getMenuItem().setImage((Image)icon);
        } else if (icon instanceof SWTIcon) {
            this.getMenuItem().setImage(((SWTIcon)icon).getImage());
        }
    }

    public SWTMenu(SWTMenu parentMenu, String label, boolean b) {
        this(parentMenu, label);
    }

    public final Menu getMenu() {
        return this.menu;
    }

    public final MenuItem getMenuItem() {
        return this.menuItem;
    }

    public final SWTMenuItem add(Action a) {
        return new SWTMenuItem(this, a);
    }

    public final SWTMenuItem add(SWTMenuItem menuItem) {
        return menuItem;
    }

    public final SWTMenuItem add(String s) {
        return new SWTMenuItem(this, s);
    }

    public final void addSeparator() {
        new MenuItem(this.getMenu(), 2);
    }

    public final void insert(Action a, int index) {
        MenuItem menuItem = new MenuItem(this.getMenu(), 8, index);
        new SWTMenuItem(menuItem);
    }

    public final void remove(int pos) {
        this.getMenu().getItem(pos).dispose();
    }

    public final boolean isEnabled() {
        return this.getMenuItem().isEnabled();
    }

    public final void setEnabled(boolean enabled) {
        this.getMenuItem().setEnabled(enabled);
    }

    public String getText() {
        return this.getMenuItem().getText();
    }

    public void setText(String text) {
        this.getMenuItem().setText(text);
    }

    public void setIcon(Image icon) {
        this.getMenuItem().setImage(icon);
    }

    public Image getIcon() {
        return this.getMenuItem().getImage();
    }
}

