/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.awt.ComponentOrientation;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SWTLabel
extends SWTComponent {
    public SWTLabel(Label label) {
        super((Control)label);
    }

    public SWTLabel(SWTContainer parent) {
        this(new Label(parent.getComposite(), 0));
    }

    public SWTLabel(SWTContainer parent, Image image) {
        this(parent);
        this.getLabel().setImage(image);
    }

    public SWTLabel(SWTContainer parent, Image image, int horizontalAlignment) {
        this(parent, image);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public SWTLabel(SWTContainer parent, String text) {
        this(parent);
        this.getLabel().setText(text);
    }

    public SWTLabel(SWTContainer parent, String text, Image image, int horizontalAlignment) {
        this(parent, text, horizontalAlignment);
        this.setIcon(image);
    }

    public SWTLabel(SWTContainer parent, String text, int horizontalAlignment) {
        this(parent, text);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public Label getLabel() {
        return (Label)this.getControl();
    }

    public void setText(String text) {
        this.getLabel().setText(text);
    }

    public String getText() {
        return this.getLabel().getText();
    }

    public void setHorizontalAlignment(int align) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.getDefault());
        align = align == 10 ? (orientation.isLeftToRight() ? 2 : 4) : (orientation.isLeftToRight() ? 4 : 2);
        switch (align) {
            case 2: {
                this.getLabel().setAlignment(16384);
                break;
            }
            case 0: {
                this.getLabel().setAlignment(0x1000000);
                break;
            }
            case 4: {
                this.getLabel().setAlignment(131072);
            }
        }
    }

    public int getHorizontalAlignment() {
        switch (this.getLabel().getAlignment()) {
            case 16384: {
                return 2;
            }
            case 131072: {
                return 4;
            }
            case 0x1000000: {
                return 0;
            }
        }
        return -1;
    }

    public final void setIcon(Image image) {
        this.getLabel().setImage(image);
    }

    public final Image getIcon() {
        return this.getLabel().getImage();
    }
}

