/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt;

import com.dev63.hotel.swt.swing2swt.components.SWTButton;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTLabel;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.hotel.swt.swing2swt.components.SWTPanel;
import com.dev63.hotel.swt.swing2swt.components.SWTSeparator;
import com.dev63.hotel.swt.swing2swt.layout.BorderLayout;
import com.dev63.hotel.swt.swing2swt.layout.FlowLayout;
import com.dev63.hotel.swt.swing2swt.layout.GridLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SWTSamplePanel
extends SWTPanel
implements ListSelectionListener {
    private SWTList leftList;
    private SWTList rightList;
    private SWTButton selectButton;
    private SWTButton selectAllButton;
    private SWTButton deselectButton;
    private SWTButton deselectAllButton;
    private DefaultListModel leftListModel = new DefaultListModel();
    private DefaultListModel rightListModel = new DefaultListModel();

    public SWTSamplePanel(SWTContainer parent) {
        super(parent);
        SWTPanel content = new SWTPanel(this, new BorderLayout(5, 5));
        this.add(content);
        content.add("South", this.createButtonsPanel(content));
        content.add("Center", this.createSoshPanel(content));
        this.initContent();
    }

    protected SWTComponent createSoshPanel(SWTContainer parent) {
        SWTPanel mainPanel = new SWTPanel(parent, new BorderLayout(5, 5));
        SWTPanel leftPanel = new SWTPanel(mainPanel, new BorderLayout(5, 5));
        leftPanel.add("North", new SWTLabel((SWTContainer)leftPanel, "Available items:"));
        this.leftList = new SWTList((SWTContainer)leftPanel, this.leftListModel);
        this.leftList.setPreferredSize(new Dimension(100, 150));
        this.leftList.getSelectionModel().addListSelectionListener(this);
        leftPanel.add(this.leftList);
        mainPanel.add("West", leftPanel);
        SWTPanel centerPanel = new SWTPanel(mainPanel, new BorderLayout());
        mainPanel.add(centerPanel);
        SWTPanel p1 = new SWTPanel(centerPanel);
        centerPanel.add("South", p1);
        SWTPanel p2 = new SWTPanel(p1, new BorderLayout());
        p1.add(p2);
        SWTPanel buttonsPanel = new SWTPanel(p2, new GridLayout(0, 1, 10, 10));
        p2.add("North", buttonsPanel);
        this.selectButton = new SWTButton((SWTContainer)buttonsPanel, ">");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedItems = SWTSamplePanel.this.leftList.getSelectedValues();
                for (int i = 0; i < selectedItems.length; ++i) {
                    SWTSamplePanel.this.rightListModel.addElement(selectedItems[i]);
                    SWTSamplePanel.this.leftListModel.removeElement(selectedItems[i]);
                    SWTSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.selectButton);
        this.selectAllButton = new SWTButton((SWTContainer)buttonsPanel, ">>");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] items = SWTSamplePanel.this.leftListModel.toArray();
                for (int i = 0; i < items.length; ++i) {
                    SWTSamplePanel.this.rightListModel.addElement(items[i]);
                    SWTSamplePanel.this.leftListModel.removeElement(items[i]);
                    SWTSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.selectAllButton);
        this.deselectButton = new SWTButton((SWTContainer)buttonsPanel, "<");
        this.deselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedItems = SWTSamplePanel.this.rightList.getSelectedValues();
                for (int i = 0; i < selectedItems.length; ++i) {
                    SWTSamplePanel.this.leftListModel.addElement(selectedItems[i]);
                    SWTSamplePanel.this.rightListModel.removeElement(selectedItems[i]);
                    SWTSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.deselectButton);
        this.deselectAllButton = new SWTButton((SWTContainer)buttonsPanel, "<<");
        this.deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] items = SWTSamplePanel.this.rightListModel.toArray();
                for (int i = 0; i < items.length; ++i) {
                    SWTSamplePanel.this.leftListModel.addElement(items[i]);
                    SWTSamplePanel.this.rightListModel.removeElement(items[i]);
                    SWTSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.deselectAllButton);
        SWTPanel rightPanel = new SWTPanel(mainPanel, new BorderLayout(5, 5));
        rightPanel.add("North", new SWTLabel((SWTContainer)rightPanel, "Chosen items:"));
        this.rightList = new SWTList((SWTContainer)rightPanel, this.rightListModel);
        this.rightList.setPreferredSize(new Dimension(100, 150));
        this.rightList.getSelectionModel().addListSelectionListener(this);
        rightPanel.add(this.rightList);
        mainPanel.add("East", rightPanel);
        this.updateButtonsState();
        return mainPanel;
    }

    protected SWTComponent createButtonsPanel(SWTContainer parent) {
        SWTPanel buttonsPanel = new SWTPanel(parent, new BorderLayout());
        buttonsPanel.add("North", new SWTSeparator(buttonsPanel));
        SWTPanel subPanel = new SWTPanel(buttonsPanel, new FlowLayout(4));
        buttonsPanel.add("Center", subPanel);
        SWTButton okButton = new SWTButton((SWTContainer)subPanel, "OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SWTSamplePanel.this.performOK();
            }
        });
        subPanel.add(okButton);
        SWTButton cancelButton = new SWTButton((SWTContainer)subPanel, "Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SWTSamplePanel.this.performCancel();
            }
        });
        subPanel.add(cancelButton);
        return buttonsPanel;
    }

    protected void initContent() {
        for (int i = 0; i < 10; ++i) {
            this.leftListModel.addElement("Item " + (i + 1));
        }
        this.rightListModel.addElement("Item 11");
    }

    protected void performOK() {
        System.out.println("OK performed");
    }

    protected void performCancel() {
        System.out.println("Cancel performed");
    }

    private void updateButtonsState() {
        this.selectButton.setEnabled(!this.leftList.getSelectionModel().isSelectionEmpty());
        this.selectAllButton.setEnabled(!this.leftListModel.isEmpty());
        this.deselectButton.setEnabled(!this.rightList.getSelectionModel().isSelectionEmpty());
        this.deselectAllButton.setEnabled(!this.rightListModel.isEmpty());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.leftList.getSelectionModel() || e.getSource() == this.rightList.getSelectionModel()) {
            this.updateButtonsState();
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        SWTContainer parent = new SWTContainer((Composite)shell);
        new SWTSamplePanel(parent);
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }
}

