/*
 * Decompiled with CFR 0.152.
 */
package Stampa.test;

import Stampa.data.IDataObject;
import Stampa.data.IGenericTable;
import Stampa.test.TreeItemData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeWrapper
implements IGenericTable {
    private Tree _tree;
    private List<IDataObject> _allData;

    public TreeWrapper(Tree tree) {
        this._tree = tree;
        this._allData = new ArrayList<IDataObject>();
    }

    @Override
    public List<IDataObject> getAllItems() {
        if (this._allData.isEmpty()) {
            for (TreeItem ti : this._tree.getItems()) {
                this.addTreeItemAndSubItems(ti);
            }
        }
        return this._allData;
    }

    public void addTreeItemAndSubItems(TreeItem ti) {
        this._allData.add(new TreeItemData(ti));
        for (TreeItem tti : ti.getItems()) {
            this.addTreeItemAndSubItems(tti);
        }
    }

    @Override
    public int getBodyColumnWidth(int colIndex) {
        return this._tree.getColumn(colIndex).getWidth();
    }

    @Override
    public Point[] getCellSelection() {
        ArrayList<Point> ret = new ArrayList<Point>();
        TreeItem[] sel = this._tree.getSelection();
        for (int i = 0; i < sel.length; ++i) {
            int row = this.indexOfTreeItem(sel[i]);
            int col = 0;
            while (col < this.getVisibleColumnOrder().size()) {
                Point p = new Point(0, row);
                p.x = col++;
                ret.add(p);
            }
        }
        Point[] toReturn = new Point[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            toReturn[i] = (Point)ret.get(i);
        }
        return toReturn;
    }

    public int indexOfTreeItem(TreeItem ti) {
        int tInd = 0;
        TreeItem child = ti;
        for (TreeItem parent = ti.getParentItem(); parent != null; parent = parent.getParentItem()) {
            tInd += parent.indexOf(child);
            child = parent;
        }
        return tInd += this._tree.indexOf(child);
    }

    @Override
    public int getCellSelectionCount() {
        return this._tree.getSelectionCount();
    }

    @Override
    public int getColumnCount() {
        return this._tree.getColumnCount();
    }

    @Override
    public List<Integer> getColumnOrder() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int[] nArray = this._tree.getColumnOrder();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer col = nArray[i];
            ret.add(col);
        }
        return ret;
    }

    @Override
    public String getColumnTitle(int colIndex) {
        return this._tree.getColumn(colIndex).getText();
    }

    @Override
    public IDataObject getItem(int row) {
        return this._allData.get(row);
    }

    @Override
    public List<Integer> getVisibleColumnOrder() {
        return this.getColumnOrder();
    }

    @Override
    public int getColumnAlignment(int colIndex) {
        int ret = 4;
        TreeColumn col = this._tree.getColumn(colIndex);
        if (col != null) {
            switch (col.getAlignment()) {
                case 16384: {
                    ret = 1;
                    break;
                }
                case 131072: {
                    ret = 2;
                    break;
                }
                case 0x1000000: {
                    ret = 4;
                    break;
                }
                default: {
                    ret = 4;
                }
            }
        }
        return ret;
    }
}

