/*
 * Decompiled with CFR 0.152.
 */
package Stampa.test;

import Stampa.data.IDataObject;
import Stampa.data.IGenericTable;
import Stampa.test.TableItemData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableWrapper
implements IGenericTable {
    private Table _table;
    private List<IDataObject> _allData;

    public TableWrapper(Table table) {
        this._table = table;
        this._allData = new ArrayList<IDataObject>();
    }

    @Override
    public List<IDataObject> getAllItems() {
        if (this._allData.isEmpty()) {
            for (TableItem ti : this._table.getItems()) {
                this._allData.add(new TableItemData(ti));
            }
        }
        return this._allData;
    }

    @Override
    public int getBodyColumnWidth(int colIndex) {
        return this._table.getColumn(colIndex).getWidth();
    }

    @Override
    public Point[] getCellSelection() {
        ArrayList<Point> ret = new ArrayList<Point>();
        int[] sel = this._table.getSelectionIndices();
        for (int i = 0; i < sel.length; ++i) {
            int row = sel[i];
            int col = 0;
            while (col < this.getVisibleColumnOrder().size()) {
                Point p = new Point(0, row);
                p.x = col++;
                ret.add(p);
            }
        }
        Point[] toReturn = new Point[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            toReturn[i] = (Point)ret.get(i);
        }
        return toReturn;
    }

    @Override
    public int getCellSelectionCount() {
        return this._table.getSelectionCount();
    }

    @Override
    public int getColumnCount() {
        return this._table.getColumnCount();
    }

    @Override
    public List<Integer> getColumnOrder() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int[] nArray = this._table.getColumnOrder();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer col = nArray[i];
            ret.add(col);
        }
        return ret;
    }

    @Override
    public String getColumnTitle(int colIndex) {
        return this._table.getColumn(colIndex).getText();
    }

    @Override
    public IDataObject getItem(int row) {
        return this._allData.get(row);
    }

    @Override
    public List<Integer> getVisibleColumnOrder() {
        return this.getColumnOrder();
    }

    @Override
    public int getColumnAlignment(int colIndex) {
        int ret = 4;
        TableColumn col = this._table.getColumn(colIndex);
        if (col != null) {
            switch (col.getAlignment()) {
                case 16384: {
                    ret = 1;
                    break;
                }
                case 131072: {
                    ret = 2;
                    break;
                }
                case 0x1000000: {
                    ret = 4;
                    break;
                }
                default: {
                    ret = 4;
                }
            }
        }
        return ret;
    }
}

