/*
 * Decompiled with CFR 0.152.
 */
package Stampa.core;

import Stampa.core.IPrintHandler;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Option;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class PrintHeader
implements PageDecoration {
    private String _title;
    private RestoranServer server;
    private IPrintHandler _handler;
    String licenca = "";

    public PrintHeader(IPrintHandler handler, String title, RestoranServer server) {
        this._title = title;
        this._handler = handler;
        this.server = server;
        this.licenca = server.getSetting(Option.HACCP_LICENCE).stringValue();
    }

    public Print createPrint(PageNumber arg0) {
        DefaultGridLook dgl = new DefaultGridLook(0, 3);
        GridPrint gp = new GridPrint("p, C:D:GROW", (GridLook)dgl);
        FontData fd = Display.getDefault().getSystemFont().getFontData()[0];
        fd.height = 10.0f;
        fd.setStyle(1);
        if (this._handler.getActivePrintLogo() != null) {
            String podaci = (this.server.getSetting(Option.OBJEKAT_ADRESA).getActual() != null ? this.server.getSetting(Option.OBJEKAT_ADRESA).getActual() : "Adresa") + ", " + (this.server.getSetting(Option.OBJEKAT_MESTO).getActual() != null ? this.server.getSetting(Option.OBJEKAT_MESTO).getActual() : "Mesto");
            if (this.server.getSetting(Option.HACCP).booleanValue()) {
                gp.add(131072, (Print)new TextPrint("HACCP licenca: " + this.licenca, fd, 0x1000000), -1);
            }
            gp.add(16384, (Print)new TextPrint(this.server.getSetting(Option.PREDUZECE_NAZIV).getActual() != null ? this.server.getSetting(Option.PREDUZECE_NAZIV).getActual() : "Naziv preduze\u0107a", fd, 0x1000000), -1);
            gp.add(16384, (Print)new TextPrint(podaci, fd, 0x1000000), -1);
            gp.add(16384, (Print)new TextPrint("Objekat: " + (this.server.getSetting(Option.OBJEKAT_NAZIV).getActual() != null ? this.server.getSetting(Option.OBJEKAT_NAZIV).getActual() : "Objekat"), fd, 0x1000000), -1);
            gp.add((Print)new TextPrint(""));
            gp.add(0x1000000, (Print)new TextPrint(this._title, fd, 0x1000000), -1);
        }
        return gp;
    }
}

