/*
 * Decompiled with CFR 0.152.
 */
package Stampa.core;

import Stampa.core.CustomLineBorder;
import Stampa.core.IPrintHandler;
import Stampa.core.PrintFooter;
import Stampa.core.PrintHeader;
import Stampa.core.PrintPreviewDialog;
import Stampa.core.PrintResultCode;
import Stampa.data.IDataObject;
import Stampa.data.IGenericTable;
import com.dev63.restoran.RestoranServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.paperclips.core.BigPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.CellBackgroundProvider;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GridPrinter {
    private static final String EXPANDABLE_COLUMN = "d:g";
    private static final String DOT = "...";
    private static final String EMPTY = "";
    private Image _disposeImage;
    private boolean _disposePrintImage = false;
    private RGB _evenRows;
    private RGB _oddRows;
    private RGB _headerBgColor;
    private boolean _printColHeaders;
    private boolean _printVerticalLines;
    private boolean _printHorizontalLines;
    private String _footerText;
    private FontData _headerFontData;
    private FontData _cellFontData;
    private IPrintHandler _printHandler;

    public GridPrinter(IPrintHandler handler) {
        this._printHandler = handler;
        this._printColHeaders = handler.isPrintColumnHeaders();
        this._printVerticalLines = handler.isPrintVerticalLines();
        this._printHorizontalLines = handler.isPrintHorizontalLines();
        this._footerText = handler.getFooterText();
        this._headerFontData = handler.getHeaderFontData();
        this._cellFontData = handler.getCellFontData();
        this._headerBgColor = new RGB(240, 240, 240);
        this._oddRows = new RGB(230, 230, 230);
        this._evenRows = new RGB(255, 255, 255);
    }

    public PrintResultCode printTable(IGenericTable tableImpl, boolean printSelectionOnly, boolean showPreview, String docTitle, Shell parentShell, RestoranServer server) {
        try {
            int columnCount = tableImpl.getColumnCount();
            boolean useFullColumnWidths = false;
            StringBuffer buf = new StringBuffer();
            List<Integer> cols = null;
            ArrayList<Integer> widths = new ArrayList<Integer>();
            HashMap<Integer, Integer> widthMap = new HashMap<Integer, Integer>();
            if (printSelectionOnly) {
                if (tableImpl.getCellSelectionCount() == 0) {
                    return PrintResultCode.ERROR_NO_DATA_TO_PRINT;
                }
                Point[] points = tableImpl.getCellSelection();
                cols = new ArrayList<Integer>();
                for (Point p : points) {
                    if (cols.contains(p.x)) continue;
                    cols.add(p.x);
                }
                columnCount = cols.size();
            } else {
                cols = tableImpl.getVisibleColumnOrder();
                columnCount = cols.size();
            }
            List<Integer> visibleOrder = tableImpl.getColumnOrder();
            ArrayList<Integer> correctOrderedCols = new ArrayList<Integer>();
            for (Integer correct : visibleOrder) {
                if (!cols.contains(correct)) continue;
                correctOrderedCols.add(correct);
            }
            cols = correctOrderedCols;
            for (int i = 0; i < cols.size(); ++i) {
                int column = cols.get(i);
                widths.add(tableImpl.getBodyColumnWidth(column));
                widthMap.put(column, tableImpl.getBodyColumnWidth(column));
                if (useFullColumnWidths) {
                    buf.append(EXPANDABLE_COLUMN);
                } else {
                    int colWidthPix = tableImpl.getBodyColumnWidth(column);
                    float pts = this.convertToPoints(colWidthPix);
                    buf.append("L:");
                    buf.append((int)pts);
                    buf.append(":N");
                }
                if (i == columnCount - 1) continue;
                buf.append(", ");
            }
            GridPrint print = null;
            GC concatGc = new GC((Drawable)parentShell);
            Font headerFont = new Font((Device)Display.getDefault(), this._headerFontData);
            Font cellFont = new Font((Device)Display.getDefault(), this._cellFontData);
            DefaultGridLook look = new DefaultGridLook(0, 0);
            if (this._printHorizontalLines && this._printVerticalLines) {
                LineBorder lb = new LineBorder(new RGB(128, 128, 128));
                lb.setLineWidth(1);
                look.setCellBorder((Border)new LineBorder());
                look.setCellPadding(-1, -1);
                look.setCellSpacing(-1, -1);
            } else if (this._printHorizontalLines) {
                look.setCellBorder((Border)new CustomLineBorder(true));
            } else if (this._printVerticalLines) {
                look.setCellBorder((Border)new CustomLineBorder(false));
            }
            print = new GridPrint(buf.toString(), (GridLook)look);
            look.setHeaderBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int column, int colspan) {
                    return GridPrinter.this._headerBgColor;
                }
            });
            look.setBodyBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int col, int colspan) {
                    return row % 2 == 0 ? GridPrinter.this._evenRows : GridPrinter.this._oddRows;
                }
            });
            if (printSelectionOnly) {
                Object toUse;
                Point[] points = tableImpl.getCellSelection();
                if (this._printColHeaders) {
                    for (int i = 0; i < cols.size(); ++i) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i)), (Integer)widths.get(i), concatGc, headerFont);
                        print.addHeader(align, (Print)new TextPrint(name, this._headerFontData, align));
                    }
                }
                HashMap<Integer, Object> selMap = new HashMap<Integer, Object>();
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    boolean newEntry = !selMap.containsKey(p.y);
                    Object object = toUse = newEntry ? new ArrayList() : (List)selMap.get(p.y);
                    if (!toUse.contains(p.x)) {
                        toUse.add(p.x);
                    }
                    selMap.put(p.y, toUse);
                }
                ArrayList<Integer> printedRows = new ArrayList<Integer>();
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    if (printedRows.contains(p.y)) continue;
                    toUse = cols.iterator();
                    while (toUse.hasNext()) {
                        int col = (Integer)toUse.next();
                        List selColsForRow = (List)selMap.get(p.y);
                        if (!selColsForRow.contains(col)) {
                            print.add((Print)this.tp(" "));
                            continue;
                        }
                        IDataObject gi = tableImpl.getItem(p.y);
                        String value = this.concat(gi.getColumnText(col), (Integer)widthMap.get(col), concatGc, cellFont);
                        Image image = gi.getColumnImage(col);
                        if (image != null) {
                            print.add((Print)new ImagePrint(image.getImageData(), Display.getDefault().getDPI()));
                            continue;
                        }
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(col));
                        print.add(align, (Print)this.tp(value, this._cellFontData, align));
                    }
                    printedRows.add(p.y);
                }
            } else {
                int i;
                List<IDataObject> all = tableImpl.getAllItems();
                IDataObject[] sel = new IDataObject[all.size()];
                sel = new IDataObject[all.size()];
                for (i = 0; i < all.size(); ++i) {
                    sel[i] = all.get(i);
                }
                if (this._printColHeaders) {
                    for (i = 0; i < cols.size(); ++i) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i)), (Integer)widths.get(i), concatGc, headerFont);
                        print.addHeader(align, (Print)new TextPrint(name, this._headerFontData, align));
                    }
                }
                for (IDataObject gi : sel) {
                    for (int i2 = 0; i2 < cols.size(); ++i2) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i2)));
                        String colText = gi.getColumnText(cols.get(i2));
                        if (colText == null) {
                            colText = EMPTY;
                        }
                        String text = this.concat(colText, (Integer)widths.get(i2), concatGc, cellFont);
                        print.add(align, (Print)this.tp(text, this._cellFontData, align));
                    }
                }
            }
            concatGc.dispose();
            headerFont.dispose();
            cellFont.dispose();
            BigPrint big = new BigPrint((Print)print);
            PagePrint pp = new PagePrint((PageDecoration)new PrintHeader(this._printHandler, docTitle, server), (Print)big, (PageDecoration)new PrintFooter(this.getFooterText()));
            pp.setHeaderGap(4);
            pp.setFooterGap(10);
            if (showPreview) {
                PrintPreviewDialog ppd = new PrintPreviewDialog((Print)pp, parentShell, this._printHandler);
                ppd.open();
            } else {
                PrintDialog dialog = new PrintDialog(parentShell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)new PrintJob("Printing", (Print)pp).setMargins(36), (PrinterData)printerData);
                }
            }
            if (this._disposePrintImage) {
                this._disposeImage.dispose();
            }
            return PrintResultCode.SUCCESS;
        }
        catch (Exception err) {
            err.printStackTrace();
            return PrintResultCode.ERROR_PRINTING;
        }
    }

    public PrintResultCode printTable(IGenericTable tableImpl, boolean printSelectionOnly, boolean showPreview, String docTitle, Shell parentShell, int fontSize, RestoranServer server) {
        try {
            this._cellFontData.height = fontSize;
            int columnCount = tableImpl.getColumnCount();
            boolean useFullColumnWidths = false;
            StringBuffer buf = new StringBuffer();
            List<Integer> cols = null;
            ArrayList<Integer> widths = new ArrayList<Integer>();
            HashMap<Integer, Integer> widthMap = new HashMap<Integer, Integer>();
            if (printSelectionOnly) {
                if (tableImpl.getCellSelectionCount() == 0) {
                    return PrintResultCode.ERROR_NO_DATA_TO_PRINT;
                }
                Point[] points = tableImpl.getCellSelection();
                cols = new ArrayList<Integer>();
                for (Point p : points) {
                    if (cols.contains(p.x)) continue;
                    cols.add(p.x);
                }
                columnCount = cols.size();
            } else {
                cols = tableImpl.getVisibleColumnOrder();
                columnCount = cols.size();
            }
            List<Integer> visibleOrder = tableImpl.getColumnOrder();
            ArrayList<Integer> correctOrderedCols = new ArrayList<Integer>();
            for (Integer correct : visibleOrder) {
                if (!cols.contains(correct)) continue;
                correctOrderedCols.add(correct);
            }
            cols = correctOrderedCols;
            for (int i = 0; i < cols.size(); ++i) {
                int column = cols.get(i);
                widths.add(tableImpl.getBodyColumnWidth(column));
                widthMap.put(column, tableImpl.getBodyColumnWidth(column));
                if (useFullColumnWidths) {
                    buf.append(EXPANDABLE_COLUMN);
                } else {
                    int colWidthPix = tableImpl.getBodyColumnWidth(column);
                    float pts = this.convertToPoints(colWidthPix);
                    buf.append("L:");
                    buf.append((int)pts);
                    buf.append(":N");
                }
                if (i == columnCount - 1) continue;
                buf.append(", ");
            }
            GridPrint print = null;
            GC concatGc = new GC((Drawable)parentShell);
            Font headerFont = new Font((Device)Display.getDefault(), this._headerFontData);
            Font cellFont = new Font((Device)Display.getDefault(), this._cellFontData);
            DefaultGridLook look = new DefaultGridLook(0, 0);
            if (this._printHorizontalLines && this._printVerticalLines) {
                LineBorder lb = new LineBorder(new RGB(128, 128, 128));
                lb.setLineWidth(1);
                look.setCellBorder((Border)new LineBorder());
                look.setCellPadding(-1, -1);
                look.setCellSpacing(-1, -1);
            } else if (this._printHorizontalLines) {
                look.setCellBorder((Border)new CustomLineBorder(true));
            } else if (this._printVerticalLines) {
                look.setCellBorder((Border)new CustomLineBorder(false));
            }
            print = new GridPrint(buf.toString(), (GridLook)look);
            look.setHeaderBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int column, int colspan) {
                    return GridPrinter.this._headerBgColor;
                }
            });
            look.setBodyBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int col, int colspan) {
                    return row % 2 == 0 ? GridPrinter.this._evenRows : GridPrinter.this._oddRows;
                }
            });
            if (printSelectionOnly) {
                Object toUse;
                Point[] points = tableImpl.getCellSelection();
                if (this._printColHeaders) {
                    for (int i = 0; i < cols.size(); ++i) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i)), (Integer)widths.get(i), concatGc, headerFont);
                        print.addHeader(align, (Print)new TextPrint(name, this._headerFontData, align));
                    }
                }
                HashMap<Integer, Object> selMap = new HashMap<Integer, Object>();
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    boolean newEntry = !selMap.containsKey(p.y);
                    Object object = toUse = newEntry ? new ArrayList() : (List)selMap.get(p.y);
                    if (!toUse.contains(p.x)) {
                        toUse.add(p.x);
                    }
                    selMap.put(p.y, toUse);
                }
                ArrayList<Integer> printedRows = new ArrayList<Integer>();
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    if (printedRows.contains(p.y)) continue;
                    toUse = cols.iterator();
                    while (toUse.hasNext()) {
                        int col = (Integer)toUse.next();
                        List selColsForRow = (List)selMap.get(p.y);
                        if (!selColsForRow.contains(col)) {
                            print.add((Print)this.tp(" "));
                            continue;
                        }
                        IDataObject gi = tableImpl.getItem(p.y);
                        String value = this.concat(gi.getColumnText(col), (Integer)widthMap.get(col), concatGc, cellFont);
                        Image image = gi.getColumnImage(col);
                        if (image != null) {
                            print.add((Print)new ImagePrint(image.getImageData(), Display.getDefault().getDPI()));
                            continue;
                        }
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(col));
                        print.add(align, (Print)this.tp(value, this._cellFontData, align));
                    }
                    printedRows.add(p.y);
                }
            } else {
                int i;
                List<IDataObject> all = tableImpl.getAllItems();
                IDataObject[] sel = new IDataObject[all.size()];
                sel = new IDataObject[all.size()];
                for (i = 0; i < all.size(); ++i) {
                    sel[i] = all.get(i);
                }
                if (this._printColHeaders) {
                    for (i = 0; i < cols.size(); ++i) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i)), (Integer)widths.get(i), concatGc, headerFont);
                        print.addHeader(align, (Print)new TextPrint(name, this._headerFontData, align));
                    }
                }
                for (IDataObject gi : sel) {
                    for (int i2 = 0; i2 < cols.size(); ++i2) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i2)));
                        String colText = gi.getColumnText(cols.get(i2));
                        if (colText == null) {
                            colText = EMPTY;
                        }
                        String text = this.concat(colText, (Integer)widths.get(i2), concatGc, cellFont);
                        print.add(align, (Print)this.tp(text, this._cellFontData, align));
                    }
                }
            }
            concatGc.dispose();
            headerFont.dispose();
            cellFont.dispose();
            BigPrint big = new BigPrint((Print)print);
            PagePrint pp = new PagePrint((PageDecoration)new PrintHeader(this._printHandler, docTitle, server), (Print)big, (PageDecoration)new PrintFooter(this.getFooterText()));
            pp.setHeaderGap(9);
            pp.setFooterGap(18);
            if (showPreview) {
                PrintPreviewDialog ppd = new PrintPreviewDialog((Print)pp, parentShell, this._printHandler);
                ppd.open();
            } else {
                PrintDialog dialog = new PrintDialog(parentShell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)new PrintJob("Printing", (Print)pp).setMargins(36), (PrinterData)printerData);
                }
            }
            if (this._disposePrintImage) {
                this._disposeImage.dispose();
            }
            return PrintResultCode.SUCCESS;
        }
        catch (Exception err) {
            err.printStackTrace();
            return PrintResultCode.ERROR_PRINTING;
        }
    }

    public PrintResultCode printTree(IGenericTable tableImpl, boolean printSelectionOnly, boolean showPreview, String docTitle, Shell parentShell, RestoranServer server) {
        try {
            int columnCount = tableImpl.getColumnCount();
            boolean useFullColumnWidths = false;
            StringBuffer buf = new StringBuffer();
            List<Integer> cols = null;
            ArrayList<Integer> widths = new ArrayList<Integer>();
            HashMap<Integer, Integer> widthMap = new HashMap<Integer, Integer>();
            if (printSelectionOnly) {
                if (tableImpl.getCellSelectionCount() == 0) {
                    return PrintResultCode.ERROR_NO_DATA_TO_PRINT;
                }
                Point[] points = tableImpl.getCellSelection();
                cols = new ArrayList<Integer>();
                for (Point p : points) {
                    if (cols.contains(p.x)) continue;
                    cols.add(p.x);
                }
                columnCount = cols.size();
            } else {
                cols = tableImpl.getVisibleColumnOrder();
                columnCount = cols.size();
            }
            List<Integer> visibleOrder = tableImpl.getColumnOrder();
            ArrayList<Integer> correctOrderedCols = new ArrayList<Integer>();
            for (Integer correct : visibleOrder) {
                if (!cols.contains(correct)) continue;
                correctOrderedCols.add(correct);
            }
            cols = correctOrderedCols;
            for (int i = 0; i < cols.size(); ++i) {
                int column = cols.get(i);
                widths.add(tableImpl.getBodyColumnWidth(column));
                widthMap.put(column, tableImpl.getBodyColumnWidth(column));
                if (useFullColumnWidths) {
                    buf.append(EXPANDABLE_COLUMN);
                } else {
                    int colWidthPix = tableImpl.getBodyColumnWidth(column);
                    float pts = this.convertToPoints(colWidthPix);
                    buf.append("L:");
                    buf.append((int)pts);
                    buf.append(":N");
                }
                if (i == columnCount - 1) continue;
                buf.append(", ");
            }
            GridPrint print = null;
            GC concatGc = new GC((Drawable)parentShell);
            Font headerFont = new Font((Device)Display.getDefault(), this._headerFontData);
            Font cellFont = new Font((Device)Display.getDefault(), this._cellFontData);
            DefaultGridLook look = new DefaultGridLook(0, 0);
            if (this._printHorizontalLines && this._printVerticalLines) {
                LineBorder lb = new LineBorder(new RGB(128, 128, 128));
                lb.setLineWidth(1);
                look.setCellBorder((Border)new LineBorder());
            } else if (this._printHorizontalLines) {
                look.setCellBorder((Border)new CustomLineBorder(true));
            } else if (this._printVerticalLines) {
                look.setCellBorder((Border)new CustomLineBorder(false));
            }
            print = new GridPrint(buf.toString(), (GridLook)look);
            look.setHeaderBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int column, int colspan) {
                    return GridPrinter.this._headerBgColor;
                }
            });
            look.setBodyBackgroundProvider(new CellBackgroundProvider(){

                public RGB getCellBackground(int row, int col, int colspan) {
                    return row % 2 == 0 ? GridPrinter.this._evenRows : GridPrinter.this._oddRows;
                }
            });
            if (printSelectionOnly) {
                Object toUse;
                Point[] points = tableImpl.getCellSelection();
                if (this._printColHeaders) {
                    for (int i = 0; i < cols.size(); ++i) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i)), (Integer)widths.get(i), concatGc, headerFont);
                        print.addHeader(align, (Print)new TextPrint(name, this._headerFontData, align));
                    }
                }
                HashMap<Integer, Object> selMap = new HashMap<Integer, Object>();
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    boolean newEntry = !selMap.containsKey(p.y);
                    Object object = toUse = newEntry ? new ArrayList() : (List)selMap.get(p.y);
                    if (!toUse.contains(p.x)) {
                        toUse.add(p.x);
                    }
                    selMap.put(p.y, toUse);
                }
                ArrayList<Integer> printedRows = new ArrayList<Integer>();
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    if (printedRows.contains(p.y)) continue;
                    toUse = cols.iterator();
                    while (toUse.hasNext()) {
                        int col = (Integer)toUse.next();
                        List selColsForRow = (List)selMap.get(p.y);
                        if (!selColsForRow.contains(col)) {
                            print.add((Print)this.tp(" "));
                            continue;
                        }
                        IDataObject gi = tableImpl.getItem(p.y);
                        String value = this.concat(gi.getColumnText(col), (Integer)widthMap.get(col), concatGc, cellFont);
                        Image image = gi.getColumnImage(col);
                        if (image != null) {
                            print.add((Print)new ImagePrint(image.getImageData(), Display.getDefault().getDPI()));
                            continue;
                        }
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        print.add(align, (Print)this.tp(value, this._cellFontData, align));
                    }
                    printedRows.add(p.y);
                }
            } else {
                int i;
                List<IDataObject> all = tableImpl.getAllItems();
                IDataObject[] sel = new IDataObject[all.size()];
                sel = new IDataObject[all.size()];
                for (i = 0; i < all.size(); ++i) {
                    sel[i] = all.get(i);
                }
                if (this._printColHeaders) {
                    for (i = 0; i < cols.size(); ++i) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i)));
                        String name = this.concat(tableImpl.getColumnTitle(cols.get(i)), (Integer)widths.get(i), concatGc, headerFont);
                        print.addHeader(align, (Print)new TextPrint(name, this._headerFontData, align));
                    }
                }
                for (IDataObject gi : sel) {
                    for (int i2 = 0; i2 < cols.size(); ++i2) {
                        int align = this.getSWTColAlign(tableImpl.getColumnAlignment(cols.get(i2)));
                        String colText = gi.getColumnText(cols.get(i2));
                        if (colText == null) {
                            colText = EMPTY;
                        }
                        String text = this.concat(colText, (Integer)widths.get(i2), concatGc, cellFont);
                        print.add(align, (Print)this.tp(text, this._cellFontData, align));
                    }
                }
            }
            concatGc.dispose();
            headerFont.dispose();
            cellFont.dispose();
            BigPrint big = new BigPrint((Print)print);
            PagePrint pp = new PagePrint((PageDecoration)new PrintHeader(this._printHandler, docTitle, server), (Print)big, (PageDecoration)new PrintFooter(this.getFooterText()));
            pp.setHeaderGap(9);
            pp.setFooterGap(18);
            if (showPreview) {
                PrintPreviewDialog ppd = new PrintPreviewDialog((Print)pp, parentShell, this._printHandler);
                ppd.open();
            } else {
                PrintDialog dialog = new PrintDialog(parentShell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)new PrintJob("Printing", (Print)pp).setMargins(36), (PrinterData)printerData);
                }
            }
            if (this._disposePrintImage) {
                this._disposeImage.dispose();
            }
            return PrintResultCode.SUCCESS;
        }
        catch (Exception err) {
            err.printStackTrace();
            return PrintResultCode.ERROR_PRINTING;
        }
    }

    private String concat(String str, int pixWidth, GC gc, Font f) {
        if (str == null || str.length() == 0) {
            return str;
        }
        gc.setFont(f);
        Point size = gc.stringExtent(str);
        if (size.x <= pixWidth) {
            return str;
        }
        String ret = this.getAvailableTextToDisplay(gc, new Rectangle(0, 0, pixWidth, 20), str);
        return ret;
    }

    private String getAvailableTextToDisplay(GC gc, Rectangle rectangle, String text) {
        int width = gc.textExtent((String)text).x;
        boolean displayDot = width > rectangle.width;
        String ret = null;
        try {
            if (displayDot) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(text));
                StringBuffer output = new StringBuffer();
                String line = EMPTY;
                while ((line = bufferedReader.readLine()) != null) {
                    width = gc.textExtent((String)line).x;
                    if (width > rectangle.width) {
                        int textLen = line.length();
                        for (int i = textLen - 1; i >= 0; --i) {
                            String temp = line.substring(0, i) + DOT;
                            width = gc.textExtent((String)temp).x;
                            if (width < rectangle.width) {
                                line = temp;
                                break;
                            }
                            if (i != 0) continue;
                            line = EMPTY;
                        }
                    }
                    output.append(line);
                    output.append('\n');
                }
                ret = output.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private int convertToPoints(int pixels) {
        return 72 * pixels / Display.getDefault().getDPI().x;
    }

    private TextPrint tp(String str) {
        return new TextPrint(str == null ? EMPTY : (str.equals(EMPTY) ? EMPTY : str));
    }

    private TextPrint tp(String str, FontData fd) {
        return new TextPrint(str == null ? EMPTY : (str.equals(EMPTY) ? EMPTY : str), fd);
    }

    private TextPrint tp(String str, FontData fd, int align) {
        return new TextPrint(str == null ? EMPTY : (str.equals(EMPTY) ? EMPTY : str), fd, align);
    }

    public String getFooterText() {
        return this._footerText;
    }

    private int getSWTColAlign(int colAlign) {
        switch (colAlign) {
            case 1: {
                return 16384;
            }
            case 2: {
                return 131072;
            }
            case 4: {
                return 0x1000000;
            }
        }
        return 0x1000000;
    }
}

