/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.api.model.TaxRateCategoryType;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class JsonUtil {
    public static final String JSON_FORMAT_LOCAL_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String JSON_FORMAT_ZONED_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final JsonDeserializer GSON_LOCAL_DT_DESER = new JsonDeserializer<LocalDateTime>(){

        public LocalDateTime deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return LocalDateTime.parse(json.getAsJsonPrimitive().getAsString());
        }
    };
    public static final JsonDeserializer GSON_ZONED_DT_DESER = new JsonDeserializer<ZonedDateTime>(){

        public ZonedDateTime deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return ZonedDateTime.parse(json.getAsJsonPrimitive().getAsString());
        }
    };
    public static final JsonDeserializer TAX_CATEGORY_TYPE_DESER = new JsonDeserializer<TaxRateCategoryType>(){

        public TaxRateCategoryType deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return TaxRateCategoryType.getByValue(json.getAsJsonPrimitive().getAsInt());
        }
    };
    public static final JsonSerializer GSON_ZONED_DT_SER = new JsonSerializer<ZonedDateTime>(){

        public JsonElement serialize(ZonedDateTime date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(DateTimeFormatter.ofPattern(JsonUtil.JSON_FORMAT_ZONED_DATE_TIME)));
        }
    };
    public static final GsonBuilder gsonBuilderWithLocalDtDeser = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)GSON_LOCAL_DT_DESER);
    public static final GsonBuilder gsonBuilderWithZonedDtDeser = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)GSON_ZONED_DT_DESER).registerTypeAdapter(TaxRateCategoryType.class, (Object)TAX_CATEGORY_TYPE_DESER);
    public static final GsonBuilder gsonBuilderWithZonedDtSer = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)GSON_ZONED_DT_SER);
}

