/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.api.model.AuditPackage;
import com.dmi.sdccore.api.model.TaxCoreApiToken;
import com.dmi.sdccore.api.model.TaxCoreConfiguration;
import com.dmi.sdccore.api.model.TaxRateGroup;
import com.dmi.sdccore.api.model.invoice.LatestInvoice;
import com.dmi.sdccore.utils.JsonUtil;
import com.dmi.sdccore.utils.StringUtil;
import com.dmi.sdccore.utils.SystemDrives;
import com.dmi.sdccore.utils.helpers.ComparableFilePair;
import com.dmi.sdccore.utils.helpers.FileDrive;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FsUtil {
    private static final Logger logger = LogManager.getLogger(FsUtil.class);
    private static final String STORAGE_RELATIVE_PATH = "../fs";
    public static final String DIR_PARAMS = "../fs" + File.separator + "params";
    public static final String DIR_PARAMS_CONFIG = DIR_PARAMS + File.separator + "config";
    public static final String FN_TC_TAX_GROUPS = "tc_tax_groups";
    public static final String FN_TC_ENVIRONMENT = "tc_environment";
    public static final String FN_TC_VERIFICATION_URL = "tc_verification_url";
    public static final String FN_NTP_SERVER_URL = "ntp_server_url";
    public static final String FN_TC_API_TOKEN = "tc_api_token";
    public static final String FN_LAST_REMOTE_AUDIT_TIME = DIR_PARAMS + File.separator + "last_remote_audit_time";
    public static final String FN_LAST_INVOICE_NUMBER = DIR_PARAMS + File.separator + "last_invoice_number";
    public static final String FN_LATEST_INVOICE = DIR_PARAMS + File.separator + "latest_invoice";
    public static final String FN_LOCAL_AUDIT_LATEST_INVOICE = DIR_PARAMS + File.separator + "localAuditLatestInvoice";
    public static final String FN_REMOTE_AUDIT_LATEST_INVOICE = DIR_PARAMS + File.separator + "remoteAuditLatestInvoice";
    public static final String FN_LAST_SDC_TIMESTAMP = DIR_PARAMS + File.separator + "last_sdc_timestamp";
    public static final String DIR_AUDIT = "../fs" + File.separator + "audit";
    public static final String DIR_NAME_AUDIT_BACKUP = "backup";

    public static void createLocalFileStorage() {
        FsUtil.createDir(STORAGE_RELATIVE_PATH);
    }

    public static void createAuditDirectory() {
        FsUtil.createDir(DIR_AUDIT);
    }

    public static void createDir(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            directory.mkdir();
        }
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static void deleteFile(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("deleting SDC directories is forbidden");
        }
        FileUtils.deleteQuietly((File)file);
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        FsUtil.deleteFile(file);
    }

    public static void deleteFiles(File[] files) {
        for (File file : files) {
            FsUtil.deleteFile(file);
        }
    }

    public static void writeFile(String path, byte[] data) throws IOException {
        File file = new File(path);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
    }

    public static void writeFile(String path, String data) throws IOException {
        File file = new File(path);
        FileUtils.writeStringToFile((File)file, (String)data, (Charset)StandardCharsets.UTF_8);
    }

    public static String readFileToString(String path) throws IOException {
        if (!FsUtil.fileExists(path)) {
            return null;
        }
        File file = new File(path);
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public static byte[] readFileToByteArray(String path) throws IOException {
        if (!FsUtil.fileExists(path)) {
            return null;
        }
        File file = new File(path);
        return FileUtils.readFileToByteArray((File)file);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        return FileUtils.readFileToByteArray((File)file);
    }

    public static void moveFile(File file, File destinationDirectory) throws IOException {
        FileUtils.moveFileToDirectory((File)file, (File)destinationDirectory, (boolean)true);
    }

    public static void copyFile(File file, File destinationDirectory) throws IOException {
        FileUtils.copyFileToDirectory((File)file, (File)destinationDirectory, (boolean)true);
    }

    public static void backUpAuditPackage(File auditPackageFile, String taxCardUid) throws IOException {
        String auditBackUpDirPath = DIR_AUDIT + File.separator + taxCardUid + "-" + DIR_NAME_AUDIT_BACKUP;
        File backupDir = new File(auditBackUpDirPath);
        FileUtils.moveFileToDirectory((File)auditPackageFile, (File)backupDir, (boolean)true);
    }

    public static boolean isTaxCoreConfigurationOnFs(String cardSerial) {
        return FsUtil.fileConfigExists(cardSerial, FN_TC_TAX_GROUPS) && FsUtil.fileConfigExists(cardSerial, FN_TC_ENVIRONMENT) && FsUtil.fileConfigExists(cardSerial, FN_TC_VERIFICATION_URL) && FsUtil.fileConfigExists(cardSerial, FN_NTP_SERVER_URL);
    }

    public static boolean initializeSdcFromFs(AppState appState) throws IOException {
        String cardSerial = appState.getTaxCardCertificate().getSubject().getSerialNumber();
        if (FsUtil.isTaxCoreConfigurationOnFs(cardSerial)) {
            appState.setAllTaxRateGroups(FsUtil.readTaxCoreAllTaxGroupsFromFs(cardSerial));
            appState.setTaxCoreConfiguration(FsUtil.readTaxCoreEnvironmentFromFs(cardSerial));
            appState.setTaxCoreVerificationUrl(FsUtil.readTaxCoreVerificationUrlFromFs(cardSerial));
            appState.setNtpServerUrl(FsUtil.readTaxCoreNtpServerUrlFromFs(cardSerial));
            return true;
        }
        return false;
    }

    public static List<TaxRateGroup> readTaxCoreAllTaxGroupsFromFs(String cardSerial) throws IOException {
        if (!FsUtil.fileConfigExists(cardSerial, FN_TC_TAX_GROUPS)) {
            return null;
        }
        String allTaxRatesJson = FsUtil.readConfigFileToString(cardSerial, FN_TC_TAX_GROUPS);
        return (List)JsonUtil.gsonBuilderWithZonedDtDeser.create().fromJson(allTaxRatesJson, new TypeToken<List<TaxRateGroup>>(){}.getType());
    }

    public static TaxCoreConfiguration readTaxCoreEnvironmentFromFs(String cardSerial) throws IOException {
        if (!FsUtil.fileConfigExists(cardSerial, FN_TC_ENVIRONMENT)) {
            return null;
        }
        String taxCoreConfigJson = FsUtil.readConfigFileToString(cardSerial, FN_TC_ENVIRONMENT);
        return (TaxCoreConfiguration)new Gson().fromJson(taxCoreConfigJson, TaxCoreConfiguration.class);
    }

    public static String readTaxCoreVerificationUrlFromFs(String cardSerial) throws IOException {
        if (!FsUtil.fileConfigExists(cardSerial, FN_TC_VERIFICATION_URL)) {
            return null;
        }
        return FsUtil.readConfigFileToString(cardSerial, FN_TC_VERIFICATION_URL);
    }

    public static String readTaxCoreNtpServerUrlFromFs(String cardSerial) throws IOException {
        if (!FsUtil.fileConfigExists(cardSerial, FN_NTP_SERVER_URL)) {
            return null;
        }
        return FsUtil.readConfigFileToString(cardSerial, FN_NTP_SERVER_URL);
    }

    public static TaxCoreApiToken readTaxCoreApiTokenFromFs(String cardSerial) throws IOException {
        if (!FsUtil.fileConfigExists(cardSerial, FN_TC_API_TOKEN)) {
            return null;
        }
        String apiTokenJson = FsUtil.readConfigFileToString(cardSerial, FN_TC_API_TOKEN);
        return (TaxCoreApiToken)JsonUtil.gsonBuilderWithLocalDtDeser.create().fromJson(apiTokenJson, TaxCoreApiToken.class);
    }

    public static String readLastInvoiceNumberFromFs() throws IOException {
        if (!FsUtil.fileExists(FN_LAST_INVOICE_NUMBER)) {
            return null;
        }
        return FsUtil.readFileToString(FN_LAST_INVOICE_NUMBER);
    }

    public static String readLastInvoiceNumberFromFs(String cardSerialUid) throws IOException {
        String fileName = FN_LAST_INVOICE_NUMBER + "_" + cardSerialUid;
        if (!FsUtil.fileExists(fileName)) {
            return null;
        }
        return FsUtil.readFileToString(fileName);
    }

    public static long readLastRemoteAuditTimeFromFs() throws IOException {
        if (!FsUtil.fileExists(FN_LAST_REMOTE_AUDIT_TIME)) {
            return 0L;
        }
        String lastRemoteAuditTime = FsUtil.readFileToString(FN_LAST_REMOTE_AUDIT_TIME);
        if (lastRemoteAuditTime == null) {
            return 0L;
        }
        try {
            return Long.parseLong(lastRemoteAuditTime);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long readLastSdcTimestampFromFs() throws IOException {
        if (!FsUtil.fileExists(FN_LAST_SDC_TIMESTAMP)) {
            return ZonedDateTime.now().toEpochSecond();
        }
        String lastSdcTimestamp = FsUtil.readFileToString(FN_LAST_SDC_TIMESTAMP);
        if (lastSdcTimestamp == null) {
            return ZonedDateTime.now().toEpochSecond();
        }
        try {
            return Long.parseLong(lastSdcTimestamp);
        }
        catch (Exception exception) {
            return ZonedDateTime.now().toEpochSecond();
        }
    }

    public static void saveAuditPackage(AuditPackage auditPackage, String taxCardUid, long ordinalNumber) throws IOException {
        String auditPackageJson = new GsonBuilder().setPrettyPrinting().create().toJson((Object)auditPackage);
        FsUtil.saveAuditPackage(auditPackageJson, taxCardUid, ordinalNumber);
    }

    public static void saveAuditPackage(String auditPackageJson, String taxCardUid, long ordinalNumber) throws IOException {
        String auditDirPath = DIR_AUDIT + File.separator + taxCardUid;
        FsUtil.createDir(auditDirPath);
        String fileName = auditDirPath + File.separator + String.format("%s-%s-%d.json", taxCardUid, taxCardUid, ordinalNumber);
        FsUtil.writeFile(fileName, auditPackageJson);
    }

    public static void saveLastInvoiceNumber(String cardSerialUid, String invoiceNumber) throws IOException {
        String fileName = FN_LAST_INVOICE_NUMBER + "_" + cardSerialUid;
        FsUtil.writeFile(fileName, invoiceNumber);
        FsUtil.writeFile(FN_LAST_INVOICE_NUMBER, invoiceNumber);
    }

    public static void saveLatestInvoice(LatestInvoice latestInvoice) throws IOException {
        String fileName = FN_LATEST_INVOICE + "_" + latestInvoice.getCardSerialUid();
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)latestInvoice);
        FsUtil.writeFile(fileName, json);
    }

    public static LatestInvoice getLatestInvoice(String requestId, String cardSerialUid) throws IOException {
        String fileName = FN_LATEST_INVOICE + "_" + cardSerialUid;
        if (!FsUtil.fileExists(fileName)) {
            return null;
        }
        String json = FsUtil.readFileToString(fileName);
        LatestInvoice latestInvoice = (LatestInvoice)JsonUtil.gsonBuilderWithZonedDtDeser.create().fromJson(json, LatestInvoice.class);
        if (requestId.equals(latestInvoice.getRequestId())) {
            return latestInvoice;
        }
        return null;
    }

    public static File[] getFilesFromDirSortedByLastModified(String dirPath) {
        File directory = new File(dirPath);
        File[] files = directory.listFiles();
        if (files != null) {
            int i;
            Object[] pairs = new ComparableFilePair[files.length];
            for (i = 0; i < files.length; ++i) {
                pairs[i] = new ComparableFilePair(files[i]);
            }
            Arrays.sort(pairs);
            for (i = 0; i < files.length; ++i) {
                files[i] = ((ComparableFilePair)pairs[i]).f;
            }
        }
        return files;
    }

    public static File[] getAuditPackagesForSubmittingByUid(String uid) {
        String dirPath = DIR_AUDIT + File.separator + uid;
        return FsUtil.getFilesFromDirSortedByLastModified(dirPath);
    }

    public static File[] getCandidateAuditPackagesForDeletingByUid(String uid) {
        String dirPath = DIR_AUDIT + File.separator + uid + "-" + DIR_NAME_AUDIT_BACKUP;
        return FsUtil.getFilesFromDirSortedByLastModified(dirPath);
    }

    public static List<File> getExistingAuditPackageDirectories() {
        File directory = new File(DIR_AUDIT);
        ArrayList<File> auditPackageDirectories = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.getName().length() != 8) continue;
                auditPackageDirectories.add(file);
            }
        }
        return auditPackageDirectories;
    }

    public static List<FileDrive> getAvailableDrives(boolean removableOnly) {
        return SystemDrives.getAvailableDrives(removableOnly);
    }

    public static boolean isExternalDiskPresent() {
        return SystemDrives.isRemovableDrivePresent();
    }

    public static void zipFolder(String folderAbsolutePath, String zipFileFullPath) throws Exception {
        FileOutputStream fos = new FileOutputStream(zipFileFullPath);
        ZipOutputStream zos = new ZipOutputStream(fos);
        FsUtil.addDirToZipArchive(zos, new File(folderAbsolutePath), null);
        zos.flush();
        fos.flush();
        zos.close();
        fos.close();
    }

    public static void addDirToZipArchive(ZipOutputStream zos, File fileToZip, String parentDirectoryName) throws Exception {
        if (fileToZip == null || !fileToZip.exists()) {
            return;
        }
        String zipEntryName = fileToZip.getName();
        if (parentDirectoryName != null && !parentDirectoryName.isEmpty()) {
            zipEntryName = parentDirectoryName + File.separator + fileToZip.getName();
        }
        if (fileToZip.isDirectory()) {
            for (File file : fileToZip.listFiles()) {
                FsUtil.addDirToZipArchive(zos, file, zipEntryName);
            }
        } else {
            int length;
            byte[] buffer = new byte[8192];
            FileInputStream fis = new FileInputStream(fileToZip);
            zos.putNextEntry(new ZipEntry(zipEntryName));
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
            zos.closeEntry();
            fis.close();
        }
    }

    public static String getLastInvoiceNumber(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        return files[files.length - 1].getName();
    }

    public static List<File> getInvoicesCompareByCounterNotGreater(File[] inputFiles, String referenceFileName) {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (File file : inputFiles) {
            Long counter = FsUtil.getTotalCounterFromInvoiceNumber(file.getName());
            Long referenceCounter = FsUtil.getTotalCounterFromInvoiceNumber(referenceFileName);
            if (counter == null || referenceCounter == null || counter > referenceCounter) continue;
            outputFiles.add(file);
        }
        return outputFiles;
    }

    public static Long getTotalCounterFromInvoiceNumber(String invoiceNumber) {
        String[] fields = invoiceNumber.split("\\.");
        if (fields.length == 2) {
            for (String string : fields = fields[0].split("-")) {
            }
            if (fields.length == 3 && StringUtil.isNumeric(fields[2])) {
                return Long.parseLong(fields[2]);
            }
        }
        return null;
    }

    public static void backUpAuditPackagesAfterSuccessfulLocalAudit(String cardSerialNumber) throws Exception {
        File[] availableAuditPackages = FsUtil.getAuditPackagesForSubmittingByUid(cardSerialNumber);
        if (availableAuditPackages != null && availableAuditPackages.length > 0) {
            List<File> filesToBackup = FsUtil.getInvoicesCompareByCounterNotGreater(availableAuditPackages, FsUtil.readFileToString(FN_LOCAL_AUDIT_LATEST_INVOICE + "_" + cardSerialNumber));
            for (File file : filesToBackup) {
                try {
                    FsUtil.backUpAuditPackage(file, cardSerialNumber);
                }
                catch (Exception exc) {
                    logger.error("Back up audit file error", (Throwable)exc);
                }
            }
        }
    }

    public static void deleteAuditPackagesAfterSuccessfulRemoteAudit(String cardSerialNumber) throws Exception {
        File[] availableAuditPackages = FsUtil.getCandidateAuditPackagesForDeletingByUid(cardSerialNumber);
        if (availableAuditPackages != null && availableAuditPackages.length > 0) {
            List<File> filesToDelete = FsUtil.getInvoicesCompareByCounterNotGreater(availableAuditPackages, FsUtil.readFileToString(FN_REMOTE_AUDIT_LATEST_INVOICE + "_" + cardSerialNumber));
            for (File file : filesToDelete) {
                try {
                    logger.info("Deleting file " + file.getAbsolutePath());
                    FsUtil.deleteFile(file);
                }
                catch (Exception exc) {
                    logger.error("Deleting file error", (Throwable)exc);
                }
            }
        }
    }

    public static void deleteFilesFromDirectory(String dirPath) {
        try {
            if (!FsUtil.fileExists(dirPath)) {
                return;
            }
            File directory = new File(dirPath);
            File[] files = directory.listFiles();
            FsUtil.deleteFiles(directory.listFiles());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getConfigFileFullPath(String cardSerial, String fileName) {
        return DIR_PARAMS_CONFIG + File.separator + cardSerial + File.separator + fileName;
    }

    public static boolean fileConfigExists(String cardSerial, String fileName) {
        return FsUtil.fileExists(FsUtil.getConfigFileFullPath(cardSerial, fileName));
    }

    public static String readConfigFileToString(String cardSerial, String fileName) throws IOException {
        return FsUtil.readFileToString(FsUtil.getConfigFileFullPath(cardSerial, fileName));
    }

    public static void writeConfigFile(String cardSerial, String fileName, String fileContent) throws IOException {
        FsUtil.writeFile(FsUtil.getConfigFileFullPath(cardSerial, fileName), fileContent);
    }
}

