/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.ui;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.ui.BoolStatusUiItem;
import com.dmi.sdccore.ui.UiUtil;
import com.dmi.sdccore.utils.DateTimeUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class StatusTabPanel
extends HBox {
    List<BoolStatusUiItem> statusUiItems = new ArrayList<BoolStatusUiItem>();
    VBox statusBox = new VBox();
    VBox cardInfoBox = new VBox();

    public StatusTabPanel() {
        this.getStyleClass().add((Object)"roundedPanelBorder");
        this.setAlignment(Pos.TOP_CENTER);
        this.setStyle("-fx-padding: 10;");
        this.setSpacing(20.0);
        HBox.setHgrow((Node)this.statusBox, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)this.cardInfoBox, (Priority)Priority.SOMETIMES);
        BoolStatusUiItem licenseValidItem = new BoolStatusUiItem("License valid", I18N.text("text.license.valid.true"), "text.license.valid.", UiUtil.createBooleanIcon(true), UiUtil.createBooleanIcon(false));
        licenseValidItem.setVisible(false);
        this.statusUiItems.add(licenseValidItem);
        BoolStatusUiItem sdcConfigured = new BoolStatusUiItem("SDC configured", I18N.text("text.sdc.configured.false"), "text.sdc.configured.");
        sdcConfigured.updateStatus(AppState.getInstance().isSdcInitialized());
        this.statusUiItems.add(sdcConfigured);
        BoolStatusUiItem terminalConnected = new BoolStatusUiItem("Terminal", I18N.text("text.card.terminal.connected.false"), "text.card.terminal.connected.");
        terminalConnected.setVisible(false);
        this.statusUiItems.add(terminalConnected);
        BoolStatusUiItem cardConnected = new BoolStatusUiItem("Card", I18N.text("text.card.connected.false"), "text.card.connected.");
        cardConnected.setVisible(false);
        this.statusUiItems.add(cardConnected);
        this.statusUiItems.add(new BoolStatusUiItem("Pin code", I18N.text("text.pin.code.entered.false"), "text.pin.code.entered.", UiUtil.createBooleanIcon(true), UiUtil.createWarningIcon()));
        BoolStatusUiItem file = new BoolStatusUiItem("File number", "Broj neposlatih filova je : 0", "text.file.number.contect.");
        file.setVisible(false);
        this.statusUiItems.add(file);
        BoolStatusUiItem cardLimit75Item = new BoolStatusUiItem("Card limit > 75%", I18N.text("text.card.limit.warning.75.false"), "text.card.limit.warning.75.", UiUtil.createWarningIcon(), UiUtil.createBooleanIcon(true));
        cardLimit75Item.setVisible(false);
        this.statusUiItems.add(cardLimit75Item);
        BoolStatusUiItem auditRequiredItem = new BoolStatusUiItem("Audit required", I18N.text("text.audit.required.true"), "text.audit.required.", UiUtil.createWarningIcon(), UiUtil.createBooleanIcon(true));
        auditRequiredItem.setVisible(false);
        this.statusUiItems.add(auditRequiredItem);
        BoolStatusUiItem auditInProgressItem = new BoolStatusUiItem("Audit in progress", I18N.text("text.audit.in.progress.true"), "text.audit.in.progress.", UiUtil.createInfoIcon(), UiUtil.createBooleanIcon(true));
        auditInProgressItem.setVisible(false);
        this.statusUiItems.add(auditInProgressItem);
        BoolStatusUiItem serialNumberNotDefinedItem = new BoolStatusUiItem("SDC number not defined", I18N.text("text.sdc.serial.number.defined.false"), "text.sdc.serial.number.defined.", UiUtil.createBooleanIcon(false), UiUtil.createBooleanIcon(true));
        serialNumberNotDefinedItem.setVisible(false);
        this.statusUiItems.add(serialNumberNotDefinedItem);
        BoolStatusUiItem internetNotAvailableItem = new BoolStatusUiItem("Internet not available", I18N.text("text.internet.available.false"), "text.internet.available.", UiUtil.createBooleanIcon(false), UiUtil.createBooleanIcon(true));
        internetNotAvailableItem.setVisible(false);
        this.statusUiItems.add(internetNotAvailableItem);
        BoolStatusUiItem externalDiskPresentItem = new BoolStatusUiItem("External disk present", I18N.text("text.external.drive.present.true"), "text.external.drive.present.", UiUtil.createBooleanIcon(true), UiUtil.createBooleanIcon(false));
        externalDiskPresentItem.setVisible(false);
        this.statusUiItems.add(externalDiskPresentItem);
        this.statusBox.getChildren().add((Object)UiUtil.createLabelBold(I18N.text("text.sdc.status")));
        this.statusBox.getChildren().add((Object)new Separator());
        this.statusUiItems.forEach(s -> this.statusBox.getChildren().add((Object)s));
        double panelWidth = 300.0;
        double panelHeight = 300.0;
        this.cardInfoBox.setMinWidth(panelWidth);
        this.cardInfoBox.setPrefWidth(panelWidth);
        this.cardInfoBox.setMinHeight(panelHeight);
        this.cardInfoBox.setPrefHeight(panelHeight);
        this.statusBox.setMinWidth(panelWidth);
        this.statusBox.setPrefWidth(panelWidth);
        this.statusBox.setMinHeight(panelHeight);
        this.statusBox.setPrefHeight(panelHeight);
        this.updateCardInfo(AppState.getInstance());
        this.getChildren().addAll((Object[])new Node[]{this.statusBox, this.cardInfoBox});
    }

    private void updateStatuses(AppState appState) {
        String itemCode = "text.sdc.configured.";
        boolean condition = appState.isSdcInitialized();
        BoolStatusUiItem item = this.findItem(itemCode);
        item.updateStatus(condition, I18N.text(itemCode + condition));
        itemCode = "text.file.number.contect.";
        condition = appState.isMessageFile();
        BoolStatusUiItem item1 = this.findItem(itemCode);
        item1.updateStatus(true, I18N.text(itemCode + condition));
        item1.setVisible(false);
        itemCode = "text.card.terminal.connected.";
        condition = appState.isTerminalConnected();
        item = this.findItem(itemCode);
        item.updateStatus(condition, I18N.text(itemCode + condition));
        item.setVisible(true);
        itemCode = "text.card.connected.";
        condition = appState.isCardInserted();
        item = this.findItem(itemCode);
        item.updateStatus(condition, I18N.text(itemCode + condition));
        item.setVisible(true);
        itemCode = "text.pin.code.entered.";
        condition = appState.isCardPinCodeEntered();
        this.findItem(itemCode).updateStatus(condition, I18N.text(itemCode + condition));
        itemCode = "text.card.limit.warning.75.";
        condition = appState.isCardAmountPercentsMoreThen75();
        item = this.findItem(itemCode);
        if (!appState.isAuditRequired()) {
            item.updateStatus(condition, String.format(I18N.text(itemCode + condition), appState.getCardAmountPercents()));
        } else {
            item.updateStatus(UiUtil.createBooleanIcon(false), I18N.text("text.card.limit.warning.100"));
        }
        item.setVisible(appState.isTaxCardInfoRead() && appState.getCardAmountPercents() > 0);
        itemCode = "text.audit.required.";
        condition = appState.isCardAmountPercentsMoreThen75();
        item = this.findItem(itemCode);
        item.updateStatus(condition);
        item.setVisible(condition);
        itemCode = "text.audit.in.progress.";
        condition = appState.isAuditInProgress();
        item = this.findItem(itemCode);
        item.updateStatus(condition);
        item.setVisible(condition);
        itemCode = "text.sdc.serial.number.defined.";
        condition = !appState.isSdcSerialNumberDefined();
        item = this.findItem(itemCode);
        item.updateStatus(condition);
        item.setVisible(condition);
        itemCode = "text.license.valid.";
        condition = appState.isSdcLicenceValid();
        item = this.findItem(itemCode);
        item.updateStatus(condition, I18N.text(itemCode + condition));
        item.setVisible(appState.isTaxCardInfoRead());
        itemCode = "text.internet.available.";
        condition = !appState.isInternetAvailable();
        item = this.findItem(itemCode);
        item.updateStatus(condition);
        item.setVisible(condition);
        itemCode = "text.external.drive.present.";
        condition = appState.isExternalDiskPresent();
        item = this.findItem(itemCode);
        item.updateStatus(condition, I18N.text(itemCode + condition));
        item.setVisible(condition);
    }

    private void updateCardInfo(AppState appState) {
        this.cardInfoBox.getChildren().clear();
        this.cardInfoBox.getChildren().add((Object)UiUtil.createLabelBold(I18N.text("text.card.info")));
        this.cardInfoBox.getChildren().add((Object)new Separator());
        if (appState.isTaxCardInfoRead()) {
            TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
            this.cardInfoBox.getChildren().add((Object)new Text(taxCardCertificate.getSubject().getO()));
            this.cardInfoBox.getChildren().add((Object)new Text(taxCardCertificate.getSubject().getOu()));
            this.cardInfoBox.getChildren().add((Object)new Text(taxCardCertificate.getSubject().getStreet()));
            this.cardInfoBox.getChildren().add((Object)new Text(taxCardCertificate.getSubject().getL()));
            this.cardInfoBox.getChildren().add((Object)UiUtil.createLabelAndValue(I18N.text("text.tin"), taxCardCertificate.getTaxpayerTin()));
            this.cardInfoBox.getChildren().add((Object)UiUtil.createLabelAndValue(I18N.text("text.card.uid"), taxCardCertificate.getSubject().getSerialNumber()));
            this.cardInfoBox.getChildren().add((Object)UiUtil.createLabelBold(I18N.text("text.card.valid")));
            this.cardInfoBox.getChildren().add((Object)UiUtil.createLabelAndValue("   " + I18N.text("text.from"), DateTimeUtil.toReceiptDateTimeString(taxCardCertificate.getValidFrom())));
            this.cardInfoBox.getChildren().add((Object)UiUtil.createLabelAndValue("   " + I18N.text("text.to"), DateTimeUtil.toReceiptDateTimeString(taxCardCertificate.getValidTo())));
        } else {
            this.cardInfoBox.getChildren().add((Object)new Text(I18N.text("text.card.info.not.available")));
        }
    }

    public void update(AppState appState) {
        this.updateStatuses(appState);
        this.updateCardInfo(appState);
    }

    public BoolStatusUiItem findItem(String itemCode) {
        return this.statusUiItems.stream().filter(sui -> sui.getItemCode().equals(itemCode)).findFirst().orElse(null);
    }
}

