/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.api.model.lcd.CustomerDisplay;
import com.dmi.sdccore.api.model.printer.InvoiceReusultItem;
import com.dmi.sdccore.api.model.printer.StateReport;
import com.dmi.sdccore.api.model.report.Report;
import com.dmi.sdccore.api.model.report.ReportSettings;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.printimage.ContentProporties;
import com.dmi.sdccore.printimage.EscPosPrinterStandard;
import com.dmi.sdccore.printimage.NPrintUtil;
import com.dmi.sdccore.utils.helpers.OrderedProperties;
import com.fazecast.jSerialComm.SerialPort;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Map;
import javax.print.PrintService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NarrowPosPrintCurrentSales
extends ContentProporties {
    private static final String PROPERTIES_FILE_NAME = "../config.properties";
    private OrderedProperties properties = new OrderedProperties();
    private static final Logger logger = LogManager.getLogger(NarrowPosPrintCurrentSales.class);

    public void printReport(Report report) {
        StringBuilder sales = this.makeContent(report);
        this.printFiscalBill(report, sales);
    }

    public void printState(StateReport report) {
        StringBuilder sales = this.makeContentState(report);
        this.printFiscalState(report, sales);
    }

    public StringBuilder makeContentState(StateReport stateReport) {
        AppState appState = AppState.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        if (appState != null && appState.getTaxCardCertificate() != null) {
            TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
            stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", stateReport.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent("PIB:" + taxCardCertificate.getTaxpayerTin(), stateReport.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(taxCardCertificate.getSubject().getO(), stateReport.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(taxCardCertificate.getSubject().getStreet(), stateReport.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(taxCardCertificate.getSubject().getL(), stateReport.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", stateReport.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.contentInTheMiddle("Artikli", stateReport.getNumOfCharacters()));
        stringBuilder.append("\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithChar('=', stateReport.getNumOfCharacters()));
        stringBuilder.append("\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Naziv   Cena", " Kol.     Ukupno", stateReport.getNumOfCharacters()));
        stringBuilder.append("\n");
        String vatCode = "";
        String productName = "";
        String unitName = "";
        String price = "";
        String quantity = "";
        String value = "";
        for (InvoiceReusultItem item : stateReport.getInvoiceReusultItem()) {
            vatCode = item.getVatCode();
            productName = item.getProductName();
            unitName = item.getUnitName();
            quantity = NarrowPosPrintCurrentSales.formatOnThree(item.getQuantity());
            price = NarrowPosPrintCurrentSales.formatOnTwo(item.getPrice());
            value = NarrowPosPrintCurrentSales.formatOnTwo(item.getValue());
            String productCombination = " " + productName;
            String productNameTemp = (productCombination.length() <= stateReport.getNumOfCharacters() - 1 ? productCombination : productCombination.substring(0, stateReport.getNumOfCharacters() - 1)) + "\n";
            productNameTemp = productNameTemp + (productCombination.length() > stateReport.getNumOfCharacters() - 1 ? productCombination.substring(stateReport.getNumOfCharacters() - 1, productCombination.length()) + "\n" : "");
            stringBuilder.append(productNameTemp);
            String text = NarrowPosPrintCurrentSales.textWithSpaceBetween(NarrowPosPrintCurrentSales.priceLine("", price), NarrowPosPrintCurrentSales.qunatitySumLine(quantity, value), stateReport.getNumOfCharacters());
            if (text.length() > stateReport.getNumOfCharacters()) {
                String text1 = text.substring(0, stateReport.getNumOfCharacters());
                String text2 = text.substring(stateReport.getNumOfCharacters(), text.length());
                text = text1 + "\n" + text2;
            }
            stringBuilder.append(text);
            logger.info("Item " + stringBuilder.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }

    private StringBuilder makeContent(Report report) {
        String val;
        AppState appState;
        String reportDate = report.getDateFrom();
        String header = report.getReportHeader();
        StringBuilder stringBuilder = new StringBuilder();
        String pattern = "###,##0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        if (report.getDateTo() != null && !report.getDateTo().isEmpty()) {
            reportDate = reportDate + "-" + report.getDateTo();
        }
        if ((appState = AppState.getInstance()) != null && appState.getTaxCardCertificate() != null) {
            TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
            stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent("PIB:" + taxCardCertificate.getTaxpayerTin(), report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(taxCardCertificate.getSubject().getO(), report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(taxCardCertificate.getSubject().getStreet(), report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(taxCardCertificate.getSubject().getL(), report.getNumOfCharacters()) + "\n");
        } else {
            stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent("PIB:" + report.getPib(), report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(report.getCompanyName(), report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(report.getAddress(), report.getNumOfCharacters()) + "\n");
            stringBuilder.append(this.makeMultiRowContent(report.getCityName(), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.contentInTheMiddle(header + " " + reportDate, report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Gotovina:", decimalFormat.format(report.getReportPayment().get("Gotovina")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Kartica:", decimalFormat.format(report.getReportPayment().get("Platna Kartica")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Cek:", decimalFormat.format(report.getReportPayment().get("\u010cek")), report.getNumOfCharacters()) + "\n");
        BigDecimal value = report.getReportPayment().get("Prenos na ra\u010dun") != null ? report.getReportPayment().get("Prenos na ra\u010dun") : report.getReportPayment().get("Faktura");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Faktura:", decimalFormat.format(value), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Vau\u010der:", decimalFormat.format(report.getReportPayment().get("Vau\u010der")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Instant placanje:", decimalFormat.format(report.getReportPayment().get("Instant pla\u0107anje")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Ostalo:", decimalFormat.format(report.getReportPayment().get("Ostalo")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("Ukupno:", decimalFormat.format(report.getReportPayment().get("Ukupno")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        for (Map.Entry<String, BigDecimal> entry : report.getBasic().entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append("Osnovice po stopama \n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        for (Map.Entry<String, BigDecimal> entry : report.getBasic().entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append("Pdv po stopama \n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        for (Map.Entry<String, BigDecimal> entry : report.getPdv().entrySet()) {
            val = NPrintUtil.replaceCyrillicToUnicode("Po stopi " + entry.getKey() + ":");
            stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween(val, decimalFormat.format(entry.getValue()), report.getNumOfCharacters()) + "\n");
        }
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("*Avans uplaceno :", decimalFormat.format(report.getReportPayment().get("Avans")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("*Predracun uplaceno :", decimalFormat.format(report.getReportPayment().get("Predracun")), report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.makeLineWithString("=", report.getNumOfCharacters()) + "\n");
        stringBuilder.append(NarrowPosPrintCurrentSales.textWithSpaceBetween("*Refundacija uplaceno :", decimalFormat.format(report.getReportPayment().get("Refundacija")), report.getNumOfCharacters()) + "\n");
        return stringBuilder;
    }

    public void printFiscalBill(Report report, StringBuilder sales) {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)report.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            EscPosPrinterStandard escPosPrinter = new EscPosPrinterStandard(escPos);
            escPosPrinter.printImage(null, sales, null, report.getNumOfCharacters(), escPos, null, new StringBuilder());
            escPosPrinter.printBlankLines(5);
            escPos.cut(EscPos.CutMode.FULL);
            escPos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printFiscalState(StateReport report, StringBuilder sales) {
        PrintService service = PrinterOutputStream.getPrintServiceByName((String)report.getServerName());
        try {
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            EscPosPrinterStandard escPosPrinter = new EscPosPrinterStandard(escPos);
            escPosPrinter.printImage(null, sales, null, report.getNumOfCharacters(), escPos, null, new StringBuilder());
            escPosPrinter.printBlankLines(5);
            escPos.cut(EscPos.CutMode.FULL);
            escPos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printImageReport(ReportSettings report) {
        try {
            PrintService service = PrinterOutputStream.getPrintServiceByName((String)report.getServerName());
            PrinterOutputStream outputStream = new PrinterOutputStream(service);
            EscPos escPos = new EscPos((OutputStream)outputStream);
            EscPosPrinterStandard escPosPrinter = new EscPosPrinterStandard(escPos);
            escPosPrinter.printImageReport(report, escPos);
            escPosPrinter.printBlankLines(5);
            escPos.cut(EscPos.CutMode.FULL);
            escPos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadProperties() throws IOException {
        File file = new File(PROPERTIES_FILE_NAME);
        FileInputStream fi = new FileInputStream(file);
        this.properties.load(fi);
        fi.close();
    }

    public void printCustomerDispaly(CustomerDisplay customerDisplay) throws InterruptedException {
        SerialPort serialPort = null;
        try {
            this.loadProperties();
            String portName = "COM" + this.properties.getProperty("sdcLcdPort");
            logger.info("Port name : " + portName);
            logger.info("getCommPort je " + portName);
            serialPort = SerialPort.getCommPort((String)portName);
            serialPort.openPort();
            logger.info("open port " + portName);
            serialPort.setBaudRate(9600);
            serialPort.setNumDataBits(8);
            serialPort.setNumStopBits(1);
            serialPort.setParity(0);
            logger.info("Enter data to send: ");
            String name = customerDisplay.getName();
            String unitPrice = customerDisplay.getUnitPrice();
            String price = customerDisplay.getPrice();
            try {
                byte[] clearCommand = new byte[]{12};
                logger.info("pre Problem je ");
                serialPort.writeBytes(clearCommand, clearCommand.length);
                logger.info("nakon Problem je ");
            }
            catch (Exception e) {
                logger.info("Problem je " + e.getMessage());
                e.printStackTrace();
            }
            catch (Error e) {
                logger.info("Greska  je " + e.getMessage());
                e.printStackTrace();
            }
            logger.info("write data  ");
            byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
            serialPort.writeBytes(nameBytes, nameBytes.length);
            serialPort.closePort();
            serialPort = SerialPort.getCommPort((String)portName);
            serialPort.openPort();
            serialPort.setBaudRate(9600);
            serialPort.setNumDataBits(8);
            serialPort.setNumStopBits(1);
            serialPort.setParity(0);
            byte[] scrollCommand1 = new byte[]{27, 68};
            serialPort.writeBytes(scrollCommand1, scrollCommand1.length);
            if (price != null && unitPrice != null) {
                byte[] priceBytes = NarrowPosPrintCurrentSales.textWithSpaceBetween(unitPrice, price, 20).getBytes(StandardCharsets.UTF_8);
                serialPort.writeBytes(priceBytes, priceBytes.length);
            } else if (customerDisplay.getChange() != null) {
                byte[] changeBytes = NarrowPosPrintCurrentSales.textWithSpaceBetween(customerDisplay.getChange(), "", 20).getBytes(StandardCharsets.UTF_8);
                serialPort.writeBytes(changeBytes, changeBytes.length);
            }
        }
        catch (Exception e) {
            logger.error("Greska je " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        finally {
            serialPort.closePort();
        }
    }
}

