/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.api.model.invoice.PrinterResponse;
import com.dmi.sdccore.api.model.printer.PrintInvoice;
import com.dmi.sdccore.api.model.report.PrintPosition;
import com.dmi.sdccore.api.model.report.ReportSettings;
import com.dmi.sdccore.printimage.CodePageConverterUtil;
import com.dmi.sdccore.printimage.EsPosPrinterStandardOldPrint;
import com.dmi.sdccore.printimage.FormaterUtil;
import com.dmi.sdccore.printimage.ImageHelper;
import com.dmi.sdccore.printimage.SliceImage;
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.image.Bitonal;
import com.github.anastaciocintra.escpos.image.BitonalThreshold;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import com.github.anastaciocintra.escpos.image.RasterBitImageWrapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Map;
import javax.imageio.ImageIO;

public class EscPosPrinterStandard
extends EsPosPrinterStandardOldPrint {
    private static final String PRINTER_NAME_TRADER = "TRADER";
    private static final String PRINTER_NAME_BIRCH_A530 = "BIRCH-A530";
    private static final String PRINTER_NAME_BIRCH_CPQ1UN = "BIRCH-CPQ1UN";
    public static final String PRINTER_NAME_EPSON = "EPSON";
    private final EscPos escPos;
    private int defaultCodePage;
    private String defaultCharsetName;
    private int latinCodePage;
    private String latinCharsetName;
    private int cyrCodePage;
    private String cyrCharsetName;
    private String printerServerName;

    public EscPosPrinterStandard(EscPos escPos) {
        this.defaultCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.defaultCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.latinCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.latinCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.cyrCodePage = 36;
        this.cyrCharsetName = "cp855";
        this.escPos = escPos;
    }

    public EscPosPrinterStandard(EscPos escPos, String printerServerName) {
        this.defaultCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.defaultCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.latinCodePage = EscPos.CharacterCodeTable.CP852_Latin2.value;
        this.latinCharsetName = EscPos.CharacterCodeTable.CP852_Latin2.charsetName;
        this.cyrCodePage = 36;
        this.cyrCharsetName = "cp855";
        this.escPos = escPos;
        this.printerServerName = printerServerName;
        if (this.isPrinterTrader()) {
            this.latinCodePage = 32;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 38;
            this.cyrCharsetName = "cp855";
        }
        if (this.isPrinterBirchCPQ1UN()) {
            this.latinCodePage = 18;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 60;
            this.cyrCharsetName = "cp855";
        }
        if (this.isPrinterBirchA530()) {
            this.latinCodePage = 32;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 38;
            this.cyrCharsetName = "cp855";
        }
        if (printerServerName.toUpperCase().contains(PRINTER_NAME_EPSON)) {
            System.out.println("EPSON PRINTER");
            this.latinCodePage = 18;
            this.latinCharsetName = "cp852";
            this.cyrCodePage = 46;
            this.cyrCharsetName = "cp1251";
        }
    }

    public void printBlankLine() throws IOException {
        this.printBlankLines(1);
    }

    public void printBlankLines(int lineCount) throws IOException {
        this.escPos.feed(lineCount);
    }

    public void print(String value) throws IOException {
        this.printWithStyle(value, this.defaultCodePage, this.defaultCharsetName, null);
    }

    public void printLine(String value) throws IOException {
        this.printWithStyle(value, this.defaultCodePage, this.defaultCharsetName, null);
        this.escPos.writeLF("");
    }

    public void print(String value, Integer codePageTable, String charsetName) throws IOException {
        this.printWithStyle(value, codePageTable, charsetName, null);
    }

    public void printWithStyle(String value, Integer codePageTable, String charsetName, Style style) throws IOException {
        if (style != null) {
            byte[] configBytes = style.getConfigBytes();
            this.escPos.write(configBytes, 0, configBytes.length);
        }
        this.escPos.setPrinterCharacterTable(codePageTable.intValue());
        this.escPos.write(CodePageConverterUtil.convertToBytes(value, charsetName), 0, value.length());
    }

    public void printLatin(String value) throws IOException {
        this.print(value, this.latinCodePage, this.latinCharsetName);
    }

    public void printCyrillic(String value) throws IOException {
        this.print(value, this.cyrCodePage, this.cyrCharsetName);
    }

    public void printLine(String value, Integer codePageTable, String charsetName) throws IOException {
        if (!this.canPrintCyrAndLatInOneLine()) {
            this.escPos.flush();
            this.escPos.initializePrinter();
        }
        this.print(value, codePageTable, charsetName);
        this.escPos.writeLF("");
    }

    public void printLineWithStyle(String value, Integer codePageTable, String charsetName, Style style) throws IOException {
        this.printWithStyle(value, codePageTable, charsetName, style);
        this.escPos.writeLF("");
    }

    public void printLineLatinWithStyle(String value, Style style) throws IOException {
        this.printWithStyle(value, this.latinCodePage, this.latinCharsetName, style);
        this.escPos.writeLF("");
    }

    public void printLineLatin(String value) throws IOException {
        if (!this.canPrintCyrAndLatInOneLine()) {
            this.escPos.flush();
            this.escPos.initializePrinter();
        }
        this.printLatin(value);
        this.escPos.writeLF("");
    }

    public void printLineCyrillic(String value) throws IOException {
        if (!this.canPrintCyrAndLatInOneLine()) {
            this.escPos.flush();
            this.escPos.initializePrinter();
        }
        this.printCyrillic(value);
        this.escPos.writeLF("");
    }

    public void printLineAutoDetect(String value) throws IOException {
        if (FormaterUtil.isCyrillic(value)) {
            this.printLineCyrillic(value);
        } else {
            this.printLineLatin(value);
        }
    }

    public int getLatinCodePage() {
        return this.latinCodePage;
    }

    public void setLatinCodePage(int latinCodePage) {
        this.latinCodePage = latinCodePage;
    }

    public String getLatinCharsetName() {
        return this.latinCharsetName;
    }

    public void setLatinCharsetName(String latinCharsetName) {
        this.latinCharsetName = latinCharsetName;
    }

    public int getCyrCodePage() {
        return this.cyrCodePage;
    }

    public void setCyrCodePage(int cyrCodePage) {
        this.cyrCodePage = cyrCodePage;
    }

    public String getCyrCharsetName() {
        return this.cyrCharsetName;
    }

    public void setCyrCharsetName(String cyrCharsetName) {
        this.cyrCharsetName = cyrCharsetName;
    }

    public EscPos getEscPos() {
        return this.escPos;
    }

    public String getPrinterServerName() {
        return this.printerServerName;
    }

    public void setPrinterServerName(String printerServerName) {
        this.printerServerName = printerServerName;
    }

    public boolean isPrinterTrader() {
        if (this.printerServerName == null) {
            return false;
        }
        return this.printerServerName.toUpperCase().contains(PRINTER_NAME_TRADER);
    }

    public boolean isPrinterBirchCPQ1UN() {
        if (this.printerServerName == null) {
            return false;
        }
        return this.printerServerName.toUpperCase().contains(PRINTER_NAME_BIRCH_CPQ1UN);
    }

    public boolean isPrinterBirchA530() {
        if (this.printerServerName == null) {
            return false;
        }
        return this.printerServerName.toUpperCase().contains(PRINTER_NAME_BIRCH_A530);
    }

    public boolean canPrintCyrAndLatInOneLine() {
        return !this.isPrinterTrader() && !this.isPrinterBirchCPQ1UN() && !this.isPrinterBirchA530();
    }

    public PrinterResponse printImage(PrintInvoice printInvoice, StringBuilder sb, String endBill, int numberCharset, EscPos escPos, String invoice, StringBuilder stringBuilder) {
        try {
            return this.printImageCustom(printInvoice, sb.toString(), endBill, numberCharset, escPos, invoice, stringBuilder);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PrinterResponse printerResponse = new PrinterResponse();
            printerResponse.setResponse("NOk");
            return printerResponse;
        }
    }

    public static String convertToBase64(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, outputStream);
        byte[] imageBytes = outputStream.toByteArray();
        String base64String = Base64.getEncoder().encodeToString(imageBytes);
        outputStream.close();
        return base64String;
    }

    private PrinterResponse printImageCustom(PrintInvoice printInvoice, String value, String endBill, int numberCharSet, EscPos escPos, String invoice, StringBuilder stringBuilder) throws IOException, Exception {
        ImageHelper helper;
        if (printInvoice.getIsImage().booleanValue()) {
            BufferedImage image2;
            BufferedImage imageBufferedImage;
            PrinterResponse printerResponse = new PrinterResponse();
            BufferedImage bufferedImage = imageBufferedImage = endBill != null ? this.convert(value, endBill, numberCharSet, escPos, invoice, stringBuilder) : this.convert(value, null, numberCharSet);
            if (printInvoice != null && printInvoice.getAdditionalData() != null) {
                BufferedImage bufferedImage2 = this.convert(this.buildAdditionalData(printInvoice), null, 30);
                printerResponse.setNote(EscPosPrinterStandard.convertToBase64(bufferedImage2, "png"));
            }
            BufferedImage image1 = SliceImage.getLogo();
            System.out.println("logo vrednost");
            if (image1 != null) {
                printerResponse.setHeaderLogo(EscPosPrinterStandard.convertToBase64(image1, "png"));
            }
            if ((image2 = SliceImage.getCompanyUs()) != null) {
                printerResponse.setFooterLogo(EscPosPrinterStandard.convertToBase64(image2, "png"));
            }
            printerResponse.setResponse(EscPosPrinterStandard.convertToBase64(imageBufferedImage, "png"));
            return printerResponse;
        }
        BufferedImage image1 = SliceImage.getLogo();
        System.out.println("logo vrednost");
        if (image1 != null) {
            System.out.println("Stampa logoa");
            this.convertImage(image1, escPos, EscPosConst.Justification.Center);
        }
        BufferedImage imageBufferedImage = endBill != null ? this.convert(value, endBill, numberCharSet, escPos, invoice, stringBuilder) : this.convert(value, null, numberCharSet);
        RasterBitImageWrapper imageWrapper = new RasterBitImageWrapper();
        imageWrapper.setJustification(EscPosConst.Justification.Left_Default);
        BitonalThreshold algorithm = new BitonalThreshold();
        if (image1 != null) {
            helper = new ImageHelper(imageBufferedImage.getWidth() + image1.getWidth());
            helper.write(escPos, imageBufferedImage, (ImageWrapperInterface)imageWrapper, (Bitonal)algorithm);
        } else {
            helper = new ImageHelper(imageBufferedImage.getWidth());
            helper.write(escPos, imageBufferedImage, (ImageWrapperInterface)imageWrapper, (Bitonal)algorithm);
        }
        if (printInvoice != null && printInvoice.getAdditionalData() != null) {
            BufferedImage bufferedImage = this.convert(this.buildAdditionalData(printInvoice), null, 30);
            RasterBitImageWrapper imageWrapper1 = new RasterBitImageWrapper();
            imageWrapper1.setJustification(EscPosConst.Justification.Left_Default);
            BitonalThreshold algorithm1 = new BitonalThreshold();
            ImageHelper helper2 = new ImageHelper(imageBufferedImage.getWidth() + this.width(image1));
            helper2.write(escPos, bufferedImage, (ImageWrapperInterface)imageWrapper1, (Bitonal)algorithm1);
        }
        PrinterResponse printerResponse = new PrinterResponse();
        printerResponse.setResponse("Ok");
        return printerResponse;
    }

    private int width(BufferedImage image) {
        if (image != null) {
            return image.getWidth();
        }
        return 0;
    }

    private String buildAdditionalData(PrintInvoice printInvoice) {
        StringBuilder stringBuilder = new StringBuilder();
        if (printInvoice.getAdditionalData().getKupac() != null) {
            stringBuilder.append("Kupac: " + printInvoice.getAdditionalData().getKupac() + "\n");
        }
        if (printInvoice.getAdditionalData().getPib() != null) {
            stringBuilder.append("PIB: " + printInvoice.getAdditionalData().getPib() + "\n");
        }
        if (printInvoice.getAdditionalData().getMb() != null) {
            stringBuilder.append("MB: " + printInvoice.getAdditionalData().getMb() + "\n");
        }
        if (printInvoice.getAdditionalData().getMesto() != null) {
            stringBuilder.append("Mesto: " + printInvoice.getAdditionalData().getMesto() + "\n");
        }
        if (printInvoice.getAdditionalData().getAdresa() != null) {
            stringBuilder.append("Adresa: " + printInvoice.getAdditionalData().getAdresa() + "\n");
        }
        if (printInvoice.getAdditionalData().getRacun() != null) {
            stringBuilder.append("Uplatu izvrsiti na ziro racun:\n");
        }
        if (printInvoice.getAdditionalData().getRacun() != null) {
            stringBuilder.append(printInvoice.getAdditionalData().getRacun() + "\n");
        }
        if (printInvoice.getAdditionalData().getValuta() != null) {
            stringBuilder.append("Valuta placanja: " + printInvoice.getAdditionalData().getValuta() + "\n");
        }
        if (printInvoice.getAdditionalData().getBrojFakture() != null) {
            stringBuilder.append("Broj fakture: " + printInvoice.getAdditionalData().getBrojFakture() + "\n");
        }
        if (printInvoice.getAdditionalData().getNapomena() != null) {
            stringBuilder.append(printInvoice.getAdditionalData().getNapomena());
        }
        return stringBuilder.toString();
    }

    public BufferedImage convert(String text, Map<String, Integer> map, int numberCharSet) throws Exception {
        String[] text_array = text.split("[\n]");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D graphics = img.createGraphics();
        int fontSize = 24;
        if (numberCharSet <= 30) {
            fontSize = 23;
        }
        Font font = new Font("Consolas", 0, fontSize);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        int width = (int)font.getStringBounds(EscPosPrinterStandard.getLongestLine(text_array), fontRenderContext).getWidth() + 10;
        int lines = EscPosPrinterStandard.getLineCount(text);
        int height = fontMetrics.getHeight() * lines;
        graphics.dispose();
        img = new BufferedImage(width, height - lines * 7, 2);
        graphics = img.createGraphics();
        graphics.setFont(font);
        fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.BLACK);
        graphics.setBackground(Color.WHITE);
        graphics.clearRect(0, 0, width, height);
        boolean isMap = false;
        for (int i = 1; i <= lines; ++i) {
            int y;
            if (map != null) {
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    if (!text_array[i - 1].contains(entry.getKey())) continue;
                    y = fontMetrics.getAscent() * i;
                    graphics.setFont(new Font("Consolas", (int)entry.getValue(), 29));
                    graphics.drawString(text_array[i - 1], 0, y);
                    isMap = true;
                }
            }
            if (!isMap) {
                y = fontMetrics.getAscent() * i;
                graphics.setFont(new Font("Consolas", 0, 24));
                graphics.drawString(text_array[i - 1], 0, y);
            }
            isMap = false;
        }
        return img;
    }

    public void printImageReport(ReportSettings report, EscPos escPos) {
        report.getReport().forEach(r -> {
            block7: {
                try {
                    if (r.getPrintText() != null) {
                        BufferedImage imageBufferedImage = this.convert(r.getPrintText().getText(), r.getPrintText().getMap(), r.getPrintText().getNumberCharacter());
                        this.convertImage(imageBufferedImage, escPos, EscPosConst.Justification.Left_Default);
                        break block7;
                    }
                    if (r.getQrCode() != null) {
                        BufferedImage imageBufferedImage = this.generateQRCodeImage(r.getQrCode().getBase64(), r.getQrCode().getWight(), r.getQrCode().getHeight());
                        this.convertImage(imageBufferedImage, escPos, this.getJustification(r.getQrCode().getPosition()));
                        break block7;
                    }
                    if (r.getBarCode() != null) {
                        BufferedImage imageBufferedImage = EscPosPrinterStandard.generateEAN13BarcodeImage(r.getBarCode().getText(), r.getBarCode().getWight(), r.getBarCode().getHeight());
                        this.convertImage(imageBufferedImage, escPos, this.getJustification(r.getBarCode().getPosition()));
                        break block7;
                    }
                    if (r.getImage() == null) break block7;
                    String base64String = r.getImage().getBase64();
                    byte[] decodedBytes = Base64.getDecoder().decode(base64String);
                    Files.write(Paths.get("C:\\imagedejan1.jpg", new String[0]), decodedBytes, new OpenOption[0]);
                    byte[] imageData = Files.readAllBytes(Paths.get("C:\\imagedejan1.jpg", new String[0]));
                    ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
                    try {
                        BufferedImage bufferedImage = ImageIO.read(bais);
                        this.convertImage(bufferedImage, escPos, this.getJustification(r.getImage().getPosition()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void convertImage(BufferedImage imageBufferedImage, EscPos escPos, EscPosConst.Justification justification) throws IOException {
        RasterBitImageWrapper imageWrapper = new RasterBitImageWrapper();
        imageWrapper.setJustification(justification);
        BitonalThreshold algorithm = new BitonalThreshold();
        ImageHelper helper = new ImageHelper(imageBufferedImage.getWidth());
        helper.write(escPos, imageBufferedImage, (ImageWrapperInterface)imageWrapper, (Bitonal)algorithm);
    }

    private EscPosConst.Justification getJustification(PrintPosition position) {
        if (position.name() == PrintPosition.LEFT.name()) {
            return EscPosConst.Justification.Left_Default;
        }
        if (position.name() == PrintPosition.RIGHT.name()) {
            return EscPosConst.Justification.Right;
        }
        if (position.name() == PrintPosition.CENTER.name()) {
            return EscPosConst.Justification.Center;
        }
        return EscPosConst.Justification.Left_Default;
    }
}

