/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.invoice;

import com.dmi.sdccore.api.model.deserializers.InvoiceTransactionTypeDeserializer;
import com.dmi.sdccore.api.model.deserializers.InvoiceTypeDeserializer;
import com.dmi.sdccore.api.model.invoice.InvoiceItem;
import com.dmi.sdccore.api.model.invoice.InvoicePayment;
import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InvoiceRequest {
    public static final String OPTION_OMIT_QR_CODE_GEN = "omitQRCodeGen";
    public static final String OPTION_OMIT_TEXT_REPRESENTATION = "omitTextualRepresentation";
    @JsonAlias(value={"dateAndTimeOfIssue", "DateAndTimeOfIssue"})
    String dateAndTimeOfIssue;
    @JsonDeserialize(using=InvoiceTypeDeserializer.class)
    @JsonAlias(value={"invoiceType", "InvoiceType"})
    InvoiceType invoiceType;
    @JsonDeserialize(using=InvoiceTransactionTypeDeserializer.class)
    @JsonAlias(value={"transactionType", "TransactionType"})
    InvoiceTransactionType transactionType;
    @JsonAlias(value={"payment", "Payment"})
    List<InvoicePayment> payment;
    @JsonAlias(value={"cashier", "Cashier"})
    String cashier;
    @JsonAlias(value={"buyerId", "BuyerId"})
    String buyerId;
    @JsonAlias(value={"buyerCostCenterId", "BuyerCostCenterId"})
    String buyerCostCenterId;
    @JsonAlias(value={"invoiceNumber", "InvoiceNumber"})
    String invoiceNumber;
    @JsonAlias(value={"referentDocumentNumber", "ReferentDocumentNumber"})
    String referentDocumentNumber;
    @JsonAlias(value={"referentDocumentDT", "ReferentDocumentDT"})
    String referentDocumentDT;
    @JsonAlias(value={"items", "Items"})
    List<InvoiceItem> items;
    @JsonAlias(value={"options", "Options"})
    Map<String, String> options;

    public String getDateAndTimeOfIssue() {
        return this.dateAndTimeOfIssue;
    }

    public void setDateAndTimeOfIssue(String dateAndTimeOfIssue) {
        this.dateAndTimeOfIssue = dateAndTimeOfIssue;
    }

    public InvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    @JsonSetter
    public void setInvoiceType(InvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }

    @JsonSetter
    public void setInvoiceTypeInt(Integer invoiceTypeInt) {
        this.invoiceType = InvoiceType.getByValue(invoiceTypeInt);
    }

    public InvoiceTransactionType getTransactionType() {
        return this.transactionType;
    }

    @JsonSetter
    public void setTransactionType(InvoiceTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @JsonSetter
    public void setTransactionTypeInt(Integer transactionTypeInt) {
        this.transactionType = InvoiceTransactionType.getByValue(transactionTypeInt);
    }

    public List<InvoicePayment> getPayment() {
        return this.payment;
    }

    public void setPayment(List<InvoicePayment> payment) {
        this.payment = payment;
    }

    public String getCashier() {
        return this.cashier;
    }

    public void setCashier(String cashier) {
        this.cashier = cashier;
    }

    public String getBuyerId() {
        return this.buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerCostCenterId() {
        return this.buyerCostCenterId;
    }

    public void setBuyerCostCenterId(String buyerCostCenterId) {
        this.buyerCostCenterId = buyerCostCenterId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getReferentDocumentNumber() {
        return this.referentDocumentNumber;
    }

    public void setReferentDocumentNumber(String referentDocumentNumber) {
        this.referentDocumentNumber = referentDocumentNumber;
    }

    public String getReferentDocumentDT() {
        return this.referentDocumentDT;
    }

    public void setReferentDocumentDT(String referentDocumentDT) {
        this.referentDocumentDT = referentDocumentDT;
    }

    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public void setItems(List<InvoiceItem> items) {
        this.items = items;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public boolean shouldOmitQRCodeGen() {
        if (this.options != null && !this.options.isEmpty()) {
            String value = this.options.get(OPTION_OMIT_QR_CODE_GEN);
            return value != null && Integer.parseInt(value) == 1;
        }
        return false;
    }

    public boolean shouldOmitTextualRepresentation() {
        if (this.options != null && !this.options.isEmpty()) {
            String value = this.options.get(OPTION_OMIT_TEXT_REPRESENTATION);
            return value != null && Integer.parseInt(value) == 1;
        }
        return false;
    }

    public String toString() {
        return "InvoiceRequest{dateAndTimeOfIssue='" + this.dateAndTimeOfIssue + '\'' + ", invoiceType=" + (Object)((Object)this.invoiceType) + ", transactionType=" + (Object)((Object)this.transactionType) + ", payment=" + this.payment + ", cashier='" + this.cashier + '\'' + ", buyerId='" + this.buyerId + '\'' + ", buyerCostCenterId='" + this.buyerCostCenterId + '\'' + ", invoiceNumber='" + this.invoiceNumber + '\'' + ", referentDocumentNumber='" + this.referentDocumentNumber + '\'' + ", referentDocumentDT=" + this.referentDocumentDT + ", items=" + this.items + ", options=" + this.options + '}';
    }
}

