/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model;

import java.util.HashMap;
import java.util.Map;

public enum TaxRateCategoryType {
    TaxOnNet(0),
    TaxOnTotal(1),
    AmountPerQuantity(2);

    private final int value;
    private static final Map<Integer, TaxRateCategoryType> byValue;

    private TaxRateCategoryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TaxRateCategoryType getByValue(int value) {
        return byValue.get(value);
    }

    public static boolean isValueSupported(int value) {
        return byValue.get(value) != null;
    }

    static {
        byValue = new HashMap<Integer, TaxRateCategoryType>();
        for (TaxRateCategoryType p : TaxRateCategoryType.values()) {
            if (byValue.put(p.getValue(), p) == null) continue;
            throw new IllegalArgumentException("duplicated value: " + p.value);
        }
    }
}

