/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore;

import com.dmi.sdccore.I18N;
import com.dmi.sdccore.events.NotificationEvent;
import com.dmi.sdccore.events.NotificationSeverity;
import com.dmi.sdccore.events.SystemEvent;
import com.dmi.sdccore.events.SystemEventType;
import org.greenrobot.eventbus.EventBus;

public class EventManager {
    private static EventManager INSTANCE = new EventManager();

    private EventManager() {
    }

    public static EventManager getInstance() {
        return INSTANCE;
    }

    public void postNotification(String title, String text, NotificationSeverity severity) {
        EventBus.getDefault().post((Object)new NotificationEvent(title, text, severity));
    }

    public void postDefaultNotification(String text) {
        EventBus.getDefault().post((Object)new NotificationEvent("Master LPFR ver 1.1", text, NotificationSeverity.None));
    }

    public void postInfoNotification(String text) {
        this.postNotification(I18N.text("message.info"), text, NotificationSeverity.Info);
    }

    public void postWarningNotification(String text) {
        this.postNotification(I18N.text("message.warn"), text, NotificationSeverity.Warning);
    }

    public void postErrorNotification(String text) {
        this.postNotification(I18N.text("message.error"), text, NotificationSeverity.Error);
    }

    public void postSystemEvent(SystemEventType systemEventType) {
        EventBus.getDefault().post((Object)new SystemEvent(systemEventType));
    }

    public void postUpdateUIEvent() {
        this.postSystemEvent(SystemEventType.UpdateUI);
    }
}

