/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellBase;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetView;
import org.controlsfx.control.spreadsheet.StringConverterWithFormat;

public abstract class SpreadsheetCellType<T> {
    protected StringConverter<T> converter;
    public static final SpreadsheetCellType<Object> OBJECT = new ObjectType();
    public static final StringType STRING = new StringType();
    public static final DoubleType DOUBLE = new DoubleType();
    public static final IntegerType INTEGER = new IntegerType();
    public static final DateType DATE = new DateType();

    public SpreadsheetCellType() {
    }

    public SpreadsheetCellType(StringConverter<T> converter) {
        this.converter = converter;
    }

    public abstract SpreadsheetCellEditor createEditor(SpreadsheetView var1);

    public String toString(T object, String format) {
        return this.toString(object);
    }

    public abstract String toString(T var1);

    public boolean match(Object value) {
        return this.match(value, Collections.emptyList());
    }

    public abstract boolean match(Object var1, Object ... var2);

    public boolean isError(Object value) {
        return false;
    }

    public boolean acceptDrop() {
        return false;
    }

    public abstract T convertValue(Object var1);

    public static final ListType LIST(List<String> items) {
        return new ListType(items);
    }

    public static class DateType
    extends SpreadsheetCellType<LocalDate> {
        public DateType() {
            this((StringConverter<LocalDate>)new StringConverterWithFormat<LocalDate>(){

                public String toString(LocalDate item) {
                    return this.toStringFormat(item, "");
                }

                public LocalDate fromString(String str) {
                    try {
                        return LocalDate.parse(str);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }

                @Override
                public String toStringFormat(LocalDate item, String format) {
                    if ("".equals(format) && item != null) {
                        return item.toString();
                    }
                    if (item != null) {
                        return item.format(DateTimeFormatter.ofPattern(format));
                    }
                    return "";
                }
            });
        }

        public DateType(StringConverter<LocalDate> converter) {
            super(converter);
        }

        public String toString() {
            return "date";
        }

        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, LocalDate value) {
            SpreadsheetCellBase cell = new SpreadsheetCellBase(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.DateEditor(view, (StringConverter<LocalDate>)this.converter);
        }

        @Override
        public boolean match(Object value, Object ... options) {
            if (value instanceof LocalDate) {
                return true;
            }
            try {
                LocalDate temp = (LocalDate)this.converter.fromString(value == null ? null : value.toString());
                return temp != null;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public LocalDate convertValue(Object value) {
            if (value instanceof LocalDate) {
                return (LocalDate)value;
            }
            try {
                return (LocalDate)this.converter.fromString(value == null ? null : value.toString());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String toString(LocalDate item) {
            return this.converter.toString((Object)item);
        }

        @Override
        public String toString(LocalDate item, String format) {
            return ((StringConverterWithFormat)this.converter).toStringFormat(item, format);
        }
    }

    public static class ListType
    extends SpreadsheetCellType<String> {
        protected final List<String> items;

        public ListType(final List<String> items) {
            super(new DefaultStringConverter(){

                public String fromString(String str) {
                    if (str != null && items.contains(str)) {
                        return str;
                    }
                    return null;
                }
            });
            this.items = items;
        }

        public String toString() {
            return "list";
        }

        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, String value) {
            SpreadsheetCellBase cell = new SpreadsheetCellBase(row, column, rowSpan, columnSpan, this);
            if (this.items != null && this.items.size() > 0) {
                if (value != null && this.items.contains(value)) {
                    cell.setItem(value);
                } else {
                    cell.setItem(this.items.get(0));
                }
            }
            return cell;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.ListEditor(view, this.items);
        }

        @Override
        public boolean match(Object value, Object ... options) {
            if (value instanceof String && this.items.contains(value.toString())) {
                return true;
            }
            return this.items.contains(value == null ? null : value.toString());
        }

        @Override
        public String convertValue(Object value) {
            return (String)this.converter.fromString(value == null ? null : value.toString());
        }

        @Override
        public String toString(String item) {
            return this.converter.toString((Object)item);
        }
    }

    public static class IntegerType
    extends SpreadsheetCellType<Integer> {
        public IntegerType() {
            this(new IntegerStringConverter(){

                public String toString(Integer item) {
                    if (item == null || Double.isNaN(item.intValue())) {
                        return "";
                    }
                    return super.toString(item);
                }

                public Integer fromString(String str) {
                    if (str == null || str.isEmpty() || "NaN".equals(str)) {
                        return null;
                    }
                    try {
                        Double temp = Double.parseDouble(str);
                        return temp.intValue();
                    }
                    catch (Exception e) {
                        return super.fromString(str);
                    }
                }
            });
        }

        public IntegerType(IntegerStringConverter converter) {
            super(converter);
        }

        public String toString() {
            return "Integer";
        }

        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, Integer value) {
            SpreadsheetCellBase cell = new SpreadsheetCellBase(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.IntegerEditor(view);
        }

        @Override
        public boolean match(Object value, Object ... options) {
            if (value instanceof Integer) {
                return true;
            }
            try {
                this.converter.fromString(value == null ? null : value.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Integer convertValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            try {
                return (Integer)this.converter.fromString(value == null ? null : value.toString());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String toString(Integer item) {
            return this.converter.toString((Object)item);
        }
    }

    public static class DoubleType
    extends SpreadsheetCellType<Double> {
        public DoubleType() {
            this((StringConverter<Double>)new StringConverterWithFormat<Double>((StringConverter)new DoubleStringConverter()){

                public String toString(Double item) {
                    return this.toStringFormat(item, "");
                }

                public Double fromString(String str) {
                    if (str == null || str.isEmpty() || "NaN".equals(str)) {
                        return Double.NaN;
                    }
                    return (Double)this.myConverter.fromString(str);
                }

                @Override
                public String toStringFormat(Double item, String format) {
                    try {
                        if (item == null || Double.isNaN(item)) {
                            return "";
                        }
                        return new DecimalFormat(format).format(item);
                    }
                    catch (Exception ex) {
                        return this.myConverter.toString((Object)item);
                    }
                }
            });
        }

        public DoubleType(StringConverter<Double> converter) {
            super(converter);
        }

        public String toString() {
            return "double";
        }

        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, Double value) {
            SpreadsheetCellBase cell = new SpreadsheetCellBase(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.DoubleEditor(view);
        }

        @Override
        public boolean match(Object value, Object ... options) {
            if (value instanceof Double) {
                return true;
            }
            try {
                this.converter.fromString(value == null ? null : value.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Double convertValue(Object value) {
            if (value instanceof Double) {
                return (Double)value;
            }
            try {
                return (Double)this.converter.fromString(value == null ? null : value.toString());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String toString(Double item) {
            return this.converter.toString((Object)item);
        }

        @Override
        public String toString(Double item, String format) {
            return ((StringConverterWithFormat)this.converter).toStringFormat(item, format);
        }
    }

    public static class StringType
    extends SpreadsheetCellType<String> {
        public StringType() {
            this((StringConverter<String>)new DefaultStringConverter());
        }

        public StringType(StringConverter<String> converter) {
            super(converter);
        }

        public String toString() {
            return "string";
        }

        @Override
        public boolean match(Object value, Object ... options) {
            return true;
        }

        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, String value) {
            SpreadsheetCellBase cell = new SpreadsheetCellBase(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.StringEditor(view);
        }

        @Override
        public String convertValue(Object value) {
            String convertedValue = (String)this.converter.fromString(value == null ? null : value.toString());
            if (convertedValue == null || convertedValue.equals("")) {
                return null;
            }
            return convertedValue;
        }

        @Override
        public String toString(String item) {
            return this.converter.toString((Object)item);
        }
    }

    public static class ObjectType
    extends SpreadsheetCellType<Object> {
        public ObjectType() {
            this(new StringConverterWithFormat<Object>(){

                public Object fromString(String arg0) {
                    return arg0;
                }

                public String toString(Object arg0) {
                    return arg0 == null ? "" : arg0.toString();
                }
            });
        }

        public ObjectType(StringConverterWithFormat<Object> converter) {
            super(converter);
        }

        public String toString() {
            return "object";
        }

        @Override
        public boolean match(Object value, Object ... options) {
            return true;
        }

        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, Object value) {
            SpreadsheetCellBase cell = new SpreadsheetCellBase(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.ObjectEditor(view);
        }

        @Override
        public Object convertValue(Object value) {
            return value;
        }

        @Override
        public String toString(Object item) {
            return this.converter.toString(item);
        }
    }
}

