/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.api.model.ModelError;
import com.dmi.sdccore.api.model.PropertyError;
import com.dmi.sdccore.api.model.TaxRateGroup;
import com.dmi.sdccore.api.model.invoice.InvoiceItem;
import com.dmi.sdccore.api.model.invoice.InvoicePayment;
import com.dmi.sdccore.api.model.invoice.InvoiceRequest;
import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.dmi.sdccore.model.invoice.CalculatedInvoice;
import com.dmi.sdccore.utils.DateTimeUtil;
import com.dmi.sdccore.utils.NumberUtil;
import com.dmi.sdccore.utils.StringUtil;
import com.dmi.sdccore.utils.TaxUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtil {
    public static final BigDecimal MAX_INVOICE_ITEM_TOTAL_AMOUNT = new BigDecimal("7205759403792.7935");
    public static final BigDecimal MAX_INVOICE_TOTAL_AMOUNT = new BigDecimal("7205759403792.7935");

    public static ModelError validateInvoiceRequest(InvoiceRequest invoiceRequest, String taxCardUid) {
        List<InvoicePayment> payments;
        ModelError modelError = new ModelError();
        if (invoiceRequest.getInvoiceType() == null) {
            modelError.addPropertyError(new PropertyError("invoiceType", Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
        }
        if (invoiceRequest.getTransactionType() == null) {
            modelError.addPropertyError(new PropertyError("transactionType", Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
        }
        if ((payments = invoiceRequest.getPayment()) != null && !payments.isEmpty()) {
            int index = 0;
            for (InvoicePayment payment : payments) {
                if (payment.getPaymentType() == null) {
                    modelError.addPropertyError(new PropertyError(String.format("payment[%d].paymentType", index), Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
                }
                if (payment.getAmount() == null) {
                    modelError.addPropertyError(new PropertyError(String.format("payment[%d].amount", index), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                } else if (payment.getAmount().signum() < 0) {
                    modelError.addPropertyError(new PropertyError(String.format("payment[%d].amount", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                }
                ++index;
            }
        } else {
            modelError.addPropertyError(new PropertyError("payment", Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
        }
        if (invoiceRequest.getTransactionType() != null && invoiceRequest.getInvoiceType() != null && (InvoiceTransactionType.Refund.equals((Object)invoiceRequest.getTransactionType()) || InvoiceType.Copy.equals((Object)invoiceRequest.getInvoiceType()))) {
            String refDocNumber = invoiceRequest.getReferentDocumentNumber();
            if (StringUtils.isBlank((CharSequence)refDocNumber)) {
                modelError.addPropertyError(new PropertyError("referentDocumentNumber", Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
            }
            if (StringUtils.isBlank((CharSequence)invoiceRequest.getReferentDocumentDT())) {
                modelError.addPropertyError(new PropertyError("referentDocumentDT", Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
            }
        }
        if (invoiceRequest.getInvoiceType() == null || InvoiceType.Proforma.equals((Object)invoiceRequest.getInvoiceType())) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getReferentDocumentNumber())) {
            String refDocNumber = invoiceRequest.getReferentDocumentNumber();
            if (refDocNumber.length() > 50) {
                modelError.addPropertyError(new PropertyError("referentDocumentNumber", Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
            } else {
                String[] fields = refDocNumber.split("-");
                if (fields.length != 3 || fields[0].length() != 8 || fields[1].length() != 8 || !StringUtil.isNumeric(fields[2])) {
                    modelError.addPropertyError(new PropertyError("referentDocumentNumber", Collections.singletonList(ApiErrCode.InvalidDataFormat.getCode())));
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getReferentDocumentDT()) && !DateTimeUtil.isValidLocalDateTime(invoiceRequest.getReferentDocumentDT()) && !DateTimeUtil.isValidZonedDateTime(invoiceRequest.getReferentDocumentDT())) {
            modelError.addPropertyError(new PropertyError("referentDocumentDT", Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getDateAndTimeOfIssue()) && !DateTimeUtil.isValidLocalDateTime(invoiceRequest.getDateAndTimeOfIssue()) && !DateTimeUtil.isValidZonedDateTime(invoiceRequest.getDateAndTimeOfIssue())) {
            modelError.addPropertyError(new PropertyError("dateAndTimeOfIssue", Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getCashier()) && invoiceRequest.getCashier().length() > 50) {
            modelError.addPropertyError(new PropertyError("cashier", Collections.singletonList(ApiErrCode.InvalidFieldValueLength.getCode())));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getBuyerCostCenterId())) {
            if (invoiceRequest.getBuyerCostCenterId().length() > 50) {
                modelError.addPropertyError(new PropertyError("buyerCostCenterId", Collections.singletonList(ApiErrCode.FieldValueTooLong.getCode())));
            }
        } else if (invoiceRequest.getBuyerCostCenterId() != null && invoiceRequest.getBuyerCostCenterId().isEmpty()) {
            modelError.addPropertyError(new PropertyError("buyerCostCenterId", Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getBuyerId())) {
            if (invoiceRequest.getBuyerId().length() > 20) {
                modelError.addPropertyError(new PropertyError("buyerId", Collections.singletonList(ApiErrCode.InvalidFieldValueLength.getCode())));
            }
        } else if (invoiceRequest.getBuyerId() != null && invoiceRequest.getBuyerId().isEmpty()) {
            modelError.addPropertyError(new PropertyError("buyerId", Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
            return modelError;
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getBuyerCostCenterId()) && StringUtils.isBlank((CharSequence)invoiceRequest.getBuyerId())) {
            modelError.addPropertyError(new PropertyError("buyerId", Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getInvoiceNumber())) {
            if (invoiceRequest.getInvoiceNumber().length() > 60) {
                modelError.addPropertyError(new PropertyError("invoiceNumber", Collections.singletonList(ApiErrCode.InvalidFieldValueLength.getCode())));
            }
        } else if (invoiceRequest.getInvoiceNumber() != null && invoiceRequest.getInvoiceNumber().isEmpty()) {
            modelError.addPropertyError(new PropertyError("invoiceNumber", Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
        }
        Map<String, String> options = invoiceRequest.getOptions();
        List<String> supportedKeys = Arrays.asList("omitQRCodeGen", "omitTextualRepresentation");
        List<Integer> supportedValues = Arrays.asList(0, 1);
        if (options != null && !options.isEmpty()) {
            Set<String> optionsKeySet = options.keySet();
            for (String optionKey : optionsKeySet) {
                String optionValue = options.get(optionKey);
                if (optionValue != null && StringUtil.isNumeric(optionValue) && supportedValues.contains(Integer.parseInt(optionValue))) continue;
                modelError.addPropertyError(new PropertyError("options." + optionKey, Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
            }
        }
        return modelError;
    }

    public static ModelError validateInvoiceRequestItemsAndTaxRates(InvoiceRequest invoiceRequest, TaxRateGroup taxRateGroup) {
        ModelError modelError = new ModelError();
        if (taxRateGroup != null) {
            List<InvoiceItem> items = invoiceRequest.getItems();
            if (items != null && !items.isEmpty()) {
                int index = 0;
                for (InvoiceItem item : items) {
                    if (StringUtils.isBlank((CharSequence)item.getName())) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].name", index), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                    } else if (item.getName().length() > 2048) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].name", index), Collections.singletonList(ApiErrCode.InvalidFieldValueLength.getCode())));
                    }
                    if (item.getUnitPrice() == null) {
                        if (StringUtils.isBlank((CharSequence)item.getUnitPriceStr())) {
                            modelError.addPropertyError(new PropertyError(String.format("items[%d].unitPrice", index), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                        } else {
                            modelError.addPropertyError(new PropertyError(String.format("items[%d].unitPrice", index), Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
                        }
                    } else if (item.getUnitPrice().signum() < 0) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].unitPrice", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    } else if (!NumberUtil.has2DecimalPlaces(item.getUnitPrice())) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].unitPrice", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    } else if (item.getUnitPrice().compareTo(new BigDecimal("999999999999.99")) > 0) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].unitPrice", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    }
                    if (item.getQuantity() == null) {
                        if (StringUtils.isBlank((CharSequence)item.getQuantityStr())) {
                            modelError.addPropertyError(new PropertyError(String.format("items[%d].quantity", index), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                        } else {
                            modelError.addPropertyError(new PropertyError(String.format("items[%d].quantity", index), Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
                        }
                    } else if (item.getQuantity().signum() <= 0) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].quantity", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    } else if (!NumberUtil.has3DecimalPlaces(item.getQuantity())) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].quantity", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    } else if (item.getQuantity().compareTo(new BigDecimal("99999999999.999")) > 0) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].quantity", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    }
                    if (item.getTotalAmount() == null) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].totalAmount", index), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                    } else if (item.getTotalAmount().signum() < 0) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].totalAmount", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    } else if (!NumberUtil.has2DecimalPlaces(item.getTotalAmount())) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].totalAmount", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    } else if (item.getTotalAmount().compareTo(MAX_INVOICE_ITEM_TOTAL_AMOUNT) > 0) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].totalAmount", index), Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
                    }
                    List<String> itemLabels = item.getLabels();
                    if (itemLabels != null && !itemLabels.isEmpty()) {
                        int labelIndex = 0;
                        for (String label : itemLabels) {
                            if (StringUtils.isBlank((CharSequence)label)) {
                                modelError.addPropertyError(new PropertyError(String.format("items[%d].labels[%d]", index, labelIndex), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                            } else if (label.length() == 1) {
                                if (TaxUtil.getTaxRateByLabel(label, taxRateGroup) == null) {
                                    modelError.addPropertyError(new PropertyError(String.format("items[%d].labels[%d]", index, labelIndex), Collections.singletonList(ApiErrCode.InvalidTaxLabels.getCode())));
                                }
                            } else {
                                modelError.addPropertyError(new PropertyError(String.format("items[%d].labels[%d]", index, labelIndex), Collections.singletonList(ApiErrCode.InvalidFieldValue.getCode())));
                            }
                            ++labelIndex;
                        }
                    } else {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].labels", index), Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
                    }
                    if (item.getGtin() != null && (item.getGtin().length() < 1 || item.getGtin().length() > 14)) {
                        modelError.addPropertyError(new PropertyError(String.format("items[%d].gtin", index), Collections.singletonList(ApiErrCode.InvalidFieldValueLength.getCode())));
                    }
                    ++index;
                }
            } else {
                modelError.addPropertyError(new PropertyError("items", Collections.singletonList(ApiErrCode.FieldValueMissing.getCode())));
            }
        } else {
            modelError.addPropertyError(new PropertyError("referentDocumentDT", Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
        }
        return modelError;
    }

    public static ModelError validateCalculatedInvoice(CalculatedInvoice calculatedInvoice) {
        ModelError modelError = new ModelError();
        if (calculatedInvoice.getInvoiceAmount().compareTo(MAX_INVOICE_TOTAL_AMOUNT) > 0) {
            modelError.addPropertyError(new PropertyError("invoice.totalAmount", Collections.singletonList(ApiErrCode.FieldValueOutOfRange.getCode())));
        }
        return modelError;
    }
}

