/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.I18N;
import com.dmi.sdccore.api.model.TaxRateCategoryType;
import com.dmi.sdccore.api.model.invoice.Invoice;
import com.dmi.sdccore.api.model.invoice.InvoiceItem;
import com.dmi.sdccore.api.model.invoice.InvoicePayment;
import com.dmi.sdccore.api.model.invoice.InvoiceRequest;
import com.dmi.sdccore.api.model.invoice.InvoiceResult;
import com.dmi.sdccore.api.model.invoice.InvoiceResultTaxItem;
import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.dmi.sdccore.utils.DateTimeUtil;
import com.dmi.sdccore.utils.TaxUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TaxReceiptUtil {
    public static final String RECEIPT_DATE_TIME_FORMAT = "dd.MM.yyyy. HH:mm:ss";
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    private static final DecimalFormat decFormatAmount;
    private static final DecimalFormat decFormatQuantity;

    public static String createReceiptPrintout(Invoice invoice, int lineWidth) {
        InvoiceRequest invoiceRequest = invoice.getRequest();
        InvoiceResult invoiceResult = invoice.getResult();
        ArrayList<String> lines = new ArrayList<String>();
        if (InvoiceType.Copy == invoiceRequest.getInvoiceType() || InvoiceType.Training == invoiceRequest.getInvoiceType() || InvoiceType.Proforma == invoiceRequest.getInvoiceType()) {
            lines.addAll(TaxReceiptUtil.paddedLines(" " + I18N.text("text.receipt.not.fiscal.invoice") + " ", Direction.center, "=", lineWidth));
        } else {
            lines.addAll(TaxReceiptUtil.paddedLines(" " + I18N.text("text.receipt.fiscal.invoice") + " ", Direction.center, "=", lineWidth));
        }
        lines.addAll(TaxReceiptUtil.paddedLines(invoiceResult.getTin(), Direction.center, lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines(invoiceResult.getBusinessName(), Direction.center, lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines(invoiceResult.getLocationName(), Direction.center, lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines(invoiceResult.getAddress(), Direction.center, lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines(invoiceResult.getDistrict(), Direction.center, lineWidth));
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getCashier())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.cashier") + ":", invoiceRequest.getCashier(), lineWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getBuyerId())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.buyerid") + ":", invoiceRequest.getBuyerId(), lineWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getBuyerCostCenterId())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.buyercostcenterid") + ":", invoiceRequest.getBuyerCostCenterId(), lineWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getInvoiceNumber())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.posnumber") + ":", invoiceRequest.getInvoiceNumber(), lineWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getDateAndTimeOfIssue())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.postime") + ":", DateTimeUtil.toReceiptDateTimeString(invoiceRequest.getDateAndTimeOfIssue()), lineWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getReferentDocumentNumber())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.refdocnumber") + ":", invoiceRequest.getReferentDocumentNumber(), lineWidth));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceRequest.getReferentDocumentDT())) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.refdoctime") + ":", DateTimeUtil.toReceiptDateTimeString(invoiceRequest.getReferentDocumentDT()), lineWidth));
        }
        lines.addAll(TaxReceiptUtil.paddedLines(" " + TaxReceiptUtil.getInvoiceTitle(invoiceRequest.getInvoiceType(), invoiceRequest.getTransactionType()) + " ", Direction.center, "-", lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines(I18N.text("text.receipt.items"), Direction.center, lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines("=", Direction.right, "=", lineWidth));
        int[] colWidths = TaxReceiptUtil.itemHeaderColumnWidths(7, lineWidth);
        lines.add(TaxReceiptUtil.lineWithTaxCategories(I18N.text("text.receipt.item.name"), colWidths[0], I18N.text("text.receipt.item.price"), colWidths[1], I18N.text("text.receipt.item.quantity"), colWidths[2], I18N.text("text.receipt.item.total"), lineWidth));
        int[] itemDataColWidths = TaxReceiptUtil.itemDataColumnWidths(7, lineWidth);
        for (InvoiceItem invoiceItem : invoiceRequest.getItems()) {
            String itemName = String.format("%s (%s)", invoiceItem.getName(), String.join((CharSequence)",", invoiceItem.getLabels()));
            lines.addAll(TaxReceiptUtil.paddedLines(itemName, Direction.right, lineWidth));
            lines.add(TaxReceiptUtil.lineWithTaxCategories(" ", itemDataColWidths[0], TaxReceiptUtil.formatAmountForPrint(invoiceItem.getUnitPrice()), itemDataColWidths[1], TaxReceiptUtil.formatQuantityForPrint(invoiceItem.getQuantity()), itemDataColWidths[2], TaxReceiptUtil.formatAmountForPrint(invoiceRequest.getTransactionType() == InvoiceTransactionType.Sale ? invoiceItem.getTotalAmount() : invoiceItem.getTotalAmount().negate()), lineWidth));
        }
        lines.addAll(TaxReceiptUtil.paddedLines("-", Direction.right, "-", lineWidth));
        lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.totalamount." + invoiceRequest.getTransactionType().name()) + ":", TaxReceiptUtil.formatAmountForPrint(invoiceResult.getTotalAmount()), lineWidth));
        for (InvoicePayment invoicePayment : invoiceRequest.getPayment()) {
            lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.pay.type." + invoicePayment.getPaymentType().name()) + ":", TaxReceiptUtil.formatAmountForPrint(invoicePayment.getAmount()), lineWidth));
        }
        lines.addAll(TaxReceiptUtil.paddedLines("=", Direction.right, "=", lineWidth));
        if (InvoiceType.Copy == invoiceRequest.getInvoiceType() || InvoiceType.Training == invoiceRequest.getInvoiceType() || InvoiceType.Proforma == invoiceRequest.getInvoiceType()) {
            lines.addAll(TaxReceiptUtil.paddedLines(I18N.text("text.receipt.not.fiscal.invoice"), Direction.center, " ", lineWidth));
            lines.addAll(TaxReceiptUtil.paddedLines("=", Direction.right, "=", lineWidth));
        }
        colWidths = TaxReceiptUtil.taxColumnWidths(7, lineWidth);
        lines.add(TaxReceiptUtil.lineWithTaxCategories(I18N.text("text.receipt.tax.mark"), colWidths[0], I18N.text("text.receipt.tax.name"), colWidths[1], I18N.text("text.receipt.tax.rate"), colWidths[2], I18N.text("text.receipt.tax.tax"), lineWidth));
        for (InvoiceResultTaxItem taxItem : invoiceResult.getTaxItems()) {
            String taxRateSufix = taxItem.getCategoryType().intValue() == TaxRateCategoryType.AmountPerQuantity.getValue() ? "$" : "%";
            lines.add(TaxReceiptUtil.lineWithTaxCategories(taxItem.getLabel(), colWidths[0], taxItem.getCategoryName(), colWidths[1], TaxReceiptUtil.formatAmountForPrint(taxItem.getRate()) + taxRateSufix, colWidths[2], TaxReceiptUtil.formatAmountForPrint(taxItem.getAmount()), lineWidth));
        }
        lines.addAll(TaxReceiptUtil.paddedLines("-", Direction.right, "-", lineWidth));
        lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.tax.totalamount") + ":", TaxReceiptUtil.formatAmountForPrint(invoiceResult.getTotalTaxAmount()), lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines("=", Direction.right, "=", lineWidth));
        lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.sdc.time") + ":", DateTimeUtil.toReceiptDateTimeString(invoiceResult.getSdcDateTime()), lineWidth));
        lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.sdc.invoicenumber") + ":", invoiceResult.getInvoiceNumber(), lineWidth));
        lines.addAll(TaxReceiptUtil.labelValueLine(I18N.text("text.receipt.sdc.invoicecounter") + ":", invoiceResult.getInvoiceCounter(), lineWidth));
        lines.addAll(TaxReceiptUtil.paddedLines("=", Direction.right, "=", lineWidth));
        if (InvoiceType.Copy == invoiceRequest.getInvoiceType() || InvoiceType.Training == invoiceRequest.getInvoiceType() || InvoiceType.Proforma == invoiceRequest.getInvoiceType()) {
            lines.addAll(TaxReceiptUtil.paddedLines(I18N.text("text.receipt.not.fiscal.invoice"), Direction.center, "=", lineWidth));
        } else {
            lines.addAll(TaxReceiptUtil.paddedLines(I18N.text("text.receipt.fiscal.invoice.end"), Direction.center, "=", lineWidth));
        }
        StringBuilder str = new StringBuilder();
        lines.forEach(str::append);
        return str.toString();
    }

    public static List<String> paddedLines(String text, Direction direction, int lineWidth) {
        return TaxReceiptUtil.paddedLines(text, direction, " ", lineWidth);
    }

    public static List<String> paddedLines(String text, Direction direction, String padChar, int lineWidth) {
        List<String> originalLines = TaxReceiptUtil.splitTextIntoSubstrings(text, lineWidth);
        ArrayList<String> paddedLines = new ArrayList<String>(originalLines.size());
        for (String originalLine : originalLines) {
            String paddedLine = TaxReceiptUtil.padText(originalLine, direction, lineWidth, padChar);
            paddedLine = paddedLine + "\r\n";
            paddedLines.add(paddedLine);
        }
        return paddedLines;
    }

    public static String lineWithTaxCategories(String colText1, int colWidth1, String colText2, int colWidth2, String colText3, int colWidth3, String colText4, int lineWidth) {
        int colWidth4 = lineWidth - colWidth1 - colWidth2 - colWidth3;
        return TaxReceiptUtil.padText(colText1, Direction.right, colWidth1) + TaxReceiptUtil.padText(colText2, Direction.left, colWidth2) + TaxReceiptUtil.padText(colText3, Direction.left, colWidth3) + TaxReceiptUtil.padText(colText4, Direction.left, colWidth4) + "\r\n";
    }

    public static List<String> labelValueLine(String labelText, String valueText, int lineWidth) {
        ArrayList<String> lines;
        if (labelText.length() + valueText.length() < lineWidth) {
            lines = new ArrayList();
            int padLength = lineWidth - labelText.length();
            String paddedValue = TaxReceiptUtil.padText(valueText, Direction.left, padLength, " ");
            lines.add(labelText + paddedValue + "\r\n");
        } else {
            lines = TaxReceiptUtil.paddedLines(labelText + " " + valueText, Direction.right, lineWidth);
        }
        return lines;
    }

    public static List<String> splitTextIntoSubstrings(String text, int lineWidth) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int index = 0; index < text.length(); index += lineWidth) {
            strings.add(text.substring(index, Math.min(index + lineWidth, text.length())));
        }
        return strings;
    }

    public static String padText(String text, Direction padding, Integer maxLength) {
        return TaxReceiptUtil.padText(text, padding, maxLength, " ");
    }

    public static String padText(String text, Direction padding, Integer maxLength, String padChar) {
        if (StringUtils.isEmpty((CharSequence)padChar)) {
            padChar = " ";
        }
        if (padding != null && maxLength != null) {
            int padLength = maxLength - text.length();
            if (padLength > 0) {
                if (padding == Direction.left) {
                    text = StringUtils.leftPad((String)text, (int)maxLength, (String)padChar);
                } else if (padding == Direction.right) {
                    text = StringUtils.rightPad((String)text, (int)maxLength, (String)padChar);
                } else if (padding == Direction.center) {
                    int paddingLeft = padLength / 2;
                    int paddingRight = padLength - paddingLeft;
                    text = StringUtils.leftPad((String)text, (int)(paddingLeft + text.length()), (String)padChar);
                    text = StringUtils.rightPad((String)text, (int)(paddingRight + text.length()), (String)padChar);
                }
            } else {
                text = text.substring(0, maxLength);
            }
        }
        return text;
    }

    public static String getInvoiceTitle(InvoiceType invoiceType, InvoiceTransactionType invoiceTransactionType) {
        String invoiceTypeExtension = I18N.text("text.invoice.type." + invoiceType.name());
        String invoiceTransactionTypeExtension = I18N.text("text.trans.type." + invoiceTransactionType.name());
        return invoiceTypeExtension.concat(" ").concat(invoiceTransactionTypeExtension);
    }

    public static int[] itemHeaderColumnWidths(int firstColWidth, int lineWidth) {
        int remainingSize = lineWidth - firstColWidth;
        int secondColWidth = remainingSize * 20 / 100;
        int thirdColWidth = remainingSize * 35 / 100;
        return new int[]{firstColWidth, secondColWidth, thirdColWidth};
    }

    public static int[] itemDataColumnWidths(int firstColWidth, int lineWidth) {
        int remainingSize = lineWidth - firstColWidth;
        int secondColWidth = remainingSize * 20 / 100 + firstColWidth - 1;
        int thirdColWidth = remainingSize * 35 / 100;
        return new int[]{1, secondColWidth, thirdColWidth};
    }

    public static int[] taxColumnWidths(int firstColWidth, int lineWidth) {
        int remainingSize = lineWidth - firstColWidth;
        int secondColWidth = remainingSize * 30 / 100;
        int thirdColWidth = remainingSize * 25 / 100;
        return new int[]{firstColWidth, secondColWidth, thirdColWidth};
    }

    public static String formatAmountForPrint(BigDecimal decimal) {
        BigDecimal roundedDecimal = TaxUtil.round(decimal, 2);
        return decFormatAmount.format(roundedDecimal);
    }

    public static String formatQuantityForPrint(BigDecimal decimal) {
        return decFormatQuantity.format(decimal);
    }

    static {
        decimalFormatSymbols.setDecimalSeparator(',');
        decimalFormatSymbols.setGroupingSeparator('.');
        decFormatAmount = new DecimalFormat("#,##0.00", decimalFormatSymbols);
        decFormatQuantity = new DecimalFormat("#,##0.###", decimalFormatSymbols);
    }

    public static enum Direction {
        left,
        center,
        right;

    }
}

