/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.api.model.invoice.InvoiceRequest;
import com.dmi.sdccore.model.invoice.CalculatedInvoice;
import com.dmi.sdccore.model.invoice.CalculatedTaxCategoryAmount;
import com.dmi.sdccore.utils.TaxUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;

public class ApduUtil {
    public static byte[] toBcdByteArray(int num) {
        ArrayList<Byte> listOfBytes = new ArrayList<Byte>();
        while (num >= 0) {
            listOfBytes.add((byte)(num % 10));
            if ((num /= 10) != 0) continue;
        }
        Collections.reverse(listOfBytes);
        Byte[] bytes = new Byte[listOfBytes.size()];
        return ArrayUtils.toPrimitive((Byte[])listOfBytes.toArray(bytes));
    }

    public static byte[] toBcdByteArray(String num) {
        ArrayList<Byte> listOfBytes = new ArrayList<Byte>();
        for (int i = 0; i < num.length(); ++i) {
            String digit = num.substring(i, i + 1);
            listOfBytes.add(Byte.parseByte(digit));
        }
        Byte[] bytes = new Byte[listOfBytes.size()];
        return ArrayUtils.toPrimitive((Byte[])listOfBytes.toArray(bytes));
    }

    public static byte[] getApduPin(String num) {
        return ApduUtil.toBcdByteArray(num);
    }

    public static byte[] getHexEncodedByteArray(String str) {
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] convertToBEByteArray(long number) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(number);
        return buffer.array();
    }

    public static byte[] convertToLEByteArray(long number) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(number);
        return buffer.array();
    }

    public static byte[] convertToBEByteArray(int number) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(number);
        return buffer.array();
    }

    public static byte[] convertToLEByteArray(int number) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(number);
        return buffer.array();
    }

    public static long bytesBEToLong(byte[] bytes) {
        return ApduUtil.bytesBEToLong(bytes, false);
    }

    public static long bytesBEToLong(byte[] bytes, boolean appendZeroesIfNeeded) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (appendZeroesIfNeeded && bytes.length < 8) {
            for (int zeroesToFill = 8 - bytes.length; zeroesToFill > 0; --zeroesToFill) {
                buffer.put((byte)0);
            }
        }
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public static int bytesBEToInt(byte[] bytes) {
        return ApduUtil.bytesBEToInt(bytes, false);
    }

    public static int bytesBEToInt(byte[] bytes, boolean appendZeroesIfNeeded) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (appendZeroesIfNeeded && bytes.length < 8) {
            for (int zeroesToFill = 8 - bytes.length; zeroesToFill > 0; --zeroesToFill) {
                buffer.put((byte)0);
            }
        }
        buffer.put(bytes);
        buffer.flip();
        return buffer.getInt();
    }

    public static byte[] appendZeroesToTotalLength(byte[] bytes, int totalLength) {
        ByteBuffer buffer = ByteBuffer.allocate(totalLength);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (bytes.length < totalLength) {
            for (int zeroesToFill = totalLength - bytes.length; zeroesToFill > 0; --zeroesToFill) {
                buffer.put((byte)0);
            }
        }
        buffer.put(bytes);
        return buffer.array();
    }

    public static byte[] copyOfRange(byte[] originalArray, int from, int to) {
        return Arrays.copyOfRange(originalArray, from, to);
    }

    public static String parseApiVersion(byte[] apiVersion) {
        int i;
        int major = 0;
        int minor = 0;
        int patch = 0;
        int offset = 0;
        for (i = 0; i < 4; ++i) {
            major = (int)((double)major + (double)apiVersion[i + offset] * Math.pow(10.0, i - 3));
        }
        offset += 4;
        for (i = 0; i < 4; ++i) {
            minor = (int)((double)minor + (double)apiVersion[i + offset] * Math.pow(10.0, i - 3));
        }
        offset += 4;
        for (i = 0; i < 4; ++i) {
            patch = (int)((double)patch + (double)apiVersion[i + offset] * Math.pow(10.0, i - 3));
        }
        return String.format("%d.%d.%d", major, minor, patch);
    }

    public static boolean isAuditRequired(byte[] cardAmountBytes) throws Exception {
        long maxAmountLong;
        long currentAmountLong = ApduUtil.bytesBEToLong(ApduUtil.copyOfRange(cardAmountBytes, 0, 7), true);
        return (double)currentAmountLong / (double)(maxAmountLong = ApduUtil.bytesBEToLong(ApduUtil.copyOfRange(cardAmountBytes, 7, 14), true)) >= 0.75;
    }

    public static byte[] toUnixTimestamp(ZonedDateTime zonedDateTime) {
        long epochMs = zonedDateTime.toInstant().getEpochSecond() * 1000L;
        byte[] b8 = ApduUtil.convertToBEByteArray(epochMs);
        return b8;
    }

    public static byte[] toUnixTimestamp(LocalDateTime localDateTime) {
        long epochMs = localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
        byte[] b8 = ApduUtil.convertToBEByteArray(epochMs);
        return b8;
    }

    public static String zero_pad_bin_char(String bin_char) {
        int len = bin_char.length();
        if (len == 8) {
            return bin_char;
        }
        String zero_pad = "0";
        for (int i = 1; i < 8 - len; ++i) {
            zero_pad = zero_pad + "0";
        }
        return zero_pad + bin_char;
    }

    public static String plaintext_to_binary(String pt) {
        return ApduUtil.hex_to_binary(ApduUtil.plaintext_to_hex(pt));
    }

    public static String binary_to_plaintext(String bin) {
        return ApduUtil.hex_to_plaintext(ApduUtil.binary_to_hex(bin));
    }

    public static String plaintext_to_hex(String pt) {
        String hex = "";
        for (int i = 0; i < pt.length(); ++i) {
            String hex_char = Integer.toHexString(pt.charAt(i));
            hex = i == 0 ? hex_char : hex + hex_char;
        }
        return hex;
    }

    public static String binary_to_hex(String binary) {
        String hex = "";
        int len = binary.length() / 8;
        for (int i = 0; i < len; ++i) {
            String bin_char = binary.substring(8 * i, 8 * i + 8);
            int conv_int = Integer.parseInt(bin_char, 2);
            String hex_char = Integer.toHexString(conv_int);
            hex = i == 0 ? hex_char : hex + hex_char;
        }
        return hex;
    }

    public static String hex_to_binary(String hex) {
        String binary = "";
        int len = hex.length() / 2;
        for (int i = 0; i < len; ++i) {
            String hex_char = hex.substring(2 * i, 2 * i + 2);
            int conv_int = Integer.parseInt(hex_char, 16);
            String bin_char = Integer.toBinaryString(conv_int);
            bin_char = ApduUtil.zero_pad_bin_char(bin_char);
            binary = i == 0 ? bin_char : binary + bin_char;
        }
        return binary;
    }

    public static String hex_to_plaintext(String hex) {
        StringBuilder plaintext = new StringBuilder();
        int len = hex.length() / 2;
        for (int i = 0; i < len; ++i) {
            String hex_char = hex.substring(2 * i, 2 * i + 2);
            char pt_char = (char)Integer.parseInt(hex_char, 16);
            plaintext.append(pt_char);
        }
        return plaintext.toString();
    }

    public static byte[] convertAmountTo7ByteApduPacket(BigDecimal amount) {
        long amountLong = amount.multiply(TaxUtil.DECIMAL_10K).longValue();
        byte[] amount8Bytes = ApduUtil.convertToBEByteArray(amountLong);
        byte[] amount7Bytes = ApduUtil.copyOfRange(amount8Bytes, 1, amount8Bytes.length);
        return amount7Bytes;
    }

    public static byte[] convertAmountToLE8ByteApduPacket(BigDecimal amount) {
        long amountLong = amount.multiply(TaxUtil.DECIMAL_10K).longValue();
        byte[] amount8Bytes = ApduUtil.convertToLEByteArray(amountLong);
        return amount8Bytes;
    }

    public static byte[] convertInvoiceRequestToApduBytes(InvoiceRequest invoiceRequest, CalculatedInvoice calculatedInvoice, String tin, ZonedDateTime sdcDatetime) {
        ByteBuffer outBuffer = ByteBuffer.allocate(58 + 8 * calculatedInvoice.getNumberOfTaxCategories());
        outBuffer.order(ByteOrder.BIG_ENDIAN);
        byte[] sdcDatetimeByteArray = ApduUtil.toUnixTimestamp(sdcDatetime);
        outBuffer.put(sdcDatetimeByteArray);
        byte[] tinByteArray = ApduUtil.appendZeroesToTotalLength(ApduUtil.getHexEncodedByteArray(tin), 20);
        outBuffer.put(tinByteArray);
        byte[] buyerIdByteArray = invoiceRequest.getBuyerId() != null && !invoiceRequest.getBuyerId().isEmpty() ? ApduUtil.appendZeroesToTotalLength(ApduUtil.getHexEncodedByteArray(invoiceRequest.getBuyerId()), 20) : ApduUtil.appendZeroesToTotalLength(new byte[0], 20);
        outBuffer.put(buyerIdByteArray);
        byte[] invoiceTypeBytes = ApduUtil.toBcdByteArray(invoiceRequest.getInvoiceType().getValue());
        outBuffer.put(invoiceTypeBytes);
        byte[] transactionTypeBytes = ApduUtil.toBcdByteArray(invoiceRequest.getTransactionType().getValue());
        outBuffer.put(transactionTypeBytes);
        byte[] invoiceAmount7Bytes = ApduUtil.convertAmountTo7ByteApduPacket(calculatedInvoice.getInvoiceAmount());
        outBuffer.put(invoiceAmount7Bytes);
        byte[] numberOfTaxCategoriesBytes = ApduUtil.toBcdByteArray(calculatedInvoice.getNumberOfTaxCategories());
        outBuffer.put(numberOfTaxCategoriesBytes);
        for (CalculatedTaxCategoryAmount calculatedTaxCategoryAmount : calculatedInvoice.getTaxCategoryAmounts()) {
            outBuffer.put(ApduUtil.toBcdByteArray(calculatedTaxCategoryAmount.getCategory().getOrderId()));
            outBuffer.put(ApduUtil.convertAmountTo7ByteApduPacket(calculatedTaxCategoryAmount.getTaxAmount()));
        }
        return outBuffer.array();
    }
}

