/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore;

import com.dmi.sdccore.utils.RandomString;
import com.dmi.sdccore.utils.helpers.OrderedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class AppSettings {
    private static final AppSettings INSTANCE = new AppSettings();
    private OrderedProperties properties = new OrderedProperties();
    private boolean showUiNotifications = true;
    private static final String PROPERTIES_FILE_NAME = "../config.properties";
    public static final String PN_SDC_SERIAL_NUMBER = "sdcSerialNumber";
    public static final String PN_POS_PRINTER_LINE_WIDTH_CHARS = "posPrinterLineWidthChars";
    public static final String PN_DEFAULT_SMART_CARD_READER_NAME = "smartCardReaderName";
    public static final String PN_SDC_TCP_PORT = "sdcTcpPort";
    public static final String PN_SDC_LCD_PORT = "sdcLcdPort";
    public static final String PN_SDC_LICENSE = "sdcLicense";
    public static final String SDC_DEFAULT_TCP_PORT = "8085";
    public static final int DEFAULT_POS_PRINTER_LINE_WIDTH_CHARS = 40;

    private AppSettings() {
    }

    public static AppSettings getInstance() {
        return INSTANCE;
    }

    public boolean isShowUiNotifications() {
        return this.showUiNotifications;
    }

    public void setShowUiNotifications(boolean showUiNotifications) {
        this.showUiNotifications = showUiNotifications;
    }

    public String getSdcSerialNumber() {
        return this.properties.getProperty(PN_SDC_SERIAL_NUMBER);
    }

    public String getPosPrinterLineWidthChars() {
        return this.properties.getProperty(PN_POS_PRINTER_LINE_WIDTH_CHARS);
    }

    public int getSdcTcpPort() {
        try {
            return Integer.parseInt(this.properties.getProperty(PN_SDC_TCP_PORT));
        }
        catch (Exception exception) {
            return Integer.parseInt(SDC_DEFAULT_TCP_PORT);
        }
    }

    public String getSdcLicense() {
        String license = this.properties.getProperty(PN_SDC_LICENSE);
        if (license == null) {
            license = "";
        }
        return license;
    }

    public String getDefaultSmartCardReaderName() {
        return this.properties.getProperty(PN_DEFAULT_SMART_CARD_READER_NAME);
    }

    public String getDeviceSerialNumberMrc() {
        return String.format("%s-%s-%s", "75", "0001", AppSettings.getInstance().getSdcSerialNumber());
    }

    public OrderedProperties getProperties() {
        return this.properties;
    }

    public void setProperties(OrderedProperties properties) {
        this.properties = properties;
    }

    public void loadProperties() throws IOException {
        File file = new File(PROPERTIES_FILE_NAME);
        FileInputStream fi = new FileInputStream(file);
        this.properties.load(fi);
        fi.close();
    }

    public void saveProperties() throws IOException {
        File file = new File(PROPERTIES_FILE_NAME);
        FileOutputStream fr = new FileOutputStream(file);
        this.properties.store(fr, "SDC properties");
        fr.close();
    }

    public void setPropertyAndSave(String propertyKey, String value) throws IOException {
        this.getProperties().setProperty(propertyKey, value);
        this.saveProperties();
    }

    public void createDefaultProperties() throws IOException {
        File file = new File(PROPERTIES_FILE_NAME);
        if (!file.exists()) {
            String serial = new RandomString(12).nextString();
            this.properties.setProperty(PN_SDC_SERIAL_NUMBER, serial);
            this.properties.setProperty(PN_POS_PRINTER_LINE_WIDTH_CHARS, "48");
            this.properties.setProperty(PN_DEFAULT_SMART_CARD_READER_NAME, "");
            this.properties.setProperty(PN_SDC_TCP_PORT, SDC_DEFAULT_TCP_PORT);
            this.properties.setProperty(PN_SDC_LICENSE, "");
            FileOutputStream fr = new FileOutputStream(file);
            this.properties.store(fr, "SDC properties");
            fr.close();
        }
    }
}

