/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpDirEntry;
import sun.net.ftp.FtpDirParser;
import sun.net.ftp.FtpProtocolException;
import sun.net.ftp.FtpReplyCode;
import sun.util.logging.PlatformLogger;

public class FtpClient
extends sun.net.ftp.FtpClient {
    private static int defaultSoTimeout;
    private static int defaultConnectTimeout;
    private static final PlatformLogger logger;
    private Proxy proxy;
    private Socket server;
    private PrintStream out;
    private InputStream in;
    private int readTimeout = -1;
    private int connectTimeout = -1;
    private static String encoding;
    private InetSocketAddress serverAddr;
    private boolean replyPending = false;
    private boolean loggedIn = false;
    private boolean useCrypto = false;
    private SSLSocketFactory sslFact;
    private Socket oldSocket;
    private Vector<String> serverResponse = new Vector(1);
    private FtpReplyCode lastReplyCode = null;
    private String welcomeMsg;
    private final boolean passiveMode = true;
    private FtpClient.TransferType type = FtpClient.TransferType.BINARY;
    private long restartOffset = 0L;
    private long lastTransSize = -1L;
    private String lastFileName;
    private static String[] patStrings;
    private static int[][] patternGroups;
    private static Pattern[] patterns;
    private static Pattern linkp;
    private DateFormat df = DateFormat.getDateInstance(2, Locale.US);
    private FtpDirParser parser = new DefaultParser();
    private FtpDirParser mlsxParser = new MLSxParser();
    private static Pattern transPat;
    private static Pattern epsvPat;
    private static Pattern pasvPat;
    private static String[] MDTMformats;
    private static SimpleDateFormat[] dateFormats;

    private static boolean isASCIISuperset(String string) throws Exception {
        String string2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] byArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        byte[] byArray2 = string2.getBytes(string);
        return Arrays.equals(byArray2, byArray);
    }

    private void getTransferSize() {
        Matcher matcher;
        this.lastTransSize = -1L;
        String string = this.getLastResponseString();
        if (transPat == null) {
            transPat = Pattern.compile("150 Opening .*\\((\\d+) bytes\\).");
        }
        if ((matcher = transPat.matcher(string)).find()) {
            String string2 = matcher.group(1);
            this.lastTransSize = Long.parseLong(string2);
        }
    }

    private void getTransferName() {
        this.lastFileName = null;
        String string = this.getLastResponseString();
        int n = string.indexOf("unique file name:");
        int n2 = string.lastIndexOf(41);
        if (n >= 0) {
            this.lastFileName = string.substring(n += 17, n2);
        }
    }

    private int readServerResponse() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(32);
        int n2 = -1;
        this.serverResponse.setSize(0);
        while (true) {
            int n3;
            if ((n3 = this.in.read()) != -1) {
                if (n3 == 13 && (n3 = this.in.read()) != 10) {
                    stringBuffer.append('\r');
                }
                stringBuffer.append((char)n3);
                if (n3 != 10) continue;
            }
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("Server [" + this.serverAddr + "] --> " + string);
            }
            if (string.isEmpty()) {
                n = -1;
            } else {
                try {
                    n = Integer.parseInt(string.substring(0, 3));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    continue;
                }
            }
            this.serverResponse.addElement(string);
            if (n2 != -1) {
                if (n != n2 || string.length() >= 4 && string.charAt(3) == '-') continue;
                n2 = -1;
                break;
            }
            if (string.length() < 4 || string.charAt(3) != '-') break;
            n2 = n;
        }
        return n;
    }

    private void sendServer(String string) {
        this.out.print(string);
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("Server [" + this.serverAddr + "] <-- " + string);
        }
    }

    private String getResponseString() {
        return this.serverResponse.elementAt(0);
    }

    private Vector<String> getResponseStrings() {
        return this.serverResponse;
    }

    private boolean readReply() throws IOException {
        this.lastReplyCode = FtpReplyCode.find(this.readServerResponse());
        if (this.lastReplyCode.isPositivePreliminary()) {
            this.replyPending = true;
            return true;
        }
        if (this.lastReplyCode.isPositiveCompletion() || this.lastReplyCode.isPositiveIntermediate()) {
            if (this.lastReplyCode == FtpReplyCode.CLOSING_DATA_CONNECTION) {
                this.getTransferName();
            }
            return true;
        }
        return false;
    }

    private boolean issueCommand(String string) throws IOException, FtpProtocolException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (this.replyPending) {
            try {
                this.completePending();
            }
            catch (FtpProtocolException ftpProtocolException) {
                // empty catch block
            }
        }
        if (string.indexOf(10) != -1) {
            FtpProtocolException ftpProtocolException = new FtpProtocolException("Illegal FTP command");
            ftpProtocolException.initCause(new IllegalArgumentException("Illegal carriage return"));
            throw ftpProtocolException;
        }
        this.sendServer(string + "\r\n");
        return this.readReply();
    }

    private void issueCommandCheck(String string) throws FtpProtocolException, IOException {
        if (!this.issueCommand(string)) {
            throw new FtpProtocolException(string + ":" + this.getResponseString(), this.getLastReplyCode());
        }
    }

    private Socket openPassiveDataConnection(String string) throws FtpProtocolException, IOException {
        Object object;
        Object object2;
        InetSocketAddress inetSocketAddress = null;
        if (this.issueCommand("EPSV ALL")) {
            this.issueCommandCheck("EPSV");
            String string2 = this.getResponseString();
            if (epsvPat == null) {
                epsvPat = Pattern.compile("^229 .* \\(\\|\\|\\|(\\d+)\\|\\)");
            }
            if (!((Matcher)(object2 = epsvPat.matcher(string2))).find()) {
                throw new FtpProtocolException("EPSV failed : " + string2);
            }
            object = ((Matcher)object2).group(1);
            int n = Integer.parseInt((String)object);
            InetAddress inetAddress = this.server.getInetAddress();
            inetSocketAddress = inetAddress != null ? new InetSocketAddress(inetAddress, n) : InetSocketAddress.createUnresolved(this.serverAddr.getHostName(), n);
        } else {
            this.issueCommandCheck("PASV");
            String string3 = this.getResponseString();
            if (pasvPat == null) {
                pasvPat = Pattern.compile("227 .* \\(?(\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)?");
            }
            if (!((Matcher)(object2 = pasvPat.matcher(string3))).find()) {
                throw new FtpProtocolException("PASV failed : " + string3);
            }
            int n = Integer.parseInt(((Matcher)object2).group(3)) + (Integer.parseInt(((Matcher)object2).group(2)) << 8);
            object = ((Matcher)object2).group(1).replace(',', '.');
            inetSocketAddress = new InetSocketAddress((String)object, n);
        }
        object2 = this.proxy != null ? (this.proxy.type() == Proxy.Type.SOCKS ? AccessController.doPrivileged(new PrivilegedAction<Socket>(){

            @Override
            public Socket run() {
                return new Socket(FtpClient.this.proxy);
            }
        }) : new Socket(Proxy.NO_PROXY)) : new Socket();
        object = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

            @Override
            public InetAddress run() {
                return FtpClient.this.server.getLocalAddress();
            }
        });
        ((Socket)object2).bind(new InetSocketAddress((InetAddress)object, 0));
        if (this.connectTimeout >= 0) {
            ((Socket)object2).connect(inetSocketAddress, this.connectTimeout);
        } else if (defaultConnectTimeout > 0) {
            ((Socket)object2).connect(inetSocketAddress, defaultConnectTimeout);
        } else {
            ((Socket)object2).connect(inetSocketAddress);
        }
        if (this.readTimeout >= 0) {
            ((Socket)object2).setSoTimeout(this.readTimeout);
        } else if (defaultSoTimeout > 0) {
            ((Socket)object2).setSoTimeout(defaultSoTimeout);
        }
        if (this.useCrypto) {
            try {
                object2 = this.sslFact.createSocket((Socket)object2, inetSocketAddress.getHostName(), inetSocketAddress.getPort(), true);
            }
            catch (Exception exception) {
                throw new FtpProtocolException("Can't open secure data channel: " + exception);
            }
        }
        if (!this.issueCommand(string)) {
            ((Socket)object2).close();
            if (this.getLastReplyCode() == FtpReplyCode.FILE_UNAVAILABLE) {
                throw new FileNotFoundException(string);
            }
            throw new FtpProtocolException(string + ":" + this.getResponseString(), this.getLastReplyCode());
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket openDataConnection(String string) throws FtpProtocolException, IOException {
        try {
            return this.openPassiveDataConnection(string);
        }
        catch (FtpProtocolException ftpProtocolException) {
            Socket socket;
            Object object = ftpProtocolException.getMessage();
            if (!((String)object).startsWith("PASV") && !((String)object).startsWith("EPSV")) {
                throw ftpProtocolException;
            }
            if (this.proxy != null && this.proxy.type() == Proxy.Type.SOCKS) {
                throw new FtpProtocolException("Passive mode failed");
            }
            try (ServerSocket serverSocket = new ServerSocket(0, 1, this.server.getLocalAddress());){
                String string2;
                object = serverSocket.getInetAddress();
                if (((InetAddress)object).isAnyLocalAddress()) {
                    object = this.server.getLocalAddress();
                }
                if (!this.issueCommand(string2 = "EPRT |" + (object instanceof Inet6Address ? "2" : "1") + "|" + ((InetAddress)object).getHostAddress() + "|" + serverSocket.getLocalPort() + "|") || !this.issueCommand(string)) {
                    string2 = "PORT ";
                    byte[] byArray = ((InetAddress)object).getAddress();
                    for (int i = 0; i < byArray.length; ++i) {
                        string2 = string2 + (byArray[i] & 0xFF) + ",";
                    }
                    string2 = string2 + (serverSocket.getLocalPort() >>> 8 & 0xFF) + "," + (serverSocket.getLocalPort() & 0xFF);
                    this.issueCommandCheck(string2);
                    this.issueCommandCheck(string);
                }
                if (this.connectTimeout >= 0) {
                    serverSocket.setSoTimeout(this.connectTimeout);
                } else if (defaultConnectTimeout > 0) {
                    serverSocket.setSoTimeout(defaultConnectTimeout);
                }
                socket = serverSocket.accept();
                if (this.readTimeout >= 0) {
                    socket.setSoTimeout(this.readTimeout);
                } else if (defaultSoTimeout > 0) {
                    socket.setSoTimeout(defaultSoTimeout);
                }
            }
            if (this.useCrypto) {
                try {
                    socket = this.sslFact.createSocket(socket, this.serverAddr.getHostName(), this.serverAddr.getPort(), true);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getLocalizedMessage());
                }
            }
            return socket;
        }
    }

    private InputStream createInputStream(InputStream inputStream) {
        if (this.type == FtpClient.TransferType.ASCII) {
            return new TelnetInputStream(inputStream, false);
        }
        return inputStream;
    }

    private OutputStream createOutputStream(OutputStream outputStream) {
        if (this.type == FtpClient.TransferType.ASCII) {
            return new TelnetOutputStream(outputStream, false);
        }
        return outputStream;
    }

    protected FtpClient() {
    }

    public static sun.net.ftp.FtpClient create() {
        return new FtpClient();
    }

    @Override
    public sun.net.ftp.FtpClient enablePassiveMode(boolean bl) {
        return this;
    }

    @Override
    public boolean isPassiveModeEnabled() {
        return true;
    }

    @Override
    public sun.net.ftp.FtpClient setConnectTimeout(int n) {
        this.connectTimeout = n;
        return this;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public sun.net.ftp.FtpClient setReadTimeout(int n) {
        this.readTimeout = n;
        return this;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public sun.net.ftp.FtpClient setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    private void tryConnect(InetSocketAddress inetSocketAddress, int n) throws IOException {
        if (this.isConnected()) {
            this.disconnect();
        }
        this.server = this.doConnect(inetSocketAddress, n);
        try {
            this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + "encoding not found", unsupportedEncodingException);
        }
        this.in = new BufferedInputStream(this.server.getInputStream());
    }

    private Socket doConnect(InetSocketAddress inetSocketAddress, int n) throws IOException {
        Socket socket = this.proxy != null ? (this.proxy.type() == Proxy.Type.SOCKS ? AccessController.doPrivileged(new PrivilegedAction<Socket>(){

            @Override
            public Socket run() {
                return new Socket(FtpClient.this.proxy);
            }
        }) : new Socket(Proxy.NO_PROXY)) : new Socket();
        if (n >= 0) {
            socket.connect(inetSocketAddress, n);
        } else if (this.connectTimeout >= 0) {
            socket.connect(inetSocketAddress, this.connectTimeout);
        } else if (defaultConnectTimeout > 0) {
            socket.connect(inetSocketAddress, defaultConnectTimeout);
        } else {
            socket.connect(inetSocketAddress);
        }
        if (this.readTimeout >= 0) {
            socket.setSoTimeout(this.readTimeout);
        } else if (defaultSoTimeout > 0) {
            socket.setSoTimeout(defaultSoTimeout);
        }
        return socket;
    }

    private void disconnect() throws IOException {
        if (this.isConnected()) {
            this.server.close();
        }
        this.server = null;
        this.in = null;
        this.out = null;
        this.lastTransSize = -1L;
        this.lastFileName = null;
        this.restartOffset = 0L;
        this.welcomeMsg = null;
        this.lastReplyCode = null;
        this.serverResponse.setSize(0);
    }

    @Override
    public boolean isConnected() {
        return this.server != null;
    }

    @Override
    public SocketAddress getServerAddress() {
        return this.server == null ? null : this.server.getRemoteSocketAddress();
    }

    @Override
    public sun.net.ftp.FtpClient connect(SocketAddress socketAddress) throws FtpProtocolException, IOException {
        return this.connect(socketAddress, -1);
    }

    @Override
    public sun.net.ftp.FtpClient connect(SocketAddress socketAddress, int n) throws FtpProtocolException, IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Wrong address type");
        }
        this.serverAddr = (InetSocketAddress)socketAddress;
        this.tryConnect(this.serverAddr, n);
        if (!this.readReply()) {
            throw new FtpProtocolException("Welcome message: " + this.getResponseString(), this.lastReplyCode);
        }
        this.welcomeMsg = this.getResponseString().substring(4);
        return this;
    }

    private void tryLogin(String string, char[] cArray) throws FtpProtocolException, IOException {
        this.issueCommandCheck("USER " + string);
        if (this.lastReplyCode == FtpReplyCode.NEED_PASSWORD && cArray != null && cArray.length > 0) {
            this.issueCommandCheck("PASS " + String.valueOf(cArray));
        }
    }

    @Override
    public sun.net.ftp.FtpClient login(String string, char[] cArray) throws FtpProtocolException, IOException {
        if (!this.isConnected()) {
            throw new FtpProtocolException("Not connected yet", FtpReplyCode.BAD_SEQUENCE);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("User name can't be null or empty");
        }
        this.tryLogin(string, cArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.serverResponse.size(); ++i) {
            String string2 = this.serverResponse.elementAt(i);
            if (string2 == null) continue;
            if (string2.length() >= 4 && string2.startsWith("230")) {
                string2 = string2.substring(4);
            }
            stringBuffer.append(string2);
        }
        this.welcomeMsg = stringBuffer.toString();
        this.loggedIn = true;
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient login(String string, char[] cArray, String string2) throws FtpProtocolException, IOException {
        if (!this.isConnected()) {
            throw new FtpProtocolException("Not connected yet", FtpReplyCode.BAD_SEQUENCE);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("User name can't be null or empty");
        }
        this.tryLogin(string, cArray);
        if (this.lastReplyCode == FtpReplyCode.NEED_ACCOUNT) {
            this.issueCommandCheck("ACCT " + string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.serverResponse != null) {
            for (String string3 : this.serverResponse) {
                if (string3 == null) continue;
                if (string3.length() >= 4 && string3.startsWith("230")) {
                    string3 = string3.substring(4);
                }
                stringBuffer.append(string3);
            }
        }
        this.welcomeMsg = stringBuffer.toString();
        this.loggedIn = true;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.isConnected()) {
            try {
                this.issueCommand("QUIT");
            }
            catch (FtpProtocolException ftpProtocolException) {
                // empty catch block
            }
            this.loggedIn = false;
        }
        this.disconnect();
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public sun.net.ftp.FtpClient changeDirectory(String string) throws FtpProtocolException, IOException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("directory can't be null or empty");
        }
        this.issueCommandCheck("CWD " + string);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient changeToParentDirectory() throws FtpProtocolException, IOException {
        this.issueCommandCheck("CDUP");
        return this;
    }

    @Override
    public String getWorkingDirectory() throws FtpProtocolException, IOException {
        this.issueCommandCheck("PWD");
        String string = this.getResponseString();
        if (!string.startsWith("257")) {
            return null;
        }
        return string.substring(5, string.lastIndexOf(34));
    }

    @Override
    public sun.net.ftp.FtpClient setRestartOffset(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("offset can't be negative");
        }
        this.restartOffset = l;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public sun.net.ftp.FtpClient getFile(String string, OutputStream outputStream) throws FtpProtocolException, IOException {
        int n = 1500;
        if (this.restartOffset > 0L) {
            int n2;
            Socket socket;
            try {
                socket = this.openDataConnection("REST " + this.restartOffset);
            }
            finally {
                this.restartOffset = 0L;
            }
            this.issueCommandCheck("RETR " + string);
            this.getTransferSize();
            InputStream inputStream = this.createInputStream(socket.getInputStream());
            byte[] byArray = new byte[n * 10];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 <= 0) continue;
                outputStream.write(byArray, 0, n2);
            }
            inputStream.close();
        } else {
            int n3;
            Socket socket = this.openDataConnection("RETR " + string);
            this.getTransferSize();
            InputStream inputStream = this.createInputStream(socket.getInputStream());
            byte[] byArray = new byte[n * 10];
            while ((n3 = inputStream.read(byArray)) >= 0) {
                if (n3 <= 0) continue;
                outputStream.write(byArray, 0, n3);
            }
            inputStream.close();
        }
        return this.completePending();
    }

    @Override
    public InputStream getFileStream(String string) throws FtpProtocolException, IOException {
        if (this.restartOffset > 0L) {
            Socket socket;
            try {
                socket = this.openDataConnection("REST " + this.restartOffset);
            }
            finally {
                this.restartOffset = 0L;
            }
            if (socket == null) {
                return null;
            }
            this.issueCommandCheck("RETR " + string);
            this.getTransferSize();
            return this.createInputStream(socket.getInputStream());
        }
        Socket socket = this.openDataConnection("RETR " + string);
        if (socket == null) {
            return null;
        }
        this.getTransferSize();
        return this.createInputStream(socket.getInputStream());
    }

    @Override
    public OutputStream putFileStream(String string, boolean bl) throws FtpProtocolException, IOException {
        String string2 = bl ? "STOU " : "STOR ";
        Socket socket = this.openDataConnection(string2 + string);
        if (socket == null) {
            return null;
        }
        boolean bl2 = this.type == FtpClient.TransferType.BINARY;
        return new TelnetOutputStream(socket.getOutputStream(), bl2);
    }

    @Override
    public sun.net.ftp.FtpClient putFile(String string, InputStream inputStream, boolean bl) throws FtpProtocolException, IOException {
        String string2 = bl ? "STOU " : "STOR ";
        int n = 1500;
        if (this.type == FtpClient.TransferType.BINARY) {
            int n2;
            Socket socket = this.openDataConnection(string2 + string);
            OutputStream outputStream = this.createOutputStream(socket.getOutputStream());
            byte[] byArray = new byte[n * 10];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 <= 0) continue;
                outputStream.write(byArray, 0, n2);
            }
            outputStream.close();
        }
        return this.completePending();
    }

    @Override
    public sun.net.ftp.FtpClient appendFile(String string, InputStream inputStream) throws FtpProtocolException, IOException {
        int n;
        int n2 = 1500;
        Socket socket = this.openDataConnection("APPE " + string);
        OutputStream outputStream = this.createOutputStream(socket.getOutputStream());
        byte[] byArray = new byte[n2 * 10];
        while ((n = inputStream.read(byArray)) >= 0) {
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        return this.completePending();
    }

    @Override
    public sun.net.ftp.FtpClient rename(String string, String string2) throws FtpProtocolException, IOException {
        this.issueCommandCheck("RNFR " + string);
        this.issueCommandCheck("RNTO " + string2);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient deleteFile(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("DELE " + string);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient makeDirectory(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("MKD " + string);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient removeDirectory(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("RMD " + string);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient noop() throws FtpProtocolException, IOException {
        this.issueCommandCheck("NOOP");
        return this;
    }

    @Override
    public String getStatus(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck(string == null ? "STAT" : "STAT " + string);
        Vector<String> vector = this.getResponseStrings();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < vector.size() - 1; ++i) {
            stringBuffer.append(vector.get(i));
        }
        return stringBuffer.toString();
    }

    @Override
    public List<String> getFeatures() throws FtpProtocolException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.issueCommandCheck("FEAT");
        Vector<String> vector = this.getResponseStrings();
        for (int i = 1; i < vector.size() - 1; ++i) {
            String string = vector.get(i);
            arrayList.add(string.substring(1, string.length() - 1));
        }
        return arrayList;
    }

    @Override
    public sun.net.ftp.FtpClient abort() throws FtpProtocolException, IOException {
        this.issueCommandCheck("ABOR");
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient completePending() throws FtpProtocolException, IOException {
        while (this.replyPending) {
            this.replyPending = false;
            if (this.readReply()) continue;
            throw new FtpProtocolException(this.getLastResponseString(), this.lastReplyCode);
        }
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient reInit() throws FtpProtocolException, IOException {
        this.issueCommandCheck("REIN");
        this.loggedIn = false;
        if (this.useCrypto && this.server instanceof SSLSocket) {
            SSLSession sSLSession = ((SSLSocket)this.server).getSession();
            sSLSession.invalidate();
            this.server = this.oldSocket;
            this.oldSocket = null;
            try {
                this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(encoding + "encoding not found", unsupportedEncodingException);
            }
            this.in = new BufferedInputStream(this.server.getInputStream());
        }
        this.useCrypto = false;
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient setType(FtpClient.TransferType transferType) throws FtpProtocolException, IOException {
        String string = "NOOP";
        this.type = transferType;
        if (transferType == FtpClient.TransferType.ASCII) {
            string = "TYPE A";
        }
        if (transferType == FtpClient.TransferType.BINARY) {
            string = "TYPE I";
        }
        if (transferType == FtpClient.TransferType.EBCDIC) {
            string = "TYPE E";
        }
        this.issueCommandCheck(string);
        return this;
    }

    @Override
    public InputStream list(String string) throws FtpProtocolException, IOException {
        Socket socket = this.openDataConnection(string == null ? "LIST" : "LIST " + string);
        if (socket != null) {
            return this.createInputStream(socket.getInputStream());
        }
        return null;
    }

    @Override
    public InputStream nameList(String string) throws FtpProtocolException, IOException {
        Socket socket = this.openDataConnection(string == null ? "NLST" : "NLST " + string);
        if (socket != null) {
            return this.createInputStream(socket.getInputStream());
        }
        return null;
    }

    @Override
    public long getSize(String string) throws FtpProtocolException, IOException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("path can't be null or empty");
        }
        this.issueCommandCheck("SIZE " + string);
        if (this.lastReplyCode == FtpReplyCode.FILE_STATUS) {
            String string2 = this.getResponseString();
            string2 = string2.substring(4, string2.length() - 1);
            return Long.parseLong(string2);
        }
        return -1L;
    }

    @Override
    public Date getLastModified(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("MDTM " + string);
        if (this.lastReplyCode == FtpReplyCode.FILE_STATUS) {
            String string2 = this.getResponseString().substring(4);
            Date date = null;
            for (SimpleDateFormat simpleDateFormat : dateFormats) {
                try {
                    date = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (date == null) continue;
                return date;
            }
        }
        return null;
    }

    @Override
    public sun.net.ftp.FtpClient setDirParser(FtpDirParser ftpDirParser) {
        this.parser = ftpDirParser;
        return this;
    }

    @Override
    public Iterator<FtpDirEntry> listFiles(String string) throws FtpProtocolException, IOException {
        Socket socket = null;
        BufferedReader bufferedReader = null;
        try {
            socket = this.openDataConnection(string == null ? "MLSD" : "MLSD " + string);
        }
        catch (FtpProtocolException ftpProtocolException) {
            // empty catch block
        }
        if (socket != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            return new FtpFileIterator(this.mlsxParser, bufferedReader);
        }
        socket = this.openDataConnection(string == null ? "LIST" : "LIST " + string);
        if (socket != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            return new FtpFileIterator(this.parser, bufferedReader);
        }
        return null;
    }

    private boolean sendSecurityData(byte[] byArray) throws IOException, FtpProtocolException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = bASE64Encoder.encode(byArray);
        return this.issueCommand("ADAT " + string);
    }

    private byte[] getSecurityData() {
        String string = this.getLastResponseString();
        if (string.substring(4, 9).equalsIgnoreCase("ADAT=")) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            try {
                return bASE64Decoder.decodeBuffer(string.substring(9, string.length() - 1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public sun.net.ftp.FtpClient useKerberos() throws FtpProtocolException, IOException {
        return this;
    }

    @Override
    public String getWelcomeMsg() {
        return this.welcomeMsg;
    }

    @Override
    public FtpReplyCode getLastReplyCode() {
        return this.lastReplyCode;
    }

    @Override
    public String getLastResponseString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.serverResponse != null) {
            for (String string : this.serverResponse) {
                if (string == null) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public long getLastTransferSize() {
        return this.lastTransSize;
    }

    @Override
    public String getLastFileName() {
        return this.lastFileName;
    }

    @Override
    public sun.net.ftp.FtpClient startSecureSession() throws FtpProtocolException, IOException {
        if (!this.isConnected()) {
            throw new FtpProtocolException("Not connected yet", FtpReplyCode.BAD_SEQUENCE);
        }
        if (this.sslFact == null) {
            try {
                this.sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            catch (Exception exception) {
                throw new IOException(exception.getLocalizedMessage());
            }
        }
        this.issueCommandCheck("AUTH TLS");
        Socket socket = null;
        try {
            socket = this.sslFact.createSocket(this.server, this.serverAddr.getHostName(), this.serverAddr.getPort(), true);
        }
        catch (SSLException sSLException) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sSLException;
        }
        this.oldSocket = this.server;
        this.server = socket;
        try {
            this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + "encoding not found", unsupportedEncodingException);
        }
        this.in = new BufferedInputStream(this.server.getInputStream());
        this.issueCommandCheck("PBSZ 0");
        this.issueCommandCheck("PROT P");
        this.useCrypto = true;
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient endSecureSession() throws FtpProtocolException, IOException {
        if (!this.useCrypto) {
            return this;
        }
        this.issueCommandCheck("CCC");
        this.issueCommandCheck("PROT C");
        this.useCrypto = false;
        this.server = this.oldSocket;
        this.oldSocket = null;
        try {
            this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + "encoding not found", unsupportedEncodingException);
        }
        this.in = new BufferedInputStream(this.server.getInputStream());
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient allocate(long l) throws FtpProtocolException, IOException {
        this.issueCommandCheck("ALLO " + l);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient structureMount(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("SMNT " + string);
        return this;
    }

    @Override
    public String getSystem() throws FtpProtocolException, IOException {
        this.issueCommandCheck("SYST");
        String string = this.getResponseString();
        return string.substring(4);
    }

    @Override
    public String getHelp(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("HELP " + string);
        Vector<String> vector = this.getResponseStrings();
        if (vector.size() == 1) {
            return vector.get(0).substring(4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < vector.size() - 1; ++i) {
            stringBuffer.append(vector.get(i).substring(3));
        }
        return stringBuffer.toString();
    }

    @Override
    public sun.net.ftp.FtpClient siteCmd(String string) throws FtpProtocolException, IOException {
        this.issueCommandCheck("SITE " + string);
        return this;
    }

    static {
        logger = PlatformLogger.getLogger("sun.net.ftp.FtpClient");
        encoding = "ISO8859_1";
        patStrings = new String[]{"([\\-ld](?:[r\\-][w\\-][x\\-]){3})\\s*\\d+ (\\w+)\\s*(\\w+)\\s*(\\d+)\\s*([A-Z][a-z][a-z]\\s*\\d+)\\s*(\\d\\d:\\d\\d)\\s*(\\p{Print}*)", "([\\-ld](?:[r\\-][w\\-][x\\-]){3})\\s*\\d+ (\\w+)\\s*(\\w+)\\s*(\\d+)\\s*([A-Z][a-z][a-z]\\s*\\d+)\\s*(\\d{4})\\s*(\\p{Print}*)", "(\\d{2}/\\d{2}/\\d{4})\\s*(\\d{2}:\\d{2}[ap])\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)", "(\\d{2}-\\d{2}-\\d{2})\\s*(\\d{2}:\\d{2}[AP]M)\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)"};
        patternGroups = new int[][]{{7, 4, 5, 6, 0, 1, 2, 3}, {7, 4, 5, 0, 6, 1, 2, 3}, {4, 3, 1, 2, 0, 0, 0, 0}, {4, 3, 1, 2, 0, 0, 0, 0}};
        linkp = Pattern.compile("(\\p{Print}+) \\-\\> (\\p{Print}+)$");
        final int[] nArray = new int[]{0, 0};
        final String[] stringArray = new String[]{null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                nArray[0] = Integer.getInteger("sun.net.client.defaultReadTimeout", 300000);
                nArray[1] = Integer.getInteger("sun.net.client.defaultConnectTimeout", 300000);
                stringArray[0] = System.getProperty("file.encoding", "ISO8859_1");
                return null;
            }
        });
        defaultSoTimeout = nArray[0] == 0 ? -1 : nArray[0];
        defaultConnectTimeout = nArray[1] == 0 ? -1 : nArray[1];
        encoding = stringArray[0];
        try {
            if (!FtpClient.isASCIISuperset(encoding)) {
                encoding = "ISO8859_1";
            }
        }
        catch (Exception exception) {
            encoding = "ISO8859_1";
        }
        patterns = new Pattern[patStrings.length];
        for (int i = 0; i < patStrings.length; ++i) {
            FtpClient.patterns[i] = Pattern.compile(patStrings[i]);
        }
        transPat = null;
        epsvPat = null;
        pasvPat = null;
        MDTMformats = new String[]{"yyyyMMddHHmmss.SSS", "yyyyMMddHHmmss"};
        dateFormats = new SimpleDateFormat[MDTMformats.length];
        for (int i = 0; i < MDTMformats.length; ++i) {
            FtpClient.dateFormats[i] = new SimpleDateFormat(MDTMformats[i]);
            dateFormats[i].setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    private class DefaultParser
    implements FtpDirParser {
        private DefaultParser() {
        }

        @Override
        public FtpDirEntry parseLine(String string) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            boolean bl = false;
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            Matcher matcher = null;
            for (int i = 0; i < patterns.length; ++i) {
                matcher = patterns[i].matcher(string);
                if (!matcher.find()) continue;
                string5 = matcher.group(patternGroups[i][0]);
                string3 = matcher.group(patternGroups[i][1]);
                string2 = matcher.group(patternGroups[i][2]);
                if (patternGroups[i][4] > 0) {
                    string2 = string2 + ", " + matcher.group(patternGroups[i][4]);
                } else if (patternGroups[i][3] > 0) {
                    string2 = string2 + ", " + String.valueOf(n);
                }
                if (patternGroups[i][3] > 0) {
                    string4 = matcher.group(patternGroups[i][3]);
                }
                if (patternGroups[i][5] > 0) {
                    string6 = matcher.group(patternGroups[i][5]);
                    bl = string6.startsWith("d");
                }
                if (patternGroups[i][6] > 0) {
                    string7 = matcher.group(patternGroups[i][6]);
                }
                if (patternGroups[i][7] > 0) {
                    string8 = matcher.group(patternGroups[i][7]);
                }
                if (!"<DIR>".equals(string3)) continue;
                bl = true;
                string3 = null;
            }
            if (string5 != null) {
                Matcher matcher2;
                Date date;
                try {
                    date = FtpClient.this.df.parse(string2);
                }
                catch (Exception exception) {
                    date = null;
                }
                if (date != null && string4 != null) {
                    int n2 = string4.indexOf(":");
                    calendar.setTime(date);
                    calendar.set(10, Integer.parseInt(string4.substring(0, n2)));
                    calendar.set(12, Integer.parseInt(string4.substring(n2 + 1)));
                    date = calendar.getTime();
                }
                if ((matcher2 = linkp.matcher(string5)).find()) {
                    string5 = matcher2.group(1);
                }
                boolean[][] blArray = new boolean[3][3];
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        blArray[i][j] = string6.charAt(i * 3 + j) != '-';
                    }
                }
                FtpDirEntry ftpDirEntry = new FtpDirEntry(string5);
                ftpDirEntry.setUser(string7).setGroup(string8);
                ftpDirEntry.setSize(Long.parseLong(string3)).setLastModified(date);
                ftpDirEntry.setPermissions(blArray);
                ftpDirEntry.setType(bl ? FtpDirEntry.Type.DIR : (string.charAt(0) == 'l' ? FtpDirEntry.Type.LINK : FtpDirEntry.Type.FILE));
                return ftpDirEntry;
            }
            return null;
        }
    }

    private class FtpFileIterator
    implements Iterator<FtpDirEntry>,
    Closeable {
        private BufferedReader in = null;
        private FtpDirEntry nextFile = null;
        private FtpDirParser fparser = null;
        private boolean eof = false;

        public FtpFileIterator(FtpDirParser ftpDirParser, BufferedReader bufferedReader) {
            this.in = bufferedReader;
            this.fparser = ftpDirParser;
            this.readNext();
        }

        private void readNext() {
            this.nextFile = null;
            if (this.eof) {
                return;
            }
            String string = null;
            try {
                do {
                    if ((string = this.in.readLine()) == null) continue;
                    this.nextFile = this.fparser.parseLine(string);
                    if (this.nextFile == null) continue;
                    return;
                } while (string != null);
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.eof = true;
        }

        @Override
        public boolean hasNext() {
            return this.nextFile != null;
        }

        @Override
        public FtpDirEntry next() {
            FtpDirEntry ftpDirEntry = this.nextFile;
            this.readNext();
            return ftpDirEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void close() throws IOException {
            if (this.in != null && !this.eof) {
                this.in.close();
            }
            this.eof = true;
            this.nextFile = null;
        }
    }

    private class MLSxParser
    implements FtpDirParser {
        private SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");

        private MLSxParser() {
        }

        @Override
        public FtpDirEntry parseLine(String string) {
            Object object;
            String string2;
            String string3 = null;
            int n = string.lastIndexOf(";");
            if (n > 0) {
                string3 = string.substring(n + 1).trim();
                string = string.substring(0, n);
            } else {
                string3 = string.trim();
                string = "";
            }
            FtpDirEntry ftpDirEntry = new FtpDirEntry(string3);
            while (!string.isEmpty()) {
                n = string.indexOf(";");
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                } else {
                    string2 = string;
                    string = "";
                }
                if ((n = string2.indexOf("=")) <= 0) continue;
                object = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                ftpDirEntry.addFact((String)object, string4);
            }
            string2 = ftpDirEntry.getFact("Size");
            if (string2 != null) {
                ftpDirEntry.setSize(Long.parseLong(string2));
            }
            if ((string2 = ftpDirEntry.getFact("Modify")) != null) {
                object = null;
                try {
                    object = this.df.parse(string2);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (object != null) {
                    ftpDirEntry.setLastModified((Date)object);
                }
            }
            if ((string2 = ftpDirEntry.getFact("Create")) != null) {
                object = null;
                try {
                    object = this.df.parse(string2);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (object != null) {
                    ftpDirEntry.setCreated((Date)object);
                }
            }
            if ((string2 = ftpDirEntry.getFact("Type")) != null) {
                if (string2.equalsIgnoreCase("file")) {
                    ftpDirEntry.setType(FtpDirEntry.Type.FILE);
                }
                if (string2.equalsIgnoreCase("dir")) {
                    ftpDirEntry.setType(FtpDirEntry.Type.DIR);
                }
                if (string2.equalsIgnoreCase("cdir")) {
                    ftpDirEntry.setType(FtpDirEntry.Type.CDIR);
                }
                if (string2.equalsIgnoreCase("pdir")) {
                    ftpDirEntry.setType(FtpDirEntry.Type.PDIR);
                }
            }
            return ftpDirEntry;
        }
    }
}

