/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.invoice;

import com.dmi.sdccore.api.model.deserializers.BigDecimalDeserializer;
import com.dmi.sdccore.utils.NumberUtil;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.List;

public class InvoiceItem {
    @JsonAlias(value={"gtin", "Gtin"})
    String gtin;
    @JsonAlias(value={"name", "Name"})
    String name;
    @JsonAlias(value={"quantity", "Quantity"})
    BigDecimal quantity;
    @JsonAlias(value={"unitPrice", "UnitPrice"})
    BigDecimal unitPrice;
    @JsonAlias(value={"labels", "Labels"})
    List<String> labels;
    @JsonAlias(value={"totalAmount", "TotalAmount"})
    @JsonDeserialize(using=BigDecimalDeserializer.class)
    BigDecimal totalAmount;
    String quantityStr;
    String unitPriceStr;

    public InvoiceItem() {
    }

    public InvoiceItem(String gtin, String name, BigDecimal quantity, BigDecimal unitPrice, List<String> labels, BigDecimal totalAmount) {
        this.gtin = gtin;
        this.name = name;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.labels = labels;
        this.totalAmount = totalAmount;
    }

    public String getGtin() {
        return this.gtin;
    }

    public void setGtin(String gtin) {
        this.gtin = gtin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonGetter(value="quantityStr")
    @JsonIgnore
    public String getQuantityStr() {
        return this.quantityStr;
    }

    @JsonSetter(value="quantity")
    public void setQuantityStr(String quantityStr) {
        this.quantityStr = quantityStr;
        this.quantity = NumberUtil.toBigDecimal(quantityStr);
    }

    @JsonSetter(value="Quantity")
    public void setQuantityStrVer2(String quantityStr) {
        this.quantityStr = quantityStr;
        this.quantity = NumberUtil.toBigDecimal(quantityStr);
    }

    @JsonGetter(value="unitPriceStr")
    @JsonIgnore
    public String getUnitPriceStr() {
        return this.unitPriceStr;
    }

    @JsonSetter(value="unitPrice")
    public void setUnitPriceStr(String unitPriceStr) {
        this.unitPriceStr = unitPriceStr;
        this.unitPrice = NumberUtil.toBigDecimal(unitPriceStr);
    }

    @JsonSetter(value="UnitPrice")
    public void setUnitPriceStrVer2(String unitPriceStr) {
        this.unitPriceStr = unitPriceStr;
        this.unitPrice = NumberUtil.toBigDecimal(unitPriceStr);
    }

    public String toString() {
        return "InvoiceItem{gtin='" + this.gtin + '\'' + ", name='" + this.name + '\'' + ", quantity=" + this.quantity + ", unitPrice=" + this.unitPrice + ", labels=" + this.labels + ", totalAmount=" + this.totalAmount + '}';
    }
}

