/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.endpoints.v3;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.api.model.ApiErrCode;
import com.dmi.sdccore.protocols.taxapi.OnlineStatusNotifier;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import com.dmi.sdccore.utils.FsUtil;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="v3/pin")
public class VerifyPinController {
    private static final Logger logger = LogManager.getLogger(VerifyPinController.class);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public synchronized Response verifyPin(String taxCardPinCode) {
        logger.info("Local API-Verifying pin");
        AppState appState = AppState.getInstance();
        if (!appState.isCardInserted()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SmartCardNotPresent.getCode()).build();
        }
        if (!appState.isTaxCardInfoRead()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.CardCommFailed.getCode()).build();
        }
        if (!appState.isSdcLicenceValid()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SdcLicenseNotValid.getCode()).build();
        }
        if (!appState.isSdcSerialNumberDefined()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.SdcSerialNumberNotDefined.getCode()).build();
        }
        CardResponse cardResponse = CardCommand.getInstance().selectApplet();
        if (CardOpCode.OK != cardResponse.getOpCode()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)ApiErrCode.CardCommFailed.getCode()).build();
        }
        cardResponse = CardCommand.getInstance().verifyPin(taxCardPinCode);
        if (CardOpCode.CardAppletNotSelected == cardResponse.getOpCode()) {
            CardCommand.getInstance().selectApplet();
            cardResponse = CardCommand.getInstance().verifyPin(taxCardPinCode);
        }
        if (CardOpCode.OK == cardResponse.getOpCode()) {
            logger.info("Pin OK");
            appState.setPinCode(taxCardPinCode);
            if (appState.isSdcInitialized()) {
                EventManager.getInstance().postInfoNotification(I18N.text("message.sdc.ready.to.sign.invoices"));
                if (appState.isAuditRequired()) {
                    appState.setShouldStartRemoteAuditNow(true);
                }
                appState.setCardPinCodeEntered(true);
                EventManager.getInstance().postUpdateUIEvent();
            } else if (appState.isInternetAvailable()) {
                boolean initSuccess = false;
                try {
                    initSuccess = OnlineStatusNotifier.initializeSDC(appState);
                }
                catch (Exception e) {
                    logger.warn("SDC init failed", (Throwable)e);
                }
                if (!initSuccess) {
                    try {
                        initSuccess = FsUtil.initializeSdcFromFs(appState);
                    }
                    catch (Exception e) {
                        logger.warn("SDC init from fs failed", (Throwable)e);
                    }
                }
                appState.setCardPinCodeEntered(true);
                if (initSuccess) {
                    EventManager.getInstance().postInfoNotification(I18N.text("message.sdc.init.success"));
                } else {
                    logger.error("PIN is valid but SDC initialization failed.");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.sdc.init.failed"));
                }
            } else {
                boolean initSuccess = false;
                try {
                    initSuccess = FsUtil.initializeSdcFromFs(appState);
                }
                catch (Exception e) {
                    logger.warn("SDC init from fs failed", (Throwable)e);
                }
                appState.setCardPinCodeEntered(true);
                if (initSuccess) {
                    EventManager.getInstance().postInfoNotification(I18N.text("message.sdc.init.success"));
                } else {
                    logger.error("PIN is valid but SDC initialization failed.");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.sdc.init.failed"));
                }
            }
            return Response.ok((Object)ApiErrCode.PinOk.getCode()).build();
        }
        appState.setCardPinCodeEntered(false);
        appState.setPinCode(null);
        ApiErrCode errCode = CardOpCode.WrongPinCode == cardResponse.getOpCode() || CardOpCode.WrongPinSize == cardResponse.getOpCode() ? ApiErrCode.PinNotOk : (CardOpCode.AllowedPinEntriesExceeded == cardResponse.getOpCode() ? ApiErrCode.CardLocked : ApiErrCode.UndefinedError);
        logger.warn("Verify pin error: {}", (Object)errCode);
        EventManager.getInstance().postUpdateUIEvent();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)errCode.getCode()).build();
    }
}

