<?php
function RekonstrukcijaKartica($to) {
	global $link;
    $pocetni_datum = getStartDateOnCards($to);
    $krajnji_datum = getEndDateOnCards($to);
    $t0 = date('Y-m-d', strtotime($to));
    $t11 = getDatumKartica($t0, 11); //crna prijemnica
    $t12 = getDatumKartica($t0, 12); //bela prijemnica
    $t19 = getDatumKartica($t0, 19); //odeljenje izlaz trebovanje belo
    $t20 = getDatumKartica($t0, 20); //odeljenje ulaz trebovanje belo
    $t21 = getDatumKartica($t0, 21); //magacin izlaz trebovanje | odeljenje izlaz trebovanje belo
    $t22 = getDatumKartica($t0, 22); //magacin ulaz trebovanje | odeljenje ulaz trebovanje belo
    $t24 = getDatumKartica($t0, 24); //proizvodnja belo
    $t25 = getDatumKartica($t0, 25); //proizvodnja crno
    $t26 = getDatumKartica($t0, 26); //utrosak
    $t45 = getDatumKartica($t0, 45); //otpis magacin
    $t46 = getDatumKartica($t0, 46);
    $t34 = getDatumKartica($t0, 34);
    $t35 = getDatumKartica($t0, 35); //beli izlaz odeljenje
    $t36 = getDatumKartica($t0, 36);
    $t50 = getDatumKartica(dateBefore($t0), 50);
//Echo "Prijemnice Begin<br>";
    $Prijemnice = mysqli_query($link, "SELECT tip, brPrijemnice, id, crno FROM prijemnica WHERE datumPrijemnice = '$t0'");
    while ($rowP = mysqli_fetch_array($Prijemnice)) {
        $idPrijemnice = $rowP['id'];
        $brPrijemnice = stripslashes($rowP['brPrijemnice']);
        $crnoPrijemnice = $rowP['crno'];
        if ($crnoPrijemnice == 1) {
            $datumPrijemnice = $t11;
            $crnoPrijemnice = 1;
        } else {
            $datumPrijemnice = $t12;
            $crnoPrijemnice = 0;
        }
        $tipPrijemnice = $rowP['tip'];
        $odeljenjePrijemnice = getMagacin()['id'];
        $StavkaPrijemnice = mysqli_query($link, "SELECT kolicina, ARTIKAL_ID, komad FROM prijemnicastavka WHERE PRIJEMNICA_ID='$idPrijemnice'");
        while ($rowPS = mysqli_fetch_array($StavkaPrijemnice)) {
            $artikalStavkaPrijemnice = $rowPS['ARTIKAL_ID'];
            $kolicinaStavkaPrijemnice = $rowPS['kolicina'];
            $komadStavkaPrijemnice = $rowPS['komad'];
            mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                            . "VALUES ('$datumPrijemnice', $crnoPrijemnice, '$brPrijemnice', '0', '$kolicinaStavkaPrijemnice', '$komadStavkaPrijemnice', '$artikalStavkaPrijemnice', '$odeljenjePrijemnice')") or die(mysqli_error($link));
        }
    }
//Echo "Prijemnice End<br>";
    /* PRIJEMNICE END */
    /* TREBOVANJA START */
//Echo "TREBOVANJA Begin<br>";
    $Trebovanja = mysqli_query($link, "SELECT tip, brTrebovanja, id, crno, IZ_ID, U_ID FROM trebovanje WHERE datumTrebovanja = '$t0'") or die(mysqli_error($link));
    while ($rowT = mysqli_fetch_array($Trebovanja)) {
        $idTrebovanja = $rowT['id'];
        $brTrebovanja = stripslashes($rowT['brTrebovanja']);
        $crnoTrebovanja = $rowT['crno'];
        if ($crnoTrebovanja == 1) {
            $crnoTrebovanja = 1;
        } else {
            $crnoTrebovanja = 0;
        }
        $uTrebovanja = $rowT['U_ID'];
        $izTrebovanja = $rowT['IZ_ID'];
        $tipTrebovanja = $rowT['tip'];
        $StavkaTrebovanja = mysqli_query($link, "SELECT kolicina, ARTIKAL_ID, komad FROM trebovanjestavka WHERE TREBOVANJE_ID='$idTrebovanja'");
        while ($rowTS = mysqli_fetch_array($StavkaTrebovanja)) {
            $artikalStavkaTrebovanja = $rowTS['ARTIKAL_ID'];
            $kolicinaStavkaTrebovanja = $rowTS['kolicina'];
            $komadStavkaTrebovanja = $rowTS['komad'];
            $getArtikal = mysqli_query($link, "SELECT tip FROM artikal WHERE id='$artikalStavkaTrebovanja'");
            $getArtikal = mysqli_fetch_row($getArtikal);
            $artikalTip = $getArtikal[0];
            if ($uTrebovanja != null) {
                $datumTrebovanja = $t22;
                $odeljenjeTrebovanja = $uTrebovanja;
                mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                                . "VALUES ('$datumTrebovanja', $crnoTrebovanja, '$brTrebovanja', 0, '$kolicinaStavkaTrebovanja', '$komadStavkaTrebovanja', '$artikalStavkaTrebovanja', '$odeljenjeTrebovanja')") or die(mysqli_error($link));
            }
            if ($izTrebovanja != NULL) {
                $datumTrebovanja = $t21;
                $odeljenjeTrebovanja = $izTrebovanja;
                $kolicinaStavkaTrebovanja = $kolicinaStavkaTrebovanja * (-1);
                mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                                . "VALUES ('$datumTrebovanja', $crnoTrebovanja, '$brTrebovanja', 0, '$kolicinaStavkaTrebovanja', '$komadStavkaTrebovanja', '$artikalStavkaTrebovanja', '$odeljenjeTrebovanja')") or die(mysqli_error($link));
            }
        }
    }
//Echo "TREBOVANJA END<br>";
    /* TREBOVANJA END */
    /* RACUNI START */

//Echo "RACUN Begin<br>";
    $karticaRacun = array();
    $StavkaRacuna = mysqli_query($link, "SELECT sr.ARTIKAL_ID, SUM(sr.kolicina) as kolicina, r.crnoPlacanje FROM stavkaracuna sr, racun r WHERE r.id=sr.RACUN_ID AND r.datum >= '$pocetni_datum' AND r.datum<='$krajnji_datum' AND sr.ARTIKAL_ID IS NOT NULL AND r.KASA_ID IS NOT NULL GROUP BY r.crnoPlacanje, sr.ARTIKAL_ID") or die(mysqli_error($link));
    while ($rowRS = mysqli_fetch_array($StavkaRacuna)) {
        $artikalStavkaRacuna = $rowRS['ARTIKAL_ID'];
        $kolicinaStavkaRacuna = -1 * $rowRS['kolicina'];
        $crnoStavkaRacuna = $rowRS['crnoPlacanje'];

        $getArtikal = mysqli_query($link, "SELECT tip, ODELJENJENORMATIV_ID, trenutnaNV FROM artikal WHERE id='$artikalStavkaRacuna'") or die(mysqli_error($link));
        $getArtikal = mysqli_fetch_row($getArtikal);
        $artikalTip = $getArtikal[0];
        $artikalOdeljenje = $getArtikal[1];
        $artikalCena = $getArtikal[2];
        if ($crnoStavkaRacuna != null) {
            $crnoStavkaRacuna = 1;
        } else {
            $crnoStavkaRacuna = 0;
        }
        $datumRacuna = $t36;
        $kljucKartica = $datumRacuna . '-' . $crnoStavkaRacuna . '-' . $artikalStavkaRacuna . '-' . $artikalOdeljenje;

        $Postoji = array_search($kljucKartica, array_column($karticaRacun, 'kljucKartice'));
        if ($artikalTip != 'SLOZ' && $artikalTip != 'DODA') {
            if (is_numeric($Postoji)) {
                $karticaRacun[$Postoji]['kolicina'] = $karticaRacun[$Postoji]['kolicina'] + $kolicinaStavkaRacuna;
            } else {
                array_push($karticaRacun, array('kljucKartice' => $kljucKartica, 'datumRacuna' => $datumRacuna, 'crno' => $crnoStavkaRacuna, 'kolicina' => $kolicinaStavkaRacuna, 'nabavnaCena' => $artikalCena, 'ARTIKAL_ID' => $artikalStavkaRacuna, 'ODELJENJE_ID' => $artikalOdeljenje));
            }
        }       

        if ($artikalTip == 'SLOZ' || $artikalTip == 'DODA' || $artikalTip == 'PROD') {
            $getNormativ = mysqli_query($link, "SELECT kolicina, SASTOJAK_ID FROM normativ WHERE ARTIKAL_ID='$artikalStavkaRacuna' AND ODELJENJE_ID='$artikalOdeljenje'") or die(mysqli_error($link));
            while ($rowN = mysqli_fetch_array($getNormativ)) {
                $kolicinaN = $rowN['kolicina'];
                $sastojakN = $rowN['SASTOJAK_ID'];
                $kolicinaN = $kolicinaN * $kolicinaStavkaRacuna;
                $NV = mysqli_query($link, "SELECT trenutnaNV FROM artikal WHERE id = '$sastojakN'");
                $NV = mysqli_fetch_row($NV);
                $NV = $NV[0];
                $kljucKartica = $datumRacuna . '-' . $crnoStavkaRacuna . '-' . $sastojakN . '-' . $artikalOdeljenje;
                $Postoji = array_search($kljucKartica, array_column($karticaRacun, 'kljucKartice'));
                if (is_numeric($Postoji)) {
                    $karticaRacun[$Postoji]['kolicina'] = $karticaRacun[$Postoji]['kolicina'] + $kolicinaN;
                } else {
                    array_push($karticaRacun, array('kljucKartice' => $kljucKartica, 'datumRacuna' => $datumRacuna, 'crno' => $crnoStavkaRacuna, 'kolicina' => $kolicinaN, 'nabavnaCena' => $NV, 'ARTIKAL_ID' => $sastojakN, 'ODELJENJE_ID' => $artikalOdeljenje));
                }
            }
        }
    }
    foreach ($karticaRacun as $kartica) {
        $artikalRacun = $kartica['ARTIKAL_ID'];
        $datumRacun = $kartica['datumRacuna'];
        $crnoRacun = $kartica['crno'];
        $odeljenjeRacun = $kartica['ODELJENJE_ID'];
        $kolicinaRacun = $kartica['kolicina'];
        //$IzlazKom = -1*$kolicinaRacun;
        $cenaRacun = $kartica['nabavnaCena'];
        mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                        . "VALUES ('$datumRacun', $crnoRacun, '', '$kolicinaRacun', '$cenaRacun', '$artikalRacun', '$odeljenjeRacun')") or die(mysqli_error($link));
    }
    $karticaRacun = '';
    $karticaRacun = array();
    $StavkaRacuna = mysqli_query($link, "SELECT sr.ARTIKAL_ID, SUM(sr.kolicina) as kolicina FROM stavkaracuna sr, tura t WHERE t.id=sr.TURA_ID AND ISNULL(sr.RACUN_ID) AND t.datum >= '$pocetni_datum' AND t.datum<='$krajnji_datum' AND sr.ARTIKAL_ID IS NOT NULL GROUP BY sr.ARTIKAL_ID") or die(mysqli_error($link));
    while ($rowRS = mysqli_fetch_array($StavkaRacuna)) {
        $artikalStavkaRacuna = $rowRS['ARTIKAL_ID'];
        $kolicinaStavkaRacuna = -1 * $rowRS['kolicina'];

        $getArtikal = mysqli_query($link, "SELECT tip, ODELJENJENORMATIV_ID, trenutnaNV FROM artikal WHERE id='$artikalStavkaRacuna'") or die(mysqli_error($link));
        $getArtikal = mysqli_fetch_row($getArtikal);
        $artikalTip = $getArtikal[0];
        $artikalOdeljenje = $getArtikal[1];
        $artikalCena = $getArtikal[2];
        $crnoStavkaRacuna = 0;
        $datumRacuna = $t34;
        $kljucKartica = $datumRacuna . '-' . $crnoStavkaRacuna . '-' . $artikalStavkaRacuna . '-' . $artikalOdeljenje;
        $Postoji = array_search($kljucKartica, array_column($karticaRacun, 'kljucKartice'));
        if ($artikalTip != 'SLOZ' && $artikalTip != 'DODA') {
            if (is_numeric($Postoji)) {
                $karticaRacun[$Postoji]['kolicina'] = $karticaRacun[$Postoji]['kolicina'] + $kolicinaStavkaRacuna;
            } else {
                array_push($karticaRacun, array('kljucKartice' => $kljucKartica, 'datumRacuna' => $datumRacuna, 'crno' => $crnoStavkaRacuna, 'kolicina' => $kolicinaStavkaRacuna, 'nabavnaCena' => $artikalCena, 'ARTIKAL_ID' => $artikalStavkaRacuna, 'ODELJENJE_ID' => $artikalOdeljenje));
            }
        }

        if ($artikalTip == 'SLOZ' || $artikalTip == 'DODA' || $artikalTip == 'PROD') {
            $getNormativ = mysqli_query($link, "SELECT kolicina, SASTOJAK_ID FROM normativ WHERE ARTIKAL_ID='$artikalStavkaRacuna' AND ODELJENJE_ID='$artikalOdeljenje'") or die(mysqli_error($link));
            while ($rowN = mysqli_fetch_array($getNormativ)) {
                $kolicinaN = $rowN['kolicina'];
                $sastojakN = $rowN['SASTOJAK_ID'];
                $kolicinaN = $kolicinaN * $kolicinaStavkaRacuna;
                $NV = mysqli_query($link, "SELECT trenutnaNV FROM artikal WHERE id = '$sastojakN'");
                $NV = mysqli_fetch_row($NV);
                $NV = $NV[0];
                $kljucKartica = $datumRacuna . '-' . $crnoStavkaRacuna . '-' . $sastojakN . '-' . $artikalOdeljenje;
                $Postoji = array_search($kljucKartica, array_column($karticaRacun, 'kljucKartice'));
                if (is_numeric($Postoji)) {
                    $karticaRacun[$Postoji]['kolicina'] = $karticaRacun[$Postoji]['kolicina'] + $kolicinaN;
                } else {
                    array_push($karticaRacun, array('kljucKartice' => $kljucKartica, 'datumRacuna' => $datumRacuna, 'crno' => $crnoStavkaRacuna, 'kolicina' => $kolicinaN, 'nabavnaCena' => $NV, 'ARTIKAL_ID' => $sastojakN, 'ODELJENJE_ID' => $artikalOdeljenje));
                }
            }
        }
    }
    foreach ($karticaRacun as $kartica) {
        $artikalRacun = $kartica['ARTIKAL_ID'];
        $datumRacun = $kartica['datumRacuna'];
        $crnoRacun = $kartica['crno'];
        $odeljenjeRacun = $kartica['ODELJENJE_ID'];
        $kolicinaRacun = $kartica['kolicina'];
        $IzlazKom = -1*$kolicinaRacun;
        $cenaRacun = $kartica['nabavnaCena'];
        mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                        . "VALUES ('$datumRacun', $crnoRacun, '', '$kolicinaRacun', '$cenaRacun', '$artikalRacun', '$odeljenjeRacun')") or die(mysqli_error($link));
    }
    $karticaRacun = '';
//Echo "RACUN END<br>";
    /* RACUNI END */
    /* OTPISI START */
//Echo "OTPIS Begin<br>";
    $Otpisi = mysqli_query($link, "SELECT id, crno, ODELJENJE_ID FROM otpis WHERE datum = '$t0'");
    while ($rowO = mysqli_fetch_array($Otpisi)) {

        $odeljenjeOtpisa = $rowO['ODELJENJE_ID'];
        $idOtpisa = $rowO['id'];
        $crnoOtpisa = $rowO['crno'];
        if ($crnoOtpisa == 1) {
            $datumOtpisa = $t46;
            $brOtpisa = 'Otpis 2';
            $crnoOtpisa = 1;
        } else {
            $datumOtpisa = $t45;
            $brOtpisa = 'Otpis 1';
            $crnoOtpisa = 0;
        }
        $StavkaOtpisa = mysqli_query($link, "SELECT kolicina, ARTIKAL_ID FROM otpisstavka WHERE OTPIS_ID='$idOtpisa'");
        while ($rowOS = mysqli_fetch_array($StavkaOtpisa)) {
            $artikalStavkaOtpisa = $rowOS['ARTIKAL_ID'];
            $kolicinaStavkaOtpisa = -1 * $rowOS['kolicina'];
            $getArtikal = mysqli_query($link, "SELECT tip, trenutnaNV FROM artikal WHERE id='$artikalStavkaOtpisa'");
            $getArtikal = mysqli_fetch_row($getArtikal);
            $artikalTip = $getArtikal[0];
            $komadStavkaOtpisa = $getArtikal[1];  
            if ($artikalTip != 'SLOZ' && $artikalTip != 'DODA') {
                mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                            . "VALUES ('$datumOtpisa', $crnoOtpisa, '$brOtpisa', 0, '$kolicinaStavkaOtpisa', '$komadStavkaOtpisa', '$artikalStavkaOtpisa', '$odeljenjeOtpisa')") or die(mysqli_error($link));
            }
            if ($artikalTip == 'SLOZ' || $artikalTip == 'DODA' || $artikalTip == 'PROD') {
                $getNormativO = mysqli_query($link, "SELECT kolicina, SASTOJAK_ID FROM normativ WHERE ARTIKAL_ID='$artikalStavkaOtpisa' AND ODELJENJE_ID='$odeljenjeOtpisa'") or die(mysqli_error($link));
                while ($rowNO = mysqli_fetch_array($getNormativO)) {
                    $kolicinaNO = $rowNO['kolicina'];
                    $sastojakNO = $rowNO['SASTOJAK_ID'];
                    $kolicinaNO = $kolicinaNO * $kolicinaStavkaOtpisa;
                    $NVO = mysqli_query($link, "SELECT trenutnaNV FROM artikal WHERE id = '$sastojakNO'");
                    $NVO = mysqli_fetch_row($NVO);
                    $NVO = $NVO[0];
                    mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                                    . "VALUES ('$datumOtpisa', $crnoOtpisa, '$brOtpisa', 0, '$kolicinaNO', '$NVO', '$sastojakNO', '$odeljenjeOtpisa')") or die(mysqli_error($link));
                }
            }
        }
    }
//Echo "OTPIS END";
    /* OTPISI END */
    /* PROIZVODNJA START */
//Echo "PROIZVODNJA Begin<br>";
    $Proizvodnja = mysqli_query($link, "SELECT id, crno, ODELJENJE_ID FROM proizvodnja WHERE datum = '$t0'");
    while ($rowPR = mysqli_fetch_array($Proizvodnja)) {

        $odeljenjeProizvodnje = $rowPR['ODELJENJE_ID'];
        $idProizvodnje = $rowPR['id'];
        $crnoProizvodnje = $rowPR['crno'];
        if ($crnoProizvodnje) {
            $datumProizvodnje = $t25;
            $brProizvodnje = 'Proizvodnja 2';
            $crnoProizvodnje = 1;
        } else {
            $datumProizvodnje = $t24;
            $brProizvodnje = 'Proizvodnja 1';
            $crnoProizvodnje = 0;
        }
        $StavkaProizvodnje = mysqli_query($link, "SELECT kolicina, ARTIKAL_ID FROM proizvodnjastavka WHERE PROIZVODNJA_ID='$idProizvodnje'");
        while ($rowPRS = mysqli_fetch_array($StavkaProizvodnje)) {
            $artikalStavkaProizvodnje = $rowPRS['ARTIKAL_ID'];
            $kolicinaStavkaProizvodnje = $rowPRS['kolicina'];

            $getArtikal = mysqli_query($link, "SELECT tip, trenutnaNV FROM artikal WHERE id='$artikalStavkaProizvodnje'");
            $getArtikal = mysqli_fetch_row($getArtikal);
            $artikalTip = $getArtikal[0];
            $komadStavkaProizvodnje = $getArtikal[1];
            
                mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                            . "VALUES ('$datumProizvodnje', $crnoProizvodnje, '$brProizvodnje', 0, '$kolicinaStavkaProizvodnje', '$komadStavkaProizvodnje', '$artikalStavkaProizvodnje', '$odeljenjeProizvodnje')") or die(mysqli_error($link));

            if ($artikalTip == 'SLOZ' || $artikalTip == 'DODA' || $artikalTip == 'PROD' || $artikalTip == 'POLU') {
                $getNormativP = mysqli_query($link, "SELECT kolicina, SASTOJAK_ID FROM normativ WHERE ARTIKAL_ID='$artikalStavkaProizvodnje' AND ODELJENJE_ID='$odeljenjeProizvodnje'") or die(mysqli_error($link));
                while ($rowNP = mysqli_fetch_array($getNormativP)) {
                    $kolicinaNP = $rowNP['kolicina'];
                    $sastojakNP = $rowNP['SASTOJAK_ID'];
                    $kolicinaNP = -1*$kolicinaNP * $kolicinaStavkaProizvodnje;
                    $NVP = mysqli_query($link, "SELECT trenutnaNV FROM artikal WHERE id = '$sastojakNP'");
                    $NVP = mysqli_fetch_row($NVP);
                    $NVP = $NVP[0];
                    mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                                    . "VALUES ('$datumProizvodnje', $crnoProizvodnje, '$brProizvodnje', 0, '$kolicinaNP', '$NVP', '$sastojakNP', '$odeljenjeProizvodnje')") or die(mysqli_error($link));
                }
            }
        }
    }
//Echo "PROIZVODNJA END<br>";
    /* PROIZVODNJA END */
    
    /* Utrosak START */
    
    $Utrosak = mysqli_query($link, "SELECT id, crno, ODELJENJE_ID, broj FROM utrosakdoc WHERE datum >= '$pocetni_datum'");
    while ($rowUT = mysqli_fetch_array($Utrosak)) {
        $odeljenjeUtroska = $rowUT['ODELJENJE_ID'];
        $idUtroska = $rowUT['id'];
        $crnoUtroska = $rowUT['crno'];
        if ($crnoUtroska == 1) {
            $datumUtroska = $t26;
            $brUtroska = 'Utrosak '.$rowUT['broj'];
            $crnoUtroska = 1;            
        } else {
            $datumUtroska = $t26;
            $brUtroska = 'Utrosak '.$rowUT['broj'];
            $crnoUtroska = 0;
        }
        $StavkaUtroska = mysqli_query($link, "SELECT kolicina, ARTIKAL_ID, cena FROM utrosakdocstavke WHERE UTROSAKDOC_ID='$idUtroska'");
        while ($rowUTS = mysqli_fetch_array($StavkaUtroska)) {
            $artikalStavkaUtroska = $rowUTS['ARTIKAL_ID'];
            $kolicinaStavkaUtroska = -$rowUTS['kolicina'];
            $komadStavkaUtroska = $rowUTS['cena'];
            $getArtikal = mysqli_query($link, "SELECT tip, trenutnaNV FROM artikal WHERE id='$artikalStavkaUtroska'");
            $getArtikal = mysqli_fetch_row($getArtikal);
            $artikalTip = $getArtikal[0];
            if ($artikalTip != 'SLOZ' && $artikalTip != 'DODA') {
                mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                            . "VALUES ('$datumUtroska', $crnoUtroska, '$brUtroska', 0, '$kolicinaStavkaUtroska', '$komadStavkaUtroska', '$artikalStavkaUtroska', '$odeljenjeUtroska')") or die(mysqli_error($link));
            }
            
            if ($artikalTip == 'SLOZ' || $artikalTip == 'DODA' || $artikalTip == 'PROD') {
                $getNormativU = mysqli_query($link, "SELECT kolicina, SASTOJAK_ID FROM normativ WHERE ARTIKAL_ID='$artikalStavkaUtroska' AND ODELJENJE_ID='$odeljenjeUtroska'") or die(mysqli_error($link));
                while ($rowNU = mysqli_fetch_array($getNormativU)) {
                    $kolicinaNU = $rowNU['kolicina'];
                    $sastojakNU = $rowNU['SASTOJAK_ID'];
                    $kolicinaNU = $kolicinaNU * $kolicinaStavkaUtroska;
                    $NVU = mysqli_query($link, "SELECT trenutnaNV FROM artikal WHERE id = '$sastojakNU'");
                    $NVU = mysqli_fetch_row($NVU);
                    $NVU = $NVU[0];
                    mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                                    . "VALUES ('$datumUtroska', $crnoUtroska, '$brUtroska', 0, '$kolicinaNU', '$NVU', '$sastojakNU', '$odeljenjeUtroska')") or die(mysqli_error($link));
                }
            }
        }
    }
    /* Utrosak END */
}

function PopisSravni($datum) {
	global $link;
    $Popis = mysqli_query($link, "SELECT id, crno, ODELJENJE_ID, broj FROM popis WHERE datum = '$datum' AND sravnjenje='1'");
    while ($rowPO = mysqli_fetch_array($Popis)) {
        $odeljenjePopisa = $rowPO['ODELJENJE_ID'];
        $idPopisa = $rowPO['id'];
        $brojPopisa = $rowPO['broj'];
        $crnoPopisa = $rowPO['crno'];
        if ($crnoPopisa == 1) {
            $crnoPopisa = 1;
        } else {
            $crnoPopisa = 0;
        }
        $datumPopisa = getDatumKartica(dateBefore($datum), 50);
        $brPopisa = 'Popis/' . $brojPopisa;

        $StavkaPopisa = mysqli_query($link, "SELECT stanje1, ARTIKAL_ID FROM stavkapopisa WHERE POPIS_ID='$idPopisa'") or die(mysqli_error($link));
        while ($rowPOPS = mysqli_fetch_array($StavkaPopisa)) {
            $artikalStavkaPopisa = $rowPOPS['ARTIKAL_ID'];
            $kolicinaStavkaPopisa = number_format($rowPOPS['stanje1'], 2, '.', '');
            $getArtikal = mysqli_query($link, "SELECT tip, trenutnaNV FROM artikal WHERE id='$artikalStavkaPopisa'") or die(mysqli_error($link));
            $getArtikal = mysqli_fetch_row($getArtikal);
            $artikalTip = $getArtikal[0];
            $komadStavkaPopisa = $getArtikal[1];
            mysqli_query($link, "INSERT INTO kartica (datum, crno, dokument, izlazKOM, kolicina, nabavnaCena, ARTIKAL_ID, ODELJENJE_ID) "
                            . "VALUES ('$datumPopisa', $crnoPopisa, '$brPopisa', null, '$kolicinaStavkaPopisa', '$komadStavkaPopisa', '$artikalStavkaPopisa', '$odeljenjePopisa')") or die(mysqli_error($link));
        }
    }
    //Echo "POPIS END<br>";
}

function IzracunajDnevniPromet($zaDatum) {
	global $link;
    $dateFrom = getStartDateOnCards($zaDatum);
    $dateTo = getEndDateOnCards($zaDatum);
    if ($dateFrom > $dateTo) {
        $GetDateFrom = mysqli_query($link, "SELECT zakljucenje FROM zd WHERE zakljucenje<='$dateTo' AND pocetak=0 ORDER BY zakljucenje DESC LIMIT 1");
        if (mysqli_num_rows($GetDateFrom) == 1) {
            $dateFrom = date('Y-m-d H:i:00', strtotime(mysqli_fetch_array($GetDateFrom)['zakljucenje']));
        } else {
            $dateFrom = $dateTo;
        }
    }
    //Echo "DP Begin<br>";
    $karticaDP = array();
    $dp = mysqli_query($link, "SELECT ARTIKAL_ID, ODELJENJE_ID, SUM(IF(kolicina<0 AND crno=1, kolicina, 0)) AS izlazCrno, "
            . "SUM(IF(kolicina>0 AND crno=1, kolicina, 0)) AS ulazCrno, "
            . "SUM(IF(kolicina>0 AND crno=0, kolicina, 0)) AS ulazBelo, "
            . "SUM(IF(kolicina<0 AND crno=0, kolicina, 0)) AS izlazBelo FROM kartica WHERE datum>= '$dateFrom' AND datum<= '$dateTo' AND dokument NOT LIKE 'Otpis%' GROUP BY ARTIKAL_ID, ODELJENJE_ID") or die(mysqli_error($link));
    while ($rowDP = mysqli_fetch_array($dp)) {
        $datumDP = $zaDatum;
        $artikalDP = $rowDP['ARTIKAL_ID'];
        $odeljenjeDP = $rowDP['ODELJENJE_ID'];
        $izlazBeloDP = 0 + $rowDP['izlazBelo'];
        $ulazBeloDP = 0 + $rowDP['ulazBelo'];
        $izlazCrnoDP = 0 + $rowDP['izlazCrno'];
        $ulazCrnoDP = 0 + $rowDP['ulazCrno'];
        $artikalNazivDP = mysqli_query($link, "SELECT name FROM artikal WHERE id = '$artikalDP'");
        $artikalNazivDP = mysqli_fetch_row($artikalNazivDP);
        $artikalNazivDP = $artikalNazivDP[0];

        $kljucKartica = $datumDP . '-' . $artikalDP . '-' . $odeljenjeDP;

        $Postoji = array_search($kljucKartica, array_column($karticaDP, 'kljucKartice'));
        if (is_numeric($Postoji)) {
            $karticaDP[$Postoji]['izlazBelo'] = $karticaDP[$Postoji]['izlazBelo'] + $izlazBeloDP;
            $karticaDP[$Postoji]['izlazCrno'] = $karticaDP[$Postoji]['izlazCrno'] + $izlazCrnoDP;
            $karticaDP[$Postoji]['ulazBelo'] = $karticaDP[$Postoji]['ulazBelo'] + $ulazBeloDP;
            $karticaDP[$Postoji]['ulazCrno'] = $karticaDP[$Postoji]['ulazCrno'] + $ulazCrnoDP;
        } else {
            array_push($karticaDP, array('kljucKartice' => $kljucKartica, 'datum' => $zaDatum, 'artikal' => $artikalNazivDP, 'artikalID' => $artikalDP, 'beloIzlaz' => $izlazBeloDP, 'beloUlaz' => $ulazBeloDP, 'crnoIzlaz' => $izlazCrnoDP, 'crnoUlaz' => $ulazCrnoDP, 'ODELJENJE_ID' => $odeljenjeDP));
        }
    }
    $dpOtpis = mysqli_query($link, "SELECT ARTIKAL_ID, ODELJENJE_ID, SUM(IF(crno=1, kolicina, 0)) otpisCrno, SUM(IF(crno=0, kolicina, 0)) otpisBelo FROM kartica WHERE datum BETWEEN '$dateFrom' AND '$dateTo' AND dokument LIKE 'Otpis%' GROUP BY ARTIKAL_ID, ODELJENJE_ID") or die(mysqli_error($link));
    while ($rowDPO = mysqli_fetch_array($dpOtpis)) {
        $datumDPO = $rowDPO['datum'];
        $artikalDPO = $rowDPO['ARTIKAL_ID'];
        $odeljenjeDPO = $rowDPO['ODELJENJE_ID'];
        $otpisCrnoDPO = 0 + $rowDPO['otpisCrno'];
        $otpisBeloDPO = 0 + $rowDPO['otpisBelo'];


        $kljucKartica = $datumDPO . '-' . $artikalDPO . '-' . $odeljenjeDPO;

        $Postoji = array_search($kljucKartica, array_column($karticaDP, 'kljucKartice'));
        if (is_numeric($Postoji)) {
            $karticaDP[$Postoji]['ulazBelo'] = $karticaDP[$Postoji]['ulazBelo'] + $otpisBeloDPO;
            $karticaDP[$Postoji]['ulazCrno'] = $karticaDP[$Postoji]['ulazCrno'] + $otpisCrnoDPO;
        } else {
            $artikalNazivDPO = mysqli_query($link, "SELECT name FROM artikal WHERE id = '$artikalDPO'");
            $artikalNazivDPO = mysqli_fetch_row($artikalNazivDPO);
            $artikalNazivDPO = $artikalNazivDPO[0];
            array_push($karticaDP, array('kljucKartice' => $kljucKartica, 'datum' => $zaDatum, 'artikal' => $artikalNazivDPO, 'artikalID' => $artikalDPO, 'beloIzlaz' => '0', 'beloUlaz' => $otpisBeloDPO, 'crnoIzlaz' => '0', 'crnoUlaz' => $otpisCrnoDPO, 'ODELJENJE_ID' => $odeljenjeDPO));
        }
    }
    foreach ($karticaDP as $kartica) {
        $artikalDP = $kartica['artikalID'];
        $artikalNazivDP = $kartica['artikal'];
        $beloIzlazDP = 0 + $kartica['beloIzlaz']*-1;
        $crnoIzlazDP = 0 + $kartica['crnoIzlaz']*-1;
        $beloUlazDP = 0 + $kartica['beloUlaz'];
        $crnoUlazDP = 0 + $kartica['crnoUlaz'];
        $datumDP = $kartica['datum'];
        $odeljenjeDP = $kartica['ODELJENJE_ID'];
        

        mysqli_query($link, "INSERT INTO dnevnostanje (artikal, artikalID, beloIzlaz, beloUlaz, crnoIzlaz, crnoUlaz, datum, ODELJENJE_ID) "
                        . "VALUES ('$artikalNazivDP', '$artikalDP', '$beloIzlazDP', '$beloUlazDP', '$crnoIzlazDP', '$crnoUlazDP', '$datumDP', '$odeljenjeDP')") or die(mysqli_error($link));
    }
    $karticaDP = '';
    //Echo "DP END<br>";
}

function rekonstrukcijaKarticaSaPrikazom($date, $dateTos) {
	global $link;
    $dateFrom = getStartDateOnCards($date);
    $dateTo = getEndDateOnCards($dateTos);
    if (strtotime($dateFrom) > strtotime($dateTo)) {
        $GetDateFrom = mysqli_query($link, "SELECT zakljucenje FROM zd WHERE zakljucenje<='$dateTo' AND pocetak=0 ORDER BY zakljucenje DESC LIMIT 1");
        if (mysqli_num_rows($GetDateFrom) == 1) {
            $dateFrom = date('Y-m-d H:i:00', strtotime(mysqli_fetch_array($GetDateFrom)['zakljucenje']));
        } else {
            $dateFrom = $dateTo;
        }
    }
    deleteKarticaJPA($dateFrom, $dateTo);
    deleteDnevnoStanje($dateFrom, $dateTo);
    fixPopisOnFirstDate($dateFrom);
    $DateFrom = date('Y-m-d', strtotime($dateFrom));
    $DateTo = date('Y-m-d', strtotime($dateTo));
    $AllZDInRange = mysqli_query($link, "SELECT datum FROM zd WHERE datum >='$DateFrom' AND datum <='$DateTo' GROUP BY datum ORDER BY datum ASC") or die("Greska na upitu");
    if (mysqli_num_rows($AllZDInRange) != 0) {
        while ($rowZDR = mysqli_fetch_array($AllZDInRange)) {
            $date = $rowZDR['datum'];
            RekonstrukcijaKartica($date);
            fixPopis($date, dateAfter($date));
            IzracunajDnevniPromet($date);
        }
    }
}

function fixPopisOnFirstDate($date) {
	global $link;
    $date = date('Y-m-d', strtotime($date));
    $Popis = mysqli_query($link, "SELECT id FROM popis WHERE datum = '$date'") or die(mysqli_error($link));
    if (mysqli_num_rows($Popis) != 0) {
        deleteDnevnoStanje(dateBefore($date), dateBefore($date));
        while ($rowBP = mysqli_fetch_array($Popis)) {
            $poDatumu = getDatumKartica(dateBefore($date), 50);
            deleteKarticuPopisa($poDatumu);
            IzracunajDnevniPromet(dateBefore($date));
            PopisSravni($date);
        }
    }
}

function fixPopis($pocetni_datum, $krajnji_datum) {
	global $link;
    $dateStart = date("Y-m-d", strtotime($pocetni_datum));
    $dateEnd = date("Y-m-d", strtotime($krajnji_datum));
    if ($dateStart == $dateEnd) {
        fixPopisOnFirstDate($dateStart);
    } else {
        PopisSravni($dateEnd);
    }
}

function deleteDnevnoStanje($date, $dateTo) {
	global $link;
    $date = date('Y-m-d', strtotime($date));
    $dateTo = date('Y-m-d', strtotime($dateTo));
    mysqli_query($link, "DELETE FROM dnevnostanje WHERE datum >= '$date' AND datum <='$dateTo'") or die(mysqli_error($link));
}
function deleteKarticaJPA($dateBegin, $dateEnd) {
	global $link;
    $deleteJPA = mysqli_query($link, "DELETE FROM kartica WHERE datum BETWEEN '$dateBegin' AND '$dateEnd'") or die(mysqli_error($link));
}

function deleteKarticuPopisa($poDatumu) {
	global $link;
    mysqli_query($link, "DELETE FROM kartica WHERE datum = '$poDatumu'") or die(mysqli_error($link));
}

function getMagacin() {
    global $mysqli;
    $query = "select * from odeljenje where odeljenje.magacin = 1";
    $result = $mysqli->query($query);
    if ($result->num_rows == 0) {
        $query = "select * from odeljenje where odeljenje.naziv = 'OD_MAGACIN'";
        $result = $mysqli->query($query);
        if ($result->num_rows == 0) {
            $query = "select * from odeljenje where odeljenje.naziv = 'MAGACIN'";
            $result = $mysqli->query($query);
            if ($result->num_rows == 0) {
                $magacin = null;
            } else {
                while ($row = $result->fetch_array())
                    $magacin = $row;
            }
        } else {
            while ($row = $result->fetch_array())
                $magacin = $row;
        }
    } else {
        while ($row = $result->fetch_array())
            $magacin = $row;
    }
    return $magacin;
}

function dateBefore($date) {
	global $link;
    $date = date('Y-m-d', strtotime($date . " -1 days"));
    return $date;
}

function dateAfter($date) {
    $date = date('Y-m-d', strtotime($date . " +1 days"));
    return $date;
}

function getEndDateOnCards($date) {
	global $link;
    $NV = mysqli_query($link, "SELECT zakljucenje FROM zd WHERE datum >= '$date' AND pocetak=0 ORDER BY id DESC LIMIT 1") or die('umro na GetEndDateOnCards');
    if (mysqli_num_rows($NV) != 0) {
        $NVres = mysqli_fetch_array($NV);
        $NV1 = $NVres['zakljucenje'];
        if ($NV1 == '' || $NV1 == null) {
            $date = date('Y-m-d 23:59:59', strtotime($date));
        } else {            
            $date = date('Y-m-d H:i:s', strtotime($NV1));
        }
    }else{
        $date = date('Y-m-d 23:59:59', strtotime($date));
    }
    return $date;
}

function getStartDateOnCards($date) {
	global $link;
    $NVA = "";
    $NV = mysqli_query($link, "SELECT zakljucenje FROM zd WHERE datum <= '$date' AND pocetak=1 ORDER BY id DESC LIMIT 1") or die('umro na GetStartDateOnCards');
    if (mysqli_num_rows($NV) == 1) {
        $NVres = mysqli_fetch_array($NV);
        $NVA = $NVres['zakljucenje'];
    } 
    if ($NVA == '' || $NVA == null) {
        $date = date('Y-m-d 00:00:00', strtotime($date));
    } else {
        $date = date('Y-m-d H:i:00', strtotime($NVA));
    }    
    return $date;
}

function getDatumKartica($time, $seconds) {
	global $link;
    $time = getStartDateOnCards($time);
    $date = date('Y-m-d H:i:' . $seconds . '', strtotime($time));
    return $date;
}

?>