<?php

if ($DirectStop != "CuCaNaBuCaNa") {
    header("Location: ./logout.php");
    die();
}
require_once('stampa/config/tcpdf_config_alt.php');
require_once('stampa/tcpdf.php');
require_once('stampa/tcpdf_include.php');

class PDF extends TCPDF {

    function Footer() {
        $this->SetY(-10);
        $PageNo = $this->PageNo();
        $this->SetFont('dejavusans', '', 5);
        $DateTime = date('d.m.Y H:i:s');
        $FooterPrint = <<<EOD
                    <table border="0" cellpadding="0">
                    <tr>
                        <td style="width: 10%; text-align: left;">
                            <b>str. $PageNo</b>
                        </td>
                        <td style="width: 90%; text-align: right;">
                            <i>Dokument štampan $DateTime iz programa "Barmaster" autor 5.com.d.o.o. -www.petcom.rs- Software for Business and Pleasure</i>
                        </td>
                    </tr>
                    </table>
EOD;
        $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $FooterPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }

    function Header() {
        $this->SetFont('dejavusansb', '', 8);
        global $SiteName;

        $ThisCompanyName = $SiteName;
        global $ThisCompanyPIB;
        global $ThisCompanyMB;
        global $ThisCompanyAddress;
        global $ThisCompanyZip;
        global $ThisCompanyCity;
        $ThisCompanyPhone = "";
        global $ThisCompanySifraDelatnosti;
        global $ThisCompanyRacun;
        global $ThisCompanyBanka;
        global $Updv;

        $ThisCompanyPhone2 = "";
        $PrintThisAddress = '';
        if ($ThisCompanyAddress != '') {
            $PrintThisAddress .= $ThisCompanyAddress;
        }
        if ($ThisCompanyZip != '') {
            $PrintThisAddress .= ', ' . $ThisCompanyZip;
        }
        if ($ThisCompanyCity != '') {
            $PrintThisAddress .= ', ' . $ThisCompanyCity;
        }
        $IncLines = 0;
        $this->Ln(5);
        $HeaderHtml = '<table border="0" cellpadding="0">';
        $HeaderHtml .= '<tr>
                    <td style="text-align: left; width: 50%; font-size: 7mm;">' . $ThisCompanyName . '</td>
                    <td style="text-align: right; width: 50%">';
        if ($ThisCompanyName != '') {
            $HeaderHtml .= '<b>' . $ThisCompanyName . '</b><br>';
        }
        $this->SetFont('dejavusans', '', 8);
        if ($ThisCompanyPIB != '') {
            $HeaderHtml .= '<b>PIB: </b>' . $ThisCompanyPIB . '<br>';
        }
        if ($ThisCompanyMB != '') {
            $HeaderHtml .= '<b>MB: </b>' . $ThisCompanyMB . '<br>';
        }
        if ($ThisCompanyMB != '') {
            $HeaderHtml .= $PrintThisAddress . '<br>';
        }
        if ($ThisCompanyPhone != '') {
            $HeaderHtml .= '<b>Telefon: </b>' . $ThisCompanyPhone . '<br>';
        }
        if ($ThisCompanyPhone2 != '') {
            $HeaderHtml .= $ThisCompanyPhone2 . '<br>';
        }

        if ($Updv == "true") {
            $HeaderHtml .= '<b>U sistemu PDV: </b> DA<br>';
        } else {
            $HeaderHtml .= '<b>U sistemu PDV: </b> NE<br>';
        }
        $HeaderHtml .= '<b>Šifra delatnosti: </b>' . $ThisCompanySifraDelatnosti . '<br>';
        $HeaderHtml .= '<b>' . $ThisCompanyBanka . ': </b>' . $ThisCompanyRacun . '<br>';
        $HeaderHtml .= '</td>
            </tr></table>';
        $HeaderHtml = <<<EOD
            $HeaderHtml
EOD;
        $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $HeaderHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }

}

$UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
$LogDate = date('Y-m-d');
$LogTime = date('H:i:s');
$LogUser = $UserName;
$LogWhat = "Stampa storno liste -> Korisnik: " . $UserName;
mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");

$GetZd = mysqli_query($link, "SELECT * FROM zd WHERE datum<='now()' AND pocetak=1 ORDER BY id DESC LIMIT 1");
if (mysqli_num_rows($GetZd) == 1) {
    $ZdVreme = mysqli_fetch_array($GetZd)['zakljucenje'];
    $GetStorno = mysqli_query($link, "SELECT * FROM storno WHERE vremeStorniranja>='$ZdVreme' ORDER BY id DESC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetStorno) > 0) {
        $GetKonobari = mysqli_query($link, "SELECT * FROM konobar");
        $Konobari = [];
        if (mysqli_num_rows($GetKonobari) > 0) {
            while ($rowKonobar = mysqli_fetch_array($GetKonobari)) {
                $Konobari[$rowKonobar['id']] = $rowKonobar['punoIme'];
            }
        }
        $Updv = GetSettingVal('objekat.updv');
        $ThisCompanyPIB = GetSettingVal('objekat.pib');
        $ThisCompanyMB = GetSettingVal('objekat.maticni.broj');
        $ThisCompanyAddress = GetSettingVal('objekat.adresa');
        $ThisCompanyZip = GetSettingVal('objekat.maticni.broj');
        $ThisCompanyCity = GetSettingVal('objekat.mesto');
        $ThisCompanySifraDelatnosti = GetSettingVal('objekat.sifra.delatnosti');
        $ThisCompanyRacun = GetSettingVal('objekat.racun');
        $ThisCompanyBanka = GetSettingVal('objekat.banka');

        $pdf = new PDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $SheetName = "Storno lista -" . date('Y-m-d');
        $pdf->SetFont('dejavusans', '', 10);
        $pdf->SetTitle($SheetName);

        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Sparkom Software www.sparkom.net');
        $pdf->SetTitle($SheetName);
        $pdf->SetSubject($SheetName);
        $pdf->SetFont('dejavusans', '', 8);
        $pdf->SetMargins(8, 40, 8);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->startPageGroup();
        $pdf->AddPage();
        $pdf->Cell(0, 1, "", "T", 1, "C");


        $pdf->SetFont('dejavusansb', '', 14);
        $pdf->Cell(0, 10, "Storno lista na dan: " . date('d.m.Y', strtotime($ZdVreme)), 0, 1, 'C');

        $pdf->SetFont('dejavusansb', '', 8);
        $pdf->Ln();
        $pdf->SetFillColor(200, 200, 200);
        $pdf->SetFont('dejavusans', '', 6);

        while ($rowStorno = mysqli_fetch_array($GetStorno)) {
            $Rb = 1;
            $ArtikliSadrzaj = '<table border="0" cellpadding="2">
                    <thead>
                    <tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 30%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Operater</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Datum</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Vreme</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Sto</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Tip</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 30%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Stornirao</b></td>
                    </tr>';
            $ArtikliSadrzaj .= '<tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 30%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . $Konobari[$rowStorno['KONOBAR_ID']] . '</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . date('d.m.Y', strtotime($rowStorno['vremeStorniranja'])) . '</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . date('H:i:s', strtotime($rowStorno['vremeStorniranja'])) . '</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . $rowStorno['brojStola'] . '</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . $rowStorno['tipStorna'] . '</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 30%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>' . $rowStorno['user'] . '</b></td>
                    </tr>';
            $ArtikliSadrzaj .= '<tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 5%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>RB</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 40%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Artikal</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 15%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Kolicina</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Cena</b></td>
                        <td colspan="2" style="background-color:#DDDDDD;color:#111111;text-align: right; width: 30%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Ukupno</b></td>
                    </tr></thead>';
            $StornoId = $rowStorno['id'];
            $GetArtikle = mysqli_query($link, "SELECT a.name, s.* FROM stornostavka s, artikal a WHERE s.ARTIKAL_ID=a.id AND s.STORNO_ID='$StornoId'");
            if (mysqli_num_rows($GetArtikle) > 0) {
                $Ukupno = 0;
                while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
                    $Cena = $rowArtikle['vrednost'] / $rowArtikle['kolicina'];
                    $Ukupno = $Ukupno + $rowArtikle['vrednost'];
                    $ArtikliSadrzaj .= '<tr>
                            <td style="text-align: center; width: 5%; border: 1px solid #333;">' . $Rb . '.</td>
                            <td style="text-align: left; width: 40%; border: 1px solid #333;">' . $rowArtikle['name'] . '</td>
                            <td style="text-align: center; width: 15%; border: 1px solid #333;">' . $rowArtikle['kolicina'] . '</td>
                            <td style="text-align: center; width: 10%; border: 1px solid #333;">' . $Cena . '</td>
                            <td colspan="2" style="text-align: right; width: 30%; border: 1px solid #333;"><b>' . $rowArtikle['vrednost'] . '</b></td>
                        </tr>';
                    $Rb++;
                }
                $ArtikliSadrzaj .= '<tr>
                            <td colspan="4" style="background-color:#DDDDDD;color:#111111;text-align: center; width: 70%; border: 1px solid #333;"><b>Ukupno: </b></td>
                            <td colspan="2" style="background-color:#DDDDDD;color:#111111;text-align: right; width: 30%; border: 1px solid #333;"><b>' . $Ukupno . '</b></td>
                        </tr>';
            }
            $ArtikliSadrzaj .= '</table><br>';
            $ArtikliSadrzaj = <<<EOD
            $ArtikliSadrzaj
EOD;
            $pdf->SetFont('dejavusans', '', 7);
            $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
        }

        $FileName = str_replace('.', '-', $SheetName);
        $FileName = str_replace('/', '-', $FileName);
        $FileName = str_replace(':', ' ', $FileName);
        $pdf->Output($FileName . '.pdf', I);
    } else {
        Echo "Greska pri kreiranju PDF Fajla Nema storna...";
    }
} else {
    Echo "Greska pri kreiranju PDF Fajla Nema radnog dana...";
}