<?php

if ($DirectStop != "CuCaNaBuCaNa") {
    header("Location: ./logout.php");
    die();
}
if (isset($_GET['id'])) {
    $CurrentPageId = mysqli_real_escape_string($link, $_GET['id']);
    require_once('stampa/config/tcpdf_config_alt.php');
    require_once('stampa/tcpdf.php');
    require_once('stampa/tcpdf_include.php');

    class PDF extends TCPDF {

        function Footer() {
            $this->SetY(-10);
            $this->SetFont('dejavusans', '', 5);
            $PageNo = $this->PageNo();
            $DateTime = date('d.m.Y H:i:s');
            $FooterPrint = <<<EOD
                    <table border="0" cellpadding="0">
                    <tr>
                        <td style="width: 10%; text-align: left;">
                            
                        </td>
                        <td style="width: 90%; text-align: right;">
                            <i>Dokument štampan $DateTime | www.petcom.rs 011 4 405 405 Programska resenja za ugostiteljstvo Bmaster #3klika</i>
                        </td>
                    </tr>
                    </table>
EOD;
            $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $FooterPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
        }

        function Header() {
            $this->SetFont('dejavusansb', '', 8);
            global $SiteName;

            $ThisCompanyName = $SiteName;
            $ThisCompanyPIB = GetSettingVal('objekat.pib');
            $ThisCompanyMB = GetSettingVal('objekat.maticni.broj');
            $ThisCompanyAddress = GetSettingVal('objekat.adresa');
            $ThisCompanyCity = GetSettingVal('objekat.mesto');
            $ThisCompanyPhone = GetSettingVal('objekat.telefon');
            $ThisCompanyPhone2 = "";
            $PrintThisAddress = '';
            if ($ThisCompanyAddress != '') {
                $PrintThisAddress .= $ThisCompanyAddress;
            }
            if ($ThisCompanyCity != '') {
                $PrintThisAddress .= ', ' . $ThisCompanyCity;
            }
            $IncLines = 0;
            $this->Ln(5);
            $HeaderHtml = '<table border="0" cellpadding="0">';
            $FakturaLogo = GetSettingVal('faktura.logo.zaglavlja');
            if ($FakturaLogo != '') {
                $HeaderHtml .= '<tr>
                    <td style="text-align: left; width: 50%; font-size: 7mm;"><img src="' . $FakturaLogo . '" style="height: 33mm;" /></td>
                    <td style="text-align: right; width: 50%">';
            } else {
                $HeaderHtml .= '<tr>
                    <td style="text-align: left; width: 50%; font-size: 7mm;">' . $ThisCompanyName . '</td>
                    <td style="text-align: right; width: 50%">';
            }
            if ($ThisCompanyName != '') {
                $HeaderHtml .= '<b>' . $ThisCompanyName . '</b><br>';
            }
            $this->SetFont('dejavusans', '', 8);
            if ($ThisCompanyPIB != '') {
                $HeaderHtml .= '<b>PIB: </b>' . $ThisCompanyPIB . '<br>';
            }
            if ($ThisCompanyMB != '') {
                $HeaderHtml .= '<b>MB: </b>' . $ThisCompanyMB . '<br>';
            }
            if ($PrintThisAddress != '') {
                $HeaderHtml .= $PrintThisAddress . '<br>';
            }
            if ($ThisCompanyPhone != '') {
                $HeaderHtml .= '<b>Telefon: </b>' . $ThisCompanyPhone . '<br>';
            }
            $Updv = GetSettingVal('objekat.updv');
            if ($Updv == "true") {
                $HeaderHtml .= '<b>U sistemu PDV: </b> DA<br>';
            } else {
                $HeaderHtml .= '<b>U sistemu PDV: </b> NE<br>';
            }
            $HeaderHtml .= '<b>Šifra delatnosti: </b>' . GetSettingVal('objekat.sifra.delatnosti') . '<br>';
            $HeaderHtml .= '<b>' . GetSettingVal('objekat.banka') . ': </b>' . GetSettingVal('objekat.racun') . '<br>';
            $HeaderHtml .= '</td>
            </tr></table>';
            $HeaderHtml = <<<EOD
            $HeaderHtml
EOD;
            $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $HeaderHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
        }

    }

    if ($CurrentPageId != '') {
        $UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
        $LogDate = date('Y-m-d');
        $LogTime = date('H:i:s');
        $LogUser = $UserName;
        $LogWhat = "Stampa fakture -> Korisnik: " . $UserName . " ID RACUNA->" . $CurrentPageId;
        mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");

        $Komitent = 0;
        $StalniGost = 0;
        if (isset($_GET['BrojIsecka'])) {
            $BrojIsecka = mysqli_real_escape_string($link, $_GET['BrojIsecka']);
            if ($BrojIsecka > 0) {
                mysqli_query($link, "UPDATE racun SET brojBI='$BrojIsecka' WHERE id='$CurrentPageId' AND zatvoren=1");
            }
        }
        $KupacPib = "";
        $KupacNaziv = "";
        $KupacAdresa = "";
        $KupacMesto = "";
        $KupacMB = "";

        $GetDocument = mysqli_query($link, "SELECT * FROM racun WHERE id='$CurrentPageId' AND zatvoren=1");
        if (mysqli_num_rows($GetDocument) != 0) {
            $ResDocument = mysqli_fetch_array($GetDocument);
            $StalniGost = $ResDocument['STALNIGOST_ID'];
            if ($ResDocument['brojFakture'] == '') {
                $BrojFakture = GetSettingVal('faktura.broj.sledeci');
                if ($BrojFakture > 0) {
                    mysqli_query($link, "UPDATE racun SET brojFakture='$BrojFakture' WHERE id='$CurrentPageId'");
                    $NoviBrojFakture = $BrojFakture + 1;
                    mysqli_query($link, "UPDATE setting SET actual='$NoviBrojFakture' WHERE name='faktura.broj.sledeci'");
                } else {
                    $BrojFakture = 1;
                    $NoviBrojFakture = $BrojFakture + 1;
                    mysqli_query($link, "UPDATE racun SET brojFakture='$BrojFakture' WHERE id='$CurrentPageId'");
                    mysqli_query($link, "UPDATE setting SET actual='$NoviBrojFakture' WHERE name='faktura.broj.sledeci'");
                }
                $ResDocument['brojFakture'] = $BrojFakture;
            }
            $GetKupacData = mysqli_query($link, "SELECT * FROM stalnigost WHERE id='$StalniGost'");
            $KupacData = mysqli_fetch_array($GetKupacData);
            $KupacPib = $KupacData['pib'];
            $KupacNaziv = $KupacData['naziv'];
            $KupacAdresa = $KupacData['adersa'];
            $KupacMesto = $KupacData['mesto'];
            $KupacMB = $KupacData['maticniBroj'];

            $pdf = new PDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
            $SheetName = "Racun " . $ResDocument['brojFakture'] . '-' . date('Y', strtotime($ResDocument['datum']));
            $pdf->SetFont('dejavusans', '', 10);
            $pdf->SetTitle($SheetName);


            $ValutaZnak = 'rsd';
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor('Sparkom Software www.sparkom.net');
            $pdf->SetTitle($SheetName);
            $pdf->SetSubject($SheetName);
            $pdf->SetFont('dejavusans', '', 8);
            $pdf->SetMargins(8, 40, 8);
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
            $MestoIzdavanja = GetSettingVal('objekat.mesto');
            $HowManyInvoices = GetSettingVal('faktura.broj.kopija.fakture');
            if ($HowManyInvoices == "") {
                $HowManyInvoices = 1;
            }
            for ($i = 0; $i < $HowManyInvoices; $i++) {
                $pdf->startPageGroup();
                $pdf->AddPage();
                $pdf->Cell(0, 1, "", "T", 1, "C");

                $ZaglavljeHtml = '<table border="0" cellpadding="5">
                    <tr>
                        <td style="text-align: left; width: 50%;">
                            <b>Datum prometa dobara:</b> ' . date('d.m.Y', strtotime($ResDocument['datum'])) . '<br>
                            <b>Mesto prometa dobara:</b> ' . $MestoIzdavanja . '<br>
                            <b>Datum izdavanja:</b> ' . date('d.m.Y', strtotime($ResDocument['datum'])) . '<br>
                            <b>Mesto izdavanja:</b> ' . $MestoIzdavanja . '<br>
                            <b>Datum valute:</b> ' . date('d.m.Y', strtotime($ResDocument['datum'])) . '
                        </td>
                        <td style="border: 1px solid #333; text-align: left; width: 50%;">
                        <b>' . $KupacNaziv . '</b><br>
                            <b>PIB:</b> ' . $KupacPib . '<br>
                            <b>MB:</b> ' . $KupacMB . '<br>
                                    <b>Adresa:</b> ' . $KupacAdresa . '<br>
                                        <b>Mesto:</b> ' . $KupacMesto . '
                        </td>
                    </tr>
                </table>';
                $ZaglavljeHtml = <<<EOD
            $ZaglavljeHtml
EOD;
                $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ZaglavljeHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);

                $pdf->Ln();
                $pdf->SetFont('dejavusansb', '', 14);
                $pdf->Cell(0, 10, "RAČUN-OTPREMNICA br. " . $ResDocument['brojFakture'] . "/" . date('Y', strtotime($ResDocument['datum'])), 0, 1, 'C');
                $pdf->SetFont('dejavusansb', '', 7);
                if ($ResDocument['brojBI'] != '') {
                    $pdf->Cell(0, 6, "Broj fiskalnog isečka: " . $ResDocument['brojBI'], 0, 1, 'R');
                } else {
                    $pdf->Cell(0, 6, "Broj fiskalnog isečka:_______________________", 0, 1, 'R');
                }

                $pdf->SetFont('dejavusansb', '', 8);
                $pdf->Ln();
                $pdf->SetFillColor(200, 200, 200);
                $pdf->SetFont('dejavusans', '', 6);
                $Rb = 1;
                $Porez20 = 0;
                $Porez10 = 0;
                $Ukupno = 0;
                if ($ResDocument['menipromet'] > 0) {
                    $GetArtikle = mysqli_query($link, "SELECT * FROM menipromet WHERE RACUN_ID='$CurrentPageId'");
                    if (mysqli_num_rows($GetArtikle) > 0) {
                        $ArtikliSadrzaj = '<table border="0" cellpadding="2">
                    <thead>
                    <tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 4%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>R.B.</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 41%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Naziv dobara-usluga</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Količina</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Cena</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Osnovica</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 5%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>PDV%</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>PDV</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Ukupno</b></td>
                    </tr>
                    </thead>';
                        $OsnovicaTotal = 0;
                        $PorezTotal = 0;
                        $OsnovicaBezRabataTotal = 0;
                        $RabatTotal = 0;
                        $rowArtikle = mysqli_fetch_array($GetArtikle);
                        $rowArtikle['poreskaGrupa'] = GetSettingVal('meni.redni.broj.pg');

                        if ($rowArtikle['poreskaGrupa'] == 3) {
                            $VatVal = 20;
                        } elseif ($rowArtikle['poreskaGrupa'] == 4) {
                            $VatVal = 10;
                        } else {
                            $VatVal = 0;
                        }
                        $Quantity = $rowArtikle['kolicina'];
                        $Discount = $ResDocument['popust'];
                        $Price = $rowArtikle['cena'];

                        $OsnovnaCena = $Price / (1 + ($VatVal / 100));
                        $OsnovnaCena = $OsnovnaCena;
                        $CenaSaRabatom = $OsnovnaCena * (1 - ($Discount / 100));

                        $Osnovica = $OsnovnaCena * $Quantity;
                        $Popust = $ResDocument['popust'];
                        $OsnovicaSaPopustom = $Osnovica * (1 - ($Discount / 100));
                        $Medjuzbir = $Price * $Quantity * (1 - ($Discount / 100));
                        $Porez = $Medjuzbir - $OsnovicaSaPopustom;
                        $RabatTotal = $RabatTotal + ($Osnovica - $OsnovicaSaPopustom);
                        $ArtikliSadrzaj .= '<tr>
                            <td style="text-align: center; width: 4%; border-bottom: 1px solid #333;">' . $Rb . '.</td>
                            <td style="text-align: left; width: 41%; border-bottom: 1px solid #333;"><b>' . $rowArtikle['naziv'] . '</b></td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($Quantity, 2, '.', '') . '</td>
                            <td style="text-align: right;width: 10%; border-bottom: 1px solid #333;">' . number_format($CenaSaRabatom, 2, '.', '') . '</td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($OsnovicaSaPopustom, 2, '.', '') . '</td>
                            <td style="text-align: center; width: 5%; border-bottom: 1px solid #333;">' . number_format($VatVal, 0) . '</td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($Porez, 2, '.', '') . '</td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($Medjuzbir, 2, '.', '') . '</td>
                        </tr>';

                        $Rb++;
                        $OsnovicaBezRabataTotal = $OsnovicaBezRabataTotal + ($OsnovnaCena * $Quantity);
                        $OsnovicaTotal = $OsnovicaTotal + $OsnovicaSaPopustom;
                        $PorezTotal = $PorezTotal + $Porez;


                        if ($rowArtikle['poreskaGrupa'] == 3) {
                            $ArtikalPorez20 = $OsnovicaSaPopustom;
                            $Porez20 = $Porez20 + $ArtikalPorez20;
                        } elseif ($rowArtikle['poreskaGrupa'] == 4) {
                            $ArtikalPorez10 = $OsnovicaSaPopustom;
                            $Porez10 = $Porez10 + $ArtikalPorez10;
                        }
                        $Ukupno = $Ukupno + $OsnovicaSaPopustom + $Porez;
                        $ArtikliSadrzaj .= '</table>';
                        $ArtikliSadrzaj = <<<EOD
            $ArtikliSadrzaj
EOD;
                        $pdf->SetFont('dejavusans', '', 7);
                        $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
                    } else {
                        echo 'Odabrani račun nema stavke!';
                        die();
                    }
                } else {
                    $GetArtikle = mysqli_query($link, "SELECT a.dozvoljenPopust, a.poreskaGrupa, SUM(sr.kolicina) as kolicina, sr.cena, sr.naziv, sr.ARTIKAL_ID FROM stavkaracuna sr, artikal a WHERE a.id=sr.ARTIKAL_ID AND sr.RACUN_ID='$CurrentPageId'  GROUP BY sr.ARTIKAL_ID, sr.cena ORDER BY sr.id ASC");
                    if (mysqli_num_rows($GetArtikle) > 0) {
                        $ArtikliSadrzaj = '<table border="0" cellpadding="2">
                    <thead>
                    <tr style="font-size: 8px;">
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 4%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>R.B.</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: left; width: 41%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Naziv dobara-usluga</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Količina</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Cena</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Osnovica</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: center; width: 5%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>PDV%</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>PDV</b></td>
                        <td style="background-color:#DDDDDD;color:#111111;text-align: right; width: 10%; border-top: 1px solid #111; border-bottom: 1px solid #111;"><b>Ukupno</b></td>
                    </tr>
                    </thead>';
                        $OsnovicaTotal = 0;
                        $PorezTotal = 0;
                        $OsnovicaBezRabataTotal = 0;
                        $RabatTotal = 0;
                        while ($rowArtikle = mysqli_fetch_array($GetArtikle)) {
                            if ($rowArtikle['poreskaGrupa'] == 3) {
                                $VatVal = 20;
                            } elseif ($rowArtikle['poreskaGrupa'] == 4) {
                                $VatVal = 10;
                            } else {
                                $VatVal = 0;
                            }
                            $Quantity = $rowArtikle['kolicina'];
                            $Discount = $ResDocument['popust'];
                            $Price = $rowArtikle['cena'];

                            $OsnovnaCena = $Price / (1 + ($VatVal / 100));
                            $OsnovnaCena = $OsnovnaCena;
                            $CenaSaRabatom = $OsnovnaCena * (1 - ($Discount / 100));

                            $Osnovica = $OsnovnaCena * $Quantity;
                            if ($rowArtikle['dozvoljenPopust'] == 1) {
                                $Popust = $ResDocument['popust'];
                            } else {
                                $Popust = 0;
                            }
                            $OsnovicaSaPopustom = $Osnovica * (1 - ($Discount / 100));
                            $Medjuzbir = $Price * $Quantity * (1 - ($Discount / 100));
                            $Porez = $Medjuzbir - $OsnovicaSaPopustom;
                            $RabatTotal = $RabatTotal + ($Osnovica - $OsnovicaSaPopustom);
                            $ArtikliSadrzaj .= '<tr>
                            <td style="text-align: center; width: 4%; border-bottom: 1px solid #333;">' . $Rb . '.</td>
                            <td style="text-align: left; width: 41%; border-bottom: 1px solid #333;"><b>' . $rowArtikle['naziv'] . '</b></td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($Quantity, 2, '.', '') . '</td>
                            <td style="text-align: right;width: 10%; border-bottom: 1px solid #333;">' . number_format($CenaSaRabatom, 2, '.', '') . '</td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($OsnovicaSaPopustom, 2, '.', '') . '</td>
                            <td style="text-align: center; width: 5%; border-bottom: 1px solid #333;">' . number_format($VatVal, 0) . '</td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($Porez, 2, '.', '') . '</td>
                            <td style="text-align: right; width: 10%; border-bottom: 1px solid #333;">' . number_format($Medjuzbir, 2, '.', '') . '</td>
                        </tr>';

                            $Rb++;
                            $OsnovicaBezRabataTotal = $OsnovicaBezRabataTotal + ($OsnovnaCena * $Quantity);
                            $OsnovicaTotal = $OsnovicaTotal + $OsnovicaSaPopustom;
                            $PorezTotal = $PorezTotal + $Porez;


                            if ($rowArtikle['poreskaGrupa'] == 3) {
                                $ArtikalPorez20 = $OsnovicaSaPopustom;
                                $Porez20 = $Porez20 + $ArtikalPorez20;
                            } elseif ($rowArtikle['poreskaGrupa'] == 4) {
                                $ArtikalPorez10 = $OsnovicaSaPopustom;
                                $Porez10 = $Porez10 + $ArtikalPorez10;
                            }
                            $Ukupno = $Ukupno + $OsnovicaSaPopustom + $Porez;
                        }
                        $ArtikliSadrzaj .= '</table>';
                        $ArtikliSadrzaj = <<<EOD
            $ArtikliSadrzaj
EOD;
                        $pdf->SetFont('dejavusans', '', 7);
                        $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
                    } else {
                        echo 'Odabrani račun nema stavke!';
                        die();
                    }
                }
                $pdf->SetFont('dejavusans', '', 7);
                $Slovima = brojsrpski($Ukupno);

                $TotalPrint = '<table border="0" cellpadding="2"><thead>
                <tr>
                <td style="width: 64%; text-align: center;" rowspan="3"><i>Slovima: ' . $Slovima . '</i> <small>' . $ValutaZnak . '</small><br>Napomena o poreskom oslobođenju: NEMA. 
                <br>U SLUČAJU NEBLAGOVREMENOG PLAĆANJA OBRAČUNAVA SE ZAKONOM PROPISANA ZATEZNA KAMATA.</td>
                <td style="width: 18%; border-bottom: 1px solid #111;"><b>Poreska osnovica:</b></td>
                <td style="width: 18%; border-bottom: 1px solid #111; text-align: right;"><b>' . number_format($OsnovicaTotal, 2, '.', '') . '<small>' . $ValutaZnak . '</small></b></td>
                </tr>
                <tr>
                <td style="width: 18%; border-bottom: 1px solid #111;"><b>Obračunat PDV:</b></td>
                <td style="width: 18%; border-bottom: 1px solid #111; text-align: right;"><b>' . number_format($PorezTotal, 2, '.', '') . '<small>' . $ValutaZnak . '</small></b></td>
                </tr>
                <tr>
                <td style="background-color: #DDDDDD; color: #111111; width: 18%; border-bottom: 1px solid #111;"><b>Za plaćanje:</b></td>
                <td style="background-color: #DDDDDD; color: #111111; width: 18%; border-bottom: 1px solid #111; text-align: right;"><b>' . number_format($Ukupno, 2, '.', '') . '<small>' . $ValutaZnak . '</small></b></td>
                </tr>
                </thead></table>';
                $TotalPrint = <<<EOD
               $TotalPrint
EOD;
                $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $TotalPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
                $pdf->SetFont('dejavusans', '', 8);
                if ($Porez10 > 0 || $Porez20 > 0) {
                    $PoreziPrint = '<table border="0" cellpadding="4">
                    <thead>
                    <tr style="background-color: #DDDDDD; color: #111111;">
                        <td style="width: 40%; border-bottom: 1px solid #111; border-top: 1px solid #111;"><b>Poreske stope</b></td>
                        <td style="width: 20%; border-bottom: 1px solid #111; border-top: 1px solid #111; text-align:right;"><b>Osnova</b></td>
                        <td style="width: 20%; border-bottom: 1px solid #111; border-top: 1px solid #111; text-align:right;"><b>PDV</b></td>
                        <td style="width: 20%; border-bottom: 1px solid #111; border-top: 1px solid #111; text-align:right;"><b>Vrednost</b></td>
                    </tr>
                    </thead>';
                    if ($Porez10 > 0) {
                        $TotalPorez10 = $Porez10 * 1.1;
                        $Vrednost10 = $TotalPorez10 - $Porez10;
                        $PoreziPrint .= '<tr>
                        <td style="width: 40%; border-top: 1px solid #111;">Porez na dodatu vrednost 10%</td>
                        <td style="width: 20%; border-top: 1px solid #111; text-align:right;">' . number_format($Porez10, 2, '.', '') . '<small>' . $ValutaZnak . '</small></td>
                        <td style="width: 20%; border-top: 1px solid #111; text-align:right;">' . number_format($Vrednost10, 2, '.', '') . '<small>' . $ValutaZnak . '</small></td>
                        <td style="width: 20%; border-top: 1px solid #111; text-align:right;">' . number_format($TotalPorez10, 2, '.', '') . '<small>' . $ValutaZnak . '</small></td>
                    </tr>';
                    }
                    if ($Porez20 > 0) {
                        $TotalPorez20 = $Porez20 * 1.2;
                        $Vrednost20 = $TotalPorez20 - $Porez20;
                        $PoreziPrint .= '<tr>
                        <td style="width: 40%; border-top: 1px solid #111;">Porez na dodatu vrednost 20%</td>
                        <td style="width: 20%; border-top: 1px solid #111; text-align:right;">' . number_format($Porez20, 2, '.', '') . '<small>' . $ValutaZnak . '</small></td>
                        <td style="width: 20%; border-top: 1px solid #111; text-align:right;">' . number_format($Vrednost20, 2, '.', '') . '<small>' . $ValutaZnak . '</small></td>
                        <td style="width: 20%; border-top: 1px solid #111; text-align:right;">' . number_format($TotalPorez20, 2, '.', '') . '<small>' . $ValutaZnak . '</small></td>
                    </tr>';
                    }
                }
                $PoreziPrint .= '</table>';
                $pdf->Ln(5);
                $PoreziPrint = <<<EOD
$PoreziPrint
EOD;
                $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $PoreziPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
                $pdf->Ln(5);

                $PotpisPrint = <<<EOD
                    <table border="0" cellpadding="5">
                     <tr>
                    <td style="width: 30%; text-align: left;">Izdao<br><br></td>
                    <td style="width: 5%; text-align: center;"></td>
                    <td style="width: 30%; text-align: left;"></td>
                    <td style="width: 5%; text-align: center;"></td>
                    <td style="width: 30%; text-align: left;">Primio<br>lk. br.<br>br. vozila</td>
                    </tr>
                    <tr>
                    <td style="width: 30%; border-bottom: 1px solid #111111;"></td>
                    <td style="width: 5%; text-align: center;"></td>
                    <td style="width: 30%;"></td>
                    <td style="width: 5%; text-align: center;"></td>
                    <td style="width: 30%; border-bottom: 1px solid #111111;"></td>
                    </tr>
                    <tr>
                        <td colspan="5"><br><b>Račun je punovažan bez overe pečata i potpisa.</b></td>
                    </tr>
                    </table>
EOD;
                $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $PotpisPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
            }
            $FileName = str_replace('.', '-', $SheetName);
            $FileName = str_replace('/', '-', $FileName);
            $FileName = str_replace(':', ' ', $FileName);
            $pdf->Output($FileName . '.pdf', "I");
        } else {
            Echo "Greska pri kreiranju PDF Fajla...";
        }
    } else {
        Echo "Greska pri kreiranju PDF Fajla page...";
    }
} else {
    Echo "Greska pri kreiranju PDF fajla!!!";
}
