<?php

if ($DirectStop != "CuCaNaBuCaNa") {
    header("Location: ./logout.php");
    die();
}
require_once('stampa/config/tcpdf_config_alt.php');
require_once('stampa/tcpdf.php');
require_once('stampa/tcpdf_include.php');

class PDF extends TCPDF {

    function Footer() {
        $this->SetY(-10);
        $PageNo = $this->PageNo();
        $this->SetFont('dejavusans', '', 5);
        $DateTime = date('d.m.Y H:i:s');
        $FooterPrint = <<<EOD
                    <table border="0" cellpadding="0">
                    <tr>
                        <td style="width: 10%; text-align: left;">
                            <b>str. $PageNo</b>
                        </td>
                        <td style="width: 90%; text-align: right;">
                            <i>Dokument štampan $DateTime iz programa "Barmaster" autor 5.com.d.o.o. -www.petcom.rs- Software for Business and Pleasure</i>
                        </td>
                    </tr>
                    </table>
EOD;
        $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $FooterPrint, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }

    function Header() {
        $this->SetFont('dejavusansb', '', 8);
        global $SiteName;

        $ThisCompanyName = $SiteName;
        global $ThisCompanyPIB;
        global $ThisCompanyMB;
        global $ThisCompanyAddress;
        global $ThisCompanyZip;
        global $ThisCompanyCity;
        $ThisCompanyPhone = "";
        global $ThisCompanySifraDelatnosti;
        global $ThisCompanyRacun;
        global $ThisCompanyBanka;
        global $Updv;

        $ThisCompanyPhone2 = "";
        $PrintThisAddress = '';
        if ($ThisCompanyAddress != '') {
            $PrintThisAddress .= $ThisCompanyAddress;
        }
        if ($ThisCompanyZip != '') {
            $PrintThisAddress .= ', ' . $ThisCompanyZip;
        }
        if ($ThisCompanyCity != '') {
            $PrintThisAddress .= ', ' . $ThisCompanyCity;
        }
        $IncLines = 0;
        $this->Ln(5);
        $HeaderHtml = '<table border="0" cellpadding="0">';
        $HeaderHtml .= '<tr>
                    <td style="text-align: left; width: 50%; font-size: 7mm;">' . $ThisCompanyName . '</td>
                    <td style="text-align: right; width: 50%">';
        if ($ThisCompanyName != '') {
            $HeaderHtml .= '<b>' . $ThisCompanyName . '</b><br>';
        }
        $this->SetFont('dejavusans', '', 8);
        if ($ThisCompanyPIB != '') {
            $HeaderHtml .= '<b>PIB: </b>' . $ThisCompanyPIB . '<br>';
        }
        if ($ThisCompanyMB != '') {
            $HeaderHtml .= '<b>MB: </b>' . $ThisCompanyMB . '<br>';
        }
        if ($ThisCompanyMB != '') {
            $HeaderHtml .= $PrintThisAddress . '<br>';
        }
        if ($ThisCompanyPhone != '') {
            $HeaderHtml .= '<b>Telefon: </b>' . $ThisCompanyPhone . '<br>';
        }
        if ($ThisCompanyPhone2 != '') {
            $HeaderHtml .= $ThisCompanyPhone2 . '<br>';
        }

        if ($Updv == "true") {
            $HeaderHtml .= '<b>U sistemu PDV: </b> DA<br>';
        } else {
            $HeaderHtml .= '<b>U sistemu PDV: </b> NE<br>';
        }
        $HeaderHtml .= '<b>Šifra delatnosti: </b>' . $ThisCompanySifraDelatnosti . '<br>';
        $HeaderHtml .= '<b>' . $ThisCompanyBanka . ': </b>' . $ThisCompanyRacun . '<br>';
        $HeaderHtml .= '</td>
            </tr></table>';
        $HeaderHtml = <<<EOD
            $HeaderHtml
EOD;
        $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $HeaderHtml, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }

}

$UserName = mysqli_real_escape_string($link, $_COOKIE['UserName']);
$LogDate = date('Y-m-d');
$LogTime = date('H:i:s');
$LogUser = $UserName;
$LogWhat = "Stampa razduzenja -> Korisnik: " . $UserName;
mysqli_query($link, "INSERT INTO logrecord(dan, vreme, uname, what) VALUES('$LogDate', '$LogTime', '$LogUser', '$LogWhat')");

$UserId = mysqli_real_escape_string($link, $_COOKIE['UserId']);
$GetZd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY id DESC LIMIT 1");
if (mysqli_num_rows($GetZd) == 1) {
    $Zd = mysqli_fetch_array($GetZd)['zdBroj'];
}
mysqli_query($link, "INSERT INTO zd_konobar(ZD_BROJ, KONOBAR_ID) VALUES ('$Zd', '$UserId')");
$GetLastWd = mysqli_query($link, "SELECT * FROM zd WHERE pocetak=1 ORDER BY zakljucenje DESC LIMIT 1") or die(mysqli_error($link));
if (mysqli_num_rows($GetLastWd) == 1) {
    $ZdData = mysqli_fetch_array($GetLastWd);
    $ZdBroj = $ZdData['zdBroj'];
    $ZdVreme = $ZdData['zakljucenje'];
} else {
    echo json_encode(array('Status' => 'error', 'Message' => 'Nema otvorenog radnog dana!!!'));
    die();
}
$GetUserData = mysqli_query($link, "SELECT * FROM konobar WHERE id='$UserId'") or die(mysqli_error($link));
if (mysqli_num_rows($GetUserData) == 1) {
    $UserData = mysqli_fetch_array($GetUserData);
} else {
    echo json_encode(array('Status' => 'error', 'Message' => 'Nema korisnickog naloga!!!'));
    die();
}
$SGID = 0;
$UserSifra = $UserData['sifra'];
$GetSG = mysqli_query($link, "SELECT * FROM stalnigost WHERE sifra='$UserSifra' AND blokiran=0") or die(mysqli_error($link));
if (mysqli_num_rows($GetSG) == 1) {
    $SGData = mysqli_fetch_array($GetSG);
    $SGID = $SGData['id'];
}
$GetSaleData = mysqli_query($link, "SELECT r.*, sr.kolicina, sr.naziv, sr.cena, sr.ARTIKAL_ID, sr.RACUN_ID FROM racun r, stavkaracuna sr WHERE r.id=sr.RACUN_ID AND r.zdBroj='$ZdBroj' AND r.KONOBAR_ID='$UserId' ORDER BY r.id ASC, sr.id ASC") or die(mysqli_error($link));
if (mysqli_num_rows($GetSaleData) > 0) {
    $Updv = GetSettingVal('objekat.updv');
    $ThisCompanyPIB = GetSettingVal('objekat.pib');
    $ThisCompanyMB = GetSettingVal('objekat.maticni.broj');
    $ThisCompanyAddress = GetSettingVal('objekat.adresa');
    $ThisCompanyZip = GetSettingVal('objekat.maticni.broj');
    $ThisCompanyCity = GetSettingVal('objekat.mesto');
    $ThisCompanySifraDelatnosti = GetSettingVal('objekat.sifra.delatnosti');
    $ThisCompanyRacun = GetSettingVal('objekat.racun');
    $ThisCompanyBanka = GetSettingVal('objekat.banka');

    $pdf = new PDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $SheetName = "Izvestaj prodaje operatera " . $UserData['skrIme'] . " " . date('Y-m-d');
    $pdf->SetFont('dejavusans', '', 10);
    $pdf->SetTitle($SheetName);

    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sparkom Software www.sparkom.net');
    $pdf->SetTitle($SheetName);
    $pdf->SetSubject($SheetName);
    $pdf->SetFont('dejavusans', '', 8);
    $pdf->SetMargins(8, 40, 8);
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    $pdf->startPageGroup();
    $pdf->AddPage();
    $pdf->Cell(0, 1, "", "T", 1, "C");


    $pdf->SetFont('dejavusansb', '', 14);
    $pdf->Cell(0, 10, "Izvestaj prodaje operatera: " . $UserData['skrIme'] . " " . date('d.m.Y', strtotime($ZdVreme)), 0, 1, 'C');

    $pdf->SetFont('dejavusansb', '', 8);
    $pdf->Ln();
    $Payments = [];
    $GetPaymentData = mysqli_query($link, "SELECT * FROM placanje WHERE vreme>='$ZdVreme' ORDER BY id ASC") or die(mysqli_error($link));
    if (mysqli_num_rows($GetPaymentData) > 0) {
        while ($rowPaymentData = mysqli_fetch_array($GetPaymentData)) {
            $Payments[$rowPaymentData['RACUN_ID']][$rowPaymentData['id']] = ['Nacin' => $rowPaymentData['nacin'], 'Iznos' => $rowPaymentData['iznos']];
        }
    }
    $Grupe = [];
    $GetGrupe = mysqli_query($link, "SELECT * FROM grupaartikala");
    if (mysqli_num_rows($GetGrupe) > 0) {
        while ($rowGrupe = mysqli_fetch_array($GetGrupe)) {
            $Grupe[$rowGrupe['id']] = $rowGrupe;
        }
    }
    $PodGrupe = [];
    $GetPodGrupe = mysqli_query($link, "SELECT * FROM podgrupaartikala");
    if (mysqli_num_rows($GetPodGrupe) > 0) {
        while ($rowPodGrupe = mysqli_fetch_array($GetPodGrupe)) {
            $PodGrupe[$rowPodGrupe['id']] = $rowPodGrupe;
        }
    }
    $Artikli = [];
    $GetArtikle = mysqli_query($link, "SELECT * FROM artikal");
    if (mysqli_num_rows($GetArtikle) > 0) {
        while ($rowArtikal = mysqli_fetch_array($GetArtikle)) {
            $Artikli[$rowArtikal['id']] = $rowArtikal;
        }
    }
    $StornoIznos = 0;
    $StornoBroj = [];
    $PoGrupama = [];
    $PoPodgrupama = [];
    $PoArtiklima = [];
    $PoPlacanjima = [];
    $NeNaplaceno = [];
    $PopustNaPopust = 0;
    $PopustNaPopustTotal = 0;
    $NaplaceniIznosi = [];
    $NaplaceniBrojeviRacuna = [];
    $RacuniData = [];
    $NenaplacenoBroj = [];
    while ($rowSaleData = mysqli_fetch_array($GetSaleData)) {
        $RacunId = $rowSaleData['RACUN_ID'];
        if ($rowSaleData['zatvoren'] == TRUE) {
            if ($rowSaleData['storniran'] == TRUE) {
                $StornoIznos = $StornoIznos + (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                $StornoBroj[$rowSaleData['RACUN_ID']] = $rowSaleData['RACUN_ID'];
            } else {
                if ($rowSaleData['menipromet'] > 0) {
                    if (empty($PoArtiklima["MENI" . $RacunId])) {
                        $GetMeni = mysqli_query($link, "SELECT * FROM menipromet WHERE RACUN_ID='$RacunId'") or die(mysqli_error($link));
                        if (mysqli_num_rows($GetMeni) == 1) {
                            $MeniData = mysqli_fetch_array($GetMeni);
                            $PoArtiklima["MENI" . $RacunId]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            $PoArtiklima["MENI" . $RacunId]['Kolicina'] = $MeniData['kolicina'];
                            $PoArtiklima["MENI" . $RacunId]['Naziv'] = $MeniData['naziv'];
                            $PoArtiklima["MENI" . $RacunId]['Id'] = 0;
                            $PoArtiklima["MENI" . $RacunId]['PodGrupa'] = 0;
                        }
                        if (!empty($RacuniData[$RacunId])) {
                            $RacuniData[$RacunId]['Iznos'] = $RacuniData[$RacunId]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        } else {
                            if ($rowSaleData['crnoPlacanje'] == '') {
                                $RacuniData[$RacunId]['CrnoPlacanje'] = "";
                            } else {
                                $RacuniData[$RacunId]['CrnoPlacanje'] = $rowSaleData['crnoPlacanje'];
                            }
                            $RacuniData[$RacunId]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        }
                        $PodGrupa = 0;
                        if (!empty($PoPodgrupama[$PodGrupa]['Iznos'])) {
                            $PoPodgrupama[$PodGrupa]['Iznos'] = $PoPodgrupama[$PodGrupa]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        } else {
                            $PoPodgrupama[$PodGrupa]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            $PoPodgrupama[$PodGrupa]['Naziv'] = 'Meni';
                        }
                        $Grupa = 0;
                        if (!empty($PoGrupama[$Grupa]['Iznos'])) {
                            $PoGrupama[$Grupa]['Iznos'] = $PoGrupama[$Grupa]['Iznos'] + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        } else {
                            $PoGrupama[$Grupa]['Iznos'] = (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                            $PoGrupama[$Grupa]['Naziv'] = 'Meni';
                        }
                        if ($rowSaleData['STALNIGOST_ID'] == $SGID) {
                            $PopustNaPopustTotal = $PopustNaPopustTotal + ($MeniData['kolicina'] * $MeniData['cena']);
                            $PopustNaPopust = $PopustNaPopust + (($MeniData['kolicina'] * $MeniData['cena']) - (($MeniData['kolicina'] * $MeniData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        }
                    }
                } else {
                    if ($rowSaleData['STALNIGOST_ID'] == $SGID) {
                        $PopustNaPopustTotal = $PopustNaPopustTotal + ($rowSaleData['kolicina'] * $rowSaleData['cena']);
                        if ($Artikli[$rowSaleData['ARTIKAL_ID']]['dozvoljenPopust'] == TRUE) {
                            $PopustNaPopust = $PopustNaPopust + (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                        } else {
                            $PopustNaPopust = $PopustNaPopust + ($rowSaleData['kolicina'] * $rowSaleData['cena']);
                        }
                    }
                    if ($Artikli[$rowSaleData['ARTIKAL_ID']]['dozvoljenPopust'] == TRUE) {
                        $LineTotal = (($rowSaleData['kolicina'] * $rowSaleData['cena']) - (($rowSaleData['kolicina'] * $rowSaleData['cena']) * (0 + $rowSaleData['popust'] / 100)));
                    } else {
                        $LineTotal = $rowSaleData['kolicina'] * $rowSaleData['cena'];
                    }
                    $PodGrupa = $Artikli[$rowSaleData['ARTIKAL_ID']]['PODGRUPA_ID'];
                    if (!empty($PoPodgrupama[$PodGrupa]['Iznos'])) {
                        $PoPodgrupama[$PodGrupa]['Iznos'] = $PoPodgrupama[$PodGrupa]['Iznos'] + $LineTotal;
                    } else {
                        $PoPodgrupama[$PodGrupa]['Iznos'] = $LineTotal;
                        $PoPodgrupama[$PodGrupa]['Naziv'] = $PodGrupe[$PodGrupa]['naziv'];
                    }
                    $Grupa = $PodGrupe[$PodGrupa]['GRUPA_ID'];
                    if (!empty($PoGrupama[$Grupa]['Iznos'])) {
                        $PoGrupama[$Grupa]['Iznos'] = $PoGrupama[$Grupa]['Iznos'] + $LineTotal;
                    } else {
                        $PoGrupama[$Grupa]['Iznos'] = $LineTotal;
                        $PoGrupama[$Grupa]['Naziv'] = $Grupe[$Grupa]['naziv'];
                    }

                    if (!empty($PoArtiklima[$rowSaleData['ARTIKAL_ID']])) {
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] + $LineTotal;
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] + $rowSaleData['kolicina'];
                    } else {
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $LineTotal;
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $rowSaleData['kolicina'];
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Naziv'] = $rowSaleData['naziv'];
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['Id'] = $rowSaleData['ARTIKAL_ID'];
                        $PoArtiklima[$rowSaleData['ARTIKAL_ID']]['PodGrupa'] = $PodGrupa;
                    }
                    if (!empty($RacuniData[$RacunId])) {
                        $RacuniData[$RacunId]['Iznos'] = $RacuniData[$RacunId]['Iznos'] + $LineTotal;
                    } else {
                        if ($rowSaleData['crnoPlacanje'] == '') {
                            $RacuniData[$RacunId]['CrnoPlacanje'] = "";
                        } else {
                            $RacuniData[$RacunId]['CrnoPlacanje'] = $rowSaleData['crnoPlacanje'];
                        }
                        $RacuniData[$RacunId]['Iznos'] = $LineTotal;
                    }
                }
            }
        } else {
            if (!empty($NeNaplaceno[$rowSaleData['ARTIKAL_ID']])) {
                $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] + $rowSaleData['kolicina'];
                $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] + ($rowSaleData['cena'] * $rowSaleData['kolicina']);
            } else {
                $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Naziv'] = $rowSaleData['naziv'];
                $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Kolicina'] = $rowSaleData['kolicina'];
                $NeNaplaceno[$rowSaleData['ARTIKAL_ID']]['Iznos'] = $rowSaleData['cena'] * $rowSaleData['kolicina'];
            }
            $NenaplacenoBroj[$RacunId] = $RacunId;
        }
    }
    if (!empty($RacuniData)) {
        foreach ($RacuniData AS $RacunId => $Racun) {
            if ($Racun['CrnoPlacanje'] != '') {
                if (!empty($NaplaceniIznosi[$Racun['CrnoPlacanje']])) {
                    $NaplaceniIznosi[$Racun['CrnoPlacanje']] = $NaplaceniIznosi[$Racun['CrnoPlacanje']] + $Racun['Iznos'];
                } else {
                    $NaplaceniIznosi[$Racun['CrnoPlacanje']] = $Racun['Iznos'];
                }
                if (!empty($NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']])) {
                    $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] = $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] + 1;
                } else {
                    $NaplaceniBrojeviRacuna[$Racun['CrnoPlacanje']] = 1;
                }
            } else {
                $CountPayments = $Payments[$RacunId];
                if (count($CountPayments) > 1) {
                    if (!empty($NaplaceniBrojeviRacuna['KOMBINOVANO'])) {
                        $NaplaceniBrojeviRacuna['KOMBINOVANO'] = $NaplaceniBrojeviRacuna['KOMBINOVANO'] + 1;
                    } else {
                        $NaplaceniBrojeviRacuna['KOMBINOVANO'] = 1;
                    }
                } else {
                    foreach ($CountPayments as $PaymentData) {
                        if (!empty($NaplaceniBrojeviRacuna[$PaymentData['Nacin']])) {
                            $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] = $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] + 1;
                        } else {
                            $NaplaceniBrojeviRacuna[$PaymentData['Nacin']] = 1;
                        }
                    }
                }
                foreach ($CountPayments as $PaymentData) {
                    if (!empty($NaplaceniIznosi[$PaymentData['Nacin']])) {
                        $NaplaceniIznosi[$PaymentData['Nacin']] = $NaplaceniIznosi[$PaymentData['Nacin']] + $PaymentData['Iznos'];
                    } else {
                        $NaplaceniIznosi[$PaymentData['Nacin']] = $PaymentData['Iznos'];
                    }
                }
            }
        }
    }
    $HtmlToReturn = '<table border="1" cellpadding="2" style="text-align: right;"><tbody><tr style="background-color: #ccc;"><th style="text-align: left;">Način plaćanja</th><th>Iznos</th></tr>';
    $TotalIznos = 0;
    if ($NaplaceniIznosi['GOTOVINA'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">GOTOVINA</td><td>' . number_format($NaplaceniIznosi['GOTOVINA'], 2, '.', '') . '</td></tr>';
    }
    if ($NaplaceniIznosi['KARTICA'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">KARTICA</td><td>' . number_format($NaplaceniIznosi['KARTICA'], 2, '.', '') . '</td></tr>';
    }
    if ($NaplaceniIznosi['CEK'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">CEK</td><td>' . number_format($NaplaceniIznosi['CEK'], 2, '.', '') . '</td></tr>';
    }
    if ($NaplaceniIznosi['FAKTURA'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">FAKTURA</td><td>' . number_format($NaplaceniIznosi['FAKTURA'], 2, '.', '') . '</td></tr>';
    }

    foreach ($NaplaceniIznosi as $Nacin => $Iznos) {
        if ($Nacin != 'GOTOVINA' && $Nacin != 'CEK' && $Nacin != 'KARTICA' && $Nacin != 'FAKTURA') {
            $HtmlToReturn .= '<tr><td style="text-align: left;">' . $Nacin . '</td><td>' . number_format($Iznos, 2, '.', '') . '</td></tr>';
        }
        $TotalIznos = $TotalIznos + $Iznos;
    }
    $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">UKUPNO</th><th>' . number_format($TotalIznos, 2, '.', '') . '</th></tr></tbody>';
    $HtmlToReturn .= '</table>';
    $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);

    $HtmlToReturn = '<br/><br/><table border="1" cellpadding="2" style="text-align: right;"><tbody><tr style="background-color: #ccc;"><th style="text-align: left;">Način plaćanja</th><th>Broj računa</th></tr>';
    $TotalBrojevi = 0;
    if ($NaplaceniBrojeviRacuna['GOTOVINA'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">GOTOVINA</td><td>' . number_format($NaplaceniBrojeviRacuna['GOTOVINA'], 0) . '</td></tr>';
    }
    if ($NaplaceniBrojeviRacuna['KARTICA'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">KARTICA</td><td>' . number_format($NaplaceniBrojeviRacuna['KARTICA'], 0) . '</td></tr>';
    }
    if ($NaplaceniBrojeviRacuna['CEK'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">CEK</td><td>' . number_format($NaplaceniBrojeviRacuna['CEK'], 0) . '</td></tr>';
    }
    if ($NaplaceniBrojeviRacuna['FAKTURA'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">FAKTURA</td><td>' . number_format($NaplaceniBrojeviRacuna['FAKTURA'], 0) . '</td></tr>';
    }
    if ($NaplaceniBrojeviRacuna['KOMBINOVANO'] > 0) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">KOMBINOVANO</td><td>' . number_format($NaplaceniBrojeviRacuna['KOMBINOVANO'], 0) . '</td></tr>';
    }
    foreach ($NaplaceniBrojeviRacuna as $Nacin => $Broj) {
        if ($Nacin != 'GOTOVINA' && $Nacin != 'CEK' && $Nacin != 'KARTICA' && $Nacin != 'FAKTURA' && $Nacin != 'KOMBINOVANO') {
            $HtmlToReturn .= '<tr><td style="text-align: left;">' . $Nacin . '</td><td>' . number_format($Broj, 0) . '</td></tr>';
        }
        $TotalBrojevi = $TotalBrojevi + $Broj;
    }
    $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">UKUPNO</th><th>' . number_format($TotalBrojevi, 0) . '</th></tr></tbody>';
    $HtmlToReturn .= '</table>';

    $HtmlToReturn .= '<br/><br/><table border="1" cellpadding="2" style="text-align: right;"><tbody>';
    $HtmlToReturn .= '<tr><td style="text-align: left;">Ukupno storno</td><td>' . number_format($StornoIznos, 2, '.', '') . '</td></tr>';
    $HtmlToReturn .= '<tr><td style="text-align: left;">Broj storna</td><td>' . count($StornoBroj) . '</td></tr>';
    $HtmlToReturn .= '</tbody>';
    $HtmlToReturn .= '</table>';
    $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    if ($PopustNaPopust > 0) {
        $HtmlToReturn = '<br/><br/><table border="1" cellpadding="2" style="text-align: right;"><tbody>';
        $HtmlToReturn .= '<tr><td style="text-align: left;">Popust po stalnom gostu:</td><td>' . $SGData['naziv'] . '</td></tr>';
        $HtmlToReturn .= '<tr><td style="text-align: left;">Ukupno</td><td>' . number_format($PopustNaPopustTotal, 2, '.', '') . '</td></tr>';
        $HtmlToReturn .= '<tr><td style="text-align: left;">Popust</td><td>' . number_format($SGData['popust'], 1, '.', '') . '%</td></tr>';
        $SaPopustom = $PopustNaPopustTotal - $PopustNaPopust;
        $HtmlToReturn .= '<tr><td style="text-align: left;">Ukupno sa popustom</td><td>' . number_format($PopustNaPopust, 1, '.', '') . '</td></tr>';
        $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">Ostvareni popust</th><th>' . number_format($SaPopustom, 1, '.', '') . '</th></tr>';
        $HtmlToReturn .= '</tbody>';
        $HtmlToReturn .= '</table>';
        $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
        $pdf->SetFont('dejavusans', '', 7);
        $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    }
    $HtmlToReturn = '<br/><br/><table border="1" cellpadding="2" style="text-align: right;"><tbody><tr style="background-color: #ccc;"><th style="text-align: left;">Grupe</th><th>Total</th></tr>';
    $TotalGrupe = 0;
    foreach ($PoGrupama as $Grupa) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">' . $Grupa['Naziv'] . '</td><td>' . number_format($Grupa['Iznos'], 2, '.', '') . '</td></tr>';
        $TotalGrupe = $TotalGrupe + $Grupa['Iznos'];
    }
    $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">UKUPNO</th><th>' . number_format($TotalGrupe, 2, '.', '') . '</th></tr></tbody>';
    $HtmlToReturn .= '</table>';

    $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);

    $HtmlToReturn = '<br/><br/><table border="1" cellpadding="2" style="text-align: right;"><tbody><tr style="background-color: #ccc;"><th style="text-align: left;">Podgrupe</th><th>Total</th></tr>';
    $TotalPodGrupe = 0;
    foreach ($PoPodgrupama as $PodGrupa) {
        $HtmlToReturn .= '<tr><td style="text-align: left;">' . $PodGrupa['Naziv'] . '</td><td>' . number_format($PodGrupa['Iznos'], 2, '.', '') . '</td></tr>';
        $TotalPodGrupe = $TotalPodGrupe + $PodGrupa['Iznos'];
    }
    $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">UKUPNO</th><th>' . number_format($TotalPodGrupe, 2, '.', '') . '</th></tr></tbody>';
    $HtmlToReturn .= '</table>';
    $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    $HtmlToReturn = '<br/><br/><table border="1" cellpadding="2" style="text-align: right;color: red;"><tbody><tr style="background-color: #ccc;"><th colspan="4" style="width: 100%; text-align:center;">Nenaplaćeni stolovi</th></tr><tr style="background-color: #ccc;"><th style="text-align: left;">Artikal</th><th>Kolicina</th><th>Cena</th><th>Total</th></tr>';
    $TotalNenaplaceno = 0;
    foreach ($NeNaplaceno as $Artikal) {
        $Cena = $Artikal['Iznos'] / $Artikal['Kolicina'];
        $HtmlToReturn .= '<tr><td style="text-align: left;">' . $Artikal['Naziv'] . '</td><td>' . $Artikal['Kolicina'] . '</td><td>' . number_format($Cena, 2, '.', '') . '</td><td>' . number_format($Artikal['Iznos'], 2, '.', '') . '</td></tr>';
        $TotalNenaplaceno = $TotalNenaplaceno + $Artikal['Iznos'];
    }
    $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">UKUPNO</th><th></th><th>Stolova: ' . count($NenaplacenoBroj) . '</th><th>' . number_format($TotalNenaplaceno, 2, '.', '') . '</th></tr></tbody>';
    $HtmlToReturn .= '</table>';
    $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    $pdf->AddPage();
    $HtmlToReturn = '<br/><br/><table border="1" cellpadding="2" style="text-align: right;"><tbody>';
    $Total = 0;
    $TotalKolicina = 0;
    foreach ($PoPodgrupama as $PodGrupaId => $PodGrupa) {
        $TotalPodGrupa = 0;
        $TotalKolicinaPodGrupa = 0;
        $HtmlToReturn .= '<tr style="background-color: #ccc;"><th colspan="4" style="text-align: center;">' . $PodGrupa['Naziv'] . '</th></tr><tr style="background-color: #ccc;"><th style="text-align: left;">Artikal</th><th>Količina</th><th>Cena</th><th>Iznos</th></tr>';
        foreach ($PoArtiklima as $Artikal) {
            if ($Artikal['PodGrupa'] == $PodGrupaId) {
                $Cena = $Artikal['Iznos'] / $Artikal['Kolicina'];
                $HtmlToReturn .= '<tr><td style="text-align: left;">' . $Artikal['Naziv'] . '</td><td>' . $Artikal['Kolicina'] . '</td><td>' . number_format($Cena, 2, '.', '') . '</td><td>' . number_format($Artikal['Iznos'], 2, '.', '') . '</td></tr>';
                $TotalPodGrupa = $TotalPodGrupa + $Artikal['Iznos'];
                $TotalKolicinaPodGrupa = $TotalKolicinaPodGrupa + $Artikal['Kolicina'];
            }
        }
        $HtmlToReturn .= '<tr style="background-color: #ccc;"><th style="text-align: left;">UKUPNO</th><th>' . number_format($TotalKolicinaPodGrupa, 1, '.', '') . '</th><th></th><th>' . number_format($TotalPodGrupa, 2, '.', '') . '</th></tr>';
        $Total = $Total + $TotalPodGrupa;
        $TotalKolicina = $TotalKolicina + $TotalKolicinaPodGrupa;
    }
    $HtmlToReturn .= '<tr style="background-color: #ccc;"><th>UKUPNO</th><th>' . number_format($TotalKolicina, 2, '.', '') . '</th><th></th><th>' . number_format($Total, 2, '.', '') . '</th></tr></tbody>';
    $HtmlToReturn .= '</table>';
    $ArtikliSadrzaj = <<<EOD
            $HtmlToReturn
EOD;
    $pdf->SetFont('dejavusans', '', 7);
    $pdf->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $ArtikliSadrzaj, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
    $FileName = str_replace('.', '-', $SheetName);
    $FileName = str_replace('/', '-', $FileName);
    $FileName = str_replace(':', ' ', $FileName);
    $pdf->Output($FileName . '.pdf', I);
} else {
    Echo "Greska pri kreiranju PDF Fajla Nema podataka...";
}